/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.codefilarete.stalactite.engine.PersistExecutor;
import org.codefilarete.stalactite.engine.runtime.ConfiguredPersister;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.Maps;

public class AlreadyAssignedIdentifierPersistExecutor<C, I>
implements PersistExecutor<C> {
    private final ConfiguredPersister<C, I> persister;

    public AlreadyAssignedIdentifierPersistExecutor(ConfiguredPersister<C, I> persister) {
        this.persister = persister;
    }

    @Override
    public void persist(Iterable<? extends C> entities) {
        ConfiguredPersister selector = this.persister;
        ConfiguredPersister<C, I> updater = this.persister;
        ConfiguredPersister inserter = this.persister;
        Function<Object, Object> idProvider = this.persister.getMapping()::getId;
        Map entitiesPerId = Iterables.map(entities, idProvider);
        Set existingEntities = selector.select(entitiesPerId.keySet());
        Set existingEntitiesIds = (Set)Iterables.collect(existingEntities, idProvider, HashSet::new);
        Predicate<Object> isNewProvider = c -> !existingEntitiesIds.contains(idProvider.apply(c));
        if (Iterables.isEmpty(entities)) {
            return;
        }
        ArrayList<C> toInsert = new ArrayList<C>(20);
        ArrayList<C> toUpdate = new ArrayList<C>(20);
        for (C c2 : entities) {
            if (isNewProvider.test(c2)) {
                toInsert.add(c2);
                continue;
            }
            toUpdate.add(c2);
        }
        if (!toInsert.isEmpty()) {
            inserter.insert(toInsert);
        }
        if (!toUpdate.isEmpty()) {
            Map loadedEntitiesPerId = Iterables.map(existingEntities, idProvider);
            Map modifiedEntitiesPerId = Iterables.map(toUpdate, idProvider);
            Map modifiedVSunmodified = Maps.innerJoin((Map)modifiedEntitiesPerId, (Map)loadedEntitiesPerId);
            ArrayList updateArg = new ArrayList();
            modifiedVSunmodified.forEach((k, v) -> updateArg.add(new Duo(k, v)));
            updater.update(updateArg, true);
        }
    }
}

