/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.mapping.id.assembly;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.codefilarete.stalactite.mapping.id.assembly.IdentifierAssembler;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.collection.Iterables;

public abstract class ComposedIdentifierAssembler<I, T extends Table<T>>
implements IdentifierAssembler<I, T> {
    private final PrimaryKey<T, I> primaryKey;

    protected ComposedIdentifierAssembler(T table) {
        this(((Table)table).getPrimaryKey());
    }

    protected ComposedIdentifierAssembler(PrimaryKey<T, I> primaryKey) {
        this.primaryKey = primaryKey;
    }

    @Override
    public Set<Column<T, ?>> getColumns() {
        return this.primaryKey.getColumns();
    }

    @Override
    @Nullable
    public abstract I assemble(Function<Column<?, ?>, Object> var1);

    @Override
    public Map<Column<T, ?>, Object> getColumnValues(List<I> ids) {
        HashMap pkValues = new HashMap();
        if (ids.size() == 1) {
            Map localPkValues = this.getColumnValues(Iterables.first(ids));
            this.primaryKey.getColumns().forEach(pkColumn -> pkValues.put((Column)pkColumn, localPkValues.get(pkColumn)));
        } else {
            ids.forEach(id -> {
                Map localPkValues = this.getColumnValues(id);
                this.primaryKey.getColumns().forEach(pkColumn -> ((List)pkValues.computeIfAbsent((Column)pkColumn, k -> new ArrayList())).add(localPkValues.get(pkColumn)));
            });
        }
        return pkValues;
    }
}

