/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.statement;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.codefilarete.stalactite.sql.statement.binder.PreparedStatementWriter;
import org.codefilarete.stalactite.sql.statement.binder.PreparedStatementWriterIndex;
import org.codefilarete.stalactite.sql.statement.binder.PreparedStatementWriterProvider;
import org.codefilarete.tool.collection.Iterables;

public abstract class SQLStatement<ParamType> {
    protected final Map<ParamType, Object> values = new HashMap<ParamType, Object>(5);
    protected final PreparedStatementWriterProvider<ParamType> parameterBinderProvider;
    protected final Set<ParamType> expectedParameters;

    protected SQLStatement(Map<? extends ParamType, ? extends PreparedStatementWriter<?>> parameterBinders) {
        this(PreparedStatementWriterIndex.fromMap(parameterBinders));
    }

    protected SQLStatement(PreparedStatementWriterIndex<? extends ParamType, ? extends PreparedStatementWriter<?>> parameterBinderProvider) {
        this.parameterBinderProvider = parameterBinderProvider;
        this.expectedParameters = parameterBinderProvider.keys();
    }

    public PreparedStatementWriterIndex<ParamType, PreparedStatementWriter<?>> getParameterBinderProvider() {
        return (PreparedStatementWriterIndex)this.parameterBinderProvider;
    }

    public void setValues(Map<ParamType, ?> values) {
        this.values.putAll(values);
    }

    public void setValue(ParamType index, Object value) {
        this.values.put(index, value);
    }

    public Map<ParamType, Object> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    public String getSQLSource() {
        return this.getSQL();
    }

    public abstract String getSQL();

    public void applyValues(PreparedStatement statement) {
        this.assertValuesAreApplyable();
        for (Map.Entry<ParamType, Object> indexToValue : this.values.entrySet()) {
            try {
                this.doApplyValue(indexToValue.getKey(), indexToValue.getValue(), statement);
            }
            catch (OutOfMemoryError | RuntimeException e) {
                throw new BindingException(indexToValue.getValue(), indexToValue.getKey(), this.getSQL(), e);
            }
        }
    }

    public void assertValuesAreApplyable() {
        Set<ParamType> paramTypes = this.values.keySet();
        Set indexDiff = Iterables.minus(this.expectedParameters, paramTypes);
        if (!indexDiff.isEmpty()) {
            throw new IllegalArgumentException("Missing value for parameters " + indexDiff + " in values " + this.values + " in \"" + this.getSQL() + "\"");
        }
        Set missingParameters = this.values.keySet().stream().filter(paramType -> this.parameterBinderProvider.doGetWriter(paramType) == null).collect(Collectors.toSet());
        if (!missingParameters.isEmpty()) {
            throw new IllegalArgumentException("Missing binder for " + missingParameters + " for values " + this.values + " in \"" + this.getSQL() + "\"");
        }
    }

    public PreparedStatementWriter<Object> getParameterBinder(ParamType parameter) {
        return this.parameterBinderProvider.getWriter(parameter);
    }

    protected abstract void doApplyValue(ParamType var1, Object var2, PreparedStatement var3);

    protected <T> void doApplyValue(int index, T value, PreparedStatementWriter<T> paramBinder, PreparedStatement statement) {
        try {
            paramBinder.set(statement, index, value);
        }
        catch (SQLException e) {
            throw new BindingException(value, index, this.getSQL(), e);
        }
    }

    public static class BindingException
    extends RuntimeException {
        public BindingException(String message) {
            super(message);
        }

        public BindingException(String message, Throwable cause) {
            super(message, cause);
        }

        public BindingException(Object value, Object paramId, String sql) {
            this("Error while setting value " + value + " for parameter " + paramId + " on statement " + sql);
        }

        public BindingException(Object value, Object paramId, String sql, Throwable cause) {
            this(value, paramId, sql);
            this.initCause(cause);
        }
    }
}

