/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query.builder;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.query.builder.FunctionSQLBuilderFactory;
import org.codefilarete.stalactite.query.builder.SQLAppender;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.ValuedVariable;
import org.codefilarete.stalactite.query.model.Variable;
import org.codefilarete.stalactite.query.model.operator.Between;
import org.codefilarete.stalactite.query.model.operator.Equals;
import org.codefilarete.stalactite.query.model.operator.Greater;
import org.codefilarete.stalactite.query.model.operator.In;
import org.codefilarete.stalactite.query.model.operator.IsNull;
import org.codefilarete.stalactite.query.model.operator.Lesser;
import org.codefilarete.stalactite.query.model.operator.Like;
import org.codefilarete.stalactite.query.model.operator.SQLFunction;
import org.codefilarete.stalactite.query.model.operator.TupleIn;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.VisibleForTesting;

public class OperatorSQLBuilderFactory {
    public OperatorSQLBuilder operatorSQLBuilder(FunctionSQLBuilderFactory.FunctionSQLBuilder functionSQLBuilder) {
        return new OperatorSQLBuilder(functionSQLBuilder);
    }

    public static class OperatorSQLBuilder {
        private final FunctionSQLBuilderFactory.FunctionSQLBuilder functionSQLBuilder;

        public OperatorSQLBuilder(FunctionSQLBuilderFactory.FunctionSQLBuilder functionSQLBuilder) {
            this.functionSQLBuilder = functionSQLBuilder;
        }

        public void cat(ConditionalOperator operator, SQLAppender sql) {
            if (operator instanceof TupleIn) {
                this.catTupledIn((TupleIn)operator, sql);
            } else {
                this.cat(null, operator, sql);
            }
        }

        public <V> void cat(Selectable<V> column, ConditionalOperator<?, V> operator, SQLAppender sql) {
            if (operator.isNull()) {
                this.catNullValue(operator.isNot(), sql);
            } else if (operator instanceof Equals) {
                this.catEquals((Equals)operator, sql, column);
            } else if (operator instanceof Lesser) {
                this.catLower((Lesser)operator, sql, column);
            } else if (operator instanceof Greater) {
                this.catGreater((Greater)operator, sql, column);
            } else if (operator instanceof Between) {
                this.catBetween((Between)operator, sql, column);
            } else if (operator instanceof In) {
                this.catIn((In)operator, sql, column);
            } else if (operator instanceof Like) {
                this.catLike((Like)operator, sql, column);
            } else if (operator instanceof IsNull) {
                this.catIsNull((IsNull)operator, sql);
            } else {
                throw new UnsupportedOperationException("Operator " + Reflections.toString(operator.getClass()) + " is not implemented");
            }
        }

        void catNullValue(boolean not, SQLAppender sql) {
            sql.cat("is", new String[0]).catIf(not, " not").cat(" null", new String[0]);
        }

        void catIsNull(IsNull isNull, SQLAppender sql) {
            this.catNullValue(isNull.isNot(), sql);
        }

        void catLike(Like like, SQLAppender sql, Selectable<?> column) {
            sql.catIf(like.isNot(), "not ").cat("like ", new String[0]);
            LikePatternAppender likePatternAppender = new LikePatternAppender(like, sql);
            if (like.getValue() instanceof ValuedVariable) {
                Object value = ((ValuedVariable)like.getValue()).getValue();
                if (value instanceof SQLFunction) {
                    this.functionSQLBuilder.cat((SQLFunction)value, likePatternAppender);
                } else {
                    likePatternAppender.catValue(column, like.getValue());
                }
            } else {
                likePatternAppender.catValue(column, like.getValue());
            }
        }

        <V> void catIn(In<V> in, SQLAppender sql, Selectable<V> column) {
            Variable<Iterable<V>> value = in.getValue();
            sql.catIf(in.isNot(), "not ").cat("in (", new String[0]);
            this.catInValue(value, sql, column);
            sql.cat(")", new String[0]);
        }

        void catTupledIn(TupleIn in, SQLAppender sql) {
            Column[] columns = in.getColumns();
            sql.catIf(in.isNot(), "not ");
            sql.cat("(", new String[0]);
            Iterator columnIterator = Arrays.stream(columns).iterator();
            while (columnIterator.hasNext()) {
                sql.catColumn((Selectable)columnIterator.next()).catIf(columnIterator.hasNext(), ", ");
            }
            sql.cat(")", new String[0]);
            sql.cat(" in (", new String[0]);
            Variable<List<Object[]>> value = in.getValue();
            if (value instanceof ValuedVariable) {
                List values = (List)((ValuedVariable)value).getValue();
                if (values == null) {
                    int columnCount = columns.length;
                    for (int i = 0; i < columnCount; ++i) {
                        sql.catValue(columns[i], null).catIf(i < columnCount - 1, ", ");
                    }
                } else {
                    Iterator valuesIterator = values.iterator();
                    while (valuesIterator.hasNext()) {
                        Object[] vals = (Object[])valuesIterator.next();
                        sql.cat("(", new String[0]);
                        int columnCount = columns.length;
                        for (int i = 0; i < columnCount; ++i) {
                            sql.catValue(columns[i], vals[i]).catIf(i < columnCount - 1, ", ");
                        }
                        sql.cat(")", new String[0]).catIf(valuesIterator.hasNext(), ", ");
                    }
                }
            }
            sql.cat(")", new String[0]);
        }

        private <V> void catInValue(Variable<Iterable<V>> value, SQLAppender sql, Selectable<V> column) {
            boolean isFirst = true;
            if (value instanceof ValuedVariable) {
                for (Object v : (Iterable)((ValuedVariable)value).getValue()) {
                    if (!isFirst) {
                        sql.cat(", ", new String[0]);
                    } else {
                        isFirst = false;
                    }
                    if (v instanceof SQLFunction) {
                        this.functionSQLBuilder.cat((SQLFunction)v, sql);
                        continue;
                    }
                    sql.catValue(column, v);
                }
            } else {
                sql.catValue(column, value);
            }
        }

        <V> void catBetween(Between<V> between, SQLAppender sql, Selectable<V> column) {
            Variable<Between.Interval<V>> value = between.getValue();
            if (value instanceof ValuedVariable) {
                Between.Interval interval = (Between.Interval)((ValuedVariable)value).getValue();
                if (interval.getValue1() == null) {
                    sql.cat(between.isNot() ? ">= " : "< ", new String[0]).catValue(column, interval.getValue2());
                } else if (interval.getValue2() == null) {
                    sql.cat(between.isNot() ? "<= " : "> ", new String[0]).catValue(column, interval.getValue1());
                } else {
                    sql.catIf(between.isNot(), "not ").cat("between ", new String[0]).catValue(column, interval.getValue1()).cat(" and ", new String[0]).catValue(column, interval.getValue2());
                }
            }
        }

        <V> void catGreater(Greater<V> greater, SQLAppender sql, Selectable<V> column) {
            sql.cat(greater.isNot() ? (greater.isEquals() ? "< " : "<= ") : (greater.isEquals() ? ">= " : "> "), new String[0]);
            this.catValue(column, greater.getValue(), sql);
        }

        <V> void catLower(Lesser<V> lesser, SQLAppender sql, Selectable<V> column) {
            sql.cat(lesser.isNot() ? (lesser.isEquals() ? "> " : ">= ") : (lesser.isEquals() ? "<= " : "< "), new String[0]);
            this.catValue(column, lesser.getValue(), sql);
        }

        <V> void catEquals(Equals<V> equals, SQLAppender sql, Selectable<V> column) {
            sql.catIf(equals.isNot(), "!").cat("= ", new String[0]);
            this.catValue(column, equals.getValue(), sql);
        }

        <V> void catValue(@Nullable Selectable<V> column, Variable<V> variable, SQLAppender sql) {
            if (variable instanceof ValuedVariable) {
                Object value = ((ValuedVariable)variable).getValue();
                if (value instanceof SQLFunction) {
                    this.functionSQLBuilder.cat((SQLFunction)value, sql);
                } else {
                    sql.catValue(column, variable);
                }
            } else {
                sql.catValue(column, variable);
            }
        }

        @VisibleForTesting
        static class LikePatternAppender
        implements SQLAppender {
            private final Like<?> like;
            private final SQLAppender sql;

            @VisibleForTesting
            LikePatternAppender(Like<?> like, SQLAppender sql) {
                this.like = like;
                this.sql = sql;
            }

            @Override
            public <V> SQLAppender catValue(@Nullable Selectable<V> column, Object variable) {
                if (variable instanceof ValuedVariable) {
                    Object value = ((ValuedVariable)variable).getValue();
                    if (value instanceof CharSequence) {
                        this.sql.catValue(column, this.addWildcards((CharSequence)value));
                    } else {
                        this.sql.catValue(column, variable);
                    }
                } else {
                    this.sql.catValue(column, variable);
                }
                return this;
            }

            private CharSequence addWildcards(CharSequence effectiveValue) {
                if (this.like.withLeadingStar()) {
                    effectiveValue = "%" + effectiveValue;
                }
                if (this.like.withEndingStar()) {
                    effectiveValue = effectiveValue + "%";
                }
                return effectiveValue;
            }

            @Override
            public SQLAppender catValue(Object value) {
                if (value instanceof ValuedVariable) {
                    value = ((ValuedVariable)value).getValue();
                }
                if (value instanceof Selectable) {
                    this.sql.catValue(this.addWildcards(((Selectable)value).getExpression()));
                } else if (value instanceof CharSequence) {
                    this.sql.catValue(this.addWildcards((CharSequence)value));
                } else {
                    throw new UnsupportedOperationException("Appending '" + value + "'" + (value == null ? "" : " (type " + Reflections.toString(value.getClass()) + ")") + " is not supported");
                }
                return this;
            }

            @Override
            public SQLAppender cat(String s, String ... ss) {
                this.sql.cat(s, ss);
                return this;
            }

            @Override
            public SQLAppender catColumn(Selectable<?> column) {
                this.sql.catColumn(column);
                return this;
            }

            @Override
            public SQLAppender catTable(Fromable table) {
                this.sql.catTable(table);
                return this;
            }

            @Override
            public SQLAppender removeLastChars(int length) {
                this.sql.removeLastChars(length);
                return this;
            }

            @Override
            public String getSQL() {
                return this.sql.getSQL();
            }

            @Override
            public SQLAppender.SubSQLAppender newSubPart(DMLNameProvider dmlNameProvider) {
                final LikePatternAppender self = this;
                return new SQLAppender.DefaultSubSQLAppender(new LikePatternAppender(this.like, this.sql.newSubPart(dmlNameProvider))){

                    @Override
                    public SQLAppender close() {
                        return self;
                    }
                };
            }
        }
    }
}

