/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.statement.binder;

import java.util.Map;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.binder.PreparedStatementWriter;

@FunctionalInterface
public interface PreparedStatementWriterProvider<K> {
    default public PreparedStatementWriter getWriter(K key) {
        PreparedStatementWriter writer = this.doGetWriter(key);
        if (writer == null) {
            throw new SQLStatement.BindingException("Writer for " + key + " is not registered");
        }
        return writer;
    }

    public PreparedStatementWriter doGetWriter(K var1);

    public static class PreparedStatementWriterProviderFromMap<ParamType, BINDER extends PreparedStatementWriter>
    implements PreparedStatementWriterProvider<ParamType> {
        private final Map<ParamType, BINDER> parameterBinders;

        public PreparedStatementWriterProviderFromMap(Map<ParamType, BINDER> parameterBinders) {
            this.parameterBinders = parameterBinders;
        }

        public Map<ParamType, BINDER> getParameterBinders() {
            return this.parameterBinders;
        }

        @Override
        public PreparedStatementWriter doGetWriter(ParamType key) {
            return (PreparedStatementWriter)this.parameterBinders.get(key);
        }
    }
}

