/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.codefilarete.stalactite.engine.InsertExecutor;
import org.codefilarete.stalactite.engine.SelectExecutor;
import org.codefilarete.stalactite.engine.UpdateExecutor;
import org.codefilarete.stalactite.engine.runtime.ConfiguredPersister;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.Maps;

public interface PersistExecutor<C> {
    public void persist(Iterable<? extends C> var1);

    public static <C, I> void persist(Iterable<? extends C> entities, ConfiguredPersister<C, I> persister) {
        PersistExecutor.persist(entities, persister::isNew, persister, persister, persister, persister::getId);
    }

    public static <C, I> void persist(Iterable<? extends C> entities, Predicate<C> isNewProvider, SelectExecutor<C, I> selector, UpdateExecutor<C> updater, InsertExecutor<C> inserter, Function<C, I> idProvider) {
        if (Iterables.isEmpty(entities)) {
            return;
        }
        ArrayList<C> toInsert = new ArrayList<C>(20);
        ArrayList<C> toUpdate = new ArrayList<C>(20);
        for (C c : entities) {
            if (isNewProvider.test(c)) {
                toInsert.add(c);
                continue;
            }
            toUpdate.add(c);
        }
        if (!toInsert.isEmpty()) {
            inserter.insert(toInsert);
        }
        if (!toUpdate.isEmpty()) {
            Set<C> loadedEntities = selector.select(Iterables.collect(toUpdate, idProvider, HashSet::new));
            Map loadedEntitiesPerId = Iterables.map(loadedEntities, idProvider);
            Map modifiedEntitiesPerId = Iterables.map(toUpdate, idProvider);
            Map modifiedVSunmodified = Maps.innerJoin((Map)modifiedEntitiesPerId, (Map)loadedEntitiesPerId);
            ArrayList updateArg = new ArrayList();
            modifiedVSunmodified.forEach((k, v) -> updateArg.add(new Duo(k, v)));
            updater.update(updateArg, true);
        }
    }

    public static <C, I> void persist(Iterable<? extends C> entities, SelectExecutor<C, I> selector, UpdateExecutor<C> updater, InsertExecutor<C> inserter, Function<C, I> idProvider) {
        if (Iterables.isEmpty(entities)) {
            return;
        }
        Set entitiesIds = (Set)Iterables.collect(entities, idProvider::apply, HashSet::new);
        Set loadedEntities = selector.select(entitiesIds);
        Set existingEntitiesIds = (Set)Iterables.collect(loadedEntities, idProvider::apply, HashSet::new);
        Predicate<Object> isNewProvider = c -> !existingEntitiesIds.contains(idProvider.apply(c));
        PersistExecutor.persist(entities, isNewProvider, ids -> loadedEntities, updater, inserter, idProvider);
    }
}

