/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import javax.sql.DataSource;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.stalactite.engine.CascadeOptions;
import org.codefilarete.stalactite.engine.EmbeddableMappingConfigurationProvider;
import org.codefilarete.stalactite.engine.EntityMappingConfigurationProvider;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.FluentEntityMappingBuilder;
import org.codefilarete.stalactite.engine.MapEntryTableNamingStrategy;
import org.codefilarete.stalactite.engine.MappingEase;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.engine.configurer.PersisterBuilderImplTest;
import org.codefilarete.stalactite.engine.model.Car;
import org.codefilarete.stalactite.engine.model.City;
import org.codefilarete.stalactite.engine.model.Country;
import org.codefilarete.stalactite.engine.model.Person;
import org.codefilarete.stalactite.engine.model.Timestamp;
import org.codefilarete.stalactite.engine.runtime.ConfiguredPersister;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.id.Identified;
import org.codefilarete.stalactite.id.Identifier;
import org.codefilarete.stalactite.id.PersistableIdentifier;
import org.codefilarete.stalactite.id.StatefulIdentifierAlreadyAssignedIdentifierPolicy;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.HSQLDBDialectBuilder;
import org.codefilarete.stalactite.sql.ddl.DDLDeployer;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.ForeignKey;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.stalactite.sql.test.HSQLDBInMemoryDataSource;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.Maps;
import org.codefilarete.tool.function.Functions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

@Nested
class FluentEntityMappingConfigurationSupportMapTest {
    private final Dialect dialect = HSQLDBDialectBuilder.defaultHSQLDBDialect();
    private final DataSource dataSource = new HSQLDBInMemoryDataSource();
    private PersistenceContext persistenceContext;

    FluentEntityMappingConfigurationSupportMapTest() {
    }

    @BeforeEach
    void initTest() {
        this.dialect.getDmlGenerator().sortColumnsAlphabetically();
        this.dialect.getColumnBinderRegistry().register(Identifier.class, Identifier.identifierBinder(DefaultParameterBinders.LONG_PRIMITIVE_BINDER));
        this.dialect.getColumnBinderRegistry().register(Identified.class, Identifier.identifierBinder(DefaultParameterBinders.LONG_PRIMITIVE_BINDER));
        this.dialect.getSqlTypeRegistry().put(Identifier.class, "int");
        this.persistenceContext = new PersistenceContext(this.dataSource, this.dialect);
    }

    @Test
    void insert() {
        ConfiguredPersister personPersister = (ConfiguredPersister)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapMap(Person::getPhoneNumbers, String.class, String.class).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Person person = new Person(new PersistableIdentifier<Long>(1L));
        person.setPhoneNumbers((Map<String, String>)Maps.forHashMap(String.class, String.class).add((Object)"home", (Object)"01 11 11 11 11").add((Object)"work", (Object)"02 22 22 22 22").add((Object)"mobile", (Object)"03 33 33 33 33"));
        personPersister.insert((Object)person);
        Person loadedPerson = (Person)personPersister.select(person.getId());
        Assertions.assertThat(loadedPerson.getPhoneNumbers()).isEqualTo((Object)Maps.forHashMap(String.class, String.class).add((Object)"home", (Object)"01 11 11 11 11").add((Object)"work", (Object)"02 22 22 22 22").add((Object)"mobile", (Object)"03 33 33 33 33"));
    }

    @Test
    void update_objectAddition() {
        ConfiguredPersister personPersister = (ConfiguredPersister)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapMap(Person::getPhoneNumbers, String.class, String.class).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Person person = new Person(new PersistableIdentifier<Long>(1L));
        person.setPhoneNumbers((Map<String, String>)Maps.forHashMap(String.class, String.class).add((Object)"home", (Object)"01 11 11 11 11").add((Object)"work", (Object)"02 22 22 22 22").add((Object)"mobile", (Object)"03 33 33 33 33"));
        personPersister.insert((Object)person);
        Person loadedPerson = (Person)personPersister.select(person.getId());
        Assertions.assertThat(loadedPerson.getPhoneNumbers()).isEqualTo((Object)Maps.forHashMap(String.class, String.class).add((Object)"home", (Object)"01 11 11 11 11").add((Object)"work", (Object)"02 22 22 22 22").add((Object)"mobile", (Object)"03 33 33 33 33"));
        loadedPerson.getPhoneNumbers().put("vacation site", "04 44 44 44 44");
        personPersister.update((Object)loadedPerson, (Object)person, true);
        loadedPerson = (Person)personPersister.select(person.getId());
        Assertions.assertThat(loadedPerson.getPhoneNumbers()).isEqualTo((Object)Maps.forHashMap(String.class, String.class).add((Object)"home", (Object)"01 11 11 11 11").add((Object)"work", (Object)"02 22 22 22 22").add((Object)"mobile", (Object)"03 33 33 33 33").add((Object)"vacation site", (Object)"04 44 44 44 44"));
    }

    @Test
    void update_objectRemoval() {
        ConfiguredPersister personPersister = (ConfiguredPersister)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapMap(Person::getPhoneNumbers, String.class, String.class).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Person person = new Person(new PersistableIdentifier<Long>(1L));
        person.setPhoneNumbers((Map<String, String>)Maps.forHashMap(String.class, String.class).add((Object)"home", (Object)"01 11 11 11 11").add((Object)"work", (Object)"02 22 22 22 22").add((Object)"mobile", (Object)"03 33 33 33 33"));
        personPersister.insert((Object)person);
        Person loadedPerson = (Person)personPersister.select(person.getId());
        Assertions.assertThat(loadedPerson.getPhoneNumbers()).isEqualTo((Object)Maps.forHashMap(String.class, String.class).add((Object)"home", (Object)"01 11 11 11 11").add((Object)"work", (Object)"02 22 22 22 22").add((Object)"mobile", (Object)"03 33 33 33 33"));
        loadedPerson.getPhoneNumbers().remove("home");
        personPersister.update((Object)loadedPerson, (Object)person, true);
        loadedPerson = (Person)personPersister.select(person.getId());
        Assertions.assertThat(loadedPerson.getPhoneNumbers()).isEqualTo((Object)Maps.forHashMap(String.class, String.class).add((Object)"work", (Object)"02 22 22 22 22").add((Object)"mobile", (Object)"03 33 33 33 33"));
    }

    @Test
    void delete() {
        ConfiguredPersister personPersister = (ConfiguredPersister)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapMap(Person::getPhoneNumbers, String.class, String.class).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Person person = new Person(new PersistableIdentifier<Long>(1L));
        person.setPhoneNumbers((Map<String, String>)Maps.forHashMap(String.class, String.class).add((Object)"home", (Object)"01 11 11 11 11").add((Object)"work", (Object)"02 22 22 22 22").add((Object)"mobile", (Object)"03 33 33 33 33"));
        personPersister.insert((Object)person);
        Person loadedPerson = (Person)personPersister.select(person.getId());
        Assertions.assertThat(loadedPerson.getPhoneNumbers()).isEqualTo((Object)Maps.forHashMap(String.class, String.class).add((Object)"home", (Object)"01 11 11 11 11").add((Object)"work", (Object)"02 22 22 22 22").add((Object)"mobile", (Object)"03 33 33 33 33"));
        personPersister.delete((Object)loadedPerson);
        PersistenceContext.ExecutableBeanPropertyQueryMapper stringExecutableQuery = this.persistenceContext.newQuery((CharSequence)"select 'key' from Person_phoneNumbers", String.class).mapKey("key", String.class);
        Set remainingPhoneNumbers = (Set)stringExecutableQuery.execute(Accumulators.toSet());
        Assertions.assertThat((Collection)remainingPhoneNumbers).isEmpty();
    }

    @Test
    void withCollectionFactory() {
        ConfiguredPersister personPersister = (ConfiguredPersister)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapMap(Person::getPhoneNumbers, String.class, String.class).withMapFactory(() -> new TreeMap(String.CASE_INSENSITIVE_ORDER.reversed())).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Person person = new Person(new PersistableIdentifier<Long>(1L));
        person.setPhoneNumbers((Map<String, String>)Maps.forHashMap(String.class, String.class).add((Object)"home", (Object)"01 11 11 11 11").add((Object)"work", (Object)"02 22 22 22 22").add((Object)"mobile", (Object)"03 33 33 33 33"));
        personPersister.insert((Object)person);
        Person loadedPerson = (Person)personPersister.select(person.getId());
        Assertions.assertThat(loadedPerson.getPhoneNumbers()).containsExactly(new Map.Entry[]{new AbstractMap.SimpleEntry<String, String>("work", "02 22 22 22 22"), new AbstractMap.SimpleEntry<String, String>("mobile", "03 33 33 33 33"), new AbstractMap.SimpleEntry<String, String>("home", "01 11 11 11 11")});
    }

    @Test
    void foreignKeyIsPresent() {
        MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapMap(Person::getPhoneNumbers, String.class, String.class).build(this.persistenceContext);
        Collection tables = DDLDeployer.collectTables((PersistenceContext)this.persistenceContext);
        Map tablePerName = Iterables.map((Iterable)tables, Table::getName);
        Table personTable = (Table)tablePerName.get("Person");
        Table nickNamesTable = (Table)tablePerName.get("Person_phoneNumbers");
        Function columnPrinter = PersisterBuilderImplTest.ToStringBuilder.of(", ", Column::getAbsoluteName, Functions.chain(Column::getJavaType, Reflections::toString));
        Function fkPrinter = PersisterBuilderImplTest.ToStringBuilder.of(", ", ForeignKey::getName, Functions.link(ForeignKey::getColumns, PersisterBuilderImplTest.ToStringBuilder.asSeveral(columnPrinter)), Functions.link(ForeignKey::getTargetColumns, PersisterBuilderImplTest.ToStringBuilder.asSeveral(columnPrinter)));
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)nickNamesTable.getForeignKeys()).usingElementComparator(Comparator.comparing(fkPrinter))).containsExactly((Object[])new ForeignKey[]{new ForeignKey("FK_Person_phoneNumbers_id_Person_id", nickNamesTable.getColumn("id"), personTable.getColumn("id"))});
    }

    @Test
    void withReverseJoinColumn() {
        MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapMap(Person::getPhoneNumbers, String.class, String.class).withReverseJoinColumn("identifier").build(this.persistenceContext);
        Collection tables = DDLDeployer.collectTables((PersistenceContext)this.persistenceContext);
        Map tablePerName = Iterables.map((Iterable)tables, Table::getName);
        Table personTable = (Table)tablePerName.get("Person");
        Table nickNamesTable = (Table)tablePerName.get("Person_phoneNumbers");
        Assertions.assertThat((Object)nickNamesTable).isNotNull();
        Function columnPrinter = PersisterBuilderImplTest.ToStringBuilder.of(", ", Column::getAbsoluteName, Functions.chain(Column::getJavaType, Reflections::toString));
        Function fkPrinter = PersisterBuilderImplTest.ToStringBuilder.of(", ", ForeignKey::getName, Functions.link(ForeignKey::getColumns, PersisterBuilderImplTest.ToStringBuilder.asSeveral(columnPrinter)), Functions.link(ForeignKey::getTargetColumns, PersisterBuilderImplTest.ToStringBuilder.asSeveral(columnPrinter)));
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)nickNamesTable.getForeignKeys()).usingElementComparator(Comparator.comparing(fkPrinter))).containsExactly((Object[])new ForeignKey[]{new ForeignKey("FK_Person_phoneNumbers_identifier_Person_id", nickNamesTable.getColumn("identifier"), personTable.getColumn("id"))});
    }

    @Test
    void withMapEntryTableNaming() {
        MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).withMapEntryTableNaming(new MapEntryTableNamingStrategy(){

            public String giveTableName(AccessorDefinition accessorDefinition, Class<?> keyType, Class<?> valueType) {
                return "Toto";
            }

            public <RIGHTTABLE extends Table<RIGHTTABLE>, RIGHTID> Map<Column<RIGHTTABLE, ?>, String> giveMapKeyColumnNames(AccessorDefinition accessorDefinition, Class entityType, PrimaryKey<RIGHTTABLE, RIGHTID> rightPrimaryKey, Set<String> existingColumnNames) {
                return null;
            }
        }).mapMap(Person::getPhoneNumbers, String.class, String.class).build(this.persistenceContext);
        Collection tables = DDLDeployer.collectTables((PersistenceContext)this.persistenceContext);
        Map tablePerName = Iterables.map((Iterable)tables, Table::getName);
        Table personTable = (Table)tablePerName.get("Person");
        Table nickNamesTable = (Table)tablePerName.get("Toto");
        Assertions.assertThat((Object)nickNamesTable).isNotNull();
        Function columnPrinter = PersisterBuilderImplTest.ToStringBuilder.of(", ", Column::getAbsoluteName, Functions.chain(Column::getJavaType, Reflections::toString));
        Function fkPrinter = PersisterBuilderImplTest.ToStringBuilder.of(", ", ForeignKey::getName, Functions.link(ForeignKey::getColumns, PersisterBuilderImplTest.ToStringBuilder.asSeveral(columnPrinter)), Functions.link(ForeignKey::getTargetColumns, PersisterBuilderImplTest.ToStringBuilder.asSeveral(columnPrinter)));
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)nickNamesTable.getForeignKeys()).usingElementComparator(Comparator.comparing(fkPrinter))).containsExactly((Object[])new ForeignKey[]{new ForeignKey("FK_Toto_id_Person_id", nickNamesTable.getColumn("id"), personTable.getColumn("id"))});
    }

    @Test
    void withTable() {
        Table phoneNumbersTable = new Table("Toto");
        MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapMap(Person::getPhoneNumbers, String.class, String.class).withTable(phoneNumbersTable).build(this.persistenceContext);
        Collection tables = DDLDeployer.collectTables((PersistenceContext)this.persistenceContext);
        Map tablePerName = Iterables.map((Iterable)tables, Table::getName);
        Table personTable = (Table)tablePerName.get("Person");
        Function columnPrinter = PersisterBuilderImplTest.ToStringBuilder.of(", ", Column::getAbsoluteName, Functions.chain(Column::getJavaType, Reflections::toString));
        Function fkPrinter = PersisterBuilderImplTest.ToStringBuilder.of(", ", ForeignKey::getName, Functions.link(ForeignKey::getColumns, PersisterBuilderImplTest.ToStringBuilder.asSeveral(columnPrinter)), Functions.link(ForeignKey::getTargetColumns, PersisterBuilderImplTest.ToStringBuilder.asSeveral(columnPrinter)));
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)phoneNumbersTable.getForeignKeys()).usingElementComparator(Comparator.comparing(fkPrinter))).containsExactly((Object[])new ForeignKey[]{new ForeignKey("FK_Toto_id_Person_id", phoneNumbersTable.getColumn("id"), personTable.getColumn("id"))});
    }

    @Test
    void withTableName() {
        MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapMap(Person::getPhoneNumbers, String.class, String.class).withTable("Toto").build(this.persistenceContext);
        Collection tables = DDLDeployer.collectTables((PersistenceContext)this.persistenceContext);
        Map tablePerName = Iterables.map((Iterable)tables, Table::getName);
        Table personTable = (Table)tablePerName.get("Person");
        Table nickNamesTable = (Table)tablePerName.get("Toto");
        Assertions.assertThat((Object)nickNamesTable).isNotNull();
        Function columnPrinter = PersisterBuilderImplTest.ToStringBuilder.of(", ", Column::getAbsoluteName, Functions.chain(Column::getJavaType, Reflections::toString));
        Function fkPrinter = PersisterBuilderImplTest.ToStringBuilder.of(", ", ForeignKey::getName, Functions.link(ForeignKey::getColumns, PersisterBuilderImplTest.ToStringBuilder.asSeveral(columnPrinter)), Functions.link(ForeignKey::getTargetColumns, PersisterBuilderImplTest.ToStringBuilder.asSeveral(columnPrinter)));
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)nickNamesTable.getForeignKeys()).usingElementComparator(Comparator.comparing(fkPrinter))).containsExactly((Object[])new ForeignKey[]{new ForeignKey("FK_Toto_id_Person_id", nickNamesTable.getColumn("id"), personTable.getColumn("id"))});
    }

    @Test
    void overrideKeyColumnName() {
        MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapMap(Person::getPhoneNumbers, String.class, String.class).withKeyColumn("toto").build(this.persistenceContext);
        Collection tables = DDLDeployer.collectTables((PersistenceContext)this.persistenceContext);
        Map tablePerName = Iterables.map((Iterable)tables, Table::getName);
        Table nickNamesTable = (Table)tablePerName.get("Person_phoneNumbers");
        Assertions.assertThat(nickNamesTable.mapColumnsOnName().keySet()).containsExactlyInAnyOrder((Object[])new String[]{"id", "toto", "value"});
    }

    @Test
    void overrideValueColumnName() {
        MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapMap(Person::getPhoneNumbers, String.class, String.class).withValueColumn("toto").build(this.persistenceContext);
        Collection tables = DDLDeployer.collectTables((PersistenceContext)this.persistenceContext);
        Map tablePerName = Iterables.map((Iterable)tables, Table::getName);
        Table nickNamesTable = (Table)tablePerName.get("Person_phoneNumbers");
        Assertions.assertThat(nickNamesTable.mapColumnsOnName().keySet()).containsExactlyInAnyOrder((Object[])new String[]{"id", "toto", "key"});
    }

    @Test
    void crudEnum() {
        ConfiguredPersister personPersister = (ConfiguredPersister)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapMap(Person::getAddressBook, Person.AddressBookType.class, String.class).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Person person = new Person(new PersistableIdentifier<Long>(1L));
        person.setAddressBook((Map<Person.AddressBookType, String>)Maps.forHashMap(Person.AddressBookType.class, String.class).add((Object)Person.AddressBookType.HOME, (Object)"Grenoble").add((Object)Person.AddressBookType.BILLING_ADDRESS, (Object)"Lyon"));
        personPersister.insert((Object)person);
        Person loadedPerson = (Person)personPersister.select(person.getId());
        Assertions.assertThat(loadedPerson.getAddressBook()).isEqualTo((Object)Maps.forHashMap(Person.AddressBookType.class, String.class).add((Object)Person.AddressBookType.HOME, (Object)"Grenoble").add((Object)Person.AddressBookType.BILLING_ADDRESS, (Object)"Lyon"));
        person.getAddressBook().remove((Object)Person.AddressBookType.HOME);
        person.getAddressBook().put(Person.AddressBookType.OTHER, "Marseille");
        personPersister.update((Object)person, (Object)loadedPerson, true);
        loadedPerson = (Person)personPersister.select(person.getId());
        Assertions.assertThat(loadedPerson.getAddressBook()).isEqualTo((Object)Maps.forHashMap(Person.AddressBookType.class, String.class).add((Object)Person.AddressBookType.OTHER, (Object)"Marseille").add((Object)Person.AddressBookType.BILLING_ADDRESS, (Object)"Lyon"));
        personPersister.delete((Object)loadedPerson);
        PersistenceContext.ExecutableBeanPropertyQueryMapper stringExecutableQuery = this.persistenceContext.newQuery((CharSequence)"select 'key' from Person_addressBook", String.class).mapKey("key", String.class);
        Set remainingAddressBook = (Set)stringExecutableQuery.execute(Accumulators.toSet());
        Assertions.assertThat((Collection)remainingAddressBook).isEmpty();
    }

    @Test
    void crud_keyIsComplexType() {
        ConfiguredPersister personPersister = (ConfiguredPersister)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapMap(Person::getAddresses, Timestamp.class, String.class).withKeyMapping((EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate)).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Person person = new Person(new PersistableIdentifier<Long>(1L));
        LocalDateTime now = LocalDateTime.now();
        person.setAddresses((Map<Timestamp, String>)Maps.forHashMap(Timestamp.class, String.class).add((Object)new Timestamp(now.minusDays(10L), now.minusDays(10L)), (Object)"Grenoble").add((Object)new Timestamp(now.minusDays(1L), now.minusDays(1L)), (Object)"Lyon"));
        personPersister.insert((Object)person);
        Person loadedPerson = (Person)personPersister.select(person.getId());
        Assertions.assertThat(loadedPerson.getAddresses()).isEqualTo((Object)Maps.forHashMap(Timestamp.class, String.class).add((Object)new Timestamp(now.minusDays(10L), now.minusDays(10L)), (Object)"Grenoble").add((Object)new Timestamp(now.minusDays(1L), now.minusDays(1L)), (Object)"Lyon"));
        person.getAddresses().remove(new Timestamp(now.minusDays(10L), now.minusDays(10L)));
        person.getAddresses().put(new Timestamp(now.minusDays(1L), now.minusDays(1L)), "Paris");
        person.getAddresses().put(new Timestamp(now.minusDays(5L), now.minusDays(5L)), "Marseille");
        personPersister.update((Object)person, (Object)loadedPerson, true);
        loadedPerson = (Person)personPersister.select(person.getId());
        Assertions.assertThat(loadedPerson.getAddresses()).isEqualTo((Object)Maps.forHashMap(Timestamp.class, String.class).add((Object)new Timestamp(now.minusDays(5L), now.minusDays(5L)), (Object)"Marseille").add((Object)new Timestamp(now.minusDays(1L), now.minusDays(1L)), (Object)"Paris"));
        personPersister.delete((Object)loadedPerson);
        PersistenceContext.ExecutableBeanPropertyQueryMapper stringExecutableQuery = this.persistenceContext.newQuery((CharSequence)"select 'key' from Person_addresses", String.class).mapKey("key", String.class);
        Set remainingAddressBook = (Set)stringExecutableQuery.execute(Accumulators.toSet());
        Assertions.assertThat((Collection)remainingAddressBook).isEmpty();
    }

    @Test
    void crud_valueIsComplexType() {
        ConfiguredPersister personPersister = (ConfiguredPersister)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapMap(Person::getContracts, String.class, Timestamp.class).withValueMapping((EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate)).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Person person = new Person(new PersistableIdentifier<Long>(1L));
        LocalDateTime now = LocalDateTime.now();
        person.setContracts((Map<String, Timestamp>)Maps.forHashMap(String.class, Timestamp.class).add((Object)"Grenoble", (Object)new Timestamp(now.minusDays(10L), now.minusDays(10L))).add((Object)"Lyon", (Object)new Timestamp(now.minusDays(1L), now.minusDays(1L))));
        personPersister.insert((Object)person);
        Person loadedPerson = (Person)personPersister.select(person.getId());
        Assertions.assertThat(loadedPerson.getContracts()).isEqualTo((Object)Maps.forHashMap(String.class, Timestamp.class).add((Object)"Grenoble", (Object)new Timestamp(now.minusDays(10L), now.minusDays(10L))).add((Object)"Lyon", (Object)new Timestamp(now.minusDays(1L), now.minusDays(1L))));
        person.getContracts().remove("Grenoble");
        person.getContracts().put("Lyon", new Timestamp(now.minusDays(2L), now.minusDays(2L)));
        person.getContracts().put("Marseille", new Timestamp(now.minusDays(5L), now.minusDays(5L)));
        personPersister.update((Object)person, (Object)loadedPerson, true);
        loadedPerson = (Person)personPersister.select(person.getId());
        Assertions.assertThat(loadedPerson.getContracts()).isEqualTo((Object)Maps.forHashMap(String.class, Timestamp.class).add((Object)"Marseille", (Object)new Timestamp(now.minusDays(5L), now.minusDays(5L))).add((Object)"Lyon", (Object)new Timestamp(now.minusDays(2L), now.minusDays(2L))));
        personPersister.delete((Object)loadedPerson);
        PersistenceContext.ExecutableBeanPropertyQueryMapper stringExecutableQuery = this.persistenceContext.newQuery((CharSequence)"select 'key' from Person_contracts", String.class).mapKey("key", String.class);
        Set remainingAddressBook = (Set)stringExecutableQuery.execute(Accumulators.toSet());
        Assertions.assertThat((Collection)remainingAddressBook).isEmpty();
    }

    @Test
    void crud_keyAndValueIsComplexType() {
        ConfiguredPersister personPersister = (ConfiguredPersister)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapMap(Person::getMapPropertyMadeOfComplexTypes, Timestamp.class, Car.Radio.class).withKeyMapping((EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate)).withValueMapping((EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Car.Radio.class).map(Car.Radio::getSerialNumber).map(Car.Radio::getModel)).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Person person = new Person(new PersistableIdentifier<Long>(1L));
        LocalDateTime now = LocalDateTime.now();
        Car.Radio radio1 = new Car.Radio("123");
        radio1.setModel("model1");
        Car.Radio radio2 = new Car.Radio("456");
        radio2.setModel("model2");
        person.setMapPropertyMadeOfComplexTypes((Map<Timestamp, Car.Radio>)Maps.forHashMap(Timestamp.class, Car.Radio.class).add((Object)new Timestamp(now.minusDays(1L), now.minusDays(1L)), (Object)radio1).add((Object)new Timestamp(now.minusDays(2L), now.minusDays(2L)), (Object)radio2));
        personPersister.insert((Object)person);
        Person loadedPerson = (Person)personPersister.select(person.getId());
        Assertions.assertThat(loadedPerson.getMapPropertyMadeOfComplexTypes()).isEqualTo((Object)Maps.forHashMap(Timestamp.class, Car.Radio.class).add((Object)new Timestamp(now.minusDays(1L), now.minusDays(1L)), (Object)radio1).add((Object)new Timestamp(now.minusDays(2L), now.minusDays(2L)), (Object)radio2));
        Car.Radio radio3 = new Car.Radio("789");
        radio3.setModel("model3");
        person.getMapPropertyMadeOfComplexTypes().remove(new Timestamp(now.minusDays(1L), now.minusDays(1L)));
        Car.Radio radio4 = new Car.Radio("789");
        radio4.setModel("model4");
        person.getMapPropertyMadeOfComplexTypes().put(new Timestamp(now.minusDays(2L), now.minusDays(2L)), radio4);
        person.getMapPropertyMadeOfComplexTypes().put(new Timestamp(now.minusDays(3L), now.minusDays(3L)), radio3);
        personPersister.update((Object)person, (Object)loadedPerson, true);
        loadedPerson = (Person)personPersister.select(person.getId());
        Assertions.assertThat(loadedPerson.getMapPropertyMadeOfComplexTypes()).isEqualTo((Object)Maps.forHashMap(Timestamp.class, Car.Radio.class).add((Object)new Timestamp(now.minusDays(2L), now.minusDays(2L)), (Object)radio4).add((Object)new Timestamp(now.minusDays(3L), now.minusDays(3L)), (Object)radio3));
        personPersister.delete((Object)loadedPerson);
        PersistenceContext.ExecutableBeanPropertyQueryMapper stringExecutableQuery = this.persistenceContext.newQuery((CharSequence)"select 'key' from Person_mapPropertyMadeOfComplexTypes", String.class).mapKey("key", String.class);
        Set remainingAddressBook = (Set)stringExecutableQuery.execute(Accumulators.toSet());
        Assertions.assertThat((Collection)remainingAddressBook).isEmpty();
    }

    @Test
    void crud_keyAndValueIsComplexType_overrideColumnName() {
        ConfiguredPersister personPersister = (ConfiguredPersister)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapMap(Person::getMapPropertyMadeOfComplexTypesWithColumnDuplicates, Timestamp.class, Timestamp.class).withKeyMapping((EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate)).withValueMapping((EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate)).overrideKeyColumnName(Timestamp::getCreationDate, "key_creationDate").overrideValueColumnName(Timestamp::getModificationDate, "value_modificationDate").build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Person person = new Person(new PersistableIdentifier<Long>(1L));
        LocalDateTime now = LocalDateTime.now();
        person.setMapPropertyMadeOfComplexTypesWithColumnDuplicates((Map<Timestamp, Timestamp>)Maps.forHashMap(Timestamp.class, Timestamp.class).add((Object)new Timestamp(now.minusDays(1L), now.minusDays(1L)), (Object)new Timestamp(now.minusDays(10L), now.minusDays(10L))).add((Object)new Timestamp(now.minusDays(2L), now.minusDays(2L)), (Object)new Timestamp(now.minusDays(20L), now.minusDays(20L))));
        personPersister.insert((Object)person);
        Person loadedPerson = (Person)personPersister.select(person.getId());
        Assertions.assertThat(loadedPerson.getMapPropertyMadeOfComplexTypesWithColumnDuplicates()).isEqualTo((Object)Maps.forHashMap(Timestamp.class, Timestamp.class).add((Object)new Timestamp(now.minusDays(1L), now.minusDays(1L)), (Object)new Timestamp(now.minusDays(10L), now.minusDays(10L))).add((Object)new Timestamp(now.minusDays(2L), now.minusDays(2L)), (Object)new Timestamp(now.minusDays(20L), now.minusDays(20L))));
        person.getMapPropertyMadeOfComplexTypesWithColumnDuplicates().remove(new Timestamp(now.minusDays(1L), now.minusDays(1L)));
        person.getMapPropertyMadeOfComplexTypesWithColumnDuplicates().put(new Timestamp(now.minusDays(3L), now.minusDays(3L)), new Timestamp(now.minusDays(30L), now.minusDays(30L)));
        personPersister.update((Object)person, (Object)loadedPerson, true);
        loadedPerson = (Person)personPersister.select(person.getId());
        Assertions.assertThat(loadedPerson.getMapPropertyMadeOfComplexTypesWithColumnDuplicates()).isEqualTo((Object)Maps.forHashMap(Timestamp.class, Timestamp.class).add((Object)new Timestamp(now.minusDays(2L), now.minusDays(2L)), (Object)new Timestamp(now.minusDays(20L), now.minusDays(20L))).add((Object)new Timestamp(now.minusDays(3L), now.minusDays(3L)), (Object)new Timestamp(now.minusDays(30L), now.minusDays(30L))));
        personPersister.delete((Object)loadedPerson);
        PersistenceContext.ExecutableBeanPropertyQueryMapper stringExecutableQuery = this.persistenceContext.newQuery((CharSequence)"select 'key' from Person_mapPropertyMadeOfComplexTypesWithColumnDuplicates", String.class).mapKey("key", String.class);
        Set remainingAddressBook = (Set)stringExecutableQuery.execute(Accumulators.toSet());
        Assertions.assertThat((Collection)remainingAddressBook).isEmpty();
    }

    @Nested
    class KeyAndValueAreEntities {
        KeyAndValueAreEntities() {
        }

        @Test
        void crud() {
            ConfiguredRelationalPersister personPersister = (ConfiguredRelationalPersister)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapMap(Person::getMapPropertyMadeOfEntityAsKeyAndValue, City.class, Country.class).withKeyMapping((EntityMappingConfigurationProvider)MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName)).withValueMapping((EntityMappingConfigurationProvider)MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName)).build(FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Person person = new Person(new PersistableIdentifier<Long>(1L));
            person.setMapPropertyMadeOfEntityAsKeyAndValue((Map<City, Country>)Maps.forHashMap(City.class, Country.class).add((Object)new City(1L, "Grenoble"), (Object)new Country(1L)).add((Object)new City(2L, "Lyon"), (Object)new Country(2L)));
            personPersister.insert((Object)person);
            Person loadedPerson = (Person)personPersister.select(person.getId());
            Assertions.assertThat(loadedPerson.getMapPropertyMadeOfEntityAsKeyAndValue()).isEqualTo((Object)Maps.forHashMap(City.class, Country.class).add((Object)new City(1L, "Grenoble"), (Object)new Country(1L)).add((Object)new City(2L, "Lyon"), (Object)new Country(2L)));
            person.getMapPropertyMadeOfEntityAsKeyAndValue().remove(new City(1L));
            person.getMapPropertyMadeOfEntityAsKeyAndValue().put(new City(2L, "Paris"), new Country(2L));
            person.getMapPropertyMadeOfEntityAsKeyAndValue().put(new City(3L, "Marseille"), new Country(3L));
            personPersister.update((Object)person, (Object)loadedPerson, true);
            loadedPerson = (Person)personPersister.select(person.getId());
            Assertions.assertThat(loadedPerson.getMapPropertyMadeOfEntityAsKeyAndValue()).isEqualTo((Object)Maps.forHashMap(City.class, Country.class).add((Object)new City(2L, "Paris"), (Object)new Country(2L)).add((Object)new City(3L, "Marseille"), (Object)new Country(3L)));
            personPersister.delete((Object)loadedPerson);
            PersistenceContext.ExecutableBeanPropertyQueryMapper stringExecutableQuery = FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.newQuery((CharSequence)"select 'key' from Person_mapPropertyMadeOfEntityAsKeyAndValue", String.class).mapKey("key", String.class);
            Set remainingEntries = (Set)stringExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)remainingEntries).isEmpty();
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery1 = FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.newQuery((CharSequence)"select id from City", Long.class).mapKey("id", Long.class);
            Set remainingCities = (Set)longExecutableQuery1.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)remainingCities).containsExactlyInAnyOrder((Object[])new Long[]{1L, 2L, 3L});
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery = FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.newQuery((CharSequence)"select id from Country", Long.class).mapKey("id", Long.class);
            Set remainingCountries = (Set)longExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)remainingCountries).containsExactlyInAnyOrder((Object[])new Long[]{1L, 2L, 3L});
        }

        @Test
        void crud_associationOnly() {
            FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions cityPersisterConfiguration = MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName);
            EntityPersister cityPersister = cityPersisterConfiguration.build(FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext);
            FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions countryPersisterConfiguration = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription);
            EntityPersister countryPersister = countryPersisterConfiguration.build(FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext);
            ConfiguredRelationalPersister personPersister = (ConfiguredRelationalPersister)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapMap(Person::getMapPropertyMadeOfEntityAsKeyAndValue, City.class, Country.class).withKeyMapping((EntityMappingConfigurationProvider)cityPersisterConfiguration).cascading(CascadeOptions.RelationMode.ASSOCIATION_ONLY).withValueMapping((EntityMappingConfigurationProvider)countryPersisterConfiguration).cascading(CascadeOptions.RelationMode.ASSOCIATION_ONLY).build(FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Person person = new Person(new PersistableIdentifier<Long>(1L));
            City city1 = new City(1L);
            City city2 = new City(2L);
            City city3 = new City(3L);
            cityPersister.insert((Iterable)Arrays.asList((Object[])new City[]{city1, city2, city3}));
            Country country1 = new Country(1L);
            Country country2 = new Country(2L);
            Country country3 = new Country(3L);
            Country country4 = new Country(4L);
            countryPersister.insert((Iterable)Arrays.asList((Object[])new Country[]{country1, country2, country3, country4}));
            person.setMapPropertyMadeOfEntityAsKeyAndValue((Map<City, Country>)Maps.forHashMap(City.class, Country.class).add((Object)city1, (Object)country1).add((Object)city2, (Object)country2));
            personPersister.insert((Object)person);
            Person loadedPerson = (Person)personPersister.select(person.getId());
            person.getMapPropertyMadeOfEntityAsKeyAndValue().remove(city1);
            person.getMapPropertyMadeOfEntityAsKeyAndValue().put(city2, country3);
            person.getMapPropertyMadeOfEntityAsKeyAndValue().put(city3, country4);
            personPersister.update((Object)person, (Object)loadedPerson, true);
            loadedPerson = (Person)personPersister.select(person.getId());
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery2 = FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.newQuery((CharSequence)"select key from Person_mapPropertyMadeOfEntityAsKeyAndValue", Long.class).mapKey("key", Long.class);
            Set remainingEntries = (Set)longExecutableQuery2.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)remainingEntries).containsExactlyInAnyOrder((Object[])new Long[]{2L, 3L});
            personPersister.delete((Object)loadedPerson);
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery1 = FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.newQuery((CharSequence)"select 'key' from Person_mapPropertyMadeOfEntityAsKeyAndValue", Long.class).mapKey("key", Long.class);
            remainingEntries = (Set)longExecutableQuery1.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)remainingEntries).isEmpty();
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery = FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.newQuery((CharSequence)"select id from Country", Long.class).mapKey("id", Long.class);
            Set remainingCountries = (Set)longExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)remainingCountries).containsExactlyInAnyOrder((Object[])new Long[]{1L, 2L, 3L, 4L});
        }

        @Test
        void crud_deleteOrphan() {
            ConfiguredRelationalPersister personPersister = (ConfiguredRelationalPersister)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapMap(Person::getMapPropertyMadeOfEntityAsKeyAndValue, City.class, Country.class).withKeyMapping((EntityMappingConfigurationProvider)MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED)).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).withValueMapping((EntityMappingConfigurationProvider)MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED)).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).build(FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Person person = new Person(new PersistableIdentifier<Long>(1L));
            person.setMapPropertyMadeOfEntityAsKeyAndValue((Map<City, Country>)Maps.forHashMap(City.class, Country.class).add((Object)new City(1L), (Object)new Country(1L)).add((Object)new City(2L), (Object)new Country(2L)).add((Object)new City(3L), (Object)new Country(3L)));
            personPersister.insert((Object)person);
            Person loadedPerson = (Person)personPersister.select(person.getId());
            person.getMapPropertyMadeOfEntityAsKeyAndValue().remove(new City(1L));
            person.getMapPropertyMadeOfEntityAsKeyAndValue().put(new City(2L), new Country(4L));
            person.getMapPropertyMadeOfEntityAsKeyAndValue().put(new City(3L), new Country(3L));
            personPersister.update((Object)person, (Object)loadedPerson, true);
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery2 = FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.newQuery((CharSequence)"select id from Country", Long.class).mapKey("id", Long.class);
            Set remainingCountries = (Set)longExecutableQuery2.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)remainingCountries).containsExactlyInAnyOrder((Object[])new Long[]{3L, 4L});
            loadedPerson = (Person)personPersister.select(person.getId());
            personPersister.delete((Object)loadedPerson);
            PersistenceContext.ExecutableBeanPropertyQueryMapper stringExecutableQuery = FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.newQuery((CharSequence)"select 'key' from Person_mapPropertyMadeOfEntityAsKeyAndValue", String.class).mapKey("key", String.class);
            Set remainingEntries = (Set)stringExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)remainingEntries).isEmpty();
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery1 = FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.newQuery((CharSequence)"select id from City", Long.class).mapKey("id", Long.class);
            remainingCountries = (Set)longExecutableQuery1.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)remainingCountries).isEmpty();
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery = FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.newQuery((CharSequence)"select id from Country", Long.class).mapKey("id", Long.class);
            remainingCountries = (Set)longExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)remainingCountries).isEmpty();
        }

        @Test
        void crud_readOnly() throws SQLException {
            FluentEntityMappingBuilder.FluentEntityMappingBuilderKeyOptions cityPersisterConfiguration = MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED);
            EntityPersister cityPersister = cityPersisterConfiguration.build(FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext);
            FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions countryPersisterConfiguration = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName);
            EntityPersister countryPersister = countryPersisterConfiguration.build(FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext);
            ConfiguredRelationalPersister personPersister = (ConfiguredRelationalPersister)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapMap(Person::getMapPropertyMadeOfEntityAsKeyAndValue, City.class, Country.class).withKeyMapping((EntityMappingConfigurationProvider)cityPersisterConfiguration).cascading(CascadeOptions.RelationMode.READ_ONLY).withValueMapping((EntityMappingConfigurationProvider)countryPersisterConfiguration).cascading(CascadeOptions.RelationMode.READ_ONLY).build(FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Person person = new Person(new PersistableIdentifier<Long>(1L));
            City city1 = new City(1L);
            City city2 = new City(2L);
            City city3 = new City(3L);
            cityPersister.insert((Iterable)Arrays.asList((Object[])new City[]{city1, city2, city3}));
            Country country1 = new Country(1L);
            Country country2 = new Country(2L);
            Country country3 = new Country(3L);
            Country country4 = new Country(4L);
            countryPersister.insert((Iterable)Arrays.asList((Object[])new Country[]{country1, country2, country3}));
            person.setMapPropertyMadeOfEntityAsKeyAndValue((Map<City, Country>)Maps.forHashMap(City.class, Country.class).add((Object)city1, (Object)country1).add((Object)city2, (Object)country2));
            personPersister.insert((Object)person);
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery4 = FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.newQuery((CharSequence)"select 'key' from Person_mapPropertyMadeOfEntityAsKeyAndValue", Long.class).mapKey("key", Long.class);
            Set remainingEntries = (Set)longExecutableQuery4.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)remainingEntries).isEmpty();
            Table associationTable = new Table("Person_mapPropertyMadeOfEntityAsKeyAndValue");
            Column idColumn = associationTable.addColumn("id", Long.class);
            Column keyColumn = associationTable.addColumn("key", Long.class);
            Column valueColumn = associationTable.addColumn("value", Long.class);
            FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.insert(associationTable).set(idColumn, (Object)1L).set(keyColumn, (Object)1L).set(valueColumn, (Object)1L).execute();
            FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.insert(associationTable).set(idColumn, (Object)1L).set(keyColumn, (Object)2L).set(valueColumn, (Object)2L).execute();
            Person loadedPerson = (Person)personPersister.select(person.getId());
            Assertions.assertThat(loadedPerson.getMapPropertyMadeOfEntityAsKeyAndValue()).containsExactlyEntriesOf((Map)Maps.forHashMap(City.class, Country.class).add((Object)new City(1L), (Object)new Country(1L)).add((Object)new City(2L), (Object)new Country(2L)));
            person.getMapPropertyMadeOfEntityAsKeyAndValue().remove(city1);
            person.getMapPropertyMadeOfEntityAsKeyAndValue().put(city2, country3);
            person.getMapPropertyMadeOfEntityAsKeyAndValue().put(city3, country4);
            loadedPerson = (Person)personPersister.select(person.getId());
            personPersister.update((Object)person, (Object)loadedPerson, true);
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery3 = FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.newQuery((CharSequence)"select key from Person_mapPropertyMadeOfEntityAsKeyAndValue", Long.class).mapKey("key", Long.class);
            remainingEntries = (Set)longExecutableQuery3.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)remainingEntries).containsExactlyInAnyOrder((Object[])new Long[]{1L, 2L});
            FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.getConnectionProvider().giveConnection().prepareStatement("alter table Person_mapPropertyMadeOfEntityAsKeyAndValue drop constraint FK_Person_mapPropertyMadeOfEntityAsKeyAndValue_id_Person_id").execute();
            loadedPerson = (Person)personPersister.select(person.getId());
            personPersister.delete((Object)loadedPerson);
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery2 = FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.newQuery((CharSequence)"select key from Person_mapPropertyMadeOfEntityAsKeyAndValue", Long.class).mapKey("key", Long.class);
            remainingEntries = (Set)longExecutableQuery2.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)remainingEntries).containsExactlyInAnyOrder((Object[])new Long[]{1L, 2L});
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery1 = FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.newQuery((CharSequence)"select id from City", Long.class).mapKey("id", Long.class);
            Set remainingCities = (Set)longExecutableQuery1.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)remainingCities).containsExactlyInAnyOrder((Object[])new Long[]{1L, 2L, 3L});
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery = FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.newQuery((CharSequence)"select id from Country", Long.class).mapKey("id", Long.class);
            Set remainingCountries = (Set)longExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)remainingCountries).containsExactlyInAnyOrder((Object[])new Long[]{1L, 2L, 3L});
        }

        @Test
        void foreignKey_creation() {
            ConfiguredRelationalPersister personPersister = (ConfiguredRelationalPersister)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapMap(Person::getMapPropertyMadeOfEntityAsKeyAndValue, City.class, Country.class).withKeyMapping((EntityMappingConfigurationProvider)MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName)).withValueMapping((EntityMappingConfigurationProvider)MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName)).build(FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Map tablePerName = Iterables.map((Iterable)personPersister.getEntityJoinTree().giveTables(), Table::getName);
            Assertions.assertThat(tablePerName.keySet()).containsExactlyInAnyOrder((Object[])new String[]{"Person", "Person_mapPropertyMadeOfEntityAsKeyAndValue", "City", "Country"});
            Table personTable = (Table)tablePerName.get("Person");
            Table cityTable = (Table)tablePerName.get("City");
            Table countryTable = (Table)tablePerName.get("Country");
            Table mapTable = (Table)tablePerName.get("Person_mapPropertyMadeOfEntityAsKeyAndValue");
            Function columnPrinter = PersisterBuilderImplTest.ToStringBuilder.of(", ", Column::getAbsoluteName, Functions.chain(Column::getJavaType, Reflections::toString));
            Function fkPrinter = PersisterBuilderImplTest.ToStringBuilder.of(", ", ForeignKey::getName, Functions.link(ForeignKey::getColumns, PersisterBuilderImplTest.ToStringBuilder.asSeveral(columnPrinter)), Functions.link(ForeignKey::getTargetColumns, PersisterBuilderImplTest.ToStringBuilder.asSeveral(columnPrinter)));
            ((AbstractCollectionAssert)Assertions.assertThat((Collection)mapTable.getForeignKeys()).usingElementComparator(Comparator.comparing(fkPrinter))).containsExactlyInAnyOrder((Object[])new ForeignKey[]{new ForeignKey("FK_Person_mapPropertyMadeOfEntityAsKeyAndValue_id_Person_id", mapTable.getColumn("id"), personTable.getColumn("id")), new ForeignKey("FK_Person_mapPropertyMadeOfEntityAsKeyAndValue_key_City_id", mapTable.getColumn("key"), cityTable.getColumn("id")), new ForeignKey("FK_Person_mapPropertyMadeOfEntityAsKeyAndValue_value_Country_id", mapTable.getColumn("value"), countryTable.getColumn("id"))});
        }
    }

    @Nested
    class ValueIsEntity {
        ValueIsEntity() {
        }

        @Test
        void crud() {
            ConfiguredRelationalPersister personPersister = (ConfiguredRelationalPersister)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapMap(Person::getMapPropertyMadeOfEntityAsValue, String.class, Country.class).withValueMapping((EntityMappingConfigurationProvider)MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription)).build(FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Person person = new Person(new PersistableIdentifier<Long>(1L));
            Country country1 = new Country(1L);
            Country country2 = new Country(2L);
            person.setMapPropertyMadeOfEntityAsValue((Map<String, Country>)Maps.forHashMap(String.class, Country.class).add((Object)"Grenoble", (Object)country1).add((Object)"Lyon", (Object)country2));
            personPersister.insert((Object)person);
            Person loadedPerson = (Person)personPersister.select(person.getId());
            Assertions.assertThat(loadedPerson.getMapPropertyMadeOfEntityAsValue()).isEqualTo((Object)Maps.forHashMap(String.class, Country.class).add((Object)"Grenoble", (Object)country1).add((Object)"Lyon", (Object)country2));
            Country country3 = new Country(3L);
            Country country4 = new Country(4L);
            person.getMapPropertyMadeOfEntityAsValue().remove("Grenoble");
            person.getMapPropertyMadeOfEntityAsValue().put("Marseille", country3);
            person.getMapPropertyMadeOfEntityAsValue().put("Lyon", country4);
            personPersister.update((Object)person, (Object)loadedPerson, true);
            loadedPerson = (Person)personPersister.select(person.getId());
            Assertions.assertThat(loadedPerson.getMapPropertyMadeOfEntityAsValue()).isEqualTo((Object)Maps.forHashMap(String.class, Country.class).add((Object)"Marseille", (Object)country3).add((Object)"Lyon", (Object)country4));
            personPersister.delete((Object)loadedPerson);
            PersistenceContext.ExecutableBeanPropertyQueryMapper stringExecutableQuery = FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.newQuery((CharSequence)"select 'key' from Person_mapPropertyMadeOfEntityAsValue", String.class).mapKey("key", String.class);
            Set remainingEntries = (Set)stringExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)remainingEntries).isEmpty();
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery = FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.newQuery((CharSequence)"select id from Country", Long.class).mapKey("id", Long.class);
            Set remainingCountries = (Set)longExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)remainingCountries).containsExactlyInAnyOrder((Object[])new Long[]{1L, 2L, 3L, 4L});
        }

        @Test
        void crud_associationOnly() {
            FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions countryPersisterConfiguration = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription);
            EntityPersister countryPersister = countryPersisterConfiguration.build(FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext);
            ConfiguredRelationalPersister personPersister = (ConfiguredRelationalPersister)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapMap(Person::getMapPropertyMadeOfEntityAsValue, String.class, Country.class).withValueMapping((EntityMappingConfigurationProvider)countryPersisterConfiguration).cascading(CascadeOptions.RelationMode.ASSOCIATION_ONLY).build(FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Person person = new Person(new PersistableIdentifier<Long>(1L));
            person.setMapPropertyMadeOfEntityAsValue((Map<String, Country>)Maps.forHashMap(String.class, Country.class).add((Object)"Grenoble", (Object)new Country(1L)).add((Object)"Lyon", (Object)new Country(2L)));
            personPersister.insert((Object)person);
            Person loadedPerson = (Person)personPersister.select(person.getId());
            person.getMapPropertyMadeOfEntityAsValue().remove("Grenoble");
            person.getMapPropertyMadeOfEntityAsValue().put("Lyon", new Country(4L));
            person.getMapPropertyMadeOfEntityAsValue().put("Marseille", new Country(3L));
            personPersister.update((Object)person, (Object)loadedPerson, true);
            loadedPerson = (Person)personPersister.select(person.getId());
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery2 = FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.newQuery((CharSequence)"select \"value\" from Person_mapPropertyMadeOfEntityAsValue", Long.class).mapKey("value", Long.class);
            Set remainingEntries = (Set)longExecutableQuery2.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)remainingEntries).containsExactlyInAnyOrder((Object[])new Long[]{4L, 3L});
            personPersister.delete((Object)loadedPerson);
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery1 = FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.newQuery((CharSequence)"select \"value\" from Person_mapPropertyMadeOfEntityAsValue", Long.class).mapKey("value", Long.class);
            remainingEntries = (Set)longExecutableQuery1.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)remainingEntries).isEmpty();
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery = FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.newQuery((CharSequence)"select id from Country", Long.class).mapKey("id", Long.class);
            Set remainingCountries = (Set)longExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)remainingCountries).containsExactlyInAnyOrder((Object[])new Long[]{1L, 2L, 3L, 4L});
        }

        @Test
        void crud_deleteOrphan() {
            ConfiguredRelationalPersister personPersister = (ConfiguredRelationalPersister)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapMap(Person::getMapPropertyMadeOfEntityAsValue, String.class, Country.class).withValueMapping((EntityMappingConfigurationProvider)MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription)).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).build(FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Person person = new Person(new PersistableIdentifier<Long>(1L));
            person.setMapPropertyMadeOfEntityAsValue((Map<String, Country>)Maps.forHashMap(String.class, Country.class).add((Object)"Grenoble", (Object)new Country(1L)).add((Object)"Lyon", (Object)new Country(2L)).add((Object)"Marseille", (Object)new Country(3L)));
            personPersister.insert((Object)person);
            Person loadedPerson = (Person)personPersister.select(person.getId());
            person.getMapPropertyMadeOfEntityAsValue().remove("Grenoble");
            person.getMapPropertyMadeOfEntityAsValue().put("Paris", new Country(2L));
            person.getMapPropertyMadeOfEntityAsValue().put("Marseille", new Country(3L));
            personPersister.update((Object)person, (Object)loadedPerson, true);
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery1 = FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.newQuery((CharSequence)"select id from Country", Long.class).mapKey("id", Long.class);
            Set remainingCountries = (Set)longExecutableQuery1.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)remainingCountries).containsExactlyInAnyOrder((Object[])new Long[]{2L, 3L});
            loadedPerson = (Person)personPersister.select(person.getId());
            personPersister.delete((Object)loadedPerson);
            PersistenceContext.ExecutableBeanPropertyQueryMapper stringExecutableQuery = FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.newQuery((CharSequence)"select 'value' from Person_mapPropertyMadeOfEntityAsValue", String.class).mapKey("value", String.class);
            Set remainingEntries = (Set)stringExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)remainingEntries).isEmpty();
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery = FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.newQuery((CharSequence)"select id from Country", Long.class).mapKey("id", Long.class);
            remainingCountries = (Set)longExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)remainingCountries).isEmpty();
        }

        @Test
        void crud_readOnly() throws SQLException {
            FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions countryPersisterConfiguration = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription);
            EntityPersister countryPersister = countryPersisterConfiguration.build(FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext);
            ConfiguredRelationalPersister personPersister = (ConfiguredRelationalPersister)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapMap(Person::getMapPropertyMadeOfEntityAsValue, String.class, Country.class).withValueMapping((EntityMappingConfigurationProvider)countryPersisterConfiguration).cascading(CascadeOptions.RelationMode.READ_ONLY).build(FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Person person = new Person(new PersistableIdentifier<Long>(1L));
            Country country1 = new Country(1L);
            Country country2 = new Country(2L);
            Country country3 = new Country(3L);
            countryPersister.insert((Iterable)Arrays.asList((Object[])new Country[]{country1, country2, country3}));
            person.setMapPropertyMadeOfEntityAsValue((Map<String, Country>)Maps.forHashMap(String.class, Country.class).add((Object)"Grenoble", (Object)country1).add((Object)"Lyon", (Object)country2));
            personPersister.insert((Object)person);
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery3 = FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.newQuery((CharSequence)"select \"value\" from Person_mapPropertyMadeOfEntityAsValue", Long.class).mapKey("value", Long.class);
            Set remainingEntries = (Set)longExecutableQuery3.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)remainingEntries).isEmpty();
            Table associationTable = new Table("Person_mapPropertyMadeOfEntityAsValue");
            Column idColumn = associationTable.addColumn("id", Long.class);
            Column keyColumn = associationTable.addColumn("key", String.class);
            Column valueColumn = associationTable.addColumn("value", Long.class);
            FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.insert(associationTable).set(idColumn, (Object)1L).set(keyColumn, (Object)"Grenoble").set(valueColumn, (Object)1L).execute();
            FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.insert(associationTable).set(idColumn, (Object)1L).set(keyColumn, (Object)"Lyon").set(valueColumn, (Object)2L).execute();
            Person loadedPerson = (Person)personPersister.select(person.getId());
            Assertions.assertThat(loadedPerson.getMapPropertyMadeOfEntityAsValue()).containsExactlyEntriesOf((Map)Maps.forHashMap(String.class, Country.class).add((Object)"Grenoble", (Object)new Country(1L)).add((Object)"Lyon", (Object)new Country(2L)));
            person.getMapPropertyMadeOfEntityAsValue().remove("Grenoble");
            person.getMapPropertyMadeOfEntityAsValue().put("Paris", country2);
            person.getMapPropertyMadeOfEntityAsValue().put("Marseille", country3);
            loadedPerson = (Person)personPersister.select(person.getId());
            personPersister.update((Object)person, (Object)loadedPerson, true);
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery2 = FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.newQuery((CharSequence)"select \"value\" from Person_mapPropertyMadeOfEntityAsValue", Long.class).mapKey("value", Long.class);
            remainingEntries = (Set)longExecutableQuery2.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)remainingEntries).containsExactlyInAnyOrder((Object[])new Long[]{1L, 2L});
            FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.getConnectionProvider().giveConnection().prepareStatement("alter table Person_mapPropertyMadeOfEntityAsValue drop constraint FK_Person_mapPropertyMadeOfEntityAsValue_id_Person_id").execute();
            loadedPerson = (Person)personPersister.select(person.getId());
            personPersister.delete((Object)loadedPerson);
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery1 = FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.newQuery((CharSequence)"select \"value\" from Person_mapPropertyMadeOfEntityAsValue", Long.class).mapKey("value", Long.class);
            remainingEntries = (Set)longExecutableQuery1.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)remainingEntries).containsExactlyInAnyOrder((Object[])new Long[]{1L, 2L});
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery = FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.newQuery((CharSequence)"select id from Country", Long.class).mapKey("id", Long.class);
            Set remainingCountries = (Set)longExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)remainingCountries).containsExactlyInAnyOrder((Object[])new Long[]{1L, 2L, 3L});
        }

        @Test
        void foreignKey_creation() {
            ConfiguredRelationalPersister personPersister = (ConfiguredRelationalPersister)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapMap(Person::getMapPropertyMadeOfEntityAsValue, String.class, Country.class).withValueMapping((EntityMappingConfigurationProvider)MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription)).build(FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Map tablePerName = Iterables.map((Iterable)personPersister.getEntityJoinTree().giveTables(), Table::getName);
            Assertions.assertThat(tablePerName.keySet()).containsExactlyInAnyOrder((Object[])new String[]{"Person", "Person_mapPropertyMadeOfEntityAsValue", "Country"});
            Table personTable = (Table)tablePerName.get("Person");
            Table countryTable = (Table)tablePerName.get("Country");
            Table mapTable = (Table)tablePerName.get("Person_mapPropertyMadeOfEntityAsValue");
            Function columnPrinter = PersisterBuilderImplTest.ToStringBuilder.of(", ", Column::getAbsoluteName, Functions.chain(Column::getJavaType, Reflections::toString));
            Function fkPrinter = PersisterBuilderImplTest.ToStringBuilder.of(", ", ForeignKey::getName, Functions.link(ForeignKey::getColumns, PersisterBuilderImplTest.ToStringBuilder.asSeveral(columnPrinter)), Functions.link(ForeignKey::getTargetColumns, PersisterBuilderImplTest.ToStringBuilder.asSeveral(columnPrinter)));
            ((AbstractCollectionAssert)Assertions.assertThat((Collection)mapTable.getForeignKeys()).usingElementComparator(Comparator.comparing(fkPrinter))).containsExactlyInAnyOrder((Object[])new ForeignKey[]{new ForeignKey("FK_Person_mapPropertyMadeOfEntityAsValue_id_Person_id", mapTable.getColumn("id"), personTable.getColumn("id")), new ForeignKey("FK_Person_mapPropertyMadeOfEntityAsValue_value_Country_id", mapTable.getColumn("value"), countryTable.getColumn("id"))});
        }
    }

    @Nested
    class KeyIsEntity {
        KeyIsEntity() {
        }

        @Test
        void crud() {
            ConfiguredRelationalPersister personPersister = (ConfiguredRelationalPersister)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapMap(Person::getMapPropertyMadeOfEntityAsKey, Country.class, String.class).withKeyMapping((EntityMappingConfigurationProvider)MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription)).build(FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Person person = new Person(new PersistableIdentifier<Long>(1L));
            person.setMapPropertyMadeOfEntityAsKey((Map<Country, String>)Maps.forHashMap(Country.class, String.class).add((Object)new Country(1L), (Object)"Grenoble").add((Object)new Country(2L), (Object)"Lyon"));
            personPersister.insert((Object)person);
            Person loadedPerson = (Person)personPersister.select(person.getId());
            Assertions.assertThat(loadedPerson.getMapPropertyMadeOfEntityAsKey()).isEqualTo((Object)Maps.forHashMap(Country.class, String.class).add((Object)new Country(1L), (Object)"Grenoble").add((Object)new Country(2L), (Object)"Lyon"));
            person.getMapPropertyMadeOfEntityAsKey().remove(new Country(1L));
            person.getMapPropertyMadeOfEntityAsKey().put(new Country(2L), "Paris");
            person.getMapPropertyMadeOfEntityAsKey().put(new Country(3L), "Marseille");
            personPersister.update((Object)person, (Object)loadedPerson, true);
            loadedPerson = (Person)personPersister.select(person.getId());
            Assertions.assertThat(loadedPerson.getMapPropertyMadeOfEntityAsKey()).isEqualTo((Object)Maps.forHashMap(Country.class, String.class).add((Object)new Country(2L), (Object)"Paris").add((Object)new Country(3L), (Object)"Marseille"));
            personPersister.delete((Object)loadedPerson);
            PersistenceContext.ExecutableBeanPropertyQueryMapper stringExecutableQuery = FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.newQuery((CharSequence)"select 'key' from Person_mapPropertyMadeOfEntityAsKey", String.class).mapKey("key", String.class);
            Set remainingEntries = (Set)stringExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)remainingEntries).isEmpty();
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery = FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.newQuery((CharSequence)"select id from Country", Long.class).mapKey("id", Long.class);
            Set remainingCountries = (Set)longExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)remainingCountries).containsExactlyInAnyOrder((Object[])new Long[]{1L, 2L, 3L});
        }

        @Test
        void crud_associationOnly() {
            FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions countryPersisterConfiguration = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription);
            EntityPersister countryPersister = countryPersisterConfiguration.build(FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext);
            ConfiguredRelationalPersister personPersister = (ConfiguredRelationalPersister)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapMap(Person::getMapPropertyMadeOfEntityAsKey, Country.class, String.class).withKeyMapping((EntityMappingConfigurationProvider)countryPersisterConfiguration).cascading(CascadeOptions.RelationMode.ASSOCIATION_ONLY).build(FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Person person = new Person(new PersistableIdentifier<Long>(1L));
            Country country1 = new Country(1L);
            Country country2 = new Country(2L);
            Country country3 = new Country(3L);
            countryPersister.insert((Iterable)Arrays.asList((Object[])new Country[]{country1, country2, country3}));
            person.setMapPropertyMadeOfEntityAsKey((Map<Country, String>)Maps.forHashMap(Country.class, String.class).add((Object)country1, (Object)"Grenoble").add((Object)country2, (Object)"Lyon"));
            personPersister.insert((Object)person);
            Person loadedPerson = (Person)personPersister.select(person.getId());
            person.getMapPropertyMadeOfEntityAsKey().remove(country1);
            person.getMapPropertyMadeOfEntityAsKey().put(country2, "Paris");
            person.getMapPropertyMadeOfEntityAsKey().put(country3, "Marseille");
            personPersister.update((Object)person, (Object)loadedPerson, true);
            loadedPerson = (Person)personPersister.select(person.getId());
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery2 = FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.newQuery((CharSequence)"select key from Person_mapPropertyMadeOfEntityAsKey", Long.class).mapKey("key", Long.class);
            Set remainingEntries = (Set)longExecutableQuery2.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)remainingEntries).containsExactlyInAnyOrder((Object[])new Long[]{2L, 3L});
            personPersister.delete((Object)loadedPerson);
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery1 = FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.newQuery((CharSequence)"select key from Person_mapPropertyMadeOfEntityAsKey", Long.class).mapKey("key", Long.class);
            remainingEntries = (Set)longExecutableQuery1.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)remainingEntries).isEmpty();
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery = FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.newQuery((CharSequence)"select id from Country", Long.class).mapKey("id", Long.class);
            Set remainingCountries = (Set)longExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)remainingCountries).containsExactlyInAnyOrder((Object[])new Long[]{1L, 2L, 3L});
        }

        @Test
        void crud_deleteOrphan() {
            ConfiguredRelationalPersister personPersister = (ConfiguredRelationalPersister)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapMap(Person::getMapPropertyMadeOfEntityAsKey, Country.class, String.class).withKeyMapping((EntityMappingConfigurationProvider)MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription)).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).build(FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Person person = new Person(new PersistableIdentifier<Long>(1L));
            person.setMapPropertyMadeOfEntityAsKey((Map<Country, String>)Maps.forHashMap(Country.class, String.class).add((Object)new Country(1L), (Object)"Grenoble").add((Object)new Country(2L), (Object)"Lyon").add((Object)new Country(3L), (Object)"Marseille"));
            personPersister.insert((Object)person);
            Person loadedPerson = (Person)personPersister.select(person.getId());
            person.getMapPropertyMadeOfEntityAsKey().remove(new Country(1L));
            person.getMapPropertyMadeOfEntityAsKey().put(new Country(2L), "Paris");
            person.getMapPropertyMadeOfEntityAsKey().put(new Country(3L), "Marseille");
            personPersister.update((Object)person, (Object)loadedPerson, true);
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery1 = FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.newQuery((CharSequence)"select id from Country", Long.class).mapKey("id", Long.class);
            Set remainingCountries = (Set)longExecutableQuery1.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)remainingCountries).containsExactlyInAnyOrder((Object[])new Long[]{2L, 3L});
            loadedPerson = (Person)personPersister.select(person.getId());
            personPersister.delete((Object)loadedPerson);
            PersistenceContext.ExecutableBeanPropertyQueryMapper stringExecutableQuery = FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.newQuery((CharSequence)"select 'key' from Person_mapPropertyMadeOfEntityAsKey", String.class).mapKey("key", String.class);
            Set remainingEntries = (Set)stringExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)remainingEntries).isEmpty();
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery = FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.newQuery((CharSequence)"select id from Country", Long.class).mapKey("id", Long.class);
            remainingCountries = (Set)longExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)remainingCountries).isEmpty();
        }

        @Test
        void crud_readOnly() throws SQLException {
            FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions countryPersisterConfiguration = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription);
            EntityPersister countryPersister = countryPersisterConfiguration.build(FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext);
            ConfiguredRelationalPersister personPersister = (ConfiguredRelationalPersister)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapMap(Person::getMapPropertyMadeOfEntityAsKey, Country.class, String.class).withKeyMapping((EntityMappingConfigurationProvider)countryPersisterConfiguration).cascading(CascadeOptions.RelationMode.READ_ONLY).build(FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Person person = new Person(new PersistableIdentifier<Long>(1L));
            Country country1 = new Country(1L);
            Country country2 = new Country(2L);
            Country country3 = new Country(3L);
            countryPersister.insert((Iterable)Arrays.asList((Object[])new Country[]{country1, country2, country3}));
            person.setMapPropertyMadeOfEntityAsKey((Map<Country, String>)Maps.forHashMap(Country.class, String.class).add((Object)country1, (Object)"Grenoble").add((Object)country2, (Object)"Lyon"));
            personPersister.insert((Object)person);
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery3 = FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.newQuery((CharSequence)"select key from Person_mapPropertyMadeOfEntityAsKey", Long.class).mapKey("key", Long.class);
            Set remainingEntries = (Set)longExecutableQuery3.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)remainingEntries).isEmpty();
            Table associationTable = new Table("Person_mapPropertyMadeOfEntityAsKey");
            Column idColumn = associationTable.addColumn("id", Long.class);
            Column keyColumn = associationTable.addColumn("key", Long.class);
            Column valueColumn = associationTable.addColumn("value", String.class);
            FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.insert(associationTable).set(idColumn, (Object)1L).set(keyColumn, (Object)1L).set(valueColumn, (Object)"Grenoble").execute();
            FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.insert(associationTable).set(idColumn, (Object)1L).set(keyColumn, (Object)2L).set(valueColumn, (Object)"Lyon").execute();
            Person loadedPerson = (Person)personPersister.select(person.getId());
            Assertions.assertThat(loadedPerson.getMapPropertyMadeOfEntityAsKey()).containsExactlyEntriesOf((Map)Maps.forHashMap(Country.class, String.class).add((Object)new Country(1L), (Object)"Grenoble").add((Object)new Country(2L), (Object)"Lyon"));
            person.getMapPropertyMadeOfEntityAsKey().remove(country1);
            person.getMapPropertyMadeOfEntityAsKey().put(country2, "Paris");
            person.getMapPropertyMadeOfEntityAsKey().put(country3, "Marseille");
            loadedPerson = (Person)personPersister.select(person.getId());
            personPersister.update((Object)person, (Object)loadedPerson, true);
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery2 = FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.newQuery((CharSequence)"select key from Person_mapPropertyMadeOfEntityAsKey", Long.class).mapKey("key", Long.class);
            remainingEntries = (Set)longExecutableQuery2.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)remainingEntries).containsExactlyInAnyOrder((Object[])new Long[]{1L, 2L});
            FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.getConnectionProvider().giveConnection().prepareStatement("alter table Person_mapPropertyMadeOfEntityAsKey drop constraint FK_Person_mapPropertyMadeOfEntityAsKey_id_Person_id").execute();
            loadedPerson = (Person)personPersister.select(person.getId());
            personPersister.delete((Object)loadedPerson);
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery1 = FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.newQuery((CharSequence)"select key from Person_mapPropertyMadeOfEntityAsKey", Long.class).mapKey("key", Long.class);
            remainingEntries = (Set)longExecutableQuery1.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)remainingEntries).containsExactlyInAnyOrder((Object[])new Long[]{1L, 2L});
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery = FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext.newQuery((CharSequence)"select id from Country", Long.class).mapKey("id", Long.class);
            Set remainingCountries = (Set)longExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)remainingCountries).containsExactlyInAnyOrder((Object[])new Long[]{1L, 2L, 3L});
        }

        @Test
        void foreignKey_creation() {
            ConfiguredRelationalPersister personPersister = (ConfiguredRelationalPersister)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapMap(Person::getMapPropertyMadeOfEntityAsKey, Country.class, String.class).withKeyMapping((EntityMappingConfigurationProvider)MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription)).build(FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportMapTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Map tablePerName = Iterables.map((Iterable)personPersister.getEntityJoinTree().giveTables(), Table::getName);
            Assertions.assertThat(tablePerName.keySet()).containsExactlyInAnyOrder((Object[])new String[]{"Person", "Person_mapPropertyMadeOfEntityAsKey", "Country"});
            Table personTable = (Table)tablePerName.get("Person");
            Table countryTable = (Table)tablePerName.get("Country");
            Table mapTable = (Table)tablePerName.get("Person_mapPropertyMadeOfEntityAsKey");
            Function columnPrinter = PersisterBuilderImplTest.ToStringBuilder.of(", ", Column::getAbsoluteName, Functions.chain(Column::getJavaType, Reflections::toString));
            Function fkPrinter = PersisterBuilderImplTest.ToStringBuilder.of(", ", ForeignKey::getName, Functions.link(ForeignKey::getColumns, PersisterBuilderImplTest.ToStringBuilder.asSeveral(columnPrinter)), Functions.link(ForeignKey::getTargetColumns, PersisterBuilderImplTest.ToStringBuilder.asSeveral(columnPrinter)));
            ((AbstractCollectionAssert)Assertions.assertThat((Collection)mapTable.getForeignKeys()).usingElementComparator(Comparator.comparing(fkPrinter))).containsExactlyInAnyOrder((Object[])new ForeignKey[]{new ForeignKey("FK_Person_mapPropertyMadeOfEntityAsKey_id_Person_id", mapTable.getColumn("id"), personTable.getColumn("id")), new ForeignKey("FK_Person_mapPropertyMadeOfEntityAsKey_key_Country_id", mapTable.getColumn("key"), countryTable.getColumn("id"))});
        }
    }
}

