/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.Function;
import javax.sql.DataSource;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.engine.ColumnOptions;
import org.codefilarete.stalactite.engine.EmbeddableMappingConfigurationProvider;
import org.codefilarete.stalactite.engine.EntityMappingConfigurationProvider;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.FluentEntityMappingConfigurationSupportTest;
import org.codefilarete.stalactite.engine.MappingEase;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.engine.configurer.PersisterBuilderImplTest;
import org.codefilarete.stalactite.engine.model.City;
import org.codefilarete.stalactite.engine.model.Country;
import org.codefilarete.stalactite.engine.model.Person;
import org.codefilarete.stalactite.engine.model.Timestamp;
import org.codefilarete.stalactite.engine.runtime.ConfiguredPersister;
import org.codefilarete.stalactite.id.Identifier;
import org.codefilarete.stalactite.id.PersistableIdentifier;
import org.codefilarete.stalactite.id.StatefulIdentifierAlreadyAssignedIdentifierPolicy;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.HSQLDBDialectBuilder;
import org.codefilarete.stalactite.sql.ddl.DDLDeployer;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.ForeignKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.stalactite.sql.test.HSQLDBInMemoryDataSource;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.function.Functions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

@Nested
class FluentEntityMappingConfigurationSupportCollectionOfElementsTest {
    private static final Class<Identifier<UUID>> UUID_TYPE = Identifier.class;
    private final Dialect dialect = HSQLDBDialectBuilder.defaultHSQLDBDialect();
    private final DataSource dataSource = new HSQLDBInMemoryDataSource();
    private PersistenceContext persistenceContext;

    FluentEntityMappingConfigurationSupportCollectionOfElementsTest() {
    }

    @BeforeEach
    void initTest() {
        this.dialect.getDmlGenerator().sortColumnsAlphabetically();
        this.dialect.getColumnBinderRegistry().register(Identifier.class, Identifier.identifierBinder(DefaultParameterBinders.LONG_PRIMITIVE_BINDER));
        this.dialect.getSqlTypeRegistry().put(Identifier.class, "int");
        this.persistenceContext = new PersistenceContext(this.dataSource, this.dialect);
    }

    @Test
    void insert() {
        ConfiguredPersister personPersister = (ConfiguredPersister)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapCollection(Person::getNicknames, String.class).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Person person = new Person(new PersistableIdentifier<Long>(1L));
        person.setName("toto");
        person.initNicknames();
        person.addNickname("tonton");
        personPersister.insert((Object)person);
        Person loadedPerson = (Person)personPersister.select(person.getId());
        Assertions.assertThat(loadedPerson.getNicknames()).isEqualTo((Object)org.codefilarete.tool.collection.Arrays.asSet((Object[])new String[]{"tonton"}));
    }

    @Test
    void update_withNewObject() {
        ConfiguredPersister personPersister = (ConfiguredPersister)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapCollection(Person::getNicknames, String.class).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Person person = new Person(new PersistableIdentifier<Long>(1L));
        person.setName("toto");
        person.initNicknames();
        person.addNickname("tonton");
        person.addNickname("tintin");
        personPersister.insert((Object)person);
        Person loadedPerson = (Person)personPersister.select(person.getId());
        Assertions.assertThat(loadedPerson.getNicknames()).isEqualTo((Object)org.codefilarete.tool.collection.Arrays.asSet((Object[])new String[]{"tintin", "tonton"}));
        loadedPerson.addNickname("toutou");
        personPersister.update((Object)loadedPerson, (Object)person, true);
        loadedPerson = (Person)personPersister.select(person.getId());
        Assertions.assertThat(loadedPerson.getNicknames()).isEqualTo((Object)org.codefilarete.tool.collection.Arrays.asSet((Object[])new String[]{"tintin", "tonton", "toutou"}));
    }

    @Test
    void update_objectRemoval() {
        ConfiguredPersister personPersister = (ConfiguredPersister)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapCollection(Person::getNicknames, String.class).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Person person = new Person(new PersistableIdentifier<Long>(1L));
        person.setName("toto");
        person.initNicknames();
        person.addNickname("tonton");
        person.addNickname("tintin");
        personPersister.insert((Object)person);
        Person loadedPerson = (Person)personPersister.select(person.getId());
        person.getNicknames().remove("tintin");
        personPersister.update((Object)person, (Object)loadedPerson, true);
        loadedPerson = (Person)personPersister.select(person.getId());
        Assertions.assertThat(loadedPerson.getNicknames()).isEqualTo((Object)org.codefilarete.tool.collection.Arrays.asSet((Object[])new String[]{"tonton"}));
    }

    @Test
    void delete() {
        ConfiguredPersister personPersister = (ConfiguredPersister)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapCollection(Person::getNicknames, String.class).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Person person = new Person(new PersistableIdentifier<Long>(1L));
        person.setName("toto");
        person.initNicknames();
        person.addNickname("tonton");
        person.addNickname("tintin");
        personPersister.insert((Object)person);
        Person loadedPerson = (Person)personPersister.select(person.getId());
        personPersister.delete((Object)loadedPerson);
        Set remainingNickNames = (Set)this.persistenceContext.newQuery((CharSequence)"select nickNames from Person_nicknames", String.class).mapKey("nickNames", String.class).execute(Accumulators.toSet());
        Assertions.assertThat((Collection)remainingNickNames).isEmpty();
    }

    @Test
    void withCollectionFactory() {
        ConfiguredPersister personPersister = (ConfiguredPersister)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapCollection(Person::getNicknames, String.class).withCollectionFactory(() -> new TreeSet(String.CASE_INSENSITIVE_ORDER.reversed())).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Person person = new Person(new PersistableIdentifier<Long>(1L));
        person.setName("toto");
        person.initNicknames();
        person.addNickname("d");
        person.addNickname("a");
        person.addNickname("c");
        person.addNickname("b");
        Assertions.assertThat(person.getNicknames()).isEqualTo((Object)org.codefilarete.tool.collection.Arrays.asSet((Object[])new String[]{"a", "b", "c", "d"}));
        personPersister.insert((Object)person);
        Person loadedPerson = (Person)personPersister.select(person.getId());
        Assertions.assertThat(loadedPerson.getNicknames()).isEqualTo((Object)org.codefilarete.tool.collection.Arrays.asSet((Object[])new String[]{"d", "c", "b", "a"}));
    }

    @Test
    void foreignKeyIsPresent() {
        MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapCollection(Person::getNicknames, String.class).build(this.persistenceContext);
        Collection tables = DDLDeployer.collectTables((PersistenceContext)this.persistenceContext);
        Map tablePerName = Iterables.map((Iterable)tables, Table::getName);
        Table personTable = (Table)tablePerName.get("Person");
        Table nickNamesTable = (Table)tablePerName.get("Person_nicknames");
        Function columnPrinter = PersisterBuilderImplTest.ToStringBuilder.of(", ", Column::getAbsoluteName, Functions.chain(Column::getJavaType, Reflections::toString));
        Function fkPrinter = PersisterBuilderImplTest.ToStringBuilder.of(", ", ForeignKey::getName, Functions.link(ForeignKey::getColumns, PersisterBuilderImplTest.ToStringBuilder.asSeveral(columnPrinter)), Functions.link(ForeignKey::getTargetColumns, PersisterBuilderImplTest.ToStringBuilder.asSeveral(columnPrinter)));
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)nickNamesTable.getForeignKeys()).usingElementComparator(Comparator.comparing(fkPrinter))).containsExactly((Object[])new ForeignKey[]{new ForeignKey("FK_Person_nicknames_id_Person_id", nickNamesTable.getColumn("id"), personTable.getColumn("id"))});
    }

    @Test
    void mappedBy() {
        MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapCollection(Person::getNicknames, String.class).withReverseJoinColumn("identifier").build(this.persistenceContext);
        Collection tables = DDLDeployer.collectTables((PersistenceContext)this.persistenceContext);
        Map tablePerName = Iterables.map((Iterable)tables, Table::getName);
        Table personTable = (Table)tablePerName.get("Person");
        Table nickNamesTable = (Table)tablePerName.get("Person_nicknames");
        Assertions.assertThat((Object)nickNamesTable).isNotNull();
        Function columnPrinter = PersisterBuilderImplTest.ToStringBuilder.of(", ", Column::getAbsoluteName, Functions.chain(Column::getJavaType, Reflections::toString));
        Function fkPrinter = PersisterBuilderImplTest.ToStringBuilder.of(", ", ForeignKey::getName, Functions.link(ForeignKey::getColumns, PersisterBuilderImplTest.ToStringBuilder.asSeveral(columnPrinter)), Functions.link(ForeignKey::getTargetColumns, PersisterBuilderImplTest.ToStringBuilder.asSeveral(columnPrinter)));
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)nickNamesTable.getForeignKeys()).usingElementComparator(Comparator.comparing(fkPrinter))).containsExactly((Object[])new ForeignKey[]{new ForeignKey("FK_Person_nicknames_identifier_Person_id", nickNamesTable.getColumn("identifier"), personTable.getColumn("id"))});
    }

    @Test
    void withElementCollectionTableNaming() {
        MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).withElementCollectionTableNaming(accessorDefinition -> "Toto").mapCollection(Person::getNicknames, String.class).build(this.persistenceContext);
        Collection tables = DDLDeployer.collectTables((PersistenceContext)this.persistenceContext);
        Map tablePerName = Iterables.map((Iterable)tables, Table::getName);
        Table personTable = (Table)tablePerName.get("Person");
        Table nickNamesTable = (Table)tablePerName.get("Toto");
        Assertions.assertThat((Object)nickNamesTable).isNotNull();
        Function columnPrinter = PersisterBuilderImplTest.ToStringBuilder.of(", ", Column::getAbsoluteName, Functions.chain(Column::getJavaType, Reflections::toString));
        Function fkPrinter = PersisterBuilderImplTest.ToStringBuilder.of(", ", ForeignKey::getName, Functions.link(ForeignKey::getColumns, PersisterBuilderImplTest.ToStringBuilder.asSeveral(columnPrinter)), Functions.link(ForeignKey::getTargetColumns, PersisterBuilderImplTest.ToStringBuilder.asSeveral(columnPrinter)));
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)nickNamesTable.getForeignKeys()).usingElementComparator(Comparator.comparing(fkPrinter))).containsExactly((Object[])new ForeignKey[]{new ForeignKey("FK_Toto_id_Person_id", nickNamesTable.getColumn("id"), personTable.getColumn("id"))});
    }

    @Test
    void withTable() {
        Table nickNamesTable = new Table("Toto");
        MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapCollection(Person::getNicknames, String.class).withTable(nickNamesTable).build(this.persistenceContext);
        Collection tables = DDLDeployer.collectTables((PersistenceContext)this.persistenceContext);
        Map tablePerName = Iterables.map((Iterable)tables, Table::getName);
        Table personTable = (Table)tablePerName.get("Person");
        Function columnPrinter = PersisterBuilderImplTest.ToStringBuilder.of(", ", Column::getAbsoluteName, Functions.chain(Column::getJavaType, Reflections::toString));
        Function fkPrinter = PersisterBuilderImplTest.ToStringBuilder.of(", ", ForeignKey::getName, Functions.link(ForeignKey::getColumns, PersisterBuilderImplTest.ToStringBuilder.asSeveral(columnPrinter)), Functions.link(ForeignKey::getTargetColumns, PersisterBuilderImplTest.ToStringBuilder.asSeveral(columnPrinter)));
        Assertions.assertThat((Collection)nickNamesTable.getForeignKeys()).usingElementComparator(Comparator.comparing(fkPrinter)).containsExactly(new Object[]{new ForeignKey("FK_Toto_id_Person_id", nickNamesTable.getColumn("id"), personTable.getColumn("id"))});
    }

    @Test
    void withTableName() {
        MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapCollection(Person::getNicknames, String.class).withTable("Toto").build(this.persistenceContext);
        Collection tables = DDLDeployer.collectTables((PersistenceContext)this.persistenceContext);
        Map tablePerName = Iterables.map((Iterable)tables, Table::getName);
        Table personTable = (Table)tablePerName.get("Person");
        Table nickNamesTable = (Table)tablePerName.get("Toto");
        Assertions.assertThat((Object)nickNamesTable).isNotNull();
        Function columnPrinter = PersisterBuilderImplTest.ToStringBuilder.of(", ", Column::getAbsoluteName, Functions.chain(Column::getJavaType, Reflections::toString));
        Function fkPrinter = PersisterBuilderImplTest.ToStringBuilder.of(", ", ForeignKey::getName, Functions.link(ForeignKey::getColumns, PersisterBuilderImplTest.ToStringBuilder.asSeveral(columnPrinter)), Functions.link(ForeignKey::getTargetColumns, PersisterBuilderImplTest.ToStringBuilder.asSeveral(columnPrinter)));
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)nickNamesTable.getForeignKeys()).usingElementComparator(Comparator.comparing(fkPrinter))).containsExactly((Object[])new ForeignKey[]{new ForeignKey("FK_Toto_id_Person_id", nickNamesTable.getColumn("id"), personTable.getColumn("id"))});
    }

    @Test
    void overrideColumnName() {
        MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapCollection(Person::getNicknames, String.class).override("toto").build(this.persistenceContext);
        Collection tables = DDLDeployer.collectTables((PersistenceContext)this.persistenceContext);
        Map tablePerName = Iterables.map((Iterable)tables, Table::getName);
        Table personTable = (Table)tablePerName.get("Person");
        Table nickNamesTable = (Table)tablePerName.get("Person_nicknames");
        Assertions.assertThat(nickNamesTable.mapColumnsOnName().keySet()).containsExactlyInAnyOrder((Object[])new String[]{"id", "toto"});
    }

    @Test
    void read_deepInTree() {
        EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.alreadyAssigned(p -> p.getId().setPersisted(), p -> p.getId().isPersisted())).map(Country::getName).map(Country::getDescription).mapOneToOne(Country::getPresident, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Person.class, Identifier.LONG_TYPE).mapKey(Person::getId, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.alreadyAssigned(p -> p.getId().setPersisted(), p -> p.getId().isPersisted())).map(Person::getName).mapCollection(Person::getNicknames, String.class)).mapOneToMany(Country::getCities, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.alreadyAssigned(p -> p.getId().setPersisted(), p -> p.getId().isPersisted())).map(City::getName)).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Country country = new Country(42L);
        country.setName("Toto");
        country.addCity(new City(111L));
        country.addCity(new City(222L));
        Person president = new Person(666L);
        president.setName("me");
        president.initNicknames();
        president.addNickname("John Do");
        president.addNickname("Jane Do");
        country.setPresident(president);
        countryPersister.insert(Arrays.asList(country));
        Country loadedCountry = (Country)countryPersister.select(country.getId());
        Assertions.assertThat(loadedCountry.getPresident().getNicknames()).containsExactlyInAnyOrderElementsOf(country.getPresident().getNicknames());
    }

    @Test
    void crudEnum() {
        Table totoTable = new Table("Toto");
        Column idColumn = totoTable.addColumn("id", UUID_TYPE);
        this.dialect.getColumnBinderRegistry().register(idColumn, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
        this.dialect.getSqlTypeRegistry().put(idColumn, "VARCHAR(255)");
        ConfiguredPersister personPersister = (ConfiguredPersister)MappingEase.entityBuilder(FluentEntityMappingConfigurationSupportTest.Toto.class, UUID_TYPE, (Table)totoTable).mapKey(FluentEntityMappingConfigurationSupportTest.Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(FluentEntityMappingConfigurationSupportTest.Toto::getName).mapCollection(FluentEntityMappingConfigurationSupportTest.Toto::getPossibleStates, FluentEntityMappingConfigurationSupportTest.State.class).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        FluentEntityMappingConfigurationSupportTest.Toto person = new FluentEntityMappingConfigurationSupportTest.Toto();
        person.setName("toto");
        person.getPossibleStates().add(FluentEntityMappingConfigurationSupportTest.State.DONE);
        person.getPossibleStates().add(FluentEntityMappingConfigurationSupportTest.State.IN_PROGRESS);
        personPersister.insert((Object)person);
        FluentEntityMappingConfigurationSupportTest.Toto loadedPerson = (FluentEntityMappingConfigurationSupportTest.Toto)personPersister.select(person.getId());
        Assertions.assertThat(loadedPerson.getPossibleStates()).isEqualTo((Object)org.codefilarete.tool.collection.Arrays.asSet((Object[])new FluentEntityMappingConfigurationSupportTest.State[]{FluentEntityMappingConfigurationSupportTest.State.DONE, FluentEntityMappingConfigurationSupportTest.State.IN_PROGRESS}));
    }

    @Test
    void crudComplexType() {
        Table totoTable = new Table("Toto");
        Column idColumn = totoTable.addColumn("id", UUID_TYPE);
        this.dialect.getColumnBinderRegistry().register(idColumn, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
        this.dialect.getSqlTypeRegistry().put(idColumn, "VARCHAR(255)");
        ConfiguredPersister personPersister = (ConfiguredPersister)MappingEase.entityBuilder(FluentEntityMappingConfigurationSupportTest.Toto.class, UUID_TYPE, (Table)totoTable).mapKey(FluentEntityMappingConfigurationSupportTest.Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(FluentEntityMappingConfigurationSupportTest.Toto::getName).mapCollection(FluentEntityMappingConfigurationSupportTest.Toto::getTimes, Timestamp.class, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate)).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        FluentEntityMappingConfigurationSupportTest.Toto person = new FluentEntityMappingConfigurationSupportTest.Toto();
        person.setName("toto");
        Timestamp timestamp1 = new Timestamp(LocalDateTime.now().plusDays(1L), LocalDateTime.now().plusDays(1L));
        Timestamp timestamp2 = new Timestamp(LocalDateTime.now().plusDays(2L), LocalDateTime.now().plusDays(2L));
        person.getTimes().add(timestamp1);
        person.getTimes().add(timestamp2);
        personPersister.insert((Object)person);
        FluentEntityMappingConfigurationSupportTest.Toto loadedPerson = (FluentEntityMappingConfigurationSupportTest.Toto)personPersister.select(person.getId());
        Assertions.assertThat(loadedPerson.getTimes()).isEqualTo((Object)org.codefilarete.tool.collection.Arrays.asSet((Object[])new Timestamp[]{timestamp1, timestamp2}));
    }

    @Test
    void crudComplexType_overrideColumnName() {
        Table totoTable = new Table("toto");
        Column idColumn = totoTable.addColumn("id", UUID_TYPE);
        this.dialect.getColumnBinderRegistry().register(idColumn, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
        this.dialect.getSqlTypeRegistry().put(idColumn, "VARCHAR(255)");
        ConfiguredPersister personPersister = (ConfiguredPersister)MappingEase.entityBuilder(FluentEntityMappingConfigurationSupportTest.Toto.class, UUID_TYPE, (Table)totoTable).mapKey(FluentEntityMappingConfigurationSupportTest.Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(FluentEntityMappingConfigurationSupportTest.Toto::getName).mapCollection(FluentEntityMappingConfigurationSupportTest.Toto::getTimes, Timestamp.class, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate)).overrideName(Timestamp::getCreationDate, "createdAt").build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Collection tables = DDLDeployer.collectTables((PersistenceContext)this.persistenceContext);
        Map tablePerName = Iterables.map((Iterable)tables, Table::getName);
        Table totoTimesTable = (Table)tablePerName.get("Toto_times");
        Map timesTableColumn = totoTimesTable.mapColumnsOnName();
        Assertions.assertThat(timesTableColumn.get("createdAt")).isNotNull();
        FluentEntityMappingConfigurationSupportTest.Toto person = new FluentEntityMappingConfigurationSupportTest.Toto();
        person.setName("toto");
        Timestamp timestamp1 = new Timestamp(LocalDateTime.now().plusDays(1L), LocalDateTime.now().plusDays(1L));
        Timestamp timestamp2 = new Timestamp(LocalDateTime.now().plusDays(2L), LocalDateTime.now().plusDays(2L));
        person.getTimes().add(timestamp1);
        person.getTimes().add(timestamp2);
        personPersister.insert((Object)person);
        FluentEntityMappingConfigurationSupportTest.Toto loadedPerson = (FluentEntityMappingConfigurationSupportTest.Toto)personPersister.select(person.getId());
        Assertions.assertThat(loadedPerson.getTimes()).isEqualTo((Object)org.codefilarete.tool.collection.Arrays.asSet((Object[])new Timestamp[]{timestamp1, timestamp2}));
    }
}

