/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.codefilarete.stalactite.engine.SubEntityMappingConfiguration;
import org.codefilarete.stalactite.engine.SubEntityMappingConfigurationProvider;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.KeepOrderMap;
import org.codefilarete.tool.collection.KeepOrderSet;

public interface PolymorphismPolicy<C> {
    public static <C> TablePerClassPolymorphism<C> tablePerClass() {
        return new TablePerClassPolymorphism();
    }

    public static <C> TablePerClassPolymorphism<C> tablePerClass(Class<C> polymorphicType) {
        return new TablePerClassPolymorphism();
    }

    public static <C> JoinTablePolymorphism<C> joinTable() {
        return new JoinTablePolymorphism();
    }

    public static <C> JoinTablePolymorphism<C> joinTable(Class<C> polymorphicType) {
        return new JoinTablePolymorphism();
    }

    public static <C> SingleTablePolymorphism<C, String> singleTable() {
        return PolymorphismPolicy.singleTable("DTYPE");
    }

    public static <C> SingleTablePolymorphism<C, String> singleTable(String discriminatorColumnName) {
        return new SingleTablePolymorphism(discriminatorColumnName, String.class);
    }

    public static <C> SingleTablePolymorphism<C, String> singleTable(Class<C> polymorphicType) {
        return PolymorphismPolicy.singleTable("DTYPE");
    }

    public static <C> SingleTablePolymorphism<C, String> singleTable(Class<C> polymorphicType, String discriminatorColumnName) {
        return new SingleTablePolymorphism(discriminatorColumnName, String.class);
    }

    public Set<SubEntityMappingConfiguration<? extends C>> getSubClasses();

    public static class SingleTablePolymorphism<C, D>
    implements PolymorphismPolicy<C> {
        private final String discriminatorColumn;
        private final Class<D> discriminatorType;
        private final Map<D, SubEntityMappingConfiguration<? extends C>> subClasses = new KeepOrderMap();

        public SingleTablePolymorphism(String discriminatorColumn, Class<D> discriminatorType) {
            this.discriminatorColumn = discriminatorColumn;
            this.discriminatorType = discriminatorType;
        }

        public String getDiscriminatorColumn() {
            return this.discriminatorColumn;
        }

        public Class<D> getDiscrimintorType() {
            return this.discriminatorType;
        }

        public SingleTablePolymorphism<C, D> addSubClass(SubEntityMappingConfigurationProvider<? extends C> entityMappingConfiguration, D discriminatorValue) {
            return this.addSubClass(entityMappingConfiguration.getConfiguration(), discriminatorValue);
        }

        public SingleTablePolymorphism<C, D> addSubClass(SubEntityMappingConfiguration<? extends C> entityMappingConfiguration, D discriminatorValue) {
            this.subClasses.put(discriminatorValue, entityMappingConfiguration);
            return this;
        }

        public Class<? extends C> getClass(D discriminatorValue) {
            return this.subClasses.get(discriminatorValue).getEntityType();
        }

        public D getDiscriminatorValue(Class<? extends C> instanceType) {
            return (D)((Map.Entry)Iterables.find(this.subClasses.entrySet(), e -> ((SubEntityMappingConfiguration)e.getValue()).getEntityType().isAssignableFrom(instanceType))).getKey();
        }

        @Override
        public Set<SubEntityMappingConfiguration<? extends C>> getSubClasses() {
            return new KeepOrderSet(this.subClasses.values());
        }
    }

    public static class JoinTablePolymorphism<C>
    implements PolymorphismPolicy<C> {
        private final Set<Duo<SubEntityMappingConfiguration<? extends C>, Table>> subClasses = new KeepOrderSet();

        public JoinTablePolymorphism<C> addSubClass(SubEntityMappingConfigurationProvider<? extends C> entityMappingConfigurationProvider) {
            this.addSubClass(entityMappingConfigurationProvider, null);
            return this;
        }

        public JoinTablePolymorphism<C> addSubClass(SubEntityMappingConfigurationProvider<? extends C> entityMappingConfigurationProvider, @Nullable Table table) {
            return this.addSubClass(entityMappingConfigurationProvider.getConfiguration(), table);
        }

        public JoinTablePolymorphism<C> addSubClass(SubEntityMappingConfiguration<? extends C> entityMappingConfiguration, @Nullable Table table) {
            this.subClasses.add(new Duo(entityMappingConfiguration, (Object)table));
            return this;
        }

        @Override
        public Set<SubEntityMappingConfiguration<? extends C>> getSubClasses() {
            return (Set)Iterables.collect(this.subClasses, Duo::getLeft, KeepOrderSet::new);
        }

        @Nullable
        public Table giveTable(SubEntityMappingConfiguration key) {
            return (Table)((Duo)Iterables.find(this.subClasses, duo -> ((SubEntityMappingConfiguration)duo.getLeft()).equals(key))).getRight();
        }
    }

    public static class TablePerClassPolymorphism<C>
    implements PolymorphismPolicy<C> {
        private final Set<Duo<SubEntityMappingConfiguration<? extends C>, Table>> subClasses = new KeepOrderSet();

        public TablePerClassPolymorphism<C> addSubClass(SubEntityMappingConfigurationProvider<? extends C> entityMappingConfigurationProvider) {
            this.addSubClass(entityMappingConfigurationProvider, null);
            return this;
        }

        public TablePerClassPolymorphism<C> addSubClass(SubEntityMappingConfiguration<? extends C> entityMappingConfiguration) {
            this.addSubClass(entityMappingConfiguration, null);
            return this;
        }

        public TablePerClassPolymorphism<C> addSubClass(SubEntityMappingConfigurationProvider<? extends C> entityMappingConfigurationProvider, @Nullable Table table) {
            this.subClasses.add(new Duo(entityMappingConfigurationProvider.getConfiguration(), (Object)table));
            return this;
        }

        public TablePerClassPolymorphism<C> addSubClass(SubEntityMappingConfiguration<? extends C> entityMappingConfiguration, @Nullable Table table) {
            this.subClasses.add(new Duo(entityMappingConfiguration, (Object)table));
            return this;
        }

        @Override
        public Set<SubEntityMappingConfiguration<? extends C>> getSubClasses() {
            return (Set)Iterables.collect(this.subClasses, Duo::getLeft, KeepOrderSet::new);
        }

        @Nullable
        public Table giveTable(SubEntityMappingConfiguration<? extends C> key) {
            return (Table)((Duo)Iterables.find(this.subClasses, duo -> ((SubEntityMappingConfiguration)duo.getLeft()).equals(key))).getRight();
        }
    }
}

