/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.util.function.Function;
import org.codefilarete.stalactite.engine.DatabaseVendorSettings;
import org.codefilarete.stalactite.engine.SQLOperationsFactories;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.query.builder.QuerySQLBuilderFactory;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.DMLNameProviderFactory;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.DialectOptions;
import org.codefilarete.stalactite.sql.GeneratedKeysReaderFactory;
import org.codefilarete.stalactite.sql.QuerySQLBuilderFactoryBuilder;
import org.codefilarete.stalactite.sql.ddl.DDLSequenceGenerator;
import org.codefilarete.stalactite.sql.ddl.DDLTableGenerator;
import org.codefilarete.stalactite.sql.ddl.SqlTypeRegistry;
import org.codefilarete.stalactite.sql.statement.DMLGenerator;
import org.codefilarete.stalactite.sql.statement.ReadOperationFactory;
import org.codefilarete.stalactite.sql.statement.WriteOperationFactory;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;
import org.codefilarete.tool.collection.CaseInsensitiveSet;

public class DialectBuilder {
    private final DatabaseVendorSettings vendorSettings;
    private final DialectOptions dialectOptions;

    public DialectBuilder(DatabaseVendorSettings vendorSettings) {
        this(vendorSettings, DialectOptions.noOptions());
    }

    public DialectBuilder(DatabaseVendorSettings vendorSettings, DialectOptions dialectOptions) {
        this.vendorSettings = vendorSettings;
        this.dialectOptions = dialectOptions;
    }

    public Dialect build() {
        SqlTypeRegistry sqlTypeRegistry = this.buildSqlTypeRegistry();
        ColumnBinderRegistry columnBinderRegistry = this.buildColumnBinderRegistry();
        DMLNameProviderFactory dmlNameProviderFactory = this.buildDmlNameProviderFactory();
        SQLOperationsFactories sqlOperationsFactories = this.vendorSettings.getSqlOperationsFactoriesBuilder().build(columnBinderRegistry, dmlNameProviderFactory, sqlTypeRegistry);
        DDLTableGenerator ddlTableGenerator = sqlOperationsFactories.getDdlTableGenerator();
        DDLSequenceGenerator ddlSequenceGenerator = sqlOperationsFactories.getDdlSequenceGenerator();
        DMLGenerator dmlGenerator = sqlOperationsFactories.getDmlGenerator();
        WriteOperationFactory writeOperationFactory = sqlOperationsFactories.getWriteOperationFactory();
        ReadOperationFactory readOperationFactory = sqlOperationsFactories.getReadOperationFactory();
        QuerySQLBuilderFactory querySQLBuilderFactory = new QuerySQLBuilderFactoryBuilder(dmlNameProviderFactory, columnBinderRegistry, this.vendorSettings.getJavaTypeToSqlTypes()).build();
        GeneratedKeysReaderFactory generatedKeysReaderFactory = this.vendorSettings.getGeneratedKeysReaderFactory();
        return new Dialect.DialectSupport(this.vendorSettings.getCompatibility(), ddlTableGenerator, ddlSequenceGenerator, dmlGenerator, writeOperationFactory, readOperationFactory, querySQLBuilderFactory, sqlTypeRegistry, columnBinderRegistry, dmlNameProviderFactory, this.dialectOptions.getInOperatorMaxSize().getOrDefault(this.vendorSettings.getInOperatorMaxSize()), generatedKeysReaderFactory, this.vendorSettings.getDatabaseSequenceSelectorFactory(), this.vendorSettings.supportsTupleCondition());
    }

    protected ColumnBinderRegistry buildColumnBinderRegistry() {
        ColumnBinderRegistry columnBinderRegistry = new ColumnBinderRegistry(this.vendorSettings.getParameterBinderRegistry());
        if (this.dialectOptions.getJavaTypeBinders().isTouched()) {
            this.dialectOptions.getJavaTypeBinders().consumeIfTouched(typeBindings -> typeBindings.forEach(typeBinding -> columnBinderRegistry.register(typeBinding.getJavaType(), typeBinding.getParameterBinder())));
        }
        return columnBinderRegistry;
    }

    protected SqlTypeRegistry buildSqlTypeRegistry() {
        SqlTypeRegistry sqlTypeRegistry = new SqlTypeRegistry(this.vendorSettings.getJavaTypeToSqlTypes());
        if (this.dialectOptions.getJavaTypeToSqlTypeMappings().isTouched()) {
            this.dialectOptions.getJavaTypeToSqlTypeMappings().consumeIfTouched(typeBindings -> typeBindings.forEach(typeBinding -> sqlTypeRegistry.put(typeBinding.getJavaType(), typeBinding.getSqlType())));
        }
        return sqlTypeRegistry;
    }

    protected DMLNameProviderFactory buildDmlNameProviderFactory() {
        return this.dialectOptions.getQuoteSQLIdentifiers().getOrDefault(false) != false ? x$0 -> new QuotingDMLNameProvider(x$0) : x$0 -> new QuotingKeywordsDMLNameProvider(x$0);
    }

    protected class QuotingDMLNameProvider
    extends DMLNameProvider {
        private final char quoteCharacter;

        protected QuotingDMLNameProvider(Function<Fromable, String> tableAliaser) {
            super(tableAliaser);
            this.quoteCharacter = DialectBuilder.this.dialectOptions.getQuoteCharacter().getOrDefault(Character.valueOf(DialectBuilder.this.vendorSettings.getQuoteCharacter())).charValue();
        }

        @Override
        public String getSimpleName(Selectable<?> column) {
            return this.quote(super.getSimpleName(column));
        }

        @Override
        public String getName(Fromable table) {
            return this.quote(super.getName(table));
        }

        @Override
        public String getAlias(Fromable table) {
            String alias = super.getAlias(table);
            return alias == null ? null : this.quote(alias);
        }

        protected String quote(String name) {
            return this.quoteCharacter + name + this.quoteCharacter;
        }
    }

    protected class QuotingKeywordsDMLNameProvider
    extends QuotingDMLNameProvider {
        private final CaseInsensitiveSet keywords;

        protected QuotingKeywordsDMLNameProvider(Function<Fromable, String> tableAliaser) {
            super(tableAliaser);
            this.keywords = new CaseInsensitiveSet(DialectBuilder.this.vendorSettings.getKeyWords());
        }

        @Override
        protected String quote(String name) {
            if (this.keywords.contains((Object)name)) {
                return super.quote(name);
            }
            return name;
        }
    }
}

