/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.order;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.query.builder.QuotingDMLNameProvider;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.Operators;
import org.codefilarete.stalactite.sql.DMLNameProviderFactory;
import org.codefilarete.stalactite.sql.DefaultDialect;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.order.Update;
import org.codefilarete.stalactite.sql.order.UpdateCommandBuilder;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.tool.collection.Maps;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class UpdateCommandBuilderTest {
    UpdateCommandBuilderTest() {
    }

    @Test
    <T extends Table<T>> void toSQL_singleTable() {
        Table totoTable = new Table("Toto");
        Column columnA = totoTable.addColumn("a", String.class);
        Column columnB = totoTable.addColumn("b", String.class);
        Update update = new Update(totoTable);
        update.where(columnA, (ConditionalOperator)Operators.eq((Object)44)).or(columnA, (ConditionalOperator)Operators.eq((Object)columnB));
        DefaultDialect dialect = new DefaultDialect();
        UpdateCommandBuilder testInstance = new UpdateCommandBuilder(update, (Dialect)dialect);
        Assertions.assertThat((String)testInstance.toSQL()).isEqualTo("update Toto set  where a = 44 or a = b");
        update = new Update(totoTable).set(columnA, columnB);
        testInstance = new UpdateCommandBuilder(update, (Dialect)dialect);
        Assertions.assertThat((String)testInstance.toSQL()).isEqualTo("update Toto set a = b");
        update = new Update(totoTable).set(columnA, (Object)"tata");
        testInstance = new UpdateCommandBuilder(update, (Dialect)dialect);
        Assertions.assertThat((String)testInstance.toSQL()).isEqualTo("update Toto set a = 'tata'");
    }

    @Test
    <T extends Table<T>> void toSQL_keywordsAreEscaped() {
        Table totoTable = new Table("Toto");
        Column columnA = totoTable.addColumn("a", Long.class);
        Column columnB = totoTable.addColumn("b", String.class);
        Update update = new Update(totoTable).set(columnB, (Object)"tata");
        DefaultDialect dialect = new DefaultDialect(){

            protected DMLNameProviderFactory newDMLNameProviderFactory() {
                return QuotingDMLNameProvider::new;
            }
        };
        UpdateCommandBuilder testInstance = new UpdateCommandBuilder(update, (Dialect)dialect);
        Assertions.assertThat((String)testInstance.toSQL()).isEqualTo("update `Toto` set `b` = 'tata'");
    }

    @Test
    <T1 extends Table<T1>, T2 extends Table<T2>> void toSQL_multiTable() {
        Table totoTable = new Table("Toto");
        Column columnA = totoTable.addColumn("a", String.class);
        Column columnB = totoTable.addColumn("b", String.class);
        Column columnC = totoTable.addColumn("c", String.class);
        Table tataTable = new Table("Tata");
        Column columnX = tataTable.addColumn("x", Long.class);
        Column columnY = tataTable.addColumn("y", String.class);
        Column columnZ = tataTable.addColumn("z", String.class);
        Update update1 = new Update(totoTable);
        update1.where(columnA, (ConditionalOperator)Operators.eq((Object)columnX)).or(columnA, (ConditionalOperator)Operators.eq((Object)columnY));
        DefaultDialect dialect = new DefaultDialect();
        UpdateCommandBuilder testInstance = new UpdateCommandBuilder(update1, (Dialect)dialect);
        Assertions.assertThat((String)testInstance.toSQL()).isEqualTo("update Toto, Tata set  where Toto.a = Tata.x or Toto.a = Tata.y");
        Update update2 = new Update(totoTable).set(columnC, columnZ);
        update2.where(columnA, (ConditionalOperator)Operators.eq((Object)columnX)).or(columnA, (ConditionalOperator)Operators.eq((Object)columnY));
        testInstance = new UpdateCommandBuilder(update2, (Dialect)dialect);
        Assertions.assertThat((String)testInstance.toSQL()).isEqualTo("update Toto, Tata set Toto.c = Tata.z where Toto.a = Tata.x or Toto.a = Tata.y");
    }

    @Test
    <T extends Table<T>> void toStatement() throws SQLException {
        Table totoTable = new Table("Toto");
        Column columnA = totoTable.addColumn("a", Long.class);
        Column columnB = totoTable.addColumn("b", Long.class);
        Column columnC = totoTable.addColumn("c", String.class);
        Column columnD = totoTable.addColumn("d", Integer.class);
        Update update = new Update(totoTable).set(columnB, columnA).set(columnC, (Object)"tata").set(columnD, (Object)666);
        update.where(columnA, (ConditionalOperator)Operators.in((Object[])new Long[]{42L, 43L})).or(columnA, (ConditionalOperator)Operators.eq((Object)columnB));
        DefaultDialect dialect = new DefaultDialect();
        UpdateCommandBuilder testInstance = new UpdateCommandBuilder(update, (Dialect)dialect);
        UpdateCommandBuilder.UpdateStatement result = testInstance.toStatement();
        Assertions.assertThat((String)result.getSQL()).isEqualTo("update Toto set b = a, c = ?, d = ? where a in (?, ?) or a = b");
        Assertions.assertThat((Map)result.getValues()).isEqualTo((Object)Maps.asMap((Object)1, (Object)"tata").add((Object)2, (Object)666).add((Object)3, (Object)42L).add((Object)4, (Object)43L));
        Assertions.assertThat((Object)result.getParameterBinder((Object)1)).isEqualTo((Object)DefaultParameterBinders.STRING_BINDER);
        Assertions.assertThat((Object)result.getParameterBinder((Object)2)).isEqualTo((Object)DefaultParameterBinders.INTEGER_BINDER);
        Assertions.assertThat((Object)result.getParameterBinder((Object)3)).isEqualTo((Object)DefaultParameterBinders.LONG_BINDER);
        Assertions.assertThat((Object)result.getParameterBinder((Object)4)).isEqualTo((Object)DefaultParameterBinders.LONG_BINDER);
        PreparedStatement mock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        result.applyValues(mock);
        ((PreparedStatement)Mockito.verify((Object)mock)).setString(1, "tata");
        ((PreparedStatement)Mockito.verify((Object)mock)).setInt(2, 666);
        ((PreparedStatement)Mockito.verify((Object)mock)).setLong(3, 42L);
        ((PreparedStatement)Mockito.verify((Object)mock)).setLong(4, 43L);
        result.setValue(columnC, (Object)"tutu");
        result.applyValues(mock);
        ((PreparedStatement)Mockito.verify((Object)mock)).setString(1, "tutu");
        dialect.getColumnBinderRegistry().register(columnD, DefaultParameterBinders.INTEGER_PRIMITIVE_BINDER);
        result = testInstance.toStatement();
        Assertions.assertThat((Object)result.getParameterBinder((Object)2)).isEqualTo((Object)DefaultParameterBinders.INTEGER_PRIMITIVE_BINDER);
        result.setValue(columnD, (Object)-666);
        result.applyValues(mock);
        ((PreparedStatement)Mockito.verify((Object)mock)).setInt(2, -666);
    }
}

