/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql;

import org.codefilarete.stalactite.mapping.id.sequence.SequenceStoredAsTableSelector;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.DMLNameProviderFactory;
import org.codefilarete.stalactite.sql.DatabaseSequenceSelectorFactory;
import org.codefilarete.stalactite.sql.DefaultDialect;
import org.codefilarete.stalactite.sql.MySQLDMLNameProvider;
import org.codefilarete.stalactite.sql.MySQLGeneratedKeysReader;
import org.codefilarete.stalactite.sql.MySQLWriteOperationFactory;
import org.codefilarete.stalactite.sql.ddl.DDLTableGenerator;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;
import org.codefilarete.stalactite.sql.ddl.MySQLDDLTableGenerator;
import org.codefilarete.stalactite.sql.ddl.structure.Sequence;
import org.codefilarete.stalactite.sql.statement.GeneratedKeysReader;
import org.codefilarete.stalactite.sql.statement.WriteOperationFactory;
import org.codefilarete.stalactite.sql.statement.binder.MySQLParameterBinderRegistry;
import org.codefilarete.stalactite.sql.statement.binder.MySQLTypeMapping;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinderRegistry;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.bean.Objects;

public class MySQLDialect
extends DefaultDialect {
    private final MySQLSequenceSelectorFactory sequenceSelectorFactory = new MySQLSequenceSelectorFactory();

    public MySQLDialect() {
        super((JavaTypeToSqlTypeMapping)new MySQLTypeMapping(), (ParameterBinderRegistry)new MySQLParameterBinderRegistry());
    }

    public <I> GeneratedKeysReader<I> buildGeneratedKeysReader(String keyName, Class<I> columnType) {
        return new MySQLGeneratedKeysReader();
    }

    protected DMLNameProviderFactory newDMLNameProviderFactory() {
        return MySQLDMLNameProvider::new;
    }

    public DDLTableGenerator newDdlTableGenerator() {
        return new MySQLDDLTableGenerator(this.getSqlTypeRegistry(), MySQLDMLNameProvider::new);
    }

    protected WriteOperationFactory newWriteOperationFactory() {
        return new MySQLWriteOperationFactory();
    }

    public DatabaseSequenceSelectorFactory getDatabaseSequenceSelectorFactory() {
        return this.sequenceSelectorFactory;
    }

    public boolean supportsTupleCondition() {
        return true;
    }

    @VisibleForTesting
    class MySQLSequenceSelectorFactory
    implements DatabaseSequenceSelectorFactory {
        MySQLSequenceSelectorFactory() {
        }

        public org.codefilarete.tool.function.Sequence<Long> create(Sequence databaseSequence, ConnectionProvider connectionProvider) {
            return new SequenceStoredAsTableSelector(databaseSequence.getSchema(), databaseSequence.getName(), ((Integer)Objects.preventNull((Object)databaseSequence.getInitialValue(), (Object)1)).intValue(), ((Integer)Objects.preventNull((Object)databaseSequence.getBatchSize(), (Object)1)).intValue(), MySQLDialect.this.getDmlGenerator(), MySQLDialect.this.getReadOperationFactory(), MySQLDialect.this.getWriteOperationFactory(), connectionProvider);
        }
    }
}

