/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.order;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.query.builder.QuotingDMLNameProvider;
import org.codefilarete.stalactite.sql.DMLNameProviderFactory;
import org.codefilarete.stalactite.sql.DefaultDialect;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.order.Insert;
import org.codefilarete.stalactite.sql.order.InsertCommandBuilder;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.tool.collection.Maps;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class InsertCommandBuilderTest {
    InsertCommandBuilderTest() {
    }

    @Test
    <T extends Table<T>> void toSQL() {
        Table totoTable = new Table("Toto");
        Column columnA = totoTable.addColumn("a", Long.class);
        Column columnB = totoTable.addColumn("b", String.class);
        Insert insert = new Insert(totoTable).set(columnB, (Object)"tata");
        InsertCommandBuilder testInstance = new InsertCommandBuilder(insert, (Dialect)new DefaultDialect());
        Assertions.assertThat((String)testInstance.toSQL()).isEqualTo("insert into Toto(a, b) values (?, ?)");
    }

    @Test
    <T extends Table<T>> void toSQL_keywordsAreEscaped() {
        Table totoTable = new Table("Toto");
        Column columnA = totoTable.addColumn("a", Long.class);
        Column columnB = totoTable.addColumn("b", String.class);
        Insert insert = new Insert(totoTable).set(columnB, (Object)"tata");
        DefaultDialect dialect = new DefaultDialect(){

            protected DMLNameProviderFactory newDMLNameProviderFactory() {
                return QuotingDMLNameProvider::new;
            }
        };
        InsertCommandBuilder testInstance = new InsertCommandBuilder(insert, (Dialect)dialect);
        Assertions.assertThat((String)testInstance.toSQL()).isEqualTo("insert into `Toto`(`a`, `b`) values (?, ?)");
    }

    @Test
    <T extends Table<T>> void toStatement() throws SQLException {
        Table totoTable = new Table("Toto");
        Column columnA = totoTable.addColumn("a", Long.class);
        Column columnB = totoTable.addColumn("b", String.class);
        Column columnC = totoTable.addColumn("c", String.class);
        Insert insert = new Insert(totoTable).set(columnB, (Object)"tata");
        DefaultDialect dialect = new DefaultDialect();
        InsertCommandBuilder testInstance = new InsertCommandBuilder(insert, (Dialect)dialect);
        InsertCommandBuilder.InsertStatement result = testInstance.toStatement();
        Assertions.assertThat((String)result.getSQL()).isEqualTo("insert into Toto(a, b, c) values (?, ?, ?)");
        Assertions.assertThat((Map)result.getValues()).isEqualTo((Object)Maps.asMap((Object)columnB, (Object)"tata"));
        Assertions.assertThat((Object)result.getParameterBinder((Object)columnA)).isEqualTo((Object)DefaultParameterBinders.LONG_BINDER);
        Assertions.assertThat((Object)result.getParameterBinder((Object)columnB)).isEqualTo((Object)DefaultParameterBinders.STRING_BINDER);
        Assertions.assertThat((Object)result.getParameterBinder((Object)columnC)).isEqualTo((Object)DefaultParameterBinders.STRING_BINDER);
        result.setValue((Object)columnA, (Object)42L);
        result.setValue((Object)columnC, (Object)"toto");
        PreparedStatement mock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        result.applyValues(mock);
        ((PreparedStatement)Mockito.verify((Object)mock)).setLong(1, 42L);
        ((PreparedStatement)Mockito.verify((Object)mock)).setString(2, "tata");
        ((PreparedStatement)Mockito.verify((Object)mock)).setString(3, "toto");
        dialect.getColumnBinderRegistry().register(columnA, DefaultParameterBinders.LONG_PRIMITIVE_BINDER);
        result = testInstance.toStatement();
        Assertions.assertThat((Object)result.getParameterBinder((Object)columnA)).isEqualTo((Object)DefaultParameterBinders.LONG_PRIMITIVE_BINDER);
        result.setValue((Object)columnA, (Object)-42L);
        result.setValue((Object)columnC, (Object)"toto");
        result.applyValues(mock);
        ((PreparedStatement)Mockito.verify((Object)mock)).setLong(1, -42L);
    }
}

