/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.codefilarete.stalactite.engine.DatabaseVendorSettings;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.DialectResolver;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.Strings;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.exception.Exceptions;

public class ServiceLoaderDialectResolver
implements DialectResolver {
    @Override
    public Dialect determineDialect(Connection conn) {
        DatabaseSignet databaseSignet = DatabaseSignet.fromMetadata(conn);
        ServiceLoader<DialectResolver.DialectResolverEntry> dialects = ServiceLoader.load(DialectResolver.DialectResolverEntry.class);
        return this.determineDialect(dialects, databaseSignet);
    }

    Dialect determineDialect(Iterable<? extends DialectResolver.DialectResolverEntry> dialects, DatabaseSignet databaseSignet) {
        Nullable matchingDialect = Nullable.nullable((Object)this.giveMatchingEntry(dialects, databaseSignet));
        return (Dialect)matchingDialect.map(DialectResolver.DialectResolverEntry::getDialect).getOrThrow(() -> new IllegalStateException("Unable to determine dialect to use for database \"" + databaseSignet.getProductName() + " " + databaseSignet.getMajorVersion() + "." + databaseSignet.getMinorVersion() + "\" among " + Iterables.collectToList((Iterable)dialects, o -> "{" + Strings.footPrint((Object)o.getCompatibility(), (Function[])new Function[]{DatabaseSignet::toString}) + "}")));
    }

    @Override
    public DatabaseVendorSettings determineVendorSettings(Connection conn) {
        DatabaseSignet databaseSignet = DatabaseSignet.fromMetadata(conn);
        ServiceLoader<DialectResolver.DialectResolverEntry> dialects = ServiceLoader.load(DialectResolver.DialectResolverEntry.class);
        return this.determineVendorSettings(dialects, databaseSignet);
    }

    DatabaseVendorSettings determineVendorSettings(Iterable<? extends DialectResolver.DialectResolverEntry> dialects, DatabaseSignet databaseSignet) {
        DialectResolver.DialectResolverEntry matchingDialect = this.giveMatchingEntry(dialects, databaseSignet);
        if (matchingDialect == null) {
            throw new IllegalStateException("Unable to determine vendor settings to use for database \"" + databaseSignet.getProductName() + " " + databaseSignet.getMajorVersion() + "." + databaseSignet.getMinorVersion() + "\" among " + Iterables.collectToList(dialects, o -> "{" + Strings.footPrint((Object)o.getCompatibility(), (Function[])new Function[]{DatabaseSignet::toString}) + "}"));
        }
        return matchingDialect.getVendorSettings();
    }

    @javax.annotation.Nullable
    @VisibleForTesting
    DialectResolver.DialectResolverEntry giveMatchingEntry(Iterable<? extends DialectResolver.DialectResolverEntry> dialects, DatabaseSignet databaseSignet) {
        Set<DialectResolver.DialectResolverEntry> databaseDialects = Iterables.stream(dialects).filter(entry -> entry.getCompatibility().getProductName().equals(databaseSignet.getProductName())).collect(Collectors.toSet());
        if (databaseDialects.isEmpty()) {
            return null;
        }
        TreeMap dialectPerSortedCompatibility = new TreeMap(DatabaseSignet.COMPARATOR);
        databaseDialects.forEach(dialect -> dialectPerSortedCompatibility.merge(dialect.getCompatibility(), dialect, (c1, c2) -> {
            String printableSignet = Strings.footPrint((Object)c1.getCompatibility(), (Function[])new Function[]{DatabaseSignet::toString});
            throw new IllegalStateException("Multiple dialects with same database compatibility found : " + printableSignet);
        }));
        Map.Entry foundEntry = dialectPerSortedCompatibility.floorEntry(databaseSignet);
        return foundEntry == null ? null : (DialectResolver.DialectResolverEntry)foundEntry.getValue();
    }

    public static class DatabaseSignet {
        static Comparator<DatabaseSignet> COMPARATOR = Comparator.comparing(DatabaseSignet::getProductName).thenComparingInt(DatabaseSignet::getMajorVersion).thenComparingInt(DatabaseSignet::getMinorVersion);
        private final String productName;
        private final int majorVersion;
        private final int minorVersion;

        public static DatabaseSignet fromMetadata(Connection connection) {
            try {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                return new DatabaseSignet(databaseMetaData.getDatabaseProductName(), databaseMetaData.getDatabaseMajorVersion(), databaseMetaData.getDatabaseMinorVersion());
            }
            catch (SQLException e) {
                throw Exceptions.asRuntimeException((Throwable)e);
            }
        }

        public DatabaseSignet(String productName, int majorVersion, int minorVersion) {
            this.productName = productName;
            this.majorVersion = majorVersion;
            this.minorVersion = minorVersion;
        }

        public String getProductName() {
            return this.productName;
        }

        public int getMajorVersion() {
            return this.majorVersion;
        }

        public int getMinorVersion() {
            return this.minorVersion;
        }

        public String toString() {
            return this.productName + " " + this.majorVersion + "." + this.minorVersion;
        }
    }
}

