/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.stream.LongStream;
import org.codefilarete.stalactite.mapping.id.sequence.SequenceStoredAsTableSelector;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.DatabaseSequenceSelectorFactory;
import org.codefilarete.stalactite.sql.DefaultDialect;
import org.codefilarete.stalactite.sql.SQLiteDMLGenerator;
import org.codefilarete.stalactite.sql.SQLiteGeneratedKeysReader;
import org.codefilarete.stalactite.sql.ddl.DDLTableGenerator;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;
import org.codefilarete.stalactite.sql.ddl.SQLiteDDLTableGenerator;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Sequence;
import org.codefilarete.stalactite.sql.statement.DMLGenerator;
import org.codefilarete.stalactite.sql.statement.GeneratedKeysReader;
import org.codefilarete.stalactite.sql.statement.ReadOperationFactory;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.WriteOperation;
import org.codefilarete.stalactite.sql.statement.WriteOperationFactory;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinderIndex;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinderRegistry;
import org.codefilarete.stalactite.sql.statement.binder.SQLiteParameterBinderRegistry;
import org.codefilarete.stalactite.sql.statement.binder.SQLiteTypeMapping;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.bean.Objects;
import org.codefilarete.tool.collection.Sorter;
import org.codefilarete.tool.function.ThrowingBiFunction;

public class SQLiteDialect
extends DefaultDialect {
    private final SQLiteSequenceSelectorFactory sequenceSelectorFactory = new SQLiteSequenceSelectorFactory();

    public SQLiteDialect() {
        super((JavaTypeToSqlTypeMapping)new SQLiteTypeMapping(), (ParameterBinderRegistry)new SQLiteParameterBinderRegistry());
    }

    public <I> GeneratedKeysReader<I> buildGeneratedKeysReader(String keyName, Class<I> columnType) {
        return new SQLiteGeneratedKeysReader();
    }

    protected DMLGenerator newDmlGenerator() {
        return new SQLiteDMLGenerator((ParameterBinderIndex<Column, ParameterBinder>)this.getColumnBinderRegistry(), (Sorter<Column>)DMLGenerator.NoopSorter.INSTANCE, this.getDmlNameProviderFactory());
    }

    protected DDLTableGenerator newDdlTableGenerator() {
        return new SQLiteDDLTableGenerator(this.getSqlTypeRegistry(), this.getDmlNameProviderFactory());
    }

    protected ReadOperationFactory newReadOperationFactory() {
        return new SQLiteReadOperationFactory();
    }

    protected WriteOperationFactory newWriteOperationFactory() {
        return new SQLiteWriteOperationFactory();
    }

    public DatabaseSequenceSelectorFactory getDatabaseSequenceSelectorFactory() {
        return this.sequenceSelectorFactory;
    }

    @VisibleForTesting
    class SQLiteSequenceSelectorFactory
    implements DatabaseSequenceSelectorFactory {
        SQLiteSequenceSelectorFactory() {
        }

        public org.codefilarete.tool.function.Sequence<Long> create(Sequence databaseSequence, ConnectionProvider connectionProvider) {
            return new SequenceStoredAsTableSelector(databaseSequence.getSchema(), databaseSequence.getName(), ((Integer)Objects.preventNull((Object)databaseSequence.getInitialValue(), (Object)1)).intValue(), ((Integer)Objects.preventNull((Object)databaseSequence.getBatchSize(), (Object)1)).intValue(), SQLiteDialect.this.getDmlGenerator(), SQLiteDialect.this.getReadOperationFactory(), SQLiteDialect.this.getWriteOperationFactory(), connectionProvider);
        }
    }

    static class SQLiteWriteOperation<ParamType>
    extends WriteOperation<ParamType> {
        private long updatedRowCount = 0L;

        public SQLiteWriteOperation(SQLStatement<ParamType> sqlGenerator, ConnectionProvider connectionProvider, WriteOperation.RowCountListener rowCountListener) {
            super(sqlGenerator, connectionProvider, rowCountListener);
        }

        public long getUpdatedRowCount() {
            return this.updatedRowCount;
        }

        protected long[] doExecuteBatch() throws SQLException {
            long[] rowCounts = super.doExecuteBatch();
            this.updatedRowCount = LongStream.of(rowCounts).sum();
            return rowCounts;
        }
    }

    public static class SQLiteWriteOperationFactory
    extends WriteOperationFactory {
        protected <ParamType> WriteOperation<ParamType> createInstance(SQLStatement<ParamType> sqlGenerator, ConnectionProvider connectionProvider, final ThrowingBiFunction<Connection, String, PreparedStatement, SQLException> statementProvider, WriteOperation.RowCountListener rowCountListener) {
            return new SQLiteWriteOperation<ParamType>(sqlGenerator, connectionProvider, rowCountListener){

                protected void prepareStatement(Connection connection) throws SQLException {
                    this.preparedStatement = (PreparedStatement)statementProvider.apply((Object)connection, (Object)this.getSQL());
                }
            };
        }
    }

    public static class SQLiteReadOperationFactory
    extends ReadOperationFactory {
    }
}

