/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.map.HashedMap;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorByMethodReference;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.MutatorByMethodReference;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.reflection.ValueAccessPointMap;
import org.codefilarete.stalactite.engine.MappingConfigurationException;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.RelationalEntityPersister;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.mapping.IdMapping;
import org.codefilarete.stalactite.mapping.SimpleIdMapping;
import org.codefilarete.stalactite.mapping.id.assembly.SimpleIdentifierAssembler;
import org.codefilarete.stalactite.query.ConfiguredEntityCriteria;
import org.codefilarete.stalactite.query.RelationalEntityCriteria;
import org.codefilarete.stalactite.query.model.AbstractCriterion;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.Criteria;
import org.codefilarete.stalactite.query.model.CriteriaChain;
import org.codefilarete.stalactite.query.model.LogicalOperator;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.StringAppender;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.PairIterator;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;
import org.danekja.java.util.function.serializable.SerializableFunction;

public class EntityCriteriaSupport<C>
implements RelationalEntityCriteria<C, EntityCriteriaSupport<C>>,
ConfiguredEntityCriteria {
    private final Criteria criteria = new Criteria();
    private final EntityCriteriaSupport<C> parent;
    private final EntityGraphNode<C> rootConfiguration;
    private boolean hasCollectionCriteria;

    public EntityCriteriaSupport(EntityMapping<C, ?, ?> entityMapping) {
        this(new EntityGraphNode<C>(entityMapping));
    }

    public EntityCriteriaSupport(EntityCriteriaSupport<C> source) {
        this(source.rootConfiguration);
    }

    private EntityCriteriaSupport(EntityGraphNode<C> source) {
        this.rootConfiguration = source;
        this.parent = null;
    }

    private EntityCriteriaSupport(EntityGraphNode<C> source, EntityCriteriaSupport<C> parent) {
        this.rootConfiguration = source;
        this.parent = parent;
    }

    public EntityGraphNode<C> getRootConfiguration() {
        return this.rootConfiguration;
    }

    public void registerRelation(ValueAccessPoint<C> relation, ConfiguredRelationalPersister<?, ?> persister) {
        this.rootConfiguration.registerRelation(relation, persister);
    }

    public <O> EntityCriteriaSupport<C> add(LogicalOperator logicalOperator, List<? extends ValueAccessPoint<?>> accessPointChain, ConditionalOperator<O, ?> operator) {
        Column column = this.rootConfiguration.giveColumn(accessPointChain);
        this.criteria.add(logicalOperator, column, operator);
        if (this.criteria.getOperator() == null) {
            this.criteria.setOperator(logicalOperator);
        }
        this.computeCollectionCriteriaIndicator(accessPointChain);
        return this;
    }

    private void computeCollectionCriteriaIndicator(List<? extends ValueAccessPoint<?>> accessPointChain) {
        this.hasCollectionCriteria |= accessPointChain.stream().anyMatch(valueAccessPoint -> Collection.class.isAssignableFrom(AccessorDefinition.giveDefinition((ValueAccessPoint)valueAccessPoint).getMemberType()));
    }

    public <O> EntityCriteriaSupport<C> and(SerializableFunction<C, O> getter, ConditionalOperator<O, ?> operator) {
        return this.add(LogicalOperator.AND, Arrays.asList((Object[])new AccessorByMethodReference[]{new AccessorByMethodReference(getter)}), operator);
    }

    public <O> EntityCriteriaSupport<C> and(SerializableBiConsumer<C, O> setter, ConditionalOperator<O, ?> operator) {
        return this.add(LogicalOperator.AND, Arrays.asList((Object[])new MutatorByMethodReference[]{new MutatorByMethodReference(setter)}), operator);
    }

    public <O> EntityCriteriaSupport<C> or(SerializableFunction<C, O> getter, ConditionalOperator<O, ?> operator) {
        return this.add(LogicalOperator.OR, Arrays.asList((Object[])new AccessorByMethodReference[]{new AccessorByMethodReference(getter)}), operator);
    }

    public <O> EntityCriteriaSupport<C> or(SerializableBiConsumer<C, O> setter, ConditionalOperator<O, ?> operator) {
        return this.add(LogicalOperator.OR, Arrays.asList((Object[])new MutatorByMethodReference[]{new MutatorByMethodReference(setter)}), operator);
    }

    public EntityCriteriaSupport<C> beginNested() {
        EntityCriteriaSupport<C> abstractCriteria = new EntityCriteriaSupport<C>(this.rootConfiguration, this);
        this.criteria.add((AbstractCriterion)abstractCriteria.criteria);
        return abstractCriteria;
    }

    public EntityCriteriaSupport<C> endNested() {
        return this.parent;
    }

    public <A, B> EntityCriteriaSupport<C> and(SerializableFunction<C, A> getter1, SerializableFunction<A, B> getter2, ConditionalOperator<B, ?> operator) {
        return this.and(AccessorChain.chain(getter1, getter2), (ConditionalOperator)operator);
    }

    public <O> EntityCriteriaSupport<C> and(AccessorChain<C, O> getter, ConditionalOperator<O, ?> operator) {
        return this.add(LogicalOperator.AND, getter.getAccessors(), operator);
    }

    public <O> EntityCriteriaSupport<C> or(AccessorChain<C, O> getter, ConditionalOperator<O, ?> operator) {
        return this.add(LogicalOperator.OR, getter.getAccessors(), operator);
    }

    @Override
    public <S extends Collection<A>, A, B> EntityCriteriaSupport<C> andMany(SerializableFunction<C, S> getter1, SerializableFunction<A, B> getter2, ConditionalOperator<B, ?> operator) {
        return this.add(LogicalOperator.AND, Arrays.asList((Object[])new AccessorByMethodReference[]{new AccessorByMethodReference(getter1), new AccessorByMethodReference(getter2)}), operator);
    }

    @Override
    public CriteriaChain<?> getCriteria() {
        return this.criteria;
    }

    @Override
    public boolean hasCollectionCriteria() {
        return this.hasCollectionCriteria;
    }

    public static class EntityGraphNode<C> {
        private final Map<List<? extends ValueAccessPoint<?>>, Column> propertyToColumn = new HashedMap<List<? extends ValueAccessPoint<?>>, Column>(){

            protected int hash(Object key) {
                List accessors = (List)key;
                int result = 1;
                for (ValueAccessPoint accessor : accessors) {
                    AccessorDefinition accessorDefinition = AccessorDefinition.giveDefinition((ValueAccessPoint)accessor);
                    result = 31 * result + 31 * accessorDefinition.getDeclaringClass().hashCode() + accessorDefinition.getName().hashCode();
                }
                return result;
            }

            protected boolean isEqualKey(Object key1, Object key2) {
                List accessors1 = (List)key1;
                List accessors2 = (List)key2;
                List accessorDefinitions1 = accessors1.stream().map(AccessorDefinition::giveDefinition).collect(Collectors.toList());
                List accessorDefinitions2 = accessors2.stream().map(AccessorDefinition::giveDefinition).collect(Collectors.toList());
                PairIterator pairIterator = new PairIterator(accessorDefinitions1, accessorDefinitions2);
                boolean result = false;
                while (!result && pairIterator.hasNext()) {
                    Duo accessorsPair = pairIterator.next();
                    result = ((AccessorDefinition)accessorsPair.getLeft()).getDeclaringClass().equals(((AccessorDefinition)accessorsPair.getRight()).getDeclaringClass()) && ((AccessorDefinition)accessorsPair.getLeft()).getName().equals(((AccessorDefinition)accessorsPair.getRight()).getName()) && ((AccessorDefinition)accessorsPair.getLeft()).getMemberType().equals(((AccessorDefinition)accessorsPair.getRight()).getMemberType());
                }
                return result;
            }
        };
        private final Class<?> entityClass;
        private final ValueAccessPointMap<C, RelationalEntityPersister<?, ?>> relations = new ValueAccessPointMap();

        @VisibleForTesting
        EntityGraphNode(EntityMapping<C, ?, ?> entityMapping) {
            this.entityClass = entityMapping.getClassToPersist();
            Stream.concat(entityMapping.getPropertyToColumn().entrySet().stream(), entityMapping.getReadonlyPropertyToColumn().entrySet().stream()).forEach(entry -> {
                ReversibleAccessor accessor = (ReversibleAccessor)entry.getKey();
                List key = accessor instanceof AccessorChain ? ((AccessorChain)accessor).getAccessors() : Arrays.asList((Object[])new ReversibleAccessor[]{accessor});
                this.propertyToColumn.put(key, (Column)entry.getValue());
            });
            IdMapping idMapping = entityMapping.getIdMapping();
            if (idMapping instanceof SimpleIdMapping) {
                Column primaryKey = ((SimpleIdentifierAssembler)idMapping.getIdentifierAssembler()).getColumn();
                this.propertyToColumn.put(Arrays.asList((Object[])new ReversibleAccessor[]{((SimpleIdMapping)idMapping).getIdAccessor().getIdAccessor()}), primaryKey);
            }
            entityMapping.getEmbeddedBeanStrategies().forEach((k, v) -> v.getPropertyToColumn().forEach((p, c) -> this.propertyToColumn.put(new AccessorChain(new Accessor[]{k, p}).getAccessors(), (Column)c)));
        }

        public boolean hasCollectionProperty() {
            return Stream.concat(this.propertyToColumn.keySet().stream().flatMap(Collection::stream), this.relations.keySet().stream()).anyMatch(valueAccessPoint -> Iterable.class.isAssignableFrom(AccessorDefinition.giveDefinition((ValueAccessPoint)valueAccessPoint).getMemberType()));
        }

        @VisibleForTesting
        void registerRelation(ValueAccessPoint<C> relationProvider, ConfiguredRelationalPersister<?, ?> persister) {
            this.propertyToColumn.remove(Arrays.asList((Object[])new ValueAccessPoint[]{relationProvider}));
            this.relations.put(relationProvider, persister);
        }

        public Column giveColumn(List<? extends ValueAccessPoint<?>> valueAccessPoints) {
            Column column = this.propertyToColumn.get(valueAccessPoints);
            if (column != null) {
                return column;
            }
            RelationalEntityPersister entityGraphNode = (RelationalEntityPersister)this.relations.get(valueAccessPoints.get(0));
            if (entityGraphNode != null) {
                column = entityGraphNode.getColumn(valueAccessPoints.subList(1, valueAccessPoints.size()));
            }
            if (column == null) {
                throw this.newConfigurationException(valueAccessPoints);
            }
            return column;
        }

        private MappingConfigurationException newConfigurationException(List<? extends ValueAccessPoint<?>> valueAccessPoints) {
            StringAppender accessPointAsString = new StringAppender(){

                public StringAppender cat(Object o) {
                    if (o instanceof ValueAccessPoint) {
                        super.cat((Object)AccessorDefinition.toString((ValueAccessPoint)((ValueAccessPoint)o)));
                    } else {
                        super.cat(o);
                    }
                    return this;
                }
            };
            accessPointAsString.ccat(valueAccessPoints, (Object)" > ");
            return new MappingConfigurationException("Error while looking for column of " + accessPointAsString + " : it is not declared in mapping of " + Reflections.toString(this.entityClass));
        }
    }
}

