/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.mapping.id.sequence;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.statement.ReadOperation;
import org.codefilarete.stalactite.sql.statement.ReadOperationFactory;
import org.codefilarete.stalactite.sql.statement.StringParamedSQL;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.bean.Objects;
import org.codefilarete.tool.function.Sequence;

public class DatabaseSequenceSelector
implements Sequence<Long> {
    private final org.codefilarete.stalactite.sql.ddl.structure.Sequence databaseSequence;
    private final int poolSize;
    private final ReadOperationFactory readOperationFactory;
    private final ConnectionProvider connectionProvider;
    private final InternalState internalState = new InternalState();
    private final StringParamedSQL sqlOrder;

    public DatabaseSequenceSelector(org.codefilarete.stalactite.sql.ddl.structure.Sequence databaseSequence, String selectStatement, ReadOperationFactory readOperationFactory, ConnectionProvider connectionProvider) {
        this.databaseSequence = databaseSequence;
        this.poolSize = (Integer)Objects.preventNull((Object)databaseSequence.getBatchSize(), (Object)1);
        this.readOperationFactory = readOperationFactory;
        this.connectionProvider = connectionProvider;
        this.sqlOrder = new StringParamedSQL(selectStatement, Collections.EMPTY_MAP);
    }

    public org.codefilarete.stalactite.sql.ddl.structure.Sequence getDatabaseSequence() {
        return this.databaseSequence;
    }

    public synchronized Long next() {
        if (!this.internalState.initialized) {
            this.internalState.currentValue = this.callDatabase();
            this.internalState.initialized = true;
            return this.internalState.currentValue;
        }
        if (this.internalState.currentValue % (long)this.poolSize == 0L) {
            this.internalState.currentValue = this.callDatabase();
            return this.internalState.currentValue;
        }
        return ++this.internalState.currentValue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    long callDatabase() {
        try (ReadOperation readOperation = this.readOperationFactory.createInstance(this.sqlOrder, this.connectionProvider);){
            ResultSet rs = readOperation.execute();
            rs.next();
            long l = rs.getLong(1);
            return l;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static class InternalState {
        private long currentValue;
        private boolean initialized = false;

        private InternalState() {
        }
    }
}

