/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import java.util.function.Function;
import javax.sql.DataSource;
import org.codefilarete.stalactite.engine.ConnectionSettings;
import org.codefilarete.stalactite.engine.CurrentThreadTransactionalConnectionProvider;
import org.codefilarete.stalactite.engine.DatabaseVendorSettings;
import org.codefilarete.stalactite.engine.SQLOperationsFactories;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.query.builder.QuerySQLBuilderFactory;
import org.codefilarete.stalactite.query.builder.QuotingDMLNameProvider;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.DMLNameProviderFactory;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.GeneratedKeysReaderFactory;
import org.codefilarete.stalactite.sql.QuerySQLBuilderFactoryBuilder;
import org.codefilarete.stalactite.sql.ddl.DDLSequenceGenerator;
import org.codefilarete.stalactite.sql.ddl.DDLTableGenerator;
import org.codefilarete.stalactite.sql.ddl.SqlTypeRegistry;
import org.codefilarete.stalactite.sql.statement.DMLGenerator;
import org.codefilarete.stalactite.sql.statement.ReadOperationFactory;
import org.codefilarete.stalactite.sql.statement.WriteOperationFactory;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;
import org.codefilarete.tool.bean.Objects;
import org.codefilarete.tool.collection.Arrays;

public class PersistenceContextConfigurationBuilder {
    protected final DatabaseVendorSettings vendorSettings;
    protected final ConnectionSettings connectionSettings;
    protected final DataSource dataSource;
    protected boolean quoteAllSQLIdentifiers = false;

    public PersistenceContextConfigurationBuilder(DatabaseVendorSettings vendorSettings, ConnectionSettings connectionSettings, DataSource dataSource) {
        this.vendorSettings = vendorSettings;
        this.connectionSettings = connectionSettings;
        this.dataSource = dataSource;
    }

    public void quoteAllSQLIdentifiers() {
        this.setQuoteAllSQLIdentifiers(true);
    }

    public void setQuoteAllSQLIdentifiers(boolean quoteAllSQLIdentifiers) {
        this.quoteAllSQLIdentifiers = quoteAllSQLIdentifiers;
    }

    public PersistenceContextConfiguration build() {
        SqlTypeRegistry sqlTypeRegistry = this.buildSqlTypeRegistry();
        ColumnBinderRegistry columnBinderRegistry = this.buildColumnBinderRegistry();
        DMLNameProviderFactory dmlNameProviderFactory = this.buildDmlNameProviderFactory();
        SQLOperationsFactories sqlOperationsFactories = this.vendorSettings.getSqlOperationsFactoriesBuilder().build(columnBinderRegistry, dmlNameProviderFactory, sqlTypeRegistry);
        DDLTableGenerator ddlTableGenerator = sqlOperationsFactories.getDdlTableGenerator();
        DDLSequenceGenerator ddlSequenceGenerator = sqlOperationsFactories.getDdlSequenceGenerator();
        DMLGenerator dmlGenerator = sqlOperationsFactories.getDmlGenerator();
        WriteOperationFactory writeOperationFactory = sqlOperationsFactories.getWriteOperationFactory();
        ReadOperationFactory readOperationFactory = sqlOperationsFactories.getReadOperationFactory();
        QuerySQLBuilderFactory querySQLBuilderFactory = new QuerySQLBuilderFactoryBuilder(dmlNameProviderFactory, columnBinderRegistry, this.vendorSettings.getJavaTypeToSqlTypes()).build();
        GeneratedKeysReaderFactory generatedKeysReaderFactory = this.vendorSettings.getGeneratedKeysReaderFactory();
        Dialect.DialectSupport dialect = new Dialect.DialectSupport(ddlTableGenerator, ddlSequenceGenerator, dmlGenerator, writeOperationFactory, readOperationFactory, querySQLBuilderFactory, sqlTypeRegistry, columnBinderRegistry, dmlNameProviderFactory, (Integer)Objects.preventNull((Object)this.connectionSettings.getInOperatorMaxSize(), (Object)this.vendorSettings.getInOperatorMaxSize()), generatedKeysReaderFactory, this.vendorSettings.getDatabaseSequenceSelectorFactory(), this.vendorSettings.supportsTupleCondition());
        ConnectionConfiguration connectionConfiguration = this.buildConnectionConfiguration();
        return new PersistenceContextConfiguration(connectionConfiguration, dialect);
    }

    protected ColumnBinderRegistry buildColumnBinderRegistry() {
        return new ColumnBinderRegistry(this.vendorSettings.getParameterBinderRegistry());
    }

    protected SqlTypeRegistry buildSqlTypeRegistry() {
        return new SqlTypeRegistry(this.vendorSettings.getJavaTypeToSqlTypes());
    }

    protected DMLNameProviderFactory buildDmlNameProviderFactory() {
        DMLNameProviderFactory dmlNameProviderFactory = this.quoteAllSQLIdentifiers ? tableAliaser -> new QuotingDMLNameProvider(tableAliaser, this.vendorSettings.getQuotingCharacter()) : new DMLNameProviderFactory(){

            @Override
            public DMLNameProvider build(Function<Fromable, String> tableAliaser) {
                return new DMLNameProvider(tableAliaser){
                    private final char quotingCharacter;
                    private final Set<String> keyWords;
                    {
                        this.quotingCharacter = PersistenceContextConfigurationBuilder.this.vendorSettings.getQuotingCharacter();
                        this.keyWords = Collections.unmodifiableSet(Arrays.asTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER, PersistenceContextConfigurationBuilder.this.vendorSettings.getKeyWords()));
                    }

                    @Override
                    public String getSimpleName(Selectable<?> column) {
                        String name = super.getSimpleName(column);
                        if (this.keyWords.contains(name)) {
                            return this.quotingCharacter + name + this.quotingCharacter;
                        }
                        return name;
                    }

                    @Override
                    public String getName(Fromable table) {
                        String name = super.getName(table);
                        if (this.keyWords.contains(name)) {
                            return this.quotingCharacter + name + this.quotingCharacter;
                        }
                        return name;
                    }
                };
            }
        };
        return dmlNameProviderFactory;
    }

    protected ConnectionConfiguration buildConnectionConfiguration() {
        return new ConnectionConfiguration.ConnectionConfigurationSupport(new CurrentThreadTransactionalConnectionProvider(this.dataSource), this.connectionSettings.getBatchSize());
    }

    public static class PersistenceContextConfiguration {
        private final ConnectionConfiguration connectionConfiguration;
        private final Dialect dialect;

        public PersistenceContextConfiguration(ConnectionConfiguration connectionConfiguration, Dialect dialect) {
            this.connectionConfiguration = connectionConfiguration;
            this.dialect = dialect;
        }

        public Dialect getDialect() {
            return this.dialect;
        }

        public ConnectionConfiguration getConnectionConfiguration() {
            return this.connectionConfiguration;
        }
    }
}

