/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.mapping.id.sequence;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.mapping.id.sequence.DatabaseSequenceSelector;
import org.codefilarete.stalactite.sql.ddl.structure.Sequence;
import org.codefilarete.stalactite.sql.statement.ReadOperationFactory;
import org.codefilarete.tool.trace.ModifiableLong;
import org.junit.jupiter.api.Test;

class DatabaseSequenceSelectorTest {
    DatabaseSequenceSelectorTest() {
    }

    @Test
    void next_basic() {
        final ArrayList databaseCalls = new ArrayList();
        final ModifiableLong counter = new ModifiableLong();
        DatabaseSequenceSelector testInstance = new DatabaseSequenceSelector(new Sequence("whatever sequence name"), "whatever SQL", new ReadOperationFactory(), null){

            long callDatabase() {
                long value = counter.increment();
                databaseCalls.add(value);
                return value;
            }
        };
        Assertions.assertThat((Long)testInstance.next()).isEqualTo(1L);
        Assertions.assertThat((Long)testInstance.next()).isEqualTo(2L);
        Assertions.assertThat((Long)testInstance.next()).isEqualTo(3L);
        Assertions.assertThat(databaseCalls).containsExactly((Object[])new Long[]{1L, 2L, 3L});
    }

    @Test
    void next_withPoolSize() {
        final ArrayList databaseCalls = new ArrayList();
        final int poolSize = 3;
        final ModifiableLong counter = new ModifiableLong((long)(-poolSize + 1));
        DatabaseSequenceSelector testInstance = new DatabaseSequenceSelector(new Sequence("whatever sequence name").withBatchSize(Integer.valueOf(poolSize)), "whatever SQL", new ReadOperationFactory(), null){

            long callDatabase() {
                long value = counter.increment((long)poolSize);
                databaseCalls.add(value);
                return value;
            }
        };
        for (int i = 1; i < 10; ++i) {
            Long sequenceValue = testInstance.next();
            Assertions.assertThat((Long)sequenceValue).isEqualTo((long)i);
        }
        Assertions.assertThat(databaseCalls).containsExactly((Object[])new Long[]{1L, 4L, 7L});
    }

    @Test
    void next_withPoolSize_multiThread() throws InterruptedException {
        final ArrayList databaseCalls = new ArrayList();
        final int poolSize = 3;
        final AtomicLong counter = new AtomicLong(1L);
        DatabaseSequenceSelector testInstance = new DatabaseSequenceSelector(new Sequence("whatever sequence name").withBatchSize(Integer.valueOf(poolSize)), "whatever SQL", new ReadOperationFactory(), null){

            long callDatabase() {
                long value = counter.getAndAdd(poolSize);
                databaseCalls.add(value);
                return value;
            }
        };
        List generatedValues = Collections.synchronizedList(new ArrayList());
        ExecutorService workerPool = Executors.newFixedThreadPool(3);
        for (int i = 0; i < 20; ++i) {
            workerPool.submit(() -> {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                generatedValues.add(testInstance.next());
            });
        }
        Thread.sleep(500L);
        Assertions.assertThat(generatedValues).contains((Object[])new Long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L});
        Assertions.assertThat(databaseCalls).contains((Object[])new Long[]{1L, 4L, 7L});
        workerPool.shutdown();
    }
}

