/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.mapping.id;

import java.util.ArrayList;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.iterable.ThrowingExtractor;
import org.codefilarete.stalactite.engine.SeparateTransactionExecutor;
import org.codefilarete.stalactite.mapping.id.sequence.hilo.PooledHiLoSequencePersister;
import org.codefilarete.stalactite.mapping.id.sequence.hilo.PooledHiLoSequenceStorageOptions;
import org.codefilarete.stalactite.sql.DefaultDialect;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.tool.collection.Arrays;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class PooledHiLoSequencePersisterTest {
    @Test
    void constructorWithoutArgs_usesDefaultStorageOptions() {
        PooledHiLoSequencePersister testInstance = new PooledHiLoSequencePersister((Dialect)new DefaultDialect(), (SeparateTransactionExecutor)Mockito.mock(SeparateTransactionExecutor.class), 42);
        PooledHiLoSequencePersister.SequenceTable sequenceTable = (PooledHiLoSequencePersister.SequenceTable)testInstance.getMapping().getTargetTable();
        Assertions.assertThat((String)sequenceTable.getName()).isEqualTo(PooledHiLoSequenceStorageOptions.DEFAULT.getTable());
        Assertions.assertThat((int)sequenceTable.mapColumnsOnName().keySet().size()).isEqualTo(2);
        Assertions.assertThat(sequenceTable.mapColumnsOnName().get(PooledHiLoSequenceStorageOptions.DEFAULT.getSequenceNameColumn())).extracting(Column::getJavaType).isEqualTo(String.class);
        Assertions.assertThat(sequenceTable.mapColumnsOnName().get(PooledHiLoSequenceStorageOptions.DEFAULT.getSequenceNameColumn())).extracting(Column::isPrimaryKey).isEqualTo((Object)true);
        Assertions.assertThat(sequenceTable.mapColumnsOnName().get(PooledHiLoSequenceStorageOptions.DEFAULT.getValueColumn())).extracting(Column::getJavaType).isEqualTo(Long.TYPE);
        Assertions.assertThat(sequenceTable.mapColumnsOnName().get(PooledHiLoSequenceStorageOptions.DEFAULT.getValueColumn())).extracting(Column::isNullable).isEqualTo((Object)false);
    }

    @Test
    void constructorWithOptions() {
        PooledHiLoSequenceStorageOptions storageOptions = new PooledHiLoSequenceStorageOptions("myTable", "mySequenceNameCol", "myNextValCol");
        PooledHiLoSequencePersister testInstance = new PooledHiLoSequencePersister(storageOptions, (Dialect)new DefaultDialect(), (SeparateTransactionExecutor)Mockito.mock(SeparateTransactionExecutor.class), 42);
        PooledHiLoSequencePersister.SequenceTable sequenceTable = (PooledHiLoSequencePersister.SequenceTable)testInstance.getMapping().getTargetTable();
        Assertions.assertThat((String)sequenceTable.getName()).isEqualTo(storageOptions.getTable());
        Assertions.assertThat((int)sequenceTable.mapColumnsOnName().keySet().size()).isEqualTo(2);
        Assertions.assertThat(sequenceTable.mapColumnsOnName().get(storageOptions.getSequenceNameColumn())).extracting(Column::getJavaType).isEqualTo(String.class);
        Assertions.assertThat(sequenceTable.mapColumnsOnName().get(storageOptions.getSequenceNameColumn())).extracting(Column::isPrimaryKey).isEqualTo((Object)true);
        Assertions.assertThat(sequenceTable.mapColumnsOnName().get(storageOptions.getValueColumn())).extracting(Column::getJavaType).isEqualTo(Long.TYPE);
        Assertions.assertThat(sequenceTable.mapColumnsOnName().get(storageOptions.getValueColumn())).extracting(Column::isNullable).isEqualTo((Object)false);
    }

    @Test
    void reservePool_emptyDatabase() {
        final ArrayList selectedSequence = new ArrayList();
        final ArrayList insertedSequence = new ArrayList();
        final ArrayList updatedSequence = new ArrayList();
        SeparateTransactionExecutor separateTransactionExecutorMock = (SeparateTransactionExecutor)Mockito.mock(SeparateTransactionExecutor.class);
        ((SeparateTransactionExecutor)Mockito.doAnswer(invocationOnMock -> {
            ((SeparateTransactionExecutor.JdbcOperation)invocationOnMock.getArgument(0)).execute(null);
            return null;
        }).when((Object)separateTransactionExecutorMock)).executeInNewTransaction((SeparateTransactionExecutor.JdbcOperation)ArgumentMatchers.any());
        PooledHiLoSequencePersister testInstance = new PooledHiLoSequencePersister((Dialect)new DefaultDialect(), separateTransactionExecutorMock, 42){

            public PooledHiLoSequencePersister.Sequence select(String sequenceName) {
                selectedSequence.add(sequenceName);
                return null;
            }

            public void insert(PooledHiLoSequencePersister.Sequence entity) {
                insertedSequence.add(entity);
            }

            public void updateById(PooledHiLoSequencePersister.Sequence entity) {
                updatedSequence.add(entity);
            }
        };
        long identifier = testInstance.reservePool("toto", 10);
        Assertions.assertThat((long)identifier).isEqualTo(10L);
        Assertions.assertThat(selectedSequence).isEqualTo((Object)Arrays.asList((Object[])new String[]{"toto"}));
        Assertions.assertThat(insertedSequence).flatExtracting(new ThrowingExtractor[]{PooledHiLoSequencePersister.Sequence::getSequenceName}).isEqualTo((Object)Arrays.asList((Object[])new String[]{"toto"}));
        Assertions.assertThat(insertedSequence).flatExtracting(new ThrowingExtractor[]{PooledHiLoSequencePersister.Sequence::getStep}).isEqualTo((Object)Arrays.asList((Object[])new Long[]{10L}));
        Assertions.assertThat(updatedSequence).isEmpty();
    }

    @Test
    void reservePool_notEmptyDatabase() {
        final ArrayList selectedSequence = new ArrayList();
        final ArrayList insertedSequence = new ArrayList();
        final ArrayList updatedSequence = new ArrayList();
        SeparateTransactionExecutor separateTransactionExecutorMock = (SeparateTransactionExecutor)Mockito.mock(SeparateTransactionExecutor.class);
        ((SeparateTransactionExecutor)Mockito.doAnswer(invocationOnMock -> {
            ((SeparateTransactionExecutor.JdbcOperation)invocationOnMock.getArgument(0)).execute(null);
            return null;
        }).when((Object)separateTransactionExecutorMock)).executeInNewTransaction((SeparateTransactionExecutor.JdbcOperation)ArgumentMatchers.any());
        PooledHiLoSequencePersister testInstance = new PooledHiLoSequencePersister((Dialect)new DefaultDialect(), separateTransactionExecutorMock, 42){

            public PooledHiLoSequencePersister.Sequence select(String sequenceName) {
                selectedSequence.add(sequenceName);
                return new PooledHiLoSequencePersister.Sequence(sequenceName, 15L);
            }

            public void insert(PooledHiLoSequencePersister.Sequence entity) {
                insertedSequence.add(entity);
            }

            public void updateById(PooledHiLoSequencePersister.Sequence entity) {
                updatedSequence.add(entity);
            }
        };
        long identifier = testInstance.reservePool("toto", 10);
        Assertions.assertThat((long)identifier).isEqualTo(25L);
        Assertions.assertThat(selectedSequence).isEqualTo((Object)Arrays.asList((Object[])new String[]{"toto"}));
        Assertions.assertThat(insertedSequence).isEmpty();
        Assertions.assertThat(updatedSequence).flatExtracting(new ThrowingExtractor[]{PooledHiLoSequencePersister.Sequence::getSequenceName}).isEqualTo((Object)Arrays.asList((Object[])new String[]{"toto"}));
        Assertions.assertThat(updatedSequence).flatExtracting(new ThrowingExtractor[]{PooledHiLoSequencePersister.Sequence::getStep}).isEqualTo((Object)Arrays.asList((Object[])new Long[]{25L}));
    }
}

