/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.mapping.id.sequence;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Database;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.DMLGenerator;
import org.codefilarete.stalactite.sql.statement.PreparedSQL;
import org.codefilarete.stalactite.sql.statement.ReadOperation;
import org.codefilarete.stalactite.sql.statement.ReadOperationFactory;
import org.codefilarete.stalactite.sql.statement.WriteOperation;
import org.codefilarete.stalactite.sql.statement.WriteOperationFactory;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Maps;
import org.codefilarete.tool.function.Sequence;

public class SequenceStoredAsTableSelector
implements Sequence<Long> {
    private final SequenceAsTable sequenceTable;
    private final int initialValue;
    private final int batchSize;
    private final ConnectionProvider connectionProvider;
    private final PreparedSQL selectSequenceStatement;
    private final PreparedSQL insertSequenceStatement;
    private final PreparedSQL updateSequenceStatement;
    private final ReadOperationFactory readOperationFactory;
    private final WriteOperationFactory writeOperationFactory;

    public SequenceStoredAsTableSelector(@Nullable Database.Schema schema, String tableName, int initialValue, int batchSize, DMLGenerator dmlGenerator, ReadOperationFactory readOperationFactory, WriteOperationFactory writeOperationFactory, ConnectionProvider connectionProvider) {
        this.readOperationFactory = readOperationFactory;
        this.writeOperationFactory = writeOperationFactory;
        this.sequenceTable = new SequenceAsTable(schema, tableName);
        this.initialValue = initialValue;
        this.batchSize = batchSize;
        this.connectionProvider = connectionProvider;
        this.selectSequenceStatement = new PreparedSQL(dmlGenerator.buildSelect(this.sequenceTable, Arrays.asList((Object[])new Column[]{this.sequenceTable.nextVal}), Collections.emptyList()).getSQL(), Collections.emptyMap());
        Maps.ChainingMap writeBinders = Maps.asMap((Object)1, (Object)DefaultParameterBinders.LONG_BINDER);
        this.insertSequenceStatement = new PreparedSQL(dmlGenerator.buildInsert(Arrays.asList((Object[])new Column[]{this.sequenceTable.nextVal})).getSQL(), (Map)writeBinders);
        this.updateSequenceStatement = new PreparedSQL(dmlGenerator.buildUpdate(Arrays.asList((Object[])new Column[]{this.sequenceTable.nextVal}), Collections.emptyList()).getSQL(), (Map)writeBinders);
    }

    public Table getSequenceTable() {
        return this.sequenceTable;
    }

    public synchronized Long next() {
        long result;
        boolean hasData;
        try (ReadOperation readOperation = this.readOperationFactory.createInstance(this.selectSequenceStatement, this.connectionProvider);){
            ResultSet resultSet = readOperation.execute();
            hasData = resultSet.next();
            result = hasData ? resultSet.getLong(1) : (long)this.initialValue;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        long valueToWrite = result + (long)this.batchSize;
        WriteOperation writeOperation = hasData ? this.writeOperationFactory.createInstance(this.updateSequenceStatement, this.connectionProvider) : this.writeOperationFactory.createInstance(this.insertSequenceStatement, this.connectionProvider);
        try (WriteOperation ignored = writeOperation;){
            writeOperation.setValue((Object)1, (Object)valueToWrite);
            writeOperation.execute();
        }
        return result;
    }

    private static class SequenceAsTable
    extends Table<SequenceAsTable> {
        private final Column<SequenceAsTable, Long> nextVal = this.addColumn("nextVal", Long.TYPE).primaryKey();

        public SequenceAsTable(@Nullable Database.Schema schema, String name) {
            super(schema, name);
        }
    }
}

