/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.sql.PreparedStatement;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.codefilarete.stalactite.engine.StaleStateObjectException;
import org.codefilarete.stalactite.engine.runtime.AbstractDMLExecutorMockTest;
import org.codefilarete.stalactite.engine.runtime.DMLExecutorTest;
import org.codefilarete.stalactite.engine.runtime.DeleteExecutor;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.DefaultDialect;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.DMLGenerator;
import org.codefilarete.stalactite.sql.statement.SQLOperation;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinderIndex;
import org.codefilarete.stalactite.test.PairSetList;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Maps;
import org.codefilarete.tool.collection.Sorter;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class DeleteExecutorTest<T extends Table<T>>
extends AbstractDMLExecutorMockTest {
    private final Dialect dialect = new DefaultDialect(new JavaTypeToSqlTypeMapping().with(Integer.class, "int"));
    private DeleteExecutor<DMLExecutorTest.Toto, Integer, T> testInstance;

    DeleteExecutorTest() {
    }

    @BeforeEach
    void setUp() {
        DMLExecutorTest.PersistenceConfiguration persistenceConfiguration = DeleteExecutorTest.giveDefaultPersistenceConfiguration();
        DMLGenerator dmlGenerator = new DMLGenerator((ParameterBinderIndex)this.dialect.getColumnBinderRegistry(), (Sorter)new DMLGenerator.CaseSensitiveSorter(), DMLNameProvider::new);
        this.testInstance = new DeleteExecutor(persistenceConfiguration.classMappingStrategy, (ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport(this.jdbcMock.transactionManager, 3), dmlGenerator, this.noRowCountCheckWriteOperationFactory, 3);
    }

    @Test
    void delete() throws Exception {
        this.testInstance.delete((Iterable)Arrays.asList((Object[])new DMLExecutorTest.Toto[]{new DMLExecutorTest.Toto(7, 17, 23)}));
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)1))).addBatch();
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)1))).executeLargeBatch();
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)0))).executeLargeUpdate();
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)1))).setInt((Integer)this.jdbcMock.indexCaptor.capture(), (Integer)this.jdbcMock.valueCaptor.capture());
        Assertions.assertThat((String)((String)this.jdbcMock.sqlCaptor.getValue())).isEqualTo("delete from Toto where a = ?");
        PairSetList<Integer, Integer> expectedPairs = PairSetList.pairSetList(1, 7);
        DeleteExecutorTest.assertCapturedPairsEqual(this.jdbcMock, expectedPairs);
    }

    @Test
    void listenerIsCalled() {
        SQLOperation.SQLOperationListener listenerMock = (SQLOperation.SQLOperationListener)Mockito.mock(SQLOperation.SQLOperationListener.class);
        this.testInstance.setOperationListener(listenerMock);
        ArgumentCaptor statementArgCaptor = ArgumentCaptor.forClass(Map.class);
        ArgumentCaptor sqlArgCaptor = ArgumentCaptor.forClass(SQLStatement.class);
        try {
            this.testInstance.delete((Iterable)Arrays.asList((Object[])new DMLExecutorTest.Toto[]{new DMLExecutorTest.Toto(1, 17, 23), new DMLExecutorTest.Toto(2, 29, 31)}));
        }
        catch (StaleStateObjectException staleStateObjectException) {
            // empty catch block
        }
        Table mappedTable = new Table("Toto");
        Column colA = mappedTable.addColumn("a", Integer.class);
        Column colB = mappedTable.addColumn("b", Integer.class);
        Column colC = mappedTable.addColumn("c", Integer.class);
        ((SQLOperation.SQLOperationListener)Mockito.verify((Object)listenerMock, (VerificationMode)Mockito.times((int)2))).onValuesSet((Map)statementArgCaptor.capture());
        ((ListAssert)Assertions.assertThat((List)statementArgCaptor.getAllValues()).usingElementComparator(Comparator.comparing(Object::toString))).containsExactly((Object[])new Map[]{Maps.asHashMap((Object)colA, (Object)1), Maps.asHashMap((Object)colA, (Object)2)});
        ((SQLOperation.SQLOperationListener)Mockito.verify((Object)listenerMock, (VerificationMode)Mockito.times((int)1))).onExecute((SQLStatement)sqlArgCaptor.capture());
        Assertions.assertThat((String)((SQLStatement)sqlArgCaptor.getValue()).getSQL()).isEqualTo("delete from Toto where a = ?");
    }

    @Test
    void delete_multiple() throws Exception {
        this.testInstance.delete((Iterable)Arrays.asList((Object[])new DMLExecutorTest.Toto[]{new DMLExecutorTest.Toto(1, 17, 23), new DMLExecutorTest.Toto(2, 29, 31), new DMLExecutorTest.Toto(3, 37, 41), new DMLExecutorTest.Toto(4, 43, 53)}));
        Assertions.assertThat((List)this.jdbcMock.sqlCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"delete from Toto where a = ?"}));
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)4))).addBatch();
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)2))).executeLargeBatch();
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)0))).executeLargeUpdate();
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)4))).setInt((Integer)this.jdbcMock.indexCaptor.capture(), (Integer)this.jdbcMock.valueCaptor.capture());
        PairSetList<Integer, Integer> expectedPairs = PairSetList.pairSetList(1, 1).add(1, 2).add(1, 3).newRow(1, 4);
        DeleteExecutorTest.assertCapturedPairsEqual(this.jdbcMock, expectedPairs);
    }

    @Test
    void deleteById() throws Exception {
        this.testInstance.deleteById((Iterable)Arrays.asList((Object[])new DMLExecutorTest.Toto[]{new DMLExecutorTest.Toto(7, 17, 23)}));
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)0))).addBatch();
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)0))).executeLargeBatch();
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)1))).executeLargeUpdate();
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)1))).setInt((Integer)this.jdbcMock.indexCaptor.capture(), (Integer)this.jdbcMock.valueCaptor.capture());
        Assertions.assertThat((String)((String)this.jdbcMock.sqlCaptor.getValue())).isEqualTo("delete from Toto where a in (?)");
        PairSetList<Integer, Integer> expectedPairs = PairSetList.pairSetList(1, 7);
        DeleteExecutorTest.assertCapturedPairsEqual(this.jdbcMock, expectedPairs);
    }

    @Test
    void deleteById_multiple_lastBlockContainsOneValue() throws Exception {
        this.testInstance.deleteById((Iterable)Arrays.asList((Object[])new DMLExecutorTest.Toto[]{new DMLExecutorTest.Toto(1, 17, 23), new DMLExecutorTest.Toto(2, 29, 31), new DMLExecutorTest.Toto(3, 37, 41), new DMLExecutorTest.Toto(4, 43, 53)}));
        Assertions.assertThat((List)this.jdbcMock.sqlCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"delete from Toto where a in (?, ?, ?)", "delete from Toto where a in (?)"}));
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)1))).addBatch();
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)1))).executeLargeBatch();
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)1))).executeLargeUpdate();
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)4))).setInt((Integer)this.jdbcMock.indexCaptor.capture(), (Integer)this.jdbcMock.valueCaptor.capture());
        PairSetList<Integer, Integer> expectedPairs = PairSetList.pairSetList(1, 1).add(2, 2).add(3, 3).newRow(1, 4);
        DeleteExecutorTest.assertCapturedPairsEqual(this.jdbcMock, expectedPairs);
    }

    @Test
    void deleteById_multiple_lastBlockContainsMultipleValue() throws Exception {
        this.testInstance.deleteById((Iterable)Arrays.asList((Object[])new DMLExecutorTest.Toto[]{new DMLExecutorTest.Toto(1, 17, 23), new DMLExecutorTest.Toto(2, 29, 31), new DMLExecutorTest.Toto(3, 37, 41), new DMLExecutorTest.Toto(4, 43, 53), new DMLExecutorTest.Toto(5, 59, 61)}));
        Assertions.assertThat((List)this.jdbcMock.sqlCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"delete from Toto where a in (?, ?, ?)", "delete from Toto where a in (?, ?)"}));
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)1))).addBatch();
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)1))).executeLargeBatch();
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)1))).executeLargeUpdate();
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)5))).setInt((Integer)this.jdbcMock.indexCaptor.capture(), (Integer)this.jdbcMock.valueCaptor.capture());
        PairSetList<Integer, Integer> expectedPairs = PairSetList.pairSetList(1, 1).add(2, 2).add(3, 3).newRow(1, 4).add(2, 5);
        DeleteExecutorTest.assertCapturedPairsEqual(this.jdbcMock, expectedPairs);
    }

    @Test
    void deleteById_multiple_lastBlockSizeIsInOperatorSize() throws Exception {
        this.testInstance.deleteById((Iterable)Arrays.asList((Object[])new DMLExecutorTest.Toto[]{new DMLExecutorTest.Toto(1, 17, 23), new DMLExecutorTest.Toto(2, 29, 31), new DMLExecutorTest.Toto(3, 37, 41), new DMLExecutorTest.Toto(4, 43, 53), new DMLExecutorTest.Toto(5, 59, 61), new DMLExecutorTest.Toto(6, 67, 71)}));
        Assertions.assertThat((List)this.jdbcMock.sqlCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"delete from Toto where a in (?, ?, ?)"}));
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)2))).addBatch();
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)1))).executeLargeBatch();
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)0))).executeLargeUpdate();
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)6))).setInt((Integer)this.jdbcMock.indexCaptor.capture(), (Integer)this.jdbcMock.valueCaptor.capture());
        PairSetList<Integer, Integer> expectedPairs = new PairSetList<Integer, Integer>().newRow(1, 1).add(2, 2).add(3, 3).newRow(1, 4).add(2, 5).add(3, 6);
        DeleteExecutorTest.assertCapturedPairsEqual(this.jdbcMock, expectedPairs);
    }

    @Test
    void deleteById_composedId_multiple_lastBlockContainsOneValue() throws Exception {
        DMLExecutorTest.PersistenceConfiguration persistenceConfiguration = DeleteExecutorTest.giveIdAsItselfPersistenceConfiguration();
        DMLGenerator dmlGenerator = new DMLGenerator((ParameterBinderIndex)this.dialect.getColumnBinderRegistry(), (Sorter)new DMLGenerator.CaseSensitiveSorter(), DMLNameProvider::new);
        DeleteExecutor testInstance = new DeleteExecutor(persistenceConfiguration.classMappingStrategy, (ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport(this.jdbcMock.transactionManager, 3), dmlGenerator, this.noRowCountCheckWriteOperationFactory, 3);
        testInstance.deleteById((Iterable)Arrays.asList((Object[])new DMLExecutorTest.Toto[]{new DMLExecutorTest.Toto(1, 17, 23), new DMLExecutorTest.Toto(2, 29, 31), new DMLExecutorTest.Toto(3, 37, 41), new DMLExecutorTest.Toto(4, 43, 53)}));
        Assertions.assertThat((List)this.jdbcMock.sqlCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"delete from Toto where (a, b) in ((?, ?), (?, ?), (?, ?))", "delete from Toto where (a, b) in ((?, ?))"}));
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)1))).addBatch();
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)1))).executeLargeBatch();
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)1))).executeLargeUpdate();
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)8))).setInt((Integer)this.jdbcMock.indexCaptor.capture(), (Integer)this.jdbcMock.valueCaptor.capture());
        List<Duo<Integer, Integer>> actualValuePairs = DeleteExecutorTest.arrangeValues(this.jdbcMock.indexCaptor.getAllValues(), this.jdbcMock.valueCaptor.getAllValues(), testInstance.getBatchSize());
        Assertions.assertThat(actualValuePairs).containsExactlyInAnyOrder((Object[])new Duo[]{new Duo((Object)1, (Object)17), new Duo((Object)2, (Object)29), new Duo((Object)3, (Object)37), new Duo((Object)4, (Object)43)});
    }

    @Test
    void deleteById_composedId_multiple_lastBlockContainsMultipleValue() throws Exception {
        DMLExecutorTest.PersistenceConfiguration persistenceConfiguration = DeleteExecutorTest.giveIdAsItselfPersistenceConfiguration();
        DMLGenerator dmlGenerator = new DMLGenerator((ParameterBinderIndex)this.dialect.getColumnBinderRegistry(), (Sorter)new DMLGenerator.CaseSensitiveSorter(), DMLNameProvider::new);
        DeleteExecutor testInstance = new DeleteExecutor(persistenceConfiguration.classMappingStrategy, (ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport(this.jdbcMock.transactionManager, 3), dmlGenerator, this.noRowCountCheckWriteOperationFactory, 3);
        testInstance.deleteById((Iterable)Arrays.asList((Object[])new DMLExecutorTest.Toto[]{new DMLExecutorTest.Toto(1, 17, 23), new DMLExecutorTest.Toto(2, 29, 31), new DMLExecutorTest.Toto(3, 37, 41), new DMLExecutorTest.Toto(4, 43, 53), new DMLExecutorTest.Toto(5, 59, 61)}));
        Assertions.assertThat((List)this.jdbcMock.sqlCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"delete from Toto where (a, b) in ((?, ?), (?, ?), (?, ?))", "delete from Toto where (a, b) in ((?, ?), (?, ?))"}));
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)1))).addBatch();
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)1))).executeLargeBatch();
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)1))).executeLargeUpdate();
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)10))).setInt((Integer)this.jdbcMock.indexCaptor.capture(), (Integer)this.jdbcMock.valueCaptor.capture());
        System.out.println(this.jdbcMock.indexCaptor.getAllValues());
        System.out.println(this.jdbcMock.valueCaptor.getAllValues());
        List<Duo<Integer, Integer>> actualValuePairs = DeleteExecutorTest.arrangeValues(this.jdbcMock.indexCaptor.getAllValues(), this.jdbcMock.valueCaptor.getAllValues(), testInstance.getBatchSize());
        System.out.println("actualValuePairs : " + actualValuePairs);
        Assertions.assertThat(actualValuePairs).containsExactlyInAnyOrder((Object[])new Duo[]{new Duo((Object)1, (Object)17), new Duo((Object)2, (Object)29), new Duo((Object)3, (Object)37), new Duo((Object)4, (Object)43), new Duo((Object)5, (Object)59)});
    }

    @Test
    void deleteById_composedId_multiple_lastBlockSizeIsInOperatorSize() throws Exception {
        DMLExecutorTest.PersistenceConfiguration persistenceConfiguration = DeleteExecutorTest.giveIdAsItselfPersistenceConfiguration();
        DMLGenerator dmlGenerator = new DMLGenerator((ParameterBinderIndex)this.dialect.getColumnBinderRegistry(), (Sorter)new DMLGenerator.CaseSensitiveSorter(), DMLNameProvider::new);
        DeleteExecutor testInstance = new DeleteExecutor(persistenceConfiguration.classMappingStrategy, (ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport(this.jdbcMock.transactionManager, 3), dmlGenerator, this.noRowCountCheckWriteOperationFactory, 3);
        testInstance.deleteById((Iterable)Arrays.asList((Object[])new DMLExecutorTest.Toto[]{new DMLExecutorTest.Toto(1, 17, 23), new DMLExecutorTest.Toto(2, 29, 31), new DMLExecutorTest.Toto(3, 37, 41), new DMLExecutorTest.Toto(4, 43, 53), new DMLExecutorTest.Toto(5, 59, 61), new DMLExecutorTest.Toto(6, 67, 71)}));
        Assertions.assertThat((List)this.jdbcMock.sqlCaptor.getAllValues()).isEqualTo((Object)Arrays.asList((Object[])new String[]{"delete from Toto where (a, b) in ((?, ?), (?, ?), (?, ?))"}));
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)2))).addBatch();
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)1))).executeLargeBatch();
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)0))).executeLargeUpdate();
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)12))).setInt((Integer)this.jdbcMock.indexCaptor.capture(), (Integer)this.jdbcMock.valueCaptor.capture());
        List<Duo<Integer, Integer>> actualValuePairs = DeleteExecutorTest.arrangeValues(this.jdbcMock.indexCaptor.getAllValues(), this.jdbcMock.valueCaptor.getAllValues(), testInstance.getBatchSize());
        Assertions.assertThat(actualValuePairs).containsExactlyInAnyOrder((Object[])new Duo[]{new Duo((Object)1, (Object)17), new Duo((Object)2, (Object)29), new Duo((Object)3, (Object)37), new Duo((Object)4, (Object)43), new Duo((Object)5, (Object)59), new Duo((Object)6, (Object)67)});
    }

    static List<Duo<Integer, Integer>> arrangeValues(List<Integer> capturedIndexes, List<Integer> capturedValues, int batchSize) {
        Object[] result = new Duo[capturedIndexes.size() / 2];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new Duo();
        }
        int colCount = 2;
        for (int i = 0; i < capturedIndexes.size(); ++i) {
            int index = capturedIndexes.get(i);
            int value = capturedValues.get(i);
            int currentBlockNumber = batchSize * (i / (batchSize * colCount));
            int duoNumber = (int)Math.ceil((double)index / (double)colCount) + currentBlockNumber;
            if (index % 2 == 0) {
                result[duoNumber - 1].setRight((Object)value);
                continue;
            }
            result[duoNumber - 1].setLeft((Object)value);
        }
        return Arrays.asList((Object[])result);
    }
}

