/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.ddl;

import java.util.Collections;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.sql.DMLNameProviderFactory;
import org.codefilarete.stalactite.sql.ddl.structure.Sequence;
import org.codefilarete.tool.StringAppender;

public class DDLSequenceGenerator {
    protected final DMLNameProvider dmlNameProvider;

    public DDLSequenceGenerator(DMLNameProviderFactory dmlNameProvider) {
        this.dmlNameProvider = dmlNameProvider.build(Collections.emptyMap());
    }

    public DDLSequenceGenerator(DMLNameProvider dmlNameProvider) {
        this.dmlNameProvider = dmlNameProvider;
    }

    public String generateCreateSequence(Sequence sequence) {
        StringAppender sqlCreateTable = new StringAppender(new Object[]{"create sequence ", sequence.getAbsoluteName()});
        sqlCreateTable.catIf(sequence.getInitialValue() != null, new Object[]{" start with ", sequence.getInitialValue()});
        sqlCreateTable.catIf(sequence.getBatchSize() != null, new Object[]{" increment by ", sequence.getBatchSize()});
        return sqlCreateTable.toString();
    }

    public String generateDropSequence(Sequence sequence) {
        return "drop sequence " + sequence.getAbsoluteName();
    }
}

