/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.codefilarete.stalactite.mapping.id.sequence.DatabaseSequenceSelector;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.DMLNameProviderFactory;
import org.codefilarete.stalactite.sql.DatabaseSequenceSelectorFactory;
import org.codefilarete.stalactite.sql.DefaultDialect;
import org.codefilarete.stalactite.sql.ddl.HSQLDBDDLTableGenerator;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;
import org.codefilarete.stalactite.sql.ddl.structure.Sequence;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.HSQLDBWriteOperation;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.WriteOperation;
import org.codefilarete.stalactite.sql.statement.WriteOperationFactory;
import org.codefilarete.stalactite.sql.statement.binder.HSQLDBParameterBinderRegistry;
import org.codefilarete.stalactite.sql.statement.binder.HSQLDBTypeMapping;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinderRegistry;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.function.ThrowingBiFunction;

public class HSQLDBDialect
extends DefaultDialect {
    private final HSQLDBSequenceSelectorFactory sequenceSelectorFactory = new HSQLDBSequenceSelectorFactory();

    public HSQLDBDialect() {
        super((JavaTypeToSqlTypeMapping)new HSQLDBTypeMapping(), (ParameterBinderRegistry)new HSQLDBParameterBinderRegistry());
    }

    protected DMLNameProviderFactory newDMLNameProviderFactory() {
        return HSQLDBDMLNameProvider::new;
    }

    protected HSQLDBDDLTableGenerator newDdlTableGenerator() {
        return new HSQLDBDDLTableGenerator(this.getSqlTypeRegistry(), HSQLDBDMLNameProvider::new);
    }

    protected WriteOperationFactory newWriteOperationFactory() {
        return new HSQLDBWriteOperationFactory();
    }

    public DatabaseSequenceSelectorFactory getDatabaseSequenceSelectorFactory() {
        return this.sequenceSelectorFactory;
    }

    public boolean supportsTupleCondition() {
        return true;
    }

    private class HSQLDBSequenceSelectorFactory
    implements DatabaseSequenceSelectorFactory {
        private HSQLDBSequenceSelectorFactory() {
        }

        public DatabaseSequenceSelector create(Sequence databaseSequence, ConnectionProvider connectionProvider) {
            return new DatabaseSequenceSelector(databaseSequence, "CALL NEXT VALUE FOR " + databaseSequence.getAbsoluteName(), HSQLDBDialect.this.getReadOperationFactory(), connectionProvider);
        }
    }

    public static class HSQLDBDMLNameProvider
    extends DMLNameProvider {
        public static final Set<String> KEYWORDS = Collections.unmodifiableSet(Arrays.asTreeSet((Comparator)String.CASE_INSENSITIVE_ORDER, (Object[])new String[0]));

        public HSQLDBDMLNameProvider(Function<Fromable, String> tableAliaser) {
            super(tableAliaser);
        }

        public HSQLDBDMLNameProvider(Map<Table, String> tableAliases) {
            super(tableAliases);
        }

        public String getSimpleName(Selectable<?> column) {
            if (KEYWORDS.contains(column.getExpression())) {
                return "`" + column.getExpression() + "`";
            }
            return super.getSimpleName(column);
        }

        public String getName(Fromable table) {
            if (KEYWORDS.contains(table.getName())) {
                return "`" + super.getName(table) + "`";
            }
            return super.getName(table);
        }
    }

    static class HSQLDBWriteOperationFactory
    extends WriteOperationFactory {
        HSQLDBWriteOperationFactory() {
        }

        protected <ParamType> WriteOperation<ParamType> createInstance(SQLStatement<ParamType> sqlGenerator, ConnectionProvider connectionProvider, final ThrowingBiFunction<Connection, String, PreparedStatement, SQLException> statementProvider, WriteOperation.RowCountListener rowCountListener) {
            return new HSQLDBWriteOperation<ParamType>(sqlGenerator, connectionProvider, rowCountListener){

                protected void prepareStatement(Connection connection) throws SQLException {
                    this.preparedStatement = (PreparedStatement)statementProvider.apply((Object)connection, (Object)this.getSQL());
                }
            };
        }
    }
}

