/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.engine.runtime.DMLExecutorTest;
import org.codefilarete.stalactite.engine.runtime.SelectExecutor;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.DefaultDialect;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.SimpleConnectionProvider;
import org.codefilarete.stalactite.sql.ddl.DDLDeployer;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.DMLGenerator;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinderIndex;
import org.codefilarete.stalactite.sql.test.DatabaseIntegrationTest;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.Sorter;
import org.junit.jupiter.api.Test;

abstract class SelectExecutorITTest<T extends Table<T>>
extends DatabaseIntegrationTest {
    private final Dialect dialect = new DefaultDialect(new JavaTypeToSqlTypeMapping().with(Integer.class, "int"));

    SelectExecutorITTest() {
    }

    @Test
    void select() throws SQLException {
        DMLExecutorTest.PersistenceConfiguration persistenceConfiguration = DMLExecutorTest.giveDefaultPersistenceConfiguration();
        DMLGenerator dmlGenerator = new DMLGenerator((ParameterBinderIndex)this.dialect.getColumnBinderRegistry(), (Sorter)new DMLGenerator.CaseSensitiveSorter(), DMLNameProvider::new);
        Connection connection = this.connectionProvider.giveConnection();
        SimpleConnectionProvider connectionProvider = new SimpleConnectionProvider(connection);
        DDLDeployer ddlDeployer = new DDLDeployer(this.dialect.getDdlTableGenerator(), this.dialect.getDdlSequenceGenerator(), (ConnectionProvider)connectionProvider);
        ddlDeployer.getDdlGenerator().addTables(persistenceConfiguration.classMappingStrategy.getTargetTable(), new Table[0]);
        ddlDeployer.deployDDL();
        connection.prepareStatement("insert into Toto(a, b, c) values (1, 10, 100)").execute();
        connection.prepareStatement("insert into Toto(a, b, c) values (2, 20, 200)").execute();
        connection.prepareStatement("insert into Toto(a, b, c) values (3, 30, 300)").execute();
        connection.prepareStatement("insert into Toto(a, b, c) values (4, 40, 400)").execute();
        SelectExecutor testInstance = new SelectExecutor(persistenceConfiguration.classMappingStrategy, (ConnectionProvider)connectionProvider, dmlGenerator, 3);
        Set totos = testInstance.select((Iterable)Arrays.asList((Object[])new Integer[]{1}));
        DMLExecutorTest.Toto t = (DMLExecutorTest.Toto)Iterables.first((Iterable)totos);
        Assertions.assertThat((Object)t.a).isEqualTo((Object)1);
        Assertions.assertThat((Object)t.b).isEqualTo((Object)10);
        Assertions.assertThat((Object)t.c).isEqualTo((Object)100);
        totos = testInstance.select((Iterable)Arrays.asList((Object[])new Integer[]{2, 3, 4}));
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)totos).usingRecursiveFieldByFieldElementComparator()).containsExactlyInAnyOrder((Object[])new DMLExecutorTest.Toto[]{new DMLExecutorTest.Toto(2, 20, 200), new DMLExecutorTest.Toto(3, 30, 300), new DMLExecutorTest.Toto(4, 40, 400)});
    }

    @Test
    void select_composedId_idIsItSelf() throws SQLException {
        DMLExecutorTest.PersistenceConfiguration persistenceConfiguration = DMLExecutorTest.giveIdAsItselfPersistenceConfiguration();
        DMLGenerator dmlGenerator = new DMLGenerator((ParameterBinderIndex)this.dialect.getColumnBinderRegistry(), (Sorter)new DMLGenerator.CaseSensitiveSorter(), DMLNameProvider::new);
        Connection connection = this.connectionProvider.giveConnection();
        SimpleConnectionProvider connectionProvider = new SimpleConnectionProvider(connection);
        DDLDeployer ddlDeployer = new DDLDeployer(this.dialect.getDdlTableGenerator(), this.dialect.getDdlSequenceGenerator(), (ConnectionProvider)connectionProvider);
        ddlDeployer.getDdlGenerator().addTables(persistenceConfiguration.classMappingStrategy.getTargetTable(), new Table[0]);
        ddlDeployer.deployDDL();
        connection.prepareStatement("insert into Toto(a, b, c) values (1, 10, 100)").execute();
        connection.prepareStatement("insert into Toto(a, b, c) values (2, 20, 200)").execute();
        connection.prepareStatement("insert into Toto(a, b, c) values (3, 30, 300)").execute();
        connection.prepareStatement("insert into Toto(a, b, c) values (4, 40, 400)").execute();
        SelectExecutor testInstance = new SelectExecutor(persistenceConfiguration.classMappingStrategy, (ConnectionProvider)connectionProvider, dmlGenerator, 3);
        Set result = testInstance.select((Iterable)Arrays.asList((Object[])new DMLExecutorTest.Toto[]{new DMLExecutorTest.Toto(1, 10, null), new DMLExecutorTest.Toto(2, 20, null), new DMLExecutorTest.Toto(3, 30, null), new DMLExecutorTest.Toto(4, 40, null)}));
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)result).usingRecursiveFieldByFieldElementComparator()).containsExactlyInAnyOrder((Object[])new DMLExecutorTest.Toto[]{new DMLExecutorTest.Toto(1, 10, 100), new DMLExecutorTest.Toto(2, 20, 200), new DMLExecutorTest.Toto(3, 30, 300), new DMLExecutorTest.Toto(4, 40, 400)});
    }

    @Test
    void select_composedId_idIsABean() throws SQLException {
        DMLExecutorTest.PersistenceConfiguration persistenceConfiguration = DMLExecutorTest.giveComposedIdPersistenceConfiguration();
        DMLGenerator dmlGenerator = new DMLGenerator((ParameterBinderIndex)this.dialect.getColumnBinderRegistry(), (Sorter)new DMLGenerator.CaseSensitiveSorter(), DMLNameProvider::new);
        Connection connection = this.connectionProvider.giveConnection();
        SimpleConnectionProvider connectionProvider = new SimpleConnectionProvider(connection);
        DDLDeployer ddlDeployer = new DDLDeployer(this.dialect.getDdlTableGenerator(), this.dialect.getDdlSequenceGenerator(), (ConnectionProvider)connectionProvider);
        ddlDeployer.getDdlGenerator().addTables(persistenceConfiguration.classMappingStrategy.getTargetTable(), new Table[0]);
        ddlDeployer.deployDDL();
        connection.prepareStatement("insert into Tata(a, b, c) values (1, 10, 100)").execute();
        connection.prepareStatement("insert into Tata(a, b, c) values (2, 20, 200)").execute();
        connection.prepareStatement("insert into Tata(a, b, c) values (3, 30, 300)").execute();
        connection.prepareStatement("insert into Tata(a, b, c) values (4, 40, 400)").execute();
        SelectExecutor testInstance = new SelectExecutor(persistenceConfiguration.classMappingStrategy, (ConnectionProvider)connectionProvider, dmlGenerator, 3);
        Set result = testInstance.select((Iterable)Arrays.asList((Object[])new DMLExecutorTest.ComposedId[]{new DMLExecutorTest.ComposedId(1, 10), new DMLExecutorTest.ComposedId(2, 20), new DMLExecutorTest.ComposedId(3, 30), new DMLExecutorTest.ComposedId(4, 40)}));
        HashSet expectedResult = Arrays.asHashSet((Object[])new DMLExecutorTest.Tata[]{new DMLExecutorTest.Tata(1, 10, 100), new DMLExecutorTest.Tata(2, 20, 200), new DMLExecutorTest.Tata(3, 30, 300), new DMLExecutorTest.Tata(4, 40, 400)});
        Assertions.assertThat(new HashSet(result)).isEqualTo((Object)expectedResult);
    }
}

