/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.codefilarete.reflection.AccessorByField;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.stalactite.engine.CurrentThreadTransactionalConnectionProvider;
import org.codefilarete.stalactite.engine.PersisterITTest;
import org.codefilarete.stalactite.engine.listener.DeleteByIdListener;
import org.codefilarete.stalactite.engine.listener.DeleteListener;
import org.codefilarete.stalactite.engine.listener.InsertListener;
import org.codefilarete.stalactite.engine.listener.PersistListener;
import org.codefilarete.stalactite.engine.listener.SelectListener;
import org.codefilarete.stalactite.engine.listener.UpdateByIdListener;
import org.codefilarete.stalactite.engine.listener.UpdateListener;
import org.codefilarete.stalactite.engine.runtime.BeanPersister;
import org.codefilarete.stalactite.mapping.ClassMapping;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.mapping.id.manager.AlreadyAssignedIdentifierManager;
import org.codefilarete.stalactite.mapping.id.manager.IdentifierInsertionManager;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.DefaultDialect;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.Maps;
import org.codefilarete.tool.function.Hanger;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class BeanPersisterTest {
    BeanPersisterTest() {
    }

    @Test
    void constructor_mustIncludeIdMappingListener() {
        PersisterITTest.TotoTable totoTable = new PersisterITTest.TotoTable("TotoTable");
        Column primaryKey = totoTable.addColumn("a", Long.class).primaryKey();
        AccessorByField identifier = Accessors.accessorByField(PersisterITTest.Toto.class, (String)"a");
        Maps.ChainingMap mapping = Maps.asMap((Object)identifier, (Object)primaryKey);
        IdentifierInsertionManager identifierInsertionManagerMock = (IdentifierInsertionManager)Mockito.mock(IdentifierInsertionManager.class);
        Mockito.when((Object)identifierInsertionManagerMock.getIdentifierType()).thenReturn(Long.class);
        InsertListener identifierManagerInsertListenerMock = (InsertListener)Mockito.mock(InsertListener.class);
        Mockito.when((Object)identifierInsertionManagerMock.getInsertListener()).thenReturn((Object)identifierManagerInsertListenerMock);
        ClassMapping classMappingStrategy = new ClassMapping(PersisterITTest.Toto.class, (Table)totoTable, (Map)mapping, (ReversibleAccessor)identifier, identifierInsertionManagerMock);
        BeanPersister<PersisterITTest.Toto, Long, PersisterITTest.TotoTable> testInstance = new BeanPersister<PersisterITTest.Toto, Long, PersisterITTest.TotoTable>((EntityMapping)classMappingStrategy, (Dialect)new DefaultDialect(), (ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport((ConnectionProvider)Mockito.mock(CurrentThreadTransactionalConnectionProvider.class), 0)){

            protected void doInsert(Iterable entities) {
            }

            protected void doUpdateById(Iterable<? extends PersisterITTest.Toto> entities) {
            }
        };
        PersisterITTest.Toto toto = new PersisterITTest.Toto();
        testInstance.insert((Object)toto);
        ((InsertListener)Mockito.verify((Object)identifierManagerInsertListenerMock)).afterInsert((Iterable)ArgumentMatchers.eq((Object)Arrays.asList((Object[])new PersisterITTest.Toto[]{toto})));
    }

    @Test
    void persist() {
        PersisterITTest.TotoTable totoTable = new PersisterITTest.TotoTable("TotoTable");
        Column primaryKey = totoTable.addColumn("a", Integer.class).primaryKey();
        AccessorByField identifier = Accessors.accessorByField(PersisterITTest.Toto.class, (String)"a");
        Maps.ChainingMap mapping = Maps.asMap((Object)identifier, (Object)primaryKey);
        IdentifierInsertionManager identifierInsertionManagerMock = (IdentifierInsertionManager)Mockito.mock(IdentifierInsertionManager.class);
        Mockito.when((Object)identifierInsertionManagerMock.getIdentifierType()).thenReturn(Integer.class);
        InsertListener identifierManagerInsertListenerMock = (InsertListener)Mockito.mock(InsertListener.class);
        Mockito.when((Object)identifierInsertionManagerMock.getInsertListener()).thenReturn((Object)identifierManagerInsertListenerMock);
        SelectListener identifierManagerSelectListenerMock = (SelectListener)Mockito.mock(SelectListener.class);
        Mockito.when((Object)identifierInsertionManagerMock.getSelectListener()).thenReturn((Object)identifierManagerSelectListenerMock);
        ClassMapping classMappingStrategy = new ClassMapping(PersisterITTest.Toto.class, (Table)totoTable, (Map)mapping, (ReversibleAccessor)identifier, identifierInsertionManagerMock);
        final Hanger.Holder mockedSelectAnswer = new Hanger.Holder();
        BeanPersister<PersisterITTest.Toto, Integer, PersisterITTest.TotoTable> testInstance = new BeanPersister<PersisterITTest.Toto, Integer, PersisterITTest.TotoTable>((EntityMapping)classMappingStrategy, (Dialect)new DefaultDialect(), (ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport((ConnectionProvider)Mockito.mock(CurrentThreadTransactionalConnectionProvider.class), 0)){

            protected void doInsert(Iterable entities) {
            }

            protected void doUpdate(Iterable<? extends Duo<PersisterITTest.Toto, PersisterITTest.Toto>> entities, boolean allColumnsStatement) {
            }

            protected Set<PersisterITTest.Toto> doSelect(Iterable<Integer> ids) {
                return (Set)Iterables.collect(ids, id -> (PersisterITTest.Toto)mockedSelectAnswer.get(), HashSet::new);
            }
        };
        PersistListener persistListener = (PersistListener)Mockito.mock(PersistListener.class);
        testInstance.getPersisterListener().addPersistListener(persistListener);
        InsertListener insertListener = (InsertListener)Mockito.mock(InsertListener.class);
        testInstance.getPersisterListener().addInsertListener(insertListener);
        UpdateListener updateListener = (UpdateListener)Mockito.mock(UpdateListener.class);
        testInstance.getPersisterListener().addUpdateListener(updateListener);
        testInstance.persist((Iterable)Arrays.asList((Object[])new PersisterITTest.Toto[0]));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{persistListener});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{insertListener});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{updateListener});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{identifierManagerInsertListenerMock});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{identifierManagerSelectListenerMock});
        PersisterITTest.Toto unPersisted = new PersisterITTest.Toto();
        PersisterITTest.Toto persisted = new PersisterITTest.Toto(1, 2, 3);
        mockedSelectAnswer.set((Object)persisted);
        testInstance.persist((Object)unPersisted);
        ((PersistListener)Mockito.verify((Object)persistListener)).beforePersist((Iterable)ArgumentMatchers.eq((Object)Arrays.asSet((Object[])new PersisterITTest.Toto[]{unPersisted})));
        ((PersistListener)Mockito.verify((Object)persistListener)).afterPersist((Iterable)ArgumentMatchers.eq((Object)Arrays.asSet((Object[])new PersisterITTest.Toto[]{unPersisted})));
        ((InsertListener)Mockito.verify((Object)insertListener)).beforeInsert((Iterable)ArgumentMatchers.eq((Object)Arrays.asList((Object[])new PersisterITTest.Toto[]{unPersisted})));
        ((InsertListener)Mockito.verify((Object)insertListener)).afterInsert((Iterable)ArgumentMatchers.eq((Object)Arrays.asList((Object[])new PersisterITTest.Toto[]{unPersisted})));
        ((InsertListener)Mockito.verify((Object)identifierManagerInsertListenerMock)).beforeInsert((Iterable)ArgumentMatchers.eq((Object)Arrays.asList((Object[])new PersisterITTest.Toto[]{unPersisted})));
        ((InsertListener)Mockito.verify((Object)identifierManagerInsertListenerMock)).afterInsert((Iterable)ArgumentMatchers.eq((Object)Arrays.asList((Object[])new PersisterITTest.Toto[]{unPersisted})));
        ((SelectListener)Mockito.verify((Object)identifierManagerSelectListenerMock, (VerificationMode)Mockito.never())).beforeSelect(ArgumentMatchers.anyIterable());
        ((SelectListener)Mockito.verify((Object)identifierManagerSelectListenerMock, (VerificationMode)Mockito.never())).afterSelect(Mockito.anySet());
        testInstance.persist((Object)persisted);
        ArgumentCaptor updateArgCaptor = ArgumentCaptor.forClass(Iterable.class);
        ((UpdateListener)Mockito.verify((Object)updateListener)).beforeUpdate((Iterable)updateArgCaptor.capture(), ArgumentMatchers.eq((boolean)true));
        Assertions.assertThat((Iterable)((Iterable)updateArgCaptor.getValue())).containsExactly((Object[])new Duo[]{new Duo((Object)persisted, (Object)persisted)});
        ((UpdateListener)Mockito.verify((Object)updateListener)).afterUpdate((Iterable)updateArgCaptor.capture(), ArgumentMatchers.eq((boolean)true));
        Assertions.assertThat((Iterable)((Iterable)updateArgCaptor.getValue())).containsExactly((Object[])new Duo[]{new Duo((Object)persisted, (Object)persisted)});
        Mockito.clearInvocations((Object[])new Object[]{insertListener, identifierManagerInsertListenerMock, updateListener, identifierManagerSelectListenerMock});
        PersisterITTest.Toto totoInDatabase = new PersisterITTest.Toto(1, 2, 3);
        mockedSelectAnswer.set((Object)totoInDatabase);
        PersisterITTest.Toto totoModifiedFromDatabase = new PersisterITTest.Toto(1, 2, 4);
        testInstance.persist((Iterable)Arrays.asList((Object[])new PersisterITTest.Toto[]{unPersisted, totoModifiedFromDatabase}));
        ((InsertListener)Mockito.verify((Object)insertListener)).beforeInsert((Iterable)ArgumentMatchers.eq((Object)Arrays.asList((Object[])new PersisterITTest.Toto[]{unPersisted})));
        ((InsertListener)Mockito.verify((Object)insertListener)).afterInsert((Iterable)ArgumentMatchers.eq((Object)Arrays.asList((Object[])new PersisterITTest.Toto[]{unPersisted})));
        ((InsertListener)Mockito.verify((Object)identifierManagerInsertListenerMock)).beforeInsert((Iterable)ArgumentMatchers.eq((Object)Arrays.asList((Object[])new PersisterITTest.Toto[]{unPersisted})));
        ((InsertListener)Mockito.verify((Object)identifierManagerInsertListenerMock)).afterInsert((Iterable)ArgumentMatchers.eq((Object)Arrays.asList((Object[])new PersisterITTest.Toto[]{unPersisted})));
        ((SelectListener)Mockito.verify((Object)identifierManagerSelectListenerMock)).beforeSelect((Iterable)ArgumentMatchers.eq((Object)Arrays.asHashSet((Object[])new Integer[]{1})));
        ((SelectListener)Mockito.verify((Object)identifierManagerSelectListenerMock)).afterSelect((Set)ArgumentMatchers.eq((Object)Arrays.asHashSet((Object[])new PersisterITTest.Toto[]{totoInDatabase})));
        ((UpdateListener)Mockito.verify((Object)updateListener)).beforeUpdate((Iterable)updateArgCaptor.capture(), ArgumentMatchers.eq((boolean)true));
        Assertions.assertThat((Iterable)((Iterable)updateArgCaptor.getValue())).containsExactly((Object[])new Duo[]{new Duo((Object)totoModifiedFromDatabase, (Object)totoInDatabase)});
        ((UpdateListener)Mockito.verify((Object)updateListener)).afterUpdate((Iterable)updateArgCaptor.capture(), ArgumentMatchers.eq((boolean)true));
        Assertions.assertThat((Iterable)((Iterable)updateArgCaptor.getValue())).containsExactly((Object[])new Duo[]{new Duo((Object)totoModifiedFromDatabase, (Object)totoInDatabase)});
    }

    @Test
    void insert() {
        PersisterITTest.TotoTable totoTable = new PersisterITTest.TotoTable("TotoTable");
        Column primaryKey = totoTable.addColumn("a", Long.class).primaryKey();
        AccessorByField identifier = Accessors.accessorByField(PersisterITTest.Toto.class, (String)"a");
        Maps.ChainingMap mapping = Maps.asMap((Object)identifier, (Object)primaryKey);
        IdentifierInsertionManager identifierInsertionManagerMock = (IdentifierInsertionManager)Mockito.mock(IdentifierInsertionManager.class);
        Mockito.when((Object)identifierInsertionManagerMock.getIdentifierType()).thenReturn(Long.class);
        InsertListener identifierManagerInsertListenerMock = (InsertListener)Mockito.mock(InsertListener.class);
        Mockito.when((Object)identifierInsertionManagerMock.getInsertListener()).thenReturn((Object)identifierManagerInsertListenerMock);
        ClassMapping classMappingStrategy = new ClassMapping(PersisterITTest.Toto.class, (Table)totoTable, (Map)mapping, (ReversibleAccessor)identifier, identifierInsertionManagerMock);
        BeanPersister<PersisterITTest.Toto, Long, PersisterITTest.TotoTable> testInstance = new BeanPersister<PersisterITTest.Toto, Long, PersisterITTest.TotoTable>((EntityMapping)classMappingStrategy, (Dialect)new DefaultDialect(), (ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport((ConnectionProvider)Mockito.mock(CurrentThreadTransactionalConnectionProvider.class), 0)){

            protected void doInsert(Iterable entities) {
            }
        };
        InsertListener insertListener = (InsertListener)Mockito.mock(InsertListener.class);
        testInstance.getPersisterListener().addInsertListener(insertListener);
        testInstance.insert((Iterable)Arrays.asList((Object[])new PersisterITTest.Toto[0]));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{insertListener});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{identifierManagerInsertListenerMock});
        PersisterITTest.Toto toBeInserted = new PersisterITTest.Toto(1, 2, 3);
        testInstance.insert((Object)toBeInserted);
        ((InsertListener)Mockito.verify((Object)insertListener)).beforeInsert((Iterable)ArgumentMatchers.eq((Object)Arrays.asList((Object[])new PersisterITTest.Toto[]{toBeInserted})));
        ((InsertListener)Mockito.verify((Object)insertListener)).afterInsert((Iterable)ArgumentMatchers.eq((Object)Arrays.asList((Object[])new PersisterITTest.Toto[]{toBeInserted})));
        ((InsertListener)Mockito.verify((Object)identifierManagerInsertListenerMock)).beforeInsert((Iterable)ArgumentMatchers.eq((Object)Arrays.asList((Object[])new PersisterITTest.Toto[]{toBeInserted})));
        ((InsertListener)Mockito.verify((Object)identifierManagerInsertListenerMock)).afterInsert((Iterable)ArgumentMatchers.eq((Object)Arrays.asList((Object[])new PersisterITTest.Toto[]{toBeInserted})));
    }

    @Test
    void update() {
        PersisterITTest.TotoTable totoTable = new PersisterITTest.TotoTable("TotoTable");
        Column primaryKey = totoTable.addColumn("a", Long.class).primaryKey();
        Column columnB = totoTable.addColumn("b", Long.class);
        AccessorByField identifier = Accessors.accessorByField(PersisterITTest.Toto.class, (String)"a");
        AccessorByField propB = Accessors.accessorByField(PersisterITTest.Toto.class, (String)"b");
        Maps.ChainingMap mapping = Maps.asMap((Object)identifier, (Object)primaryKey).add((Object)propB, (Object)columnB);
        ClassMapping classMappingStrategy = new ClassMapping(PersisterITTest.Toto.class, (Table)totoTable, (Map)mapping, (ReversibleAccessor)identifier, (IdentifierInsertionManager)new AlreadyAssignedIdentifierManager(Long.class, c -> {}, c -> false));
        BeanPersister<PersisterITTest.Toto, Long, PersisterITTest.TotoTable> testInstance = new BeanPersister<PersisterITTest.Toto, Long, PersisterITTest.TotoTable>((EntityMapping)classMappingStrategy, (Dialect)new DefaultDialect(), (ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport((ConnectionProvider)Mockito.mock(CurrentThreadTransactionalConnectionProvider.class), 0)){

            protected void doUpdate(Iterable<? extends Duo<PersisterITTest.Toto, PersisterITTest.Toto>> entities, boolean allColumnsStatement) {
            }
        };
        UpdateListener updateListener = (UpdateListener)Mockito.mock(UpdateListener.class);
        testInstance.getPersisterListener().addUpdateListener(updateListener);
        testInstance.update((Iterable)Arrays.asList((Object[])new Duo[0]), false);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{updateListener});
        testInstance.update((Iterable)Arrays.asList((Object[])new Duo[0]), true);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{updateListener});
        PersisterITTest.Toto original = new PersisterITTest.Toto(1, 2, 3);
        PersisterITTest.Toto modified = new PersisterITTest.Toto(1, -2, -3);
        testInstance.update((Object)modified, (Object)original, false);
        Duo expectedPayload = new Duo((Object)modified, (Object)original);
        ArgumentCaptor listenerArgumentCaptor = ArgumentCaptor.forClass(Iterable.class);
        ((UpdateListener)Mockito.verify((Object)updateListener)).beforeUpdate((Iterable)listenerArgumentCaptor.capture(), ArgumentMatchers.eq((boolean)false));
        Assertions.assertThat((Object)Iterables.first((Iterable)((Iterable)listenerArgumentCaptor.getValue()))).isEqualTo((Object)expectedPayload);
        ((UpdateListener)Mockito.verify((Object)updateListener)).afterUpdate((Iterable)listenerArgumentCaptor.capture(), ArgumentMatchers.eq((boolean)false));
        Assertions.assertThat((Object)Iterables.first((Iterable)((Iterable)listenerArgumentCaptor.getValue()))).isEqualTo((Object)expectedPayload);
    }

    @Test
    void updateById() {
        PersisterITTest.TotoTable totoTable = new PersisterITTest.TotoTable("TotoTable");
        Column primaryKey = totoTable.addColumn("a", Long.class).primaryKey();
        Column columnB = totoTable.addColumn("b", Long.class);
        AccessorByField identifier = Accessors.accessorByField(PersisterITTest.Toto.class, (String)"a");
        AccessorByField propB = Accessors.accessorByField(PersisterITTest.Toto.class, (String)"b");
        Maps.ChainingMap mapping = Maps.asMap((Object)identifier, (Object)primaryKey).add((Object)propB, (Object)columnB);
        ClassMapping classMappingStrategy = new ClassMapping(PersisterITTest.Toto.class, (Table)totoTable, (Map)mapping, (ReversibleAccessor)identifier, (IdentifierInsertionManager)new AlreadyAssignedIdentifierManager(Long.class, c -> {}, c -> false));
        BeanPersister<PersisterITTest.Toto, Long, PersisterITTest.TotoTable> testInstance = new BeanPersister<PersisterITTest.Toto, Long, PersisterITTest.TotoTable>((EntityMapping)classMappingStrategy, (Dialect)new DefaultDialect(), (ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport((ConnectionProvider)Mockito.mock(CurrentThreadTransactionalConnectionProvider.class), 0)){

            protected void doUpdateById(Iterable<? extends PersisterITTest.Toto> entities) {
            }
        };
        UpdateByIdListener updateListener = (UpdateByIdListener)Mockito.mock(UpdateByIdListener.class);
        testInstance.getPersisterListener().addUpdateByIdListener(updateListener);
        testInstance.updateById((Iterable)Arrays.asList((Object[])new PersisterITTest.Toto[0]));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{updateListener});
        testInstance.updateById((Iterable)Arrays.asList((Object[])new PersisterITTest.Toto[0]));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{updateListener});
        PersisterITTest.Toto toBeUpdated = new PersisterITTest.Toto(1, 2, 3);
        testInstance.updateById((Object)toBeUpdated);
        ((UpdateByIdListener)Mockito.verify((Object)updateListener)).beforeUpdateById((Iterable)Arrays.asList((Object[])new PersisterITTest.Toto[]{toBeUpdated}));
        ((UpdateByIdListener)Mockito.verify((Object)updateListener)).afterUpdateById((Iterable)Arrays.asList((Object[])new PersisterITTest.Toto[]{toBeUpdated}));
    }

    @Test
    void delete() {
        PersisterITTest.TotoTable totoTable = new PersisterITTest.TotoTable("TotoTable");
        Column primaryKey = totoTable.addColumn("a", Long.class).primaryKey();
        Column columnB = totoTable.addColumn("b", Long.class);
        AccessorByField identifier = Accessors.accessorByField(PersisterITTest.Toto.class, (String)"a");
        AccessorByField propB = Accessors.accessorByField(PersisterITTest.Toto.class, (String)"b");
        Maps.ChainingMap mapping = Maps.asMap((Object)identifier, (Object)primaryKey).add((Object)propB, (Object)columnB);
        ClassMapping classMappingStrategy = new ClassMapping(PersisterITTest.Toto.class, (Table)totoTable, (Map)mapping, (ReversibleAccessor)identifier, (IdentifierInsertionManager)new AlreadyAssignedIdentifierManager(Long.class, c -> {}, c -> false));
        BeanPersister<PersisterITTest.Toto, Long, PersisterITTest.TotoTable> testInstance = new BeanPersister<PersisterITTest.Toto, Long, PersisterITTest.TotoTable>((EntityMapping)classMappingStrategy, (Dialect)new DefaultDialect(), (ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport((ConnectionProvider)Mockito.mock(CurrentThreadTransactionalConnectionProvider.class), 0)){

            protected void doDelete(Iterable<? extends PersisterITTest.Toto> entities) {
            }
        };
        DeleteListener deleteListener = (DeleteListener)Mockito.mock(DeleteListener.class);
        testInstance.getPersisterListener().addDeleteListener(deleteListener);
        testInstance.delete((Iterable)Arrays.asList((Object[])new PersisterITTest.Toto[0]));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{deleteListener});
        PersisterITTest.Toto toBeDeleted = new PersisterITTest.Toto(1, 2, 3);
        testInstance.delete((Object)toBeDeleted);
        ((DeleteListener)Mockito.verify((Object)deleteListener)).beforeDelete((Iterable)ArgumentMatchers.eq((Object)Arrays.asList((Object[])new PersisterITTest.Toto[]{toBeDeleted})));
        ((DeleteListener)Mockito.verify((Object)deleteListener)).afterDelete((Iterable)ArgumentMatchers.eq((Object)Arrays.asList((Object[])new PersisterITTest.Toto[]{toBeDeleted})));
    }

    @Test
    void deleteById() {
        PersisterITTest.TotoTable totoTable = new PersisterITTest.TotoTable("TotoTable");
        Column primaryKey = totoTable.addColumn("a", Long.class).primaryKey();
        Column columnB = totoTable.addColumn("b", Long.class);
        AccessorByField identifier = Accessors.accessorByField(PersisterITTest.Toto.class, (String)"a");
        AccessorByField propB = Accessors.accessorByField(PersisterITTest.Toto.class, (String)"b");
        Maps.ChainingMap mapping = Maps.asMap((Object)identifier, (Object)primaryKey).add((Object)propB, (Object)columnB);
        ClassMapping classMappingStrategy = new ClassMapping(PersisterITTest.Toto.class, (Table)totoTable, (Map)mapping, (ReversibleAccessor)identifier, (IdentifierInsertionManager)new AlreadyAssignedIdentifierManager(Long.class, c -> {}, c -> false));
        BeanPersister<PersisterITTest.Toto, Long, PersisterITTest.TotoTable> testInstance = new BeanPersister<PersisterITTest.Toto, Long, PersisterITTest.TotoTable>((EntityMapping)classMappingStrategy, (Dialect)new DefaultDialect(), (ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport((ConnectionProvider)Mockito.mock(CurrentThreadTransactionalConnectionProvider.class), 0)){

            protected void doDeleteById(Iterable<? extends PersisterITTest.Toto> entities) {
            }
        };
        DeleteByIdListener deleteListener = (DeleteByIdListener)Mockito.mock(DeleteByIdListener.class);
        testInstance.getPersisterListener().addDeleteByIdListener(deleteListener);
        testInstance.deleteById((Iterable)Arrays.asList((Object[])new PersisterITTest.Toto[0]));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{deleteListener});
        PersisterITTest.Toto toBeDeleted = new PersisterITTest.Toto(1, 2, 3);
        testInstance.deleteById((Object)toBeDeleted);
        ((DeleteByIdListener)Mockito.verify((Object)deleteListener)).beforeDeleteById((Iterable)ArgumentMatchers.eq((Object)Arrays.asList((Object[])new PersisterITTest.Toto[]{toBeDeleted})));
        ((DeleteByIdListener)Mockito.verify((Object)deleteListener)).afterDeleteById((Iterable)ArgumentMatchers.eq((Object)Arrays.asList((Object[])new PersisterITTest.Toto[]{toBeDeleted})));
    }

    @Test
    void select() {
        PersisterITTest.TotoTable totoTable = new PersisterITTest.TotoTable("TotoTable");
        Column primaryKey = totoTable.addColumn("a", Integer.class).primaryKey();
        AccessorByField identifier = Accessors.accessorByField(PersisterITTest.Toto.class, (String)"a");
        Maps.ChainingMap mapping = Maps.asMap((Object)identifier, (Object)primaryKey);
        IdentifierInsertionManager identifierInsertionManagerMock = (IdentifierInsertionManager)Mockito.mock(IdentifierInsertionManager.class);
        Mockito.when((Object)identifierInsertionManagerMock.getIdentifierType()).thenReturn(Integer.class);
        InsertListener identifierManagerInsertListenerMock = (InsertListener)Mockito.mock(InsertListener.class);
        Mockito.when((Object)identifierInsertionManagerMock.getInsertListener()).thenReturn((Object)identifierManagerInsertListenerMock);
        SelectListener identifierManagerSelectListenerMock = (SelectListener)Mockito.mock(SelectListener.class);
        Mockito.when((Object)identifierInsertionManagerMock.getSelectListener()).thenReturn((Object)identifierManagerSelectListenerMock);
        ClassMapping classMappingStrategy = new ClassMapping(PersisterITTest.Toto.class, (Table)totoTable, (Map)mapping, (ReversibleAccessor)identifier, identifierInsertionManagerMock);
        BeanPersister<PersisterITTest.Toto, Integer, PersisterITTest.TotoTable> testInstance = new BeanPersister<PersisterITTest.Toto, Integer, PersisterITTest.TotoTable>((EntityMapping)classMappingStrategy, (Dialect)new DefaultDialect(), (ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport((ConnectionProvider)Mockito.mock(CurrentThreadTransactionalConnectionProvider.class), 0)){

            protected void doInsert(Iterable entities) {
            }

            protected void doUpdate(Iterable<? extends Duo<PersisterITTest.Toto, PersisterITTest.Toto>> entities, boolean allColumnsStatement) {
            }

            protected Set<PersisterITTest.Toto> doSelect(Iterable<Integer> ids) {
                return (Set)Iterables.collect(ids, id -> new PersisterITTest.Toto((Integer)id, null, null), HashSet::new);
            }
        };
        PersisterITTest.Toto selectedToto = (PersisterITTest.Toto)testInstance.select((Object)1);
        ((SelectListener)Mockito.verify((Object)identifierManagerSelectListenerMock)).beforeSelect((Iterable)ArgumentMatchers.eq((Object)Arrays.asSet((Object[])new Integer[]{1})));
        ((SelectListener)Mockito.verify((Object)identifierManagerSelectListenerMock)).afterSelect((Set)ArgumentMatchers.eq((Object)Arrays.asHashSet((Object[])new PersisterITTest.Toto[]{selectedToto})));
    }
}

