/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.codefilarete.stalactite.engine.SelectExecutor;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.mapping.ColumnedRow;
import org.codefilarete.stalactite.query.builder.QuerySQLBuilderFactory;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.Operators;
import org.codefilarete.stalactite.query.model.Query;
import org.codefilarete.stalactite.query.model.QueryEase;
import org.codefilarete.stalactite.query.model.operator.TupleIn;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Row;
import org.codefilarete.stalactite.sql.result.RowIterator;
import org.codefilarete.stalactite.sql.statement.PreparedSQL;
import org.codefilarete.stalactite.sql.statement.ReadOperation;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReader;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.collection.Collections;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.KeepOrderMap;

public class JoinTablePolymorphismSelectExecutor<C, I, T extends Table<T>>
implements SelectExecutor<C, I> {
    private final ConfiguredRelationalPersister<C, I> mainPersister;
    private final Map<Class<? extends C>, Table> tablePerSubEntity;
    private final Map<Class<? extends C>, ConfiguredRelationalPersister<C, I>> subEntitiesPersisters;
    private final ConnectionProvider connectionProvider;
    private final Dialect dialect;

    public JoinTablePolymorphismSelectExecutor(ConfiguredRelationalPersister<C, I> mainPersister, Map<Class<? extends C>, Table> tablePerSubEntity, Map<Class<? extends C>, ConfiguredRelationalPersister<? extends C, I>> subEntitiesPersisters, ConnectionProvider connectionProvider, Dialect dialect) {
        this.mainPersister = mainPersister;
        this.tablePerSubEntity = tablePerSubEntity;
        this.subEntitiesPersisters = subEntitiesPersisters;
        this.connectionProvider = connectionProvider;
        this.dialect = dialect;
    }

    public Set<C> select(Iterable<I> ids) {
        PrimaryKey primaryKey = this.mainPersister.getMainTable().getPrimaryKey();
        if (primaryKey.isComposed() && !this.dialect.supportsTupleCondition()) {
            throw new UnsupportedOperationException("Database doesn't support tuple-in so selection can't be done trivially, not yet supported");
        }
        Query.FluentFromClause from = QueryEase.select((Map)Iterables.map((Iterable)primaryKey.getColumns(), Function.identity(), Column::getAlias)).from((Fromable)this.mainPersister.getMainTable());
        if (!primaryKey.isComposed()) {
            from.where((Column)Iterables.first((Iterable)primaryKey.getColumns()), (ConditionalOperator)Operators.in(ids));
        } else {
            List idsAsList = Collections.asList(ids);
            Map columnValues = this.mainPersister.getMapping().getIdMapping().getIdentifierAssembler().getColumnValues(idsAsList);
            from.where(new Object[]{this.transformCompositeIdentifierColumnValuesToTupleInValues(idsAsList.size(), columnValues)});
        }
        Query query = (Query)from.getQuery();
        this.tablePerSubEntity.values().forEach(subTable -> {
            PrimaryKey subclassPrimaryKey = subTable.getPrimaryKey();
            query.select(Iterables.map((Iterable)subclassPrimaryKey.getColumns(), Function.identity(), Column::getAlias));
            query.getFrom().leftOuterJoin((Key)primaryKey, (Key)subclassPrimaryKey);
        });
        QuerySQLBuilderFactory.QuerySQLBuilder sqlQueryBuilder = this.dialect.getQuerySQLBuilderFactory().queryBuilder(query);
        Map aliases = query.getSelectSurrogate().getAliases();
        PreparedSQL preparedSQL = sqlQueryBuilder.toPreparableSQL().toPreparedSQL(new HashMap());
        KeepOrderMap idsPerSubclass = new KeepOrderMap();
        try (ReadOperation readOperation = new ReadOperation((SQLStatement)preparedSQL, this.connectionProvider);){
            ResultSet resultSet = readOperation.execute();
            HashMap readers = new HashMap();
            aliases.forEach((c, as) -> {
                ResultSetReader cfr_ignored_0 = (ResultSetReader)readers.put(as, this.dialect.getColumnBinderRegistry().getBinder((Object)((Column)c)));
            });
            RowIterator resultSetIterator = new RowIterator(resultSet, readers);
            ColumnedRow columnedRow = new ColumnedRow(aliases::get);
            resultSetIterator.forEachRemaining(arg_0 -> this.lambda$select$4(columnedRow, (Map)idsPerSubclass, arg_0));
        }
        HashSet result = new HashSet();
        idsPerSubclass.forEach((subclass, subclassIds) -> result.addAll(this.subEntitiesPersisters.get(subclass).select((Iterable)subclassIds)));
        return result;
    }

    @VisibleForTesting
    TupleIn transformCompositeIdentifierColumnValuesToTupleInValues(int idsCount, Map<? extends Column<T, ?>, Object> values) {
        ArrayList<Object[]> resultValues = new ArrayList<Object[]>(idsCount);
        Column[] columns = new ArrayList(values.keySet()).toArray(new Column[0]);
        for (int i = 0; i < idsCount; ++i) {
            ArrayList<Object> beanValues = new ArrayList<Object>(columns.length);
            for (Column column : columns) {
                Object value = values.get(column);
                if (value instanceof List) {
                    beanValues.add(((List)value).get(i));
                    continue;
                }
                beanValues.add(value);
            }
            resultValues.add(beanValues.toArray());
        }
        return new TupleIn(columns, resultValues);
    }

    private /* synthetic */ void lambda$select$4(ColumnedRow columnedRow, Map idsPerSubclass, Row row) {
        this.subEntitiesPersisters.values().forEach(subPersister -> {
            Object id = subPersister.getMapping().getIdMapping().getIdentifierAssembler().assemble(row, columnedRow);
            if (id != null) {
                idsPerSubclass.computeIfAbsent(subPersister.getClassToPersist(), k -> new HashSet()).add(id);
            }
        });
    }
}

