/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.mapping.id.sequence;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.statement.ReadOperation;
import org.codefilarete.stalactite.sql.statement.StringParamedSQL;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.bean.Objects;
import org.codefilarete.tool.function.Sequence;

public class DatabaseSequenceSelector
implements Sequence<Long> {
    private final org.codefilarete.stalactite.sql.ddl.structure.Sequence databaseSequence;
    private final int poolSize;
    private final ReadOperation<String> readOperation;
    private final InternalState internalState = new InternalState();

    public DatabaseSequenceSelector(org.codefilarete.stalactite.sql.ddl.structure.Sequence databaseSequence, Dialect dialect, ConnectionProvider connectionProvider) {
        this.databaseSequence = databaseSequence;
        this.poolSize = (Integer)Objects.preventNull((Object)databaseSequence.getBatchSize(), (Object)1);
        String selectStatement = dialect.getDatabaseSequenceSelectBuilder().buildSelect(databaseSequence.getAbsoluteName());
        this.readOperation = dialect.getReadOperationFactory().createInstance(new StringParamedSQL(selectStatement, Collections.EMPTY_MAP), connectionProvider);
    }

    public org.codefilarete.stalactite.sql.ddl.structure.Sequence getDatabaseSequence() {
        return this.databaseSequence;
    }

    public synchronized Long next() {
        if (!this.internalState.initialized) {
            this.internalState.currentValue = this.callDatabase();
            this.internalState.initialized = true;
            return this.internalState.currentValue;
        }
        if (this.internalState.currentValue % (long)this.poolSize == 0L) {
            this.internalState.currentValue = this.callDatabase();
            return this.internalState.currentValue;
        }
        return ++this.internalState.currentValue;
    }

    @VisibleForTesting
    long callDatabase() {
        try {
            ResultSet rs = this.readOperation.execute();
            rs.next();
            return rs.getLong(1);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static class InternalState {
        private long currentValue;
        private boolean initialized = false;

        private InternalState() {
        }
    }
}

