/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.order;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.codefilarete.stalactite.query.builder.ExpandableSQLAppender;
import org.codefilarete.stalactite.query.builder.PreparableSQLBuilder;
import org.codefilarete.stalactite.query.builder.SQLAppender;
import org.codefilarete.stalactite.query.builder.SQLBuilder;
import org.codefilarete.stalactite.query.builder.StringSQLAppender;
import org.codefilarete.stalactite.query.builder.WhereSQLBuilderFactory;
import org.codefilarete.stalactite.query.model.ColumnCriterion;
import org.codefilarete.stalactite.query.model.UnitaryOperator;
import org.codefilarete.stalactite.query.model.ValuedVariable;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.order.Delete;
import org.codefilarete.stalactite.sql.order.MultiTableAwareDMLNameProvider;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;

public class DeleteCommandBuilder<T extends Table<T>>
implements SQLBuilder,
PreparableSQLBuilder {
    private final Delete<T> delete;
    private final Dialect dialect;
    private final MultiTableAwareDMLNameProvider dmlNameProvider;

    public DeleteCommandBuilder(Delete<T> delete, Dialect dialect) {
        this.delete = delete;
        this.dialect = dialect;
        this.dmlNameProvider = new MultiTableAwareDMLNameProvider(dialect.getDmlNameProviderFactory());
    }

    @Override
    public String toSQL() {
        StringSQLAppender result = new StringSQLAppender(this.dmlNameProvider);
        this.appendTo(result, this.dmlNameProvider);
        return result.getSQL();
    }

    @Override
    public ExpandableSQLAppender toPreparableSQL() {
        ExpandableSQLAppender preparedSQLAppender = new ExpandableSQLAppender(this.dialect.getColumnBinderRegistry(), this.dmlNameProvider);
        this.appendTo(preparedSQLAppender, this.dmlNameProvider);
        return preparedSQLAppender;
    }

    private void appendTo(SQLAppender target, MultiTableAwareDMLNameProvider dmlNameProvider) {
        target.cat("delete from ", new String[0]);
        LinkedHashSet whereColumns = new LinkedHashSet();
        this.delete.getCriteria().forEach(c -> {
            if (c instanceof ColumnCriterion && ((ColumnCriterion)c).getColumn() instanceof Column) {
                whereColumns.add((Column)((ColumnCriterion)c).getColumn());
                Object condition = ((ColumnCriterion)c).getCondition();
                if (condition instanceof UnitaryOperator && ((UnitaryOperator)condition).getValue() instanceof ValuedVariable && ((ValuedVariable)((UnitaryOperator)condition).getValue()).getValue() instanceof Column) {
                    whereColumns.add((Column)((ValuedVariable)((UnitaryOperator)condition).getValue()).getValue());
                }
            }
        });
        Set additionalTables = Iterables.minus((Collection)Iterables.collect(whereColumns, Column::getTable, HashSet::new), (Collection)Arrays.asList((Object[])new Table[]{this.delete.getTargetTable()}));
        dmlNameProvider.setMultiTable(!additionalTables.isEmpty());
        target.cat(((Table)this.delete.getTargetTable()).getAbsoluteName(), new String[0]).catIf(dmlNameProvider.isMultiTable(), ", ");
        Iterator iterator = additionalTables.iterator();
        while (iterator.hasNext()) {
            Table next = (Table)iterator.next();
            target.cat(next.getAbsoluteName(), new String[0]).catIf(iterator.hasNext(), ", ");
        }
        if (this.delete.getCriteria().iterator().hasNext()) {
            target.cat(" where ", new String[0]);
            WhereSQLBuilderFactory.WhereSQLBuilder whereSqlBuilder = this.dialect.getQuerySQLBuilderFactory().getWhereBuilderFactory().whereBuilder(this.delete.getCriteria(), dmlNameProvider);
            whereSqlBuilder.appendTo(target);
        }
    }
}

