/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.Set;
import javax.sql.DataSource;
import org.codefilarete.stalactite.engine.SeparateTransactionExecutor;
import org.codefilarete.stalactite.sql.CommitListener;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.CurrentThreadConnectionProvider;
import org.codefilarete.stalactite.sql.RollbackListener;
import org.codefilarete.stalactite.sql.TransactionAwareConnexionWrapper;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.codefilarete.tool.exception.Exceptions;

public class CurrentThreadTransactionalConnectionProvider
implements ConnectionConfiguration.TransactionalConnectionProvider {
    private final CurrentThreadConnectionProvider jdbcConnectionProvider;
    private final Set<CommitListener> commitListeners = new KeepOrderSet();
    private final Set<RollbackListener> rollbackListeners = new KeepOrderSet();

    public CurrentThreadTransactionalConnectionProvider(DataSource dataSource) {
        this.jdbcConnectionProvider = new CurrentThreadConnectionProvider(dataSource);
    }

    public CurrentThreadTransactionalConnectionProvider(DataSource dataSource, int connectionOpeningRetryMaxCount) {
        this.jdbcConnectionProvider = new CurrentThreadConnectionProvider(dataSource, connectionOpeningRetryMaxCount);
    }

    public Connection giveConnection() {
        return new TransactionAwareConnexionWrapper(this.jdbcConnectionProvider.giveConnection(), this.commitListeners, this.rollbackListeners);
    }

    @Override
    public void executeInNewTransaction(SeparateTransactionExecutor.JdbcOperation jdbcOperation) {
        Connection currentConnection = this.giveConnection();
        Savepoint savepoint = null;
        try {
            savepoint = currentConnection.setSavepoint();
            jdbcOperation.execute(currentConnection);
        }
        catch (Exception e) {
            if (savepoint != null) {
                try {
                    currentConnection.rollback(savepoint);
                    throw Exceptions.asRuntimeException((Throwable)e);
                }
                catch (SQLException e1) {
                    throw Exceptions.asRuntimeException((Throwable)e1);
                }
            }
            throw Exceptions.asRuntimeException((Throwable)e);
        }
        try {
            currentConnection.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void addCommitListener(CommitListener commitListener) {
        this.commitListeners.add(commitListener);
    }

    public void addRollbackListener(RollbackListener rollbackListener) {
        this.rollbackListeners.add(rollbackListener);
    }
}

