/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.ddl;

import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.sql.ddl.DDLSequenceGenerator;
import org.codefilarete.stalactite.sql.ddl.structure.Database;
import org.codefilarete.stalactite.sql.ddl.structure.Sequence;
import org.junit.jupiter.api.Test;

class DDLSequenceGeneratorTest {
    DDLSequenceGeneratorTest() {
    }

    @Test
    public void generateCreateSequence_sequenceHasInitialValueOnly() {
        DDLSequenceGenerator testInstance = new DDLSequenceGenerator(new DMLNameProvider(new HashMap()));
        Sequence sequence = new Sequence("my_sequence").withInitialValue(Integer.valueOf(10));
        String result = testInstance.generateCreateSequence(sequence);
        Assertions.assertThat((String)result).isEqualTo("create sequence my_sequence start with 10");
    }

    @Test
    public void generateCreateSequence_sequenceHasBatchSizeOnly() {
        DDLSequenceGenerator testInstance = new DDLSequenceGenerator(new DMLNameProvider(new HashMap()));
        Sequence sequence = new Sequence("my_sequence").withBatchSize(Integer.valueOf(10));
        String result = testInstance.generateCreateSequence(sequence);
        Assertions.assertThat((String)result).isEqualTo("create sequence my_sequence increment by 10");
    }

    @Test
    public void generateCreateSequence_sequenceHasNullValues() {
        DDLSequenceGenerator testInstance = new DDLSequenceGenerator(new DMLNameProvider(new HashMap()));
        Sequence sequence = new Sequence("my_sequence");
        sequence.setInitialValue(null);
        sequence.setBatchSize(null);
        String result = testInstance.generateCreateSequence(sequence);
        Assertions.assertThat((String)result).isEqualTo("create sequence my_sequence");
    }

    @Test
    public void generateCreateSequence_sequenceHasSchema() {
        DDLSequenceGenerator testInstance = new DDLSequenceGenerator(new DMLNameProvider(new HashMap()));
        Database database = new Database();
        database.getClass();
        Sequence sequence = new Sequence(new Database.Schema(database, "any_schema"), "my_sequence").withInitialValue(Integer.valueOf(10));
        String result = testInstance.generateCreateSequence(sequence);
        Assertions.assertThat((String)result).isEqualTo("create sequence any_schema.my_sequence start with 10");
    }
}

