/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.util.HashSet;
import java.util.Set;
import org.codefilarete.stalactite.engine.InsertExecutor;
import org.codefilarete.stalactite.engine.PersistExecutor;
import org.codefilarete.stalactite.engine.SelectExecutor;
import org.codefilarete.stalactite.engine.UpdateExecutor;
import org.codefilarete.stalactite.engine.listener.DeleteByIdListener;
import org.codefilarete.stalactite.engine.listener.DeleteListener;
import org.codefilarete.stalactite.engine.listener.InsertListener;
import org.codefilarete.stalactite.engine.listener.PersistListener;
import org.codefilarete.stalactite.engine.listener.PersisterListenerCollection;
import org.codefilarete.stalactite.engine.listener.SelectListener;
import org.codefilarete.stalactite.engine.listener.UpdateByIdListener;
import org.codefilarete.stalactite.engine.listener.UpdateListener;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.PersisterWrapper;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.collection.Iterables;

public class PersisterListenerWrapper<C, I>
extends PersisterWrapper<C, I> {
    private final PersisterListenerCollection<C, I> persisterListener = new PersisterListenerCollection();

    public PersisterListenerWrapper(ConfiguredRelationalPersister<C, I> surrogate) {
        super(surrogate);
    }

    @Override
    public void addPersistListener(PersistListener<? extends C> persistListener) {
        this.persisterListener.addPersistListener(persistListener);
    }

    @Override
    public void addInsertListener(InsertListener<? extends C> insertListener) {
        this.persisterListener.addInsertListener(insertListener);
    }

    @Override
    public void addUpdateListener(UpdateListener<? extends C> updateListener) {
        this.persisterListener.addUpdateListener(updateListener);
    }

    @Override
    public void addUpdateByIdListener(UpdateByIdListener<? extends C> updateByIdListener) {
        this.surrogate.addUpdateByIdListener(updateByIdListener);
    }

    @Override
    public void addSelectListener(SelectListener<? extends C, I> selectListener) {
        this.persisterListener.addSelectListener(selectListener);
    }

    @Override
    public void addDeleteListener(DeleteListener<? extends C> deleteListener) {
        this.persisterListener.addDeleteListener(deleteListener);
    }

    @Override
    public void addDeleteByIdListener(DeleteByIdListener<? extends C> deleteListener) {
        this.persisterListener.addDeleteByIdListener(deleteListener);
    }

    @Override
    public PersisterListenerCollection<C, I> getPersisterListener() {
        return this.persisterListener;
    }

    @Override
    public void delete(Iterable<? extends C> entities) {
        this.persisterListener.doWithDeleteListener(entities, () -> this.surrogate.delete(entities));
    }

    @Override
    public void deleteById(Iterable<? extends C> entities) {
        this.persisterListener.doWithDeleteByIdListener(entities, () -> this.surrogate.deleteById(entities));
    }

    @Override
    public void insert(Iterable<? extends C> entities) {
        if (!Iterables.isEmpty(entities)) {
            this.persisterListener.doWithInsertListener(entities, () -> this.surrogate.insert(entities));
        }
    }

    @Override
    public void persist(Iterable<? extends C> entities) {
        if (!Iterables.isEmpty(entities)) {
            this.persisterListener.doWithPersistListener(entities, () -> PersistExecutor.persist((Iterable)entities, this::isNew, (SelectExecutor)this, (UpdateExecutor)this, (InsertExecutor)this, this::getId));
        }
    }

    @Override
    public Set<C> select(Iterable<I> ids) {
        if (Iterables.isEmpty(ids)) {
            return new HashSet();
        }
        return this.persisterListener.doWithSelectListener(ids, () -> this.surrogate.select(ids));
    }

    @Override
    public void updateById(Iterable<? extends C> entities) {
        if (!Iterables.isEmpty(entities)) {
            this.persisterListener.doWithUpdateByIdListener(entities, () -> this.surrogate.updateById(entities));
        }
    }

    @Override
    public void update(Iterable<? extends Duo<C, C>> differencesIterable, boolean allColumnsStatement) {
        if (!Iterables.isEmpty(differencesIterable)) {
            this.persisterListener.doWithUpdateListener(differencesIterable, allColumnsStatement, (arg_0, arg_1) -> ((ConfiguredRelationalPersister)this.surrogate).update(arg_0, arg_1));
        }
    }
}

