/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.diff.AbstractDiff;
import org.codefilarete.stalactite.engine.diff.CollectionDiffer;
import org.codefilarete.stalactite.engine.diff.Diff;
import org.codefilarete.stalactite.engine.diff.State;
import org.codefilarete.stalactite.engine.runtime.ConfiguredPersister;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.collection.Iterables;

public class CollectionUpdater<I, O, C extends Collection<O>>
implements BiConsumer<Duo<I, I>, Boolean> {
    private final CollectionDiffer<O> differ;
    private final Function<I, C> collectionGetter;
    private final BiConsumer<O, I> reverseSetter;
    protected final EntityWriter<O> elementPersister;
    private final boolean shouldDeleteRemoved;

    public CollectionUpdater(Function<I, C> collectionGetter, ConfiguredPersister<O, ?> elementPersister, @Nullable BiConsumer<O, I> reverseSetter, boolean shouldDeleteRemoved) {
        this(collectionGetter, (EntityPersister<Object, ?>)elementPersister, (BiConsumer<Object, I>)reverseSetter, shouldDeleteRemoved, arg_0 -> ((EntityMapping)elementPersister.getMapping()).getId(arg_0));
    }

    public CollectionUpdater(Function<I, C> collectionGetter, EntityPersister<O, ?> elementPersister, @Nullable BiConsumer<O, I> reverseSetter, boolean shouldDeleteRemoved, Function<O, ?> idProvider) {
        this.collectionGetter = collectionGetter;
        this.reverseSetter = reverseSetter;
        this.elementPersister = new EntityPersisterEntityWriterAdaptor<O>(elementPersister);
        this.shouldDeleteRemoved = shouldDeleteRemoved;
        this.differ = new CollectionDiffer<O>(idProvider);
    }

    public CollectionUpdater(Function<I, C> collectionGetter, EntityWriter<O> elementPersister, @Nullable BiConsumer<O, I> reverseSetter, boolean shouldDeleteRemoved, Function<O, ?> idProvider) {
        this.collectionGetter = collectionGetter;
        this.reverseSetter = reverseSetter;
        this.elementPersister = elementPersister;
        this.shouldDeleteRemoved = shouldDeleteRemoved;
        this.differ = new CollectionDiffer<O>(idProvider);
    }

    public CollectionDiffer<O> getDiffer() {
        return this.differ;
    }

    @Override
    public void accept(Duo<I, I> entry, Boolean allColumnsStatement) {
        Collection modified = (Collection)this.collectionGetter.apply(entry.getLeft());
        Collection unmodified = (Collection)this.collectionGetter.apply(entry.getRight());
        UpdateContext updateContext = this.newUpdateContext(entry);
        if (modified != null || unmodified != null) {
            if (modified != null && unmodified == null) {
                modified.forEach(o -> this.onAddedElements(updateContext, new Diff<Object>(State.ADDED, null, o)));
            } else if (modified == null && unmodified != null) {
                unmodified.forEach(o -> this.onRemovedElements(updateContext, new Diff<Object>(State.REMOVED, o, null)));
            } else {
                Set<AbstractDiff<O>> diffSet = this.diff(modified, unmodified);
                for (AbstractDiff<O> diff : diffSet) {
                    switch (diff.getState()) {
                        case ADDED: {
                            this.onAddedElements(updateContext, diff);
                            break;
                        }
                        case HELD: {
                            this.onHeldElements(updateContext, diff);
                            break;
                        }
                        case REMOVED: {
                            this.onRemovedElements(updateContext, diff);
                        }
                    }
                }
            }
        }
        this.updateTargets(updateContext, allColumnsStatement);
        this.deleteTargets(updateContext);
        this.insertTargets(updateContext);
    }

    protected void updateTargets(UpdateContext updateContext, boolean allColumnsStatement) {
        List updateInput = Iterables.collectToList(updateContext.getHeldElements(), diff -> new Duo(diff.getReplacingInstance(), diff.getSourceInstance()));
        this.elementPersister.update(updateInput, allColumnsStatement);
    }

    protected void deleteTargets(UpdateContext updateContext) {
        this.elementPersister.delete(updateContext.getRemovedElements());
    }

    protected void insertTargets(UpdateContext updateContext) {
        this.elementPersister.persist(updateContext.getAddedElements());
    }

    protected Set<? extends AbstractDiff<O>> diff(Collection<O> modified, Collection<O> unmodified) {
        return this.differ.diff(unmodified, modified);
    }

    protected UpdateContext newUpdateContext(Duo<I, I> updatePayload) {
        return new UpdateContext(updatePayload);
    }

    protected void onAddedElements(UpdateContext updateContext, AbstractDiff<O> diff) {
        updateContext.getAddedElements().add(diff.getReplacingInstance());
    }

    protected void onHeldElements(UpdateContext updateContext, AbstractDiff<O> diff) {
        updateContext.getHeldElements().add(diff);
    }

    protected void onRemovedElements(UpdateContext updateContext, AbstractDiff<O> diff) {
        if (this.shouldDeleteRemoved) {
            if (!this.elementPersister.isNew(diff.getSourceInstance())) {
                updateContext.getRemovedElements().add(diff.getSourceInstance());
            }
        } else if (this.reverseSetter != null) {
            this.reverseSetter.accept(diff.getSourceInstance(), null);
            this.elementPersister.updateById(Collections.singleton(diff.getSourceInstance()));
        }
    }

    private static class EntityPersisterEntityWriterAdaptor<C>
    implements EntityWriter<C> {
        private final EntityPersister<C, ?> delegate;

        private EntityPersisterEntityWriterAdaptor(EntityPersister<C, ?> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void update(Iterable<? extends Duo<C, C>> differencesIterable, boolean allColumnsStatement) {
            this.delegate.update(differencesIterable, allColumnsStatement);
        }

        @Override
        public void delete(Iterable<? extends C> entities) {
            this.delegate.delete(entities);
        }

        @Override
        public void persist(Iterable<? extends C> entities) {
            this.delegate.persist(entities);
        }

        @Override
        public boolean isNew(C entity) {
            return this.delegate.isNew(entity);
        }

        @Override
        public void updateById(Iterable<? extends C> entities) {
            this.delegate.updateById(entities);
        }
    }

    public static interface EntityWriter<C> {
        public void update(Iterable<? extends Duo<C, C>> var1, boolean var2);

        public void delete(Iterable<? extends C> var1);

        public void persist(Iterable<? extends C> var1);

        public boolean isNew(C var1);

        public void updateById(Iterable<? extends C> var1);
    }

    protected class UpdateContext {
        private final Duo<I, I> payload;
        private final List<O> addedElements = new ArrayList();
        private final List<AbstractDiff<O>> heldElements = new ArrayList();
        private final List<O> removedElements = new ArrayList();

        public UpdateContext(Duo<I, I> updatePayload) {
            this.payload = updatePayload;
        }

        public Duo<I, I> getPayload() {
            return this.payload;
        }

        public List<O> getAddedElements() {
            return this.addedElements;
        }

        public List<AbstractDiff<O>> getHeldElements() {
            return this.heldElements;
        }

        public List<O> getRemovedElements() {
            return this.removedElements;
        }
    }
}

