/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.tool.Retryer;
import org.codefilarete.tool.sql.ConnectionWrapper;

public class CurrentThreadConnectionProvider
implements ConnectionProvider {
    private final DataSource dataSource;
    private final ThreadLocal<Connection> currentConnection = new ThreadLocal();
    private final ClosedConnectionRetryer closedConnectionRetryer;

    public CurrentThreadConnectionProvider(DataSource dataSource) {
        this(dataSource, 5);
    }

    public CurrentThreadConnectionProvider(DataSource dataSource, int connectionOpeningRetryMaxCount) {
        this.dataSource = dataSource;
        this.closedConnectionRetryer = new ClosedConnectionRetryer(connectionOpeningRetryMaxCount);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public Connection giveConnection() {
        Connection connection = this.currentConnection.get();
        try {
            if (connection == null) {
                return this.fillCurrentConnection();
            }
            if (connection.isClosed()) {
                this.currentConnection.remove();
                return this.fillCurrentConnection();
            }
            return connection;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public Connection fillCurrentConnection() {
        try {
            CurrentThreadDetacherConnection connection = new CurrentThreadDetacherConnection(this.lookupForConnection());
            connection.setAutoCommit(false);
            this.currentConnection.set((Connection)((Object)connection));
            return connection;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private Connection lookupForConnection() throws SQLException {
        Connection connection;
        try {
            connection = (Connection)this.closedConnectionRetryer.execute(this.dataSource::getConnection, "getting a connection");
        }
        catch (Retryer.RetryException e) {
            this.currentConnection.remove();
            throw new IllegalStateException("Maximum attempt to open a connection reached : all are closed", e);
        }
        return connection;
    }

    public void releaseConnection() {
        this.currentConnection.remove();
    }

    private class CurrentThreadDetacherConnection
    extends ConnectionWrapper {
        private CurrentThreadDetacherConnection(Connection connection) {
            super(connection);
        }

        public void close() throws SQLException {
            CurrentThreadConnectionProvider.this.releaseConnection();
            super.close();
        }
    }

    private static class ClosedConnectionRetryer
    extends Retryer {
        public ClosedConnectionRetryer(int retryCount) {
            super(retryCount, 10L);
        }

        protected boolean shouldRetry(Retryer.Result result) {
            if (result instanceof Retryer.Failure) {
                return false;
            }
            try {
                return ((Connection)((Retryer.Success)result).getValue()).isClosed();
            }
            catch (SQLException e) {
                throw new IllegalStateException("Impossible to know if connection is closed or not", e);
            }
        }
    }
}

