/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.util.Arrays;
import java.util.Map;
import org.codefilarete.stalactite.query.model.OrderByChain;
import org.codefilarete.stalactite.query.model.Query;
import org.codefilarete.stalactite.query.model.QueryStatement;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ddl.structure.Column;

class ColumnCloneAwareOrderBy
implements OrderByChain {
    private final OrderByChain delegate;
    private final Map<Selectable<?>, Selectable<?>> columnClones;

    ColumnCloneAwareOrderBy(Query.FluentOrderByClause delegate, Map<Selectable<?>, Selectable<?>> columnClones) {
        this.delegate = delegate;
        this.columnClones = columnClones;
    }

    public OrderByChain add(Selectable column, OrderByChain.Order order) {
        return this.delegate.add(this.getColumn(column), order);
    }

    private Selectable getColumn(Selectable column) {
        if (column instanceof Column || column instanceof QueryStatement.PseudoColumn) {
            return this.columnClones.get(column);
        }
        return column;
    }

    public OrderByChain add(Selectable col1, OrderByChain.Order order1, Selectable col2, OrderByChain.Order order2) {
        return this.delegate.add(this.getColumn(col1), order1, this.getColumn(col2), order2);
    }

    public OrderByChain add(Selectable col1, OrderByChain.Order order1, Selectable col2, OrderByChain.Order order2, Selectable col3, OrderByChain.Order order3) {
        return this.delegate.add(this.getColumn(col1), order1, this.getColumn(col2), order2, this.getColumn(col3), order3);
    }

    public OrderByChain add(String column, OrderByChain.Order order) {
        return this.delegate.add(column, order);
    }

    public OrderByChain add(String col1, OrderByChain.Order order1, String col2, OrderByChain.Order order2) {
        return this.delegate.add(col1, order1, col2, order2);
    }

    public OrderByChain add(String col1, OrderByChain.Order order1, String col2, OrderByChain.Order order2, String col3, OrderByChain.Order order3) {
        return this.delegate.add(col1, order1, col2, order2, col3, order3);
    }

    public OrderByChain add(Selectable column, Selectable ... columns) {
        return this.delegate.add(this.getColumn(column), (Selectable[])Arrays.stream(columns).map(this::getColumn).toArray(Column[]::new));
    }

    public OrderByChain add(String column, String ... columns) {
        return this.delegate.add(column, columns);
    }
}

