/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.polymorphism;

import java.util.HashMap;
import java.util.Map;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.reflection.ValueAccessPointMap;
import org.codefilarete.reflection.ValueAccessPointSet;
import org.codefilarete.stalactite.engine.PolymorphismPolicy;
import org.codefilarete.stalactite.engine.SubEntityMappingConfiguration;
import org.codefilarete.stalactite.engine.configurer.AbstractIdentification;
import org.codefilarete.stalactite.engine.configurer.BeanMappingBuilder;
import org.codefilarete.stalactite.engine.configurer.NamingConfiguration;
import org.codefilarete.stalactite.engine.configurer.PersisterBuilderImpl;
import org.codefilarete.stalactite.engine.configurer.polymorphism.AbstractPolymorphicPersisterBuilder;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.JoinTablePolymorphismPersister;
import org.codefilarete.stalactite.engine.runtime.SimpleRelationalEntityPersister;
import org.codefilarete.stalactite.engine.runtime.load.EntityMerger;
import org.codefilarete.stalactite.mapping.ClassMapping;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.exception.NotImplementedException;
import org.codefilarete.tool.function.Converter;

public class JoinTablePolymorphismBuilder<C, I, T extends Table<T>>
extends AbstractPolymorphicPersisterBuilder<C, I, T> {
    private final PolymorphismPolicy.JoinTablePolymorphism<C> joinTablePolymorphism;
    private final PrimaryKey<T, I> mainTablePrimaryKey;

    public JoinTablePolymorphismBuilder(PolymorphismPolicy.JoinTablePolymorphism<C> polymorphismPolicy, AbstractIdentification<C, I> identification, ConfiguredRelationalPersister<C, I> mainPersister, ColumnBinderRegistry columnBinderRegistry, NamingConfiguration namingConfiguration) {
        super(polymorphismPolicy, identification, mainPersister, columnBinderRegistry, namingConfiguration);
        this.joinTablePolymorphism = polymorphismPolicy;
        this.mainTablePrimaryKey = this.mainPersister.getMapping().getTargetTable().getPrimaryKey();
    }

    @Override
    public ConfiguredRelationalPersister<C, I> build(Dialect dialect, ConnectionConfiguration connectionConfiguration) {
        Map persisterPerSubclass = this.collectSubClassPersister(dialect, connectionConfiguration);
        this.registerCascades(persisterPerSubclass, dialect, connectionConfiguration);
        return new JoinTablePolymorphismPersister(this.mainPersister, persisterPerSubclass, connectionConfiguration.getConnectionProvider(), dialect);
    }

    private <D extends C> Map<Class<D>, ConfiguredRelationalPersister<D, I>> collectSubClassPersister(Dialect dialect, ConnectionConfiguration connectionConfiguration) {
        HashMap<Class<D>, ConfiguredRelationalPersister<D, I>> persisterPerSubclass = new HashMap<Class<D>, ConfiguredRelationalPersister<D, I>>();
        for (SubEntityMappingConfiguration<C> subConfiguration : this.joinTablePolymorphism.getSubClasses()) {
            ConfiguredRelationalPersister<C, I> subclassPersister = this.buildSubclassPersister(dialect, connectionConfiguration, subConfiguration);
            subclassPersister.getEntityJoinTree().addMergeJoin("ROOT", new EntityMerger.EntityMergerAdapter(this.mainPersister.getMapping()), subclassPersister.getMapping().getTargetTable().getPrimaryKey(), this.mainTablePrimaryKey);
            persisterPerSubclass.put(subConfiguration.getEntityType(), subclassPersister);
        }
        return persisterPerSubclass;
    }

    private <D, SUBT extends Table<SUBT>> ConfiguredRelationalPersister<D, I> buildSubclassPersister(Dialect dialect, ConnectionConfiguration connectionConfiguration, SubEntityMappingConfiguration<D> subConfiguration) {
        Table tableDefinedByColumnOverride = BeanMappingBuilder.giveTargetTable(subConfiguration.getPropertiesMapping());
        Table tableDefinedByInheritanceConfiguration = this.joinTablePolymorphism.giveTable(subConfiguration);
        JoinTablePolymorphismBuilder.assertNullOrEqual(tableDefinedByColumnOverride, tableDefinedByInheritanceConfiguration);
        Table subTable = (Table)Nullable.nullable((Object)tableDefinedByColumnOverride).elseSet((Object)tableDefinedByInheritanceConfiguration).getOr(() -> new Table(this.namingConfiguration.getTableNamingStrategy().giveName(subConfiguration.getEntityType())));
        BeanMappingBuilder<D, Table> beanMappingBuilder = new BeanMappingBuilder<D, Table>(subConfiguration.getPropertiesMapping(), subTable, this.columnBinderRegistry, this.namingConfiguration.getColumnNamingStrategy());
        BeanMappingBuilder.BeanMapping<D, Table> beanMapping = beanMappingBuilder.build();
        Map<ReversibleAccessor<D, Object>, Column<Table, Object>> subEntityPropertiesMapping = beanMapping.getMapping();
        Map<ReversibleAccessor<D, Object>, Column<Table, Object>> subEntityReadonlyPropertiesMapping = beanMapping.getReadonlyMapping();
        ValueAccessPointMap<D, Converter<Object, Object>> subEntityPropertiesConverters = beanMapping.getReadConverters();
        ValueAccessPointMap<D, Converter<Object, Object>> subEntityPropertiesWriteConverters = beanMapping.getWriteConverters();
        this.addPrimarykey(subTable);
        this.addForeignKey(subTable);
        PersisterBuilderImpl.MappingPerTable.Mapping<D, Table> subEntityMapping = new PersisterBuilderImpl.MappingPerTable.Mapping<D, Table>(subConfiguration, subTable, subEntityPropertiesMapping, subEntityReadonlyPropertiesMapping, subEntityPropertiesConverters, subEntityPropertiesWriteConverters, false);
        this.addIdentificationToMapping(this.identification, subEntityMapping);
        ClassMapping classMappingStrategy = PersisterBuilderImpl.createClassMappingStrategy(false, subTable, subEntityPropertiesMapping, subEntityReadonlyPropertiesMapping, subEntityPropertiesConverters, subEntityPropertiesWriteConverters, new ValueAccessPointSet(), this.identification, subConfiguration.getPropertiesMapping().getBeanType(), null);
        return new SimpleRelationalEntityPersister(classMappingStrategy, dialect, connectionConfiguration);
    }

    @Override
    protected void assertSubPolymorphismIsSupported(PolymorphismPolicy<? extends C> subPolymorphismPolicy) {
        if (!(subPolymorphismPolicy instanceof PolymorphismPolicy.JoinTablePolymorphism) && !(subPolymorphismPolicy instanceof PolymorphismPolicy.SingleTablePolymorphism)) {
            throw new NotImplementedException("Combining joined-tables polymorphism policy with " + Reflections.toString(subPolymorphismPolicy.getClass()));
        }
    }

    private void addPrimarykey(Table table) {
        PersisterBuilderImpl.propagatePrimaryKey(this.mainTablePrimaryKey, Arrays.asSet((Object[])new Table[]{table}));
    }

    private void addForeignKey(Table table) {
        PersisterBuilderImpl.applyForeignKeys(this.mainTablePrimaryKey, this.namingConfiguration.getForeignKeyNamingStrategy(), Arrays.asSet((Object[])new Table[]{table}));
    }

    private void addIdentificationToMapping(AbstractIdentification<C, I> identification, PersisterBuilderImpl.MappingPerTable.Mapping mapping) {
        PersisterBuilderImpl.addIdentificationToMapping(identification, Arrays.asSet((Object[])new PersisterBuilderImpl.MappingPerTable.Mapping[]{mapping}));
    }
}

