/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.engine.ColumnNamingStrategy;
import org.codefilarete.stalactite.engine.ColumnOptions;
import org.codefilarete.stalactite.engine.EmbeddableMappingConfigurationProvider;
import org.codefilarete.stalactite.engine.EntityMappingConfiguration;
import org.codefilarete.stalactite.engine.EntityMappingConfigurationProvider;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.FluentEntityMappingBuilder;
import org.codefilarete.stalactite.engine.MappingConfigurationException;
import org.codefilarete.stalactite.engine.MappingEase;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.engine.model.AbstractVehicle;
import org.codefilarete.stalactite.engine.model.Car;
import org.codefilarete.stalactite.engine.model.Color;
import org.codefilarete.stalactite.engine.model.Vehicle;
import org.codefilarete.stalactite.engine.model.book.AbstractEntity;
import org.codefilarete.stalactite.engine.model.book.Author;
import org.codefilarete.stalactite.engine.model.book.Book;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.id.Identifier;
import org.codefilarete.stalactite.id.PersistedIdentifier;
import org.codefilarete.stalactite.id.StatefulIdentifierAlreadyAssignedIdentifierPolicy;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.query.model.QueryEase;
import org.codefilarete.stalactite.query.model.QueryProvider;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.CurrentThreadConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.HSQLDBDialect;
import org.codefilarete.stalactite.sql.ddl.DDLDeployer;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.stalactite.sql.statement.binder.LambdaParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.NullAwareParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.stalactite.sql.test.HSQLDBInMemoryDataSource;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

public class FluentEntityMappingConfigurationSupportInheritanceTest {
    private static final HSQLDBDialect DIALECT = new HSQLDBDialect();
    private final DataSource dataSource = new HSQLDBInMemoryDataSource();
    private final ConnectionProvider connectionProvider = new CurrentThreadConnectionProvider(this.dataSource);
    private PersistenceContext persistenceContext;

    @BeforeAll
    static void initBinders() {
        DIALECT.getColumnBinderRegistry().register(Identifier.class, Identifier.identifierBinder(DefaultParameterBinders.LONG_PRIMITIVE_BINDER));
        DIALECT.getSqlTypeRegistry().put(Identifier.class, "int");
        DIALECT.getColumnBinderRegistry().register(Color.class, (ParameterBinder)new NullAwareParameterBinder((ParameterBinder)new LambdaParameterBinder(DefaultParameterBinders.INTEGER_PRIMITIVE_BINDER, Color::new, Color::getRgb)));
        DIALECT.getSqlTypeRegistry().put(Color.class, "int");
    }

    @BeforeEach
    public void beforeTest() {
        this.persistenceContext = new PersistenceContext(this.connectionProvider, (Dialect)DIALECT);
    }

    static class MappedSuperClassData {
        private final VehicleTable vehicleTable = new VehicleTable("vehicle");
        private final CarTable carTable = new CarTable("car");

        MappedSuperClassData() {
        }

        class CarTable
        extends AbstractVehicleTable<CarTable> {
            final Column<CarTable, String> modelColumn;

            public CarTable(String name) {
                super(name);
                this.modelColumn = this.addColumn("model", String.class);
            }
        }

        class VehicleTable
        extends AbstractVehicleTable<VehicleTable> {
            public VehicleTable(String name) {
                super(name);
            }
        }

        abstract class AbstractVehicleTable<SELF extends AbstractVehicleTable<SELF>>
        extends Table<SELF> {
            final Column<SELF, Identifier<Long>> idColumn;
            final Column<SELF, Color> colorColumn;

            public AbstractVehicleTable(String name) {
                super(name);
                this.idColumn = this.addColumn("id", Identifier.class).primaryKey();
                this.colorColumn = this.addColumn("color", Color.class);
            }
        }
    }

    @Nested
    class Inheritance {
        Inheritance() {
        }

        @Test
        void withIdDefinedInSuperClass() {
            MappedSuperClassData mappedSuperClassData = new MappedSuperClassData();
            EntityMappingConfiguration inheritanceConfiguration = MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).getConfiguration();
            EntityPersister carPersister = MappingEase.entityBuilder(Car.class, Identifier.LONG_TYPE).map(Car::getModel).map(Vehicle::getColor).mapSuperClass(inheritanceConfiguration).build(FluentEntityMappingConfigurationSupportInheritanceTest.this.persistenceContext);
            Collection tables = DDLDeployer.collectTables((PersistenceContext)FluentEntityMappingConfigurationSupportInheritanceTest.this.persistenceContext);
            Assertions.assertThat((boolean)tables.contains((Object)mappedSuperClassData.vehicleTable)).isFalse();
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportInheritanceTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Car dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            dummyCar.setColor(new Color(666));
            carPersister.insert((Object)dummyCar);
            Set allCars = FluentEntityMappingConfigurationSupportInheritanceTest.this.persistenceContext.select(Car::new, ((MappedSuperClassData)mappedSuperClassData).carTable.idColumn, m -> m.add(((MappedSuperClassData)mappedSuperClassData).carTable.modelColumn, Car::setModel).add(((MappedSuperClassData)mappedSuperClassData).carTable.colorColumn, Vehicle::setColor));
            Assertions.assertThat((Collection)allCars).containsExactlyInAnyOrder((Object[])new Car[]{dummyCar});
            Car loadedCar = (Car)carPersister.select(new PersistedIdentifier<Long>(1L));
            Assertions.assertThat((Object)loadedCar).isEqualTo((Object)dummyCar);
        }

        @Test
        void withIdDefinedInSuperClass_severalTimes() {
            FluentEntityMappingBuilder.FluentEntityMappingBuilderKeyOptions inheritanceConfiguration = MappingEase.entityBuilder(AbstractEntity.class, Long.TYPE).mapKey(AbstractEntity::getId, (ColumnOptions.IdentifierPolicy)ColumnOptions.IdentifierPolicy.afterInsert());
            FluentEntityMappingBuilder.FluentMappingBuilderInheritanceOptions authorConfiguration = MappingEase.entityBuilder(Author.class, Long.TYPE).map(Author::getName).mapOneToMany(Author::getWrittenBooks, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Book.class, Long.TYPE).map(Book::getTitle).mapSuperClass((EntityMappingConfigurationProvider)inheritanceConfiguration)).mapSuperClass((EntityMappingConfigurationProvider)inheritanceConfiguration);
            Assertions.assertThatCode(() -> this.lambda$withIdDefinedInSuperClass_severalTimes$1((FluentEntityMappingBuilder)authorConfiguration)).doesNotThrowAnyException();
        }

        @Test
        void identifierIsRedefined_throwsException() {
            EntityMappingConfiguration inheritanceConfiguration = MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).getConfiguration();
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).mapSuperClass(inheritanceConfiguration).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).build(FluentEntityMappingConfigurationSupportInheritanceTest.this.persistenceContext)).isInstanceOf(MappingConfigurationException.class)).hasMessage("Defining an identifier in conjunction with entity inheritance is not supported : o.c.s.e.m.Vehicle defines identifier AbstractVehicle::getId while it inherits from o.c.s.e.m.AbstractVehicle");
        }

        @Test
        void multipleInheritance() {
            MappedSuperClassData mappedSuperClassData = new MappedSuperClassData();
            EntityMappingConfiguration inheritanceConfiguration = MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).getConfiguration();
            EntityMappingConfiguration inheritanceConfiguration2 = MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).mapSuperClass(inheritanceConfiguration).map(Vehicle::getColor).getConfiguration();
            EntityPersister carPersister = MappingEase.entityBuilder(Car.class, Identifier.LONG_TYPE).map(Car::getModel).mapSuperClass(inheritanceConfiguration2).build(FluentEntityMappingConfigurationSupportInheritanceTest.this.persistenceContext);
            Collection tables = DDLDeployer.collectTables((PersistenceContext)FluentEntityMappingConfigurationSupportInheritanceTest.this.persistenceContext);
            Assertions.assertThat((boolean)tables.contains((Object)mappedSuperClassData.vehicleTable)).isFalse();
            Assertions.assertThat((boolean)tables.contains((Object)mappedSuperClassData.carTable)).isTrue();
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportInheritanceTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Car dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            dummyCar.setColor(new Color(666));
            carPersister.insert((Object)dummyCar);
            Set allCars = FluentEntityMappingConfigurationSupportInheritanceTest.this.persistenceContext.select(Car::new, ((MappedSuperClassData)mappedSuperClassData).carTable.idColumn, m -> m.add(((MappedSuperClassData)mappedSuperClassData).carTable.modelColumn, Car::setModel).add(((MappedSuperClassData)mappedSuperClassData).carTable.colorColumn, Vehicle::setColor));
            Assertions.assertThat((Collection)allCars).containsExactlyInAnyOrder((Object[])new Car[]{dummyCar});
            Car loadedCar = (Car)carPersister.select(new PersistedIdentifier<Long>(1L));
            Assertions.assertThat((Object)loadedCar).isEqualTo((Object)dummyCar);
        }

        @Test
        void multipleInheritance_joinedTables() {
            MappedSuperClassData mappedSuperClassData = new MappedSuperClassData();
            EntityMappingConfiguration inheritanceConfiguration = MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).getConfiguration();
            EntityMappingConfiguration inheritanceConfiguration2 = MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).mapSuperClass(inheritanceConfiguration).withJoinedTable().getConfiguration();
            EntityPersister carPersister = MappingEase.entityBuilder(Car.class, Identifier.LONG_TYPE).map(Car::getModel).map(Vehicle::getColor).mapSuperClass(inheritanceConfiguration2).withJoinedTable().build(FluentEntityMappingConfigurationSupportInheritanceTest.this.persistenceContext);
            Assertions.assertThat((Collection)DDLDeployer.collectTables((PersistenceContext)FluentEntityMappingConfigurationSupportInheritanceTest.this.persistenceContext).stream().map(Table::getName).collect(Collectors.toSet())).isEqualTo((Object)Arrays.asHashSet((Object[])new String[]{"Car", "Vehicle", "AbstractVehicle"}));
            Assertions.assertThat((String)((ConfiguredRelationalPersister)FluentEntityMappingConfigurationSupportInheritanceTest.this.persistenceContext.getPersister(Car.class)).getMapping().getTargetTable().getName()).isEqualTo("Car");
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportInheritanceTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Car dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            dummyCar.setColor(new Color(666));
            carPersister.insert((Object)dummyCar);
            Set allCars = FluentEntityMappingConfigurationSupportInheritanceTest.this.persistenceContext.select(Car::new, ((MappedSuperClassData)mappedSuperClassData).carTable.idColumn, m -> m.add(((MappedSuperClassData)mappedSuperClassData).carTable.modelColumn, Car::setModel).add(((MappedSuperClassData)mappedSuperClassData).carTable.colorColumn, Vehicle::setColor));
            Assertions.assertThat((Collection)allCars).containsExactlyInAnyOrder((Object[])new Car[]{dummyCar});
            Car loadedCar = (Car)carPersister.select(new PersistedIdentifier<Long>(1L));
            Assertions.assertThat((Object)loadedCar).isEqualTo((Object)dummyCar);
        }

        @Test
        void mappedSuperClass_and_entityInheritance_throwsException() {
            EntityMappingConfiguration inheritanceConfiguration = MappingEase.entityBuilder(AbstractVehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).getConfiguration();
            FluentEntityMappingBuilder.FluentMappingBuilderInheritanceOptions mappingBuilder = MappingEase.entityBuilder(Car.class, Identifier.LONG_TYPE).map(Car::getModel).map(Vehicle::getColor).mapSuperClass((EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Vehicle.class).map(Vehicle::getColor)).mapSuperClass(inheritanceConfiguration);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$mappedSuperClass_and_entityInheritance_throwsException$5((FluentEntityMappingBuilder)mappingBuilder)).isInstanceOf(MappingConfigurationException.class)).hasMessage("Combination of mapped super class and inheritance is not supported, please remove one of them");
        }

        @Test
        void joinedTables() {
            MappedSuperClassData mappedSuperClassData = new MappedSuperClassData();
            EntityMappingConfiguration inheritanceConfiguration = MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Vehicle::getColor).getConfiguration();
            EntityPersister carPersister = MappingEase.entityBuilder(Car.class, Identifier.LONG_TYPE, (Table)mappedSuperClassData.carTable).map(Car::getModel).mapSuperClass(inheritanceConfiguration).withJoinedTable().build(FluentEntityMappingConfigurationSupportInheritanceTest.this.persistenceContext);
            Collection tables = DDLDeployer.collectTables((PersistenceContext)FluentEntityMappingConfigurationSupportInheritanceTest.this.persistenceContext);
            Assertions.assertThat((boolean)Iterables.collectToList((Iterable)tables, Table::getName).contains(Vehicle.class.getSimpleName())).isTrue();
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportInheritanceTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Car dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            dummyCar.setColor(new Color(666));
            carPersister.insert((Object)dummyCar);
            PersistenceContext.ExecutableBeanPropertyQueryMapper carExecutableQuery = FluentEntityMappingConfigurationSupportInheritanceTest.this.persistenceContext.newQuery((QueryProvider)QueryEase.select((Selectable)((MappedSuperClassData)mappedSuperClassData).carTable.idColumn, (Selectable[])new Selectable[]{((MappedSuperClassData)mappedSuperClassData).carTable.modelColumn, ((MappedSuperClassData)mappedSuperClassData).vehicleTable.colorColumn}).from((Fromable)mappedSuperClassData.carTable).innerJoin((JoinLink)((MappedSuperClassData)mappedSuperClassData).carTable.idColumn, (JoinLink)((MappedSuperClassData)mappedSuperClassData).vehicleTable.idColumn), Car.class).mapKey(Car::new, ((MappedSuperClassData)mappedSuperClassData).carTable.idColumn).map(((MappedSuperClassData)mappedSuperClassData).carTable.modelColumn, Car::setModel).map(((MappedSuperClassData)mappedSuperClassData).vehicleTable.colorColumn, Vehicle::setColor);
            Set allCars = (Set)carExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)allCars).containsExactlyInAnyOrder((Object[])new Car[]{dummyCar});
            Car loadedCar = (Car)carPersister.select(new PersistedIdentifier<Long>(1L));
            Assertions.assertThat((Object)loadedCar).isEqualTo((Object)dummyCar);
        }

        @Test
        void withEmbeddable() {
            EntityMappingConfiguration inheritanceConfiguration = MappingEase.entityBuilder(Vehicle.class, Identifier.LONG_TYPE).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).embed(Vehicle::getColor, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Color.class).map(Color::getRgb)).getConfiguration();
            EntityPersister carPersister = MappingEase.entityBuilder(Car.class, Identifier.LONG_TYPE).map(Car::getModel).mapSuperClass(inheritanceConfiguration).build(FluentEntityMappingConfigurationSupportInheritanceTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportInheritanceTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Car dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            dummyCar.setColor(new Color(666));
            carPersister.insert((Object)dummyCar);
            Car loadedCar = (Car)carPersister.select(new PersistedIdentifier<Long>(1L));
            Assertions.assertThat((Object)loadedCar).isEqualTo((Object)dummyCar);
            PersistenceContext.ExecutableBeanPropertyQueryMapper carExecutableQuery = FluentEntityMappingConfigurationSupportInheritanceTest.this.persistenceContext.newQuery((CharSequence)"select id, model, rgb from Car", Car.class).mapKey(Car::new, "id", Identifier.class).map("model", Car::setModel).map("rgb", Vehicle::setColor, Integer.TYPE, Color::new);
            Set allCars = (Set)carExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)allCars).containsExactlyInAnyOrder((Object[])new Car[]{dummyCar});
        }

        private /* synthetic */ void lambda$mappedSuperClass_and_entityInheritance_throwsException$5(FluentEntityMappingBuilder mappingBuilder) throws Throwable {
            mappingBuilder.build(FluentEntityMappingConfigurationSupportInheritanceTest.this.persistenceContext);
        }

        private /* synthetic */ void lambda$withIdDefinedInSuperClass_severalTimes$1(FluentEntityMappingBuilder authorConfiguration) throws Throwable {
            authorConfiguration.build(FluentEntityMappingConfigurationSupportInheritanceTest.this.persistenceContext);
        }
    }

    @Nested
    class MappedSuperClass {
        MappedSuperClass() {
        }

        @Test
        void simpleCase() {
            MappedSuperClassData mappedSuperClassData = new MappedSuperClassData();
            EntityPersister carPersister = MappingEase.entityBuilder(Car.class, Identifier.LONG_TYPE).map(Car::getModel).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapSuperClass((EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Vehicle.class).map(Vehicle::getColor)).build(FluentEntityMappingConfigurationSupportInheritanceTest.this.persistenceContext);
            Collection tables = DDLDeployer.collectTables((PersistenceContext)FluentEntityMappingConfigurationSupportInheritanceTest.this.persistenceContext);
            Assertions.assertThat((boolean)tables.contains((Object)mappedSuperClassData.vehicleTable)).isFalse();
            Assertions.assertThat((Object)FluentEntityMappingConfigurationSupportInheritanceTest.this.persistenceContext.getPersister(Vehicle.class)).isNull();
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportInheritanceTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Car dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            dummyCar.setColor(new Color(666));
            carPersister.insert((Object)dummyCar);
            Set allCars = FluentEntityMappingConfigurationSupportInheritanceTest.this.persistenceContext.select(Car::new, ((MappedSuperClassData)mappedSuperClassData).carTable.idColumn, m -> m.add(((MappedSuperClassData)mappedSuperClassData).carTable.modelColumn, Car::setModel).add(((MappedSuperClassData)mappedSuperClassData).carTable.colorColumn, Vehicle::setColor));
            Assertions.assertThat((Collection)allCars).containsExactlyInAnyOrder((Object[])new Car[]{dummyCar});
            Car loadedCar = (Car)carPersister.select(new PersistedIdentifier<Long>(1L));
            Assertions.assertThat((Object)loadedCar).isEqualTo((Object)dummyCar);
        }

        @Test
        void simpleCase_withTableDefinedInSuperClass() {
            MappedSuperClassData mappedSuperClassData = new MappedSuperClassData();
            EntityPersister carPersister = MappingEase.entityBuilder(Car.class, Identifier.LONG_TYPE).map(Car::getModel).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapSuperClass((EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Vehicle.class).map(Vehicle::getColor)).build(FluentEntityMappingConfigurationSupportInheritanceTest.this.persistenceContext);
            Collection tables = DDLDeployer.collectTables((PersistenceContext)FluentEntityMappingConfigurationSupportInheritanceTest.this.persistenceContext);
            Assertions.assertThat((boolean)tables.contains((Object)mappedSuperClassData.vehicleTable)).isFalse();
            Assertions.assertThat((Object)FluentEntityMappingConfigurationSupportInheritanceTest.this.persistenceContext.getPersister(Vehicle.class)).isNull();
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportInheritanceTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Car dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            dummyCar.setColor(new Color(666));
            carPersister.insert((Object)dummyCar);
            Set allCars = FluentEntityMappingConfigurationSupportInheritanceTest.this.persistenceContext.select(Car::new, ((MappedSuperClassData)mappedSuperClassData).carTable.idColumn, m -> m.add(((MappedSuperClassData)mappedSuperClassData).carTable.modelColumn, Car::setModel).add(((MappedSuperClassData)mappedSuperClassData).carTable.colorColumn, Vehicle::setColor));
            Assertions.assertThat((Collection)allCars).containsExactlyInAnyOrder((Object[])new Car[]{dummyCar});
            Car loadedCar = (Car)carPersister.select(new PersistedIdentifier<Long>(1L));
            Assertions.assertThat((Object)loadedCar).isEqualTo((Object)dummyCar);
        }

        @Test
        void columnNamingStrategyChanged() {
            EntityPersister carPersister = MappingEase.entityBuilder(Car.class, Identifier.LONG_TYPE).map(Car::getModel).withColumnNaming(accessor -> ColumnNamingStrategy.DEFAULT.giveName(accessor) + "_col").mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapSuperClass((EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Vehicle.class).map(Vehicle::getColor)).build(FluentEntityMappingConfigurationSupportInheritanceTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportInheritanceTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Car dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            dummyCar.setColor(new Color(666));
            carPersister.insert((Object)dummyCar);
            PersistenceContext.ExecutableBeanPropertyQueryMapper carExecutableQuery = FluentEntityMappingConfigurationSupportInheritanceTest.this.persistenceContext.newQuery((CharSequence)"select id_col, model_col, color_col from Car", Car.class).mapKey(Car::new, "id_col", Identifier.class).map("model_col", Car::setModel).map("color_col", Vehicle::setColor);
            Set allCars = (Set)carExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)allCars).containsExactly((Object[])new Car[]{dummyCar});
            Car loadedCar = (Car)carPersister.select(new PersistedIdentifier<Long>(1L));
            Assertions.assertThat((Object)loadedCar).isEqualTo((Object)dummyCar);
        }

        @Test
        void columnNamingStrategyChanged_inParent() {
            EntityPersister carPersister = MappingEase.entityBuilder(Car.class, Identifier.LONG_TYPE).map(Car::getModel).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapSuperClass((EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Vehicle.class).map(Vehicle::getColor).withColumnNaming(accessor -> ColumnNamingStrategy.DEFAULT.giveName(accessor) + "_supercol")).build(FluentEntityMappingConfigurationSupportInheritanceTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportInheritanceTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Car dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            dummyCar.setColor(new Color(666));
            carPersister.insert((Object)dummyCar);
            PersistenceContext.ExecutableBeanPropertyQueryMapper carExecutableQuery = FluentEntityMappingConfigurationSupportInheritanceTest.this.persistenceContext.newQuery((CharSequence)"select id_supercol, model_supercol, color_supercol from Car", Car.class).mapKey(Car::new, "id_supercol", Identifier.class).map("model_supercol", Car::setModel).map("color_supercol", Vehicle::setColor);
            Set allCars = (Set)carExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)allCars).containsExactlyInAnyOrder((Object[])new Car[]{dummyCar});
            Car loadedCar = (Car)carPersister.select(new PersistedIdentifier<Long>(1L));
            Assertions.assertThat((Object)loadedCar).isEqualTo((Object)dummyCar);
        }

        @Test
        void columnNamingStrategyChanged_inBoth_lowestTakesPriority() {
            ColumnNamingStrategy columnNamingStrategy = accessor -> {
                if (accessor.getName().contains("Color")) {
                    return ColumnNamingStrategy.DEFAULT.giveName(accessor) + "_superCol";
                }
                return ColumnNamingStrategy.DEFAULT.giveName(accessor) + "_col";
            };
            EntityPersister carPersister = MappingEase.entityBuilder(Car.class, Identifier.LONG_TYPE).map(Car::getModel).withColumnNaming(columnNamingStrategy).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapSuperClass((EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Vehicle.class).map(Vehicle::getColor)).build(FluentEntityMappingConfigurationSupportInheritanceTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportInheritanceTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Car dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            dummyCar.setColor(new Color(666));
            carPersister.insert((Object)dummyCar);
            PersistenceContext.ExecutableBeanPropertyQueryMapper carExecutableQuery = FluentEntityMappingConfigurationSupportInheritanceTest.this.persistenceContext.newQuery((CharSequence)"select id_col, model_col, color_col from Car", Car.class).mapKey(Car::new, "id_col", Identifier.class).map("model_col", Car::setModel).map("color_col", Vehicle::setColor);
            Set allCars = (Set)carExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)allCars).containsExactlyInAnyOrder((Object[])new Car[]{dummyCar});
            Car loadedCar = (Car)carPersister.select(new PersistedIdentifier<Long>(1L));
            Assertions.assertThat((Object)loadedCar).isEqualTo((Object)dummyCar);
        }

        @Test
        void withoutIdDefined_throwsException() {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MappingEase.entityBuilder(Car.class, Identifier.LONG_TYPE).map(Car::getModel).map(Vehicle::getColor).mapSuperClass((EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Vehicle.class).map(Vehicle::getColor)).build(FluentEntityMappingConfigurationSupportInheritanceTest.this.persistenceContext)).isInstanceOf(UnsupportedOperationException.class)).hasMessage("Identifier is not defined for o.c.s.e.m.Car, please add one through o.c.s.e.FluentEntityMappingBuilder.mapKey(o.d.j.u.f.s.SerializableBiConsumer, o.c.s.e.ColumnOptions$IdentifierPolicy)");
        }

        @Test
        void withEmbeddable() {
            EntityPersister carPersister = MappingEase.entityBuilder(Car.class, Identifier.LONG_TYPE).map(Car::getModel).mapKey(AbstractVehicle::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapSuperClass((EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Vehicle.class).embed(Vehicle::getColor, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Color.class).map(Color::getRgb))).build(FluentEntityMappingConfigurationSupportInheritanceTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportInheritanceTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Car dummyCar = new Car(1L);
            dummyCar.setModel("Renault");
            dummyCar.setColor(new Color(666));
            carPersister.insert((Object)dummyCar);
            Car loadedCar = (Car)carPersister.select(new PersistedIdentifier<Long>(1L));
            Assertions.assertThat((Object)loadedCar).isEqualTo((Object)dummyCar);
            PersistenceContext.ExecutableBeanPropertyQueryMapper carExecutableQuery = FluentEntityMappingConfigurationSupportInheritanceTest.this.persistenceContext.newQuery((CharSequence)"select id, model, rgb from Car", Car.class).mapKey(Car::new, "id", Identifier.class).map("model", Car::setModel).map("rgb", Vehicle::setColor, Integer.TYPE, Color::new);
            Set allCars = (Set)carExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)allCars).containsExactlyInAnyOrder((Object[])new Car[]{dummyCar});
        }
    }
}

