/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.onetomany;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.codefilarete.stalactite.engine.diff.AbstractDiff;
import org.codefilarete.stalactite.engine.diff.IndexedDiff;
import org.codefilarete.stalactite.engine.listener.SelectListener;
import org.codefilarete.stalactite.engine.listener.SelectListenerCollection;
import org.codefilarete.stalactite.engine.runtime.CollectionUpdater;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.load.AbstractJoinNode;
import org.codefilarete.stalactite.engine.runtime.onetomany.IndexedMappedManyRelationDescriptor;
import org.codefilarete.stalactite.engine.runtime.onetomany.OneToManyWithMappedAssociationEngine;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.mapping.Mapping;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.ThreadLocals;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.IdentityMap;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.trace.ModifiableInt;

public class OneToManyWithIndexedMappedAssociationEngine<SRC, TRGT, SRCID, TRGTID, C extends Collection<TRGT>, RIGHTTABLE extends Table<RIGHTTABLE>>
extends OneToManyWithMappedAssociationEngine<SRC, TRGT, SRCID, TRGTID, C, RIGHTTABLE> {
    private final ThreadLocal<IdentityMap<TRGTID, Integer>> currentSelectedIndexes = new ThreadLocal();

    public OneToManyWithIndexedMappedAssociationEngine(ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister, IndexedMappedManyRelationDescriptor<SRC, TRGT, C, SRCID> manyRelationDefinition, ConfiguredRelationalPersister<SRC, SRCID> sourcePersister, Set<Column<RIGHTTABLE, ?>> mappedReverseColumns, Function<SRCID, Map<Column<RIGHTTABLE, ?>, Object>> reverseColumnsValueProvider) {
        super(targetPersister, manyRelationDefinition, sourcePersister, mappedReverseColumns, reverseColumnsValueProvider);
    }

    @Override
    public IndexedMappedManyRelationDescriptor<SRC, TRGT, C, SRCID> getManyRelationDescriptor() {
        return (IndexedMappedManyRelationDescriptor)this.manyRelationDescriptor;
    }

    @Override
    public <T1 extends Table<T1>, T2 extends Table<T2>> void addSelectCascade(Key<T1, SRCID> sourcePrimaryKey, boolean loadSeparately) {
        HashSet<Column<Table, Integer>> columnsToSelect = new HashSet<Column<Table, Integer>>((Collection<Column<Table, Integer>>)this.targetPersister.getMainTable().getPrimaryKey().getColumns());
        columnsToSelect.add(((IndexedMappedManyRelationDescriptor)this.getManyRelationDescriptor()).getIndexingColumn());
        String joinNodeName = this.targetPersister.joinAsMany(this.sourcePersister, sourcePrimaryKey, this.manyRelationDescriptor.getReverseColumn(), this.manyRelationDescriptor.getRelationFixer(), (row, columnedRow) -> {
            Object identifier = this.targetPersister.getMapping().getIdMapping().getIdentifierAssembler().assemble(row, columnedRow);
            Integer targetEntityIndex = (Integer)columnedRow.getValue(((IndexedMappedManyRelationDescriptor)this.getManyRelationDescriptor()).getIndexingColumn(), row);
            return identifier + "-" + targetEntityIndex;
        }, "ROOT", columnsToSelect, true, loadSeparately);
        this.addIndexSelection(joinNodeName);
        SelectListenerCollection targetSelectListener = this.targetPersister.getPersisterListener().getSelectListener();
        this.sourcePersister.addSelectListener(new SelectListener<SRC, SRCID>((SelectListener)targetSelectListener){
            final /* synthetic */ SelectListener val$targetSelectListener;
            {
                this.val$targetSelectListener = selectListener;
            }

            public void beforeSelect(Iterable<SRCID> ids) {
                this.val$targetSelectListener.beforeSelect(Collections.emptyList());
            }

            public void afterSelect(Set<? extends SRC> result) {
                Set collect = Iterables.stream(result).flatMap(src -> (Stream)Nullable.nullable(OneToManyWithIndexedMappedAssociationEngine.this.manyRelationDescriptor.getCollectionGetter().apply(src)).map(Collection::stream).getOr(Stream.empty())).collect(Collectors.toSet());
                this.val$targetSelectListener.afterSelect(collect);
            }

            public void onSelectError(Iterable<SRCID> ids, RuntimeException exception) {
                this.val$targetSelectListener.onSelectError(Collections.emptyList(), exception);
            }
        });
    }

    private void addIndexSelection(String joinNodeName) {
        this.sourcePersister.addSelectListener(new SelectListener<SRC, SRCID>(){

            public void beforeSelect(Iterable<SRCID> ids) {
                OneToManyWithIndexedMappedAssociationEngine.this.currentSelectedIndexes.set(new IdentityMap());
                IndexedMappedManyRelationDescriptor.InMemoryRelationHolder relationFixer = (IndexedMappedManyRelationDescriptor.InMemoryRelationHolder)OneToManyWithIndexedMappedAssociationEngine.this.manyRelationDescriptor.getRelationFixer();
                relationFixer.init();
            }

            public void afterSelect(Set<? extends SRC> result) {
                try {
                    result.forEach(src -> {
                        IndexedMappedManyRelationDescriptor.InMemoryRelationHolder relationFixer = (IndexedMappedManyRelationDescriptor.InMemoryRelationHolder)OneToManyWithIndexedMappedAssociationEngine.this.manyRelationDescriptor.getRelationFixer();
                        Collection relationCollection = (Collection)Nullable.nullable(relationFixer.get(src)).getOr(OneToManyWithIndexedMappedAssociationEngine.this.manyRelationDescriptor.getCollectionFactory().get());
                        IdentityMap indexPerTargetId = (IdentityMap)OneToManyWithIndexedMappedAssociationEngine.this.currentSelectedIndexes.get();
                        if (relationCollection instanceof List) {
                            ((List)relationCollection).sort(Comparator.comparingInt(target -> (Integer)indexPerTargetId.get(OneToManyWithIndexedMappedAssociationEngine.this.targetPersister.getId(target))));
                        } else if (relationCollection instanceof LinkedHashSet) {
                            TreeMap sorter = new TreeMap();
                            relationCollection.forEach(trgt -> sorter.put(indexPerTargetId.get(OneToManyWithIndexedMappedAssociationEngine.this.targetPersister.getId(trgt)), trgt));
                            relationCollection = (Collection)OneToManyWithIndexedMappedAssociationEngine.this.manyRelationDescriptor.getCollectionFactory().get();
                            relationCollection.addAll(sorter.values());
                        } else {
                            throw new UnsupportedOperationException("Index computation is not supported for " + Reflections.toString(relationCollection.getClass()));
                        }
                        OneToManyWithIndexedMappedAssociationEngine.this.manyRelationDescriptor.getCollectionSetter().accept(src, relationCollection);
                    });
                }
                finally {
                    this.cleanContext();
                }
            }

            public void onSelectError(Iterable<SRCID> ids, RuntimeException exception) {
                this.cleanContext();
            }

            private void cleanContext() {
                OneToManyWithIndexedMappedAssociationEngine.this.currentSelectedIndexes.remove();
                IndexedMappedManyRelationDescriptor.InMemoryRelationHolder relationFixer = (IndexedMappedManyRelationDescriptor.InMemoryRelationHolder)OneToManyWithIndexedMappedAssociationEngine.this.manyRelationDescriptor.getRelationFixer();
                relationFixer.clear();
            }
        });
        AbstractJoinNode join = (AbstractJoinNode)this.sourcePersister.getEntityJoinTree().getJoin(joinNodeName);
        join.setConsumptionListener((trgt, columnValueProvider) -> {
            IdentityMap<TRGTID, Integer> indexPerTargetId = this.currentSelectedIndexes.get();
            if (indexPerTargetId != null) {
                int index = (Integer)columnValueProvider.apply(((IndexedMappedManyRelationDescriptor)this.getManyRelationDescriptor()).getIndexingColumn());
                Object relationOwnerId = this.targetPersister.getMapping().getIdMapping().getIdentifierAssembler().assemble(columnValueProvider);
                indexPerTargetId.put(relationOwnerId, (Object)index);
            }
        });
    }

    @Override
    public void addInsertCascade() {
        this.addIndexInsertion();
        super.addInsertCascade();
    }

    private <TARGETTABLE extends Table<TARGETTABLE>> void addIndexInsertion() {
        final Function collectionGetter = this.manyRelationDescriptor.getCollectionGetter();
        Mapping.ShadowColumnValueProvider indexValueProvider = new Mapping.ShadowColumnValueProvider<TRGT, TARGETTABLE>(){

            public boolean accept(TRGT entity) {
                Object sourceEntity = OneToManyWithIndexedMappedAssociationEngine.this.giveRelationStorageContext().get(entity);
                return sourceEntity == null || OneToManyWithIndexedMappedAssociationEngine.this.sourcePersister.getMapping().getClassToPersist().isInstance(sourceEntity);
            }

            public Set<Column<TARGETTABLE, ?>> getColumns() {
                return Collections.singleton(((IndexedMappedManyRelationDescriptor)OneToManyWithIndexedMappedAssociationEngine.this.getManyRelationDescriptor()).getIndexingColumn());
            }

            public Map<Column<TARGETTABLE, ?>, Object> giveValue(TRGT target) {
                Object source = OneToManyWithIndexedMappedAssociationEngine.this.giveRelationStorageContext().get(target);
                Integer targetEntityIndex = source == null ? null : Integer.valueOf(this.computeTargetIndex(source, target));
                HashMap result = new HashMap();
                result.put(((IndexedMappedManyRelationDescriptor)OneToManyWithIndexedMappedAssociationEngine.this.getManyRelationDescriptor()).getIndexingColumn(), targetEntityIndex);
                return result;
            }

            private int computeTargetIndex(SRC source, TRGT target) {
                int result;
                Collection apply = (Collection)collectionGetter.apply(source);
                if (apply instanceof List) {
                    result = ((List)apply).indexOf(target) + 1;
                } else if (apply instanceof LinkedHashSet) {
                    ModifiableInt counter = new ModifiableInt(0);
                    for (Object o : apply) {
                        counter.increment();
                        if (o != target) continue;
                        break;
                    }
                    result = counter.getValue();
                } else {
                    throw new UnsupportedOperationException("Index computation is not supported for " + Reflections.toString(apply.getClass()));
                }
                return result;
            }
        };
        this.targetPersister.getMapping().addShadowColumnInsert(indexValueProvider);
        this.targetPersister.getMapping().addShadowColumnUpdate(indexValueProvider);
    }

    @Override
    protected void addTargetInstancesUpdateCascader(boolean shouldDeleteRemoved) {
        ListCollectionUpdater collectionUpdater = new ListCollectionUpdater(this.manyRelationDescriptor.getCollectionGetter(), this.targetPersister, this.manyRelationDescriptor.getReverseSetter(), shouldDeleteRemoved, arg_0 -> ((EntityMapping)this.targetPersister.getMapping()).getId(arg_0), ((IndexedMappedManyRelationDescriptor)this.getManyRelationDescriptor()).getIndexingColumn());
        this.sourcePersister.getPersisterListener().addUpdateListener(new OneToManyWithMappedAssociationEngine.AfterUpdateTrigger(collectionUpdater));
    }

    private static class ListCollectionUpdater<SRC, TRGT, ID, C extends Collection<TRGT>, TARGETTABLE extends Table<TARGETTABLE>>
    extends CollectionUpdater<SRC, TRGT, C> {
        private final ThreadLocal<Map<TRGT, Integer>> currentUpdatableListIndex = new ThreadLocal();
        private final ThreadLocal<Map<TRGT, Integer>> currentInsertableListIndex = new ThreadLocal();
        private final Column<TARGETTABLE, Integer> indexingColumn;

        private ListCollectionUpdater(Function<SRC, C> collectionGetter, ConfiguredRelationalPersister<TRGT, ID> targetPersister, @javax.annotation.Nullable BiConsumer<TRGT, SRC> reverseSetter, boolean shouldDeleteRemoved, Function<TRGT, ?> idProvider, Column<TARGETTABLE, Integer> indexingColumn) {
            super(collectionGetter, targetPersister, reverseSetter, shouldDeleteRemoved, idProvider);
            this.indexingColumn = indexingColumn;
            this.addShadowIndexInsert(targetPersister);
            this.addShadowIndexUpdate(targetPersister);
        }

        private void addShadowIndexUpdate(ConfiguredRelationalPersister<TRGT, ID> targetPersister) {
            targetPersister.getMapping().addShadowColumnInsert(new Mapping.ShadowColumnValueProvider<TRGT, TARGETTABLE>(){

                public boolean accept(TRGT entity) {
                    return currentUpdatableListIndex.get() != null && ((Map)currentUpdatableListIndex.get()).containsKey(entity);
                }

                public Set<Column<TARGETTABLE, ?>> getColumns() {
                    return Arrays.asHashSet((Object[])new Column[]{indexingColumn});
                }

                public Map<Column<TARGETTABLE, ?>, Object> giveValue(TRGT bean) {
                    HashMap result = new HashMap();
                    result.put(indexingColumn, ((Map)currentUpdatableListIndex.get()).get(bean));
                    return result;
                }
            });
        }

        private void addShadowIndexInsert(ConfiguredRelationalPersister<TRGT, ID> targetPersister) {
            targetPersister.getMapping().addShadowColumnInsert(new Mapping.ShadowColumnValueProvider<TRGT, TARGETTABLE>(){

                public boolean accept(TRGT entity) {
                    return currentInsertableListIndex.get() != null && ((Map)currentInsertableListIndex.get()).containsKey(entity);
                }

                public Set<Column<TARGETTABLE, ?>> getColumns() {
                    return Arrays.asHashSet((Object[])new Column[]{indexingColumn});
                }

                public Map<Column<TARGETTABLE, ?>, Object> giveValue(TRGT bean) {
                    HashMap result = new HashMap();
                    result.put(indexingColumn, ((Map)currentInsertableListIndex.get()).get(bean));
                    return result;
                }
            });
        }

        @Override
        protected Set<? extends AbstractDiff<TRGT>> diff(Collection<TRGT> modified, Collection<TRGT> unmodified) {
            return this.getDiffer().diffOrdered(unmodified, modified);
        }

        @Override
        protected CollectionUpdater.UpdateContext newUpdateContext(Duo<SRC, SRC> updatePayload) {
            return new IndexedMappedAssociationUpdateContext(updatePayload);
        }

        @Override
        protected void onAddedElements(CollectionUpdater.UpdateContext updateContext, AbstractDiff<TRGT> diff) {
            super.onAddedElements(updateContext, diff);
            this.addNewIndexToContext((IndexedDiff)diff, (IndexedMappedAssociationUpdateContext)updateContext);
        }

        @Override
        protected void onHeldElements(CollectionUpdater.UpdateContext updateContext, AbstractDiff<TRGT> diff) {
            super.onHeldElements(updateContext, diff);
            this.addNewIndexToContext((IndexedDiff)diff, (IndexedMappedAssociationUpdateContext)updateContext);
        }

        private void addNewIndexToContext(IndexedDiff<TRGT> diff, IndexedMappedAssociationUpdateContext updateContext) {
            Set minus = Iterables.minus(diff.getReplacerIndexes(), diff.getSourceIndexes());
            Integer index = (Integer)Iterables.first((Iterable)minus);
            if (index != null) {
                updateContext.getIndexUpdates().put(diff.getReplacingInstance(), index);
            }
        }

        @Override
        protected void insertTargets(CollectionUpdater.UpdateContext updateContext) {
            ThreadLocals.doWithThreadLocal(this.currentInsertableListIndex, ((IndexedMappedAssociationUpdateContext)updateContext)::getIndexUpdates, () -> super.insertTargets(updateContext));
        }

        @Override
        protected void updateTargets(CollectionUpdater.UpdateContext updateContext, boolean allColumnsStatement) {
            ThreadLocals.doWithThreadLocal(this.currentUpdatableListIndex, ((IndexedMappedAssociationUpdateContext)updateContext)::getIndexUpdates, () -> super.updateTargets(updateContext, allColumnsStatement));
        }

        class IndexedMappedAssociationUpdateContext
        extends CollectionUpdater.UpdateContext {
            private final Map<TRGT, Integer> indexUpdates;

            public IndexedMappedAssociationUpdateContext(Duo<SRC, SRC> updatePayload) {
                super(updatePayload);
                this.indexUpdates = new IdentityHashMap();
            }

            public Map<TRGT, Integer> getIndexUpdates() {
                return this.indexUpdates;
            }
        }
    }
}

