/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.onetomany;

import java.util.Collection;
import java.util.HashSet;
import org.codefilarete.stalactite.engine.AssociationTableNamingStrategy;
import org.codefilarete.stalactite.engine.CascadeOptions;
import org.codefilarete.stalactite.engine.ColumnNamingStrategy;
import org.codefilarete.stalactite.engine.ForeignKeyNamingStrategy;
import org.codefilarete.stalactite.engine.JoinColumnNamingStrategy;
import org.codefilarete.stalactite.engine.MappingConfigurationException;
import org.codefilarete.stalactite.engine.configurer.CascadeConfigurationResult;
import org.codefilarete.stalactite.engine.configurer.PersisterBuilderImpl;
import org.codefilarete.stalactite.engine.configurer.onetomany.OneToManyAssociationConfiguration;
import org.codefilarete.stalactite.engine.configurer.onetomany.OneToManyConfigurerTemplate;
import org.codefilarete.stalactite.engine.configurer.onetomany.OneToManyRelation;
import org.codefilarete.stalactite.engine.configurer.onetomany.OneToManyWithAssociationTableConfigurer;
import org.codefilarete.stalactite.engine.configurer.onetomany.OneToManyWithMappedAssociationConfigurer;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.StringAppender;
import org.codefilarete.tool.collection.Arrays;

public class OneToManyRelationConfigurer<SRC, TRGT, SRCID, TRGTID, C extends Collection<TRGT>> {
    private final OneToManyRelation<SRC, TRGT, TRGTID, C> oneToManyRelation;
    private final ConfiguredRelationalPersister<SRC, SRCID> sourcePersister;
    private final Dialect dialect;
    private final ConnectionConfiguration connectionConfiguration;
    private final ForeignKeyNamingStrategy foreignKeyNamingStrategy;
    private final JoinColumnNamingStrategy joinColumnNamingStrategy;
    private final AssociationTableNamingStrategy associationTableNamingStrategy;
    private final ColumnNamingStrategy indexColumnNamingStrategy;

    public OneToManyRelationConfigurer(OneToManyRelation<SRC, TRGT, TRGTID, C> oneToManyRelation, ConfiguredRelationalPersister<SRC, SRCID> sourcePersister, Dialect dialect, ConnectionConfiguration connectionConfiguration, ForeignKeyNamingStrategy foreignKeyNamingStrategy, JoinColumnNamingStrategy joinColumnNamingStrategy, AssociationTableNamingStrategy associationTableNamingStrategy, ColumnNamingStrategy indexColumnNamingStrategy) {
        this.oneToManyRelation = oneToManyRelation;
        this.sourcePersister = sourcePersister;
        this.dialect = dialect;
        this.connectionConfiguration = connectionConfiguration;
        this.foreignKeyNamingStrategy = foreignKeyNamingStrategy;
        this.joinColumnNamingStrategy = joinColumnNamingStrategy;
        this.associationTableNamingStrategy = associationTableNamingStrategy;
        this.indexColumnNamingStrategy = indexColumnNamingStrategy;
    }

    public <T extends Table<T>> void configure(PersisterBuilderImpl<TRGT, TRGTID> targetPersisterBuilder) {
        Table targetTable = this.determineTargetTable(this.oneToManyRelation);
        ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister = targetPersisterBuilder.build(this.dialect, this.connectionConfiguration, targetTable);
        this.configure(targetPersister);
    }

    public CascadeConfigurationResult<SRC, TRGT> configureWithSelectIn2Phases(String tableAlias, ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister, FirstPhaseCycleLoadListener<SRC, TRGTID> firstPhaseCycleLoadListener) {
        OneToManyConfigurerTemplate configurer;
        PrimaryKey<?, SRCID> leftPrimaryKey = this.lookupSourcePrimaryKey(this.sourcePersister);
        CascadeOptions.RelationMode maintenanceMode = this.oneToManyRelation.getRelationMode();
        boolean orphanRemoval = maintenanceMode == CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL;
        boolean writeAuthorized = maintenanceMode != CascadeOptions.RelationMode.READ_ONLY;
        String columnName = this.oneToManyRelation.getIndexingColumnName();
        OneToManyAssociationConfiguration associationConfiguration = new OneToManyAssociationConfiguration(this.oneToManyRelation, this.sourcePersister, leftPrimaryKey, this.foreignKeyNamingStrategy, this.joinColumnNamingStrategy, this.indexColumnNamingStrategy, columnName, orphanRemoval, writeAuthorized);
        if (this.oneToManyRelation.isOwnedByReverseSide()) {
            if (maintenanceMode == CascadeOptions.RelationMode.ASSOCIATION_ONLY) {
                throw new MappingConfigurationException((Object)((Object)CascadeOptions.RelationMode.ASSOCIATION_ONLY) + " is only relevant with an association table");
            }
            configurer = new OneToManyWithMappedAssociationConfigurer(associationConfiguration, targetPersister, this.oneToManyRelation.isFetchSeparately());
        } else {
            configurer = new OneToManyWithAssociationTableConfigurer(associationConfiguration, targetPersister, this.oneToManyRelation.isFetchSeparately(), this.associationTableNamingStrategy, maintenanceMode == CascadeOptions.RelationMode.ASSOCIATION_ONLY, this.dialect, this.connectionConfiguration);
        }
        return ((OneToManyConfigurerTemplate)configurer).configureWithSelectIn2Phases(tableAlias, firstPhaseCycleLoadListener);
    }

    void configure(ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister) {
        OneToManyConfigurerTemplate configurer;
        PrimaryKey<?, SRCID> leftPrimaryKey = this.lookupSourcePrimaryKey(this.sourcePersister);
        CascadeOptions.RelationMode maintenanceMode = this.oneToManyRelation.getRelationMode();
        boolean orphanRemoval = maintenanceMode == CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL;
        boolean writeAuthorized = maintenanceMode != CascadeOptions.RelationMode.READ_ONLY;
        String columnName = this.oneToManyRelation.getIndexingColumnName();
        OneToManyAssociationConfiguration associationConfiguration = new OneToManyAssociationConfiguration(this.oneToManyRelation, this.sourcePersister, leftPrimaryKey, this.foreignKeyNamingStrategy, this.joinColumnNamingStrategy, this.indexColumnNamingStrategy, columnName, orphanRemoval, writeAuthorized);
        if (this.oneToManyRelation.isOwnedByReverseSide()) {
            if (maintenanceMode == CascadeOptions.RelationMode.ASSOCIATION_ONLY) {
                throw new MappingConfigurationException((Object)((Object)CascadeOptions.RelationMode.ASSOCIATION_ONLY) + " is only relevant with an association table");
            }
            configurer = new OneToManyWithMappedAssociationConfigurer(associationConfiguration, targetPersister, this.oneToManyRelation.isFetchSeparately());
        } else {
            configurer = new OneToManyWithAssociationTableConfigurer(associationConfiguration, targetPersister, this.oneToManyRelation.isFetchSeparately(), this.associationTableNamingStrategy, maintenanceMode == CascadeOptions.RelationMode.ASSOCIATION_ONLY, this.dialect, this.connectionConfiguration);
        }
        ((OneToManyConfigurerTemplate)configurer).configure();
    }

    private Table determineTargetTable(OneToManyRelation<SRC, TRGT, TRGTID, C> oneToManyRelation) {
        Table reverseTable = (Table)Nullable.nullable(oneToManyRelation.getReverseColumn()).map(Column::getTable).get();
        Table indexingTable = (Table)Nullable.nullable(oneToManyRelation.getIndexingColumn()).map(Column::getTable).get();
        HashSet availableTables = Arrays.asHashSet((Object[])new Table[]{oneToManyRelation.getTargetTable(), reverseTable, indexingTable});
        availableTables.remove(null);
        if (availableTables.size() > 1) {
            class TableAppender
            extends StringAppender {
                TableAppender() {
                }

                public StringAppender cat(Object o) {
                    if (o instanceof Table) {
                        return super.cat((Object)((Table)o).getName());
                    }
                    return super.cat(o);
                }
            }
            throw new MappingConfigurationException("Different tables used for configuring mapping : " + new TableAppender().ccat(availableTables, ", "));
        }
        return (Table)Nullable.nullable((Object)oneToManyRelation.getTargetTable()).elseSet((Object)reverseTable).elseSet((Object)indexingTable).get();
    }

    protected PrimaryKey<?, SRCID> lookupSourcePrimaryKey(ConfiguredRelationalPersister<SRC, SRCID> sourcePersister) {
        return sourcePersister.getMapping().getTargetTable().getPrimaryKey();
    }

    @FunctionalInterface
    public static interface FirstPhaseCycleLoadListener<SRC, TRGTID> {
        public void onFirstPhaseRowRead(SRC var1, TRGTID var2);
    }
}

