/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.PropertyAccessor;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.stalactite.engine.VersioningStrategy;
import org.codefilarete.stalactite.engine.runtime.AbstractDMLExecutorMockTest;
import org.codefilarete.stalactite.engine.runtime.AbstractVersioningStrategy;
import org.codefilarete.stalactite.engine.runtime.DMLExecutorTest;
import org.codefilarete.stalactite.engine.runtime.ExtendedMapAssert;
import org.codefilarete.stalactite.engine.runtime.InsertExecutor;
import org.codefilarete.stalactite.mapping.AccessorWrapperIdAccessor;
import org.codefilarete.stalactite.mapping.ClassMapping;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.mapping.IdAccessor;
import org.codefilarete.stalactite.mapping.PersistentFieldHarvester;
import org.codefilarete.stalactite.mapping.id.manager.AlreadyAssignedIdentifierManager;
import org.codefilarete.stalactite.mapping.id.manager.IdentifierInsertionManager;
import org.codefilarete.stalactite.mapping.id.manager.JDBCGeneratedKeysIdentifierManager;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.DefaultDialect;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.TransactionAwareConnectionProvider;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.DMLGenerator;
import org.codefilarete.stalactite.sql.statement.GeneratedKeysReader;
import org.codefilarete.stalactite.sql.statement.SQLOperation;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.WriteOperationFactory;
import org.codefilarete.stalactite.sql.statement.binder.DefaultResultSetReaders;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinderIndex;
import org.codefilarete.stalactite.test.PairSetList;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.Maps;
import org.codefilarete.tool.collection.Sorter;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class InsertExecutorTest<T extends Table<T>>
extends AbstractDMLExecutorMockTest {
    private final Dialect dialect = new DefaultDialect(new JavaTypeToSqlTypeMapping().with(Integer.class, "int"));
    private InsertExecutor<DMLExecutorTest.Toto, Integer, T> testInstance;

    InsertExecutorTest() {
    }

    @BeforeEach
    void setUp() {
        DMLExecutorTest.PersistenceConfiguration persistenceConfiguration = InsertExecutorTest.giveDefaultPersistenceConfiguration();
        DMLGenerator dmlGenerator = new DMLGenerator((ParameterBinderIndex)this.dialect.getColumnBinderRegistry(), (Sorter)new DMLGenerator.CaseSensitiveSorter(), DMLNameProvider::new);
        this.testInstance = new InsertExecutor(persistenceConfiguration.classMappingStrategy, (ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport(this.jdbcMock.transactionManager, 3), dmlGenerator, this.noRowCountCheckWriteOperationFactory, 3);
    }

    @Test
    void insert_simpleCase() throws Exception {
        this.testInstance.insert((Iterable)Arrays.asList((Object[])new DMLExecutorTest.Toto[]{new DMLExecutorTest.Toto(17, 23), new DMLExecutorTest.Toto(29, 31), new DMLExecutorTest.Toto(37, 41), new DMLExecutorTest.Toto(43, 53)}));
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)4))).addBatch();
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)2))).executeLargeBatch();
        ((PreparedStatement)Mockito.verify((Object)this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)12))).setInt((Integer)this.jdbcMock.indexCaptor.capture(), (Integer)this.jdbcMock.valueCaptor.capture());
        Assertions.assertThat((String)((String)this.jdbcMock.sqlCaptor.getValue())).isEqualTo("insert into Toto(a, b, c) values (?, ?, ?)");
        PairSetList<Integer, Integer> expectedPairs = new PairSetList<Integer, Integer>().newRow(1, 1).add(2, 17).add(3, 23).newRow(1, 2).add(2, 29).add(3, 31).newRow(1, 3).add(2, 37).add(3, 41).newRow(1, 4).add(2, 43).add(3, 53);
        InsertExecutorTest.assertCapturedPairsEqual(this.jdbcMock, expectedPairs);
    }

    @Test
    void insert_mandatoryColumn() {
        Column bColumn = (Column)this.testInstance.getMapping().getTargetTable().mapColumnsOnName().get("b");
        bColumn.setNullable(false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.testInstance.insert((Iterable)Arrays.asList((Object[])new DMLExecutorTest.Toto[]{new DMLExecutorTest.Toto(null, 23)}))).isInstanceOf(RuntimeException.class)).hasMessage("Error while inserting values for Toto{a=1, b=null, c=23} in statement \"insert into Toto(a, b, c) values (?, ?, ?)\"").hasCause((Throwable)new SQLStatement.BindingException("Expected non null value for : Toto.b"));
    }

    @Test
    void insert_listenerIsCalled() {
        SQLOperation.SQLOperationListener listenerMock = (SQLOperation.SQLOperationListener)Mockito.mock(SQLOperation.SQLOperationListener.class);
        this.testInstance.setOperationListener(listenerMock);
        ArgumentCaptor statementArgCaptor = ArgumentCaptor.forClass(Map.class);
        ArgumentCaptor sqlArgCaptor = ArgumentCaptor.forClass(SQLStatement.class);
        this.testInstance.insert((Iterable)Arrays.asList((Object[])new DMLExecutorTest.Toto[]{new DMLExecutorTest.Toto(17, 23), new DMLExecutorTest.Toto(29, 31)}));
        Table mappedTable = new Table("Toto");
        Column colA = mappedTable.addColumn("a", Integer.class);
        Column colB = mappedTable.addColumn("b", Integer.class);
        Column colC = mappedTable.addColumn("c", Integer.class);
        ((SQLOperation.SQLOperationListener)Mockito.verify((Object)listenerMock, (VerificationMode)Mockito.times((int)2))).onValuesSet((Map)statementArgCaptor.capture());
        ExtendedMapAssert.assertThatMap((Map)statementArgCaptor.getAllValues().get(0)).usingElementPredicate((entry1, entry2) -> ((Column)entry1.getKey()).getAbsoluteName().equals(((Column)entry2.getKey()).getAbsoluteName()) && ((Integer)entry1.getValue()).equals(entry2.getValue())).containsExactlyInAnyOrder(new Map.Entry[]{Assertions.entry((Object)colA, (Object)1), Assertions.entry((Object)colB, (Object)17), Assertions.entry((Object)colC, (Object)23)});
        ExtendedMapAssert.assertThatMap((Map)statementArgCaptor.getAllValues().get(1)).usingElementPredicate((entry1, entry2) -> ((Column)entry1.getKey()).getAbsoluteName().equals(((Column)entry2.getKey()).getAbsoluteName()) && ((Integer)entry1.getValue()).equals(entry2.getValue())).containsExactlyInAnyOrder(new Map.Entry[]{Assertions.entry((Object)colA, (Object)2), Assertions.entry((Object)colB, (Object)29), Assertions.entry((Object)colC, (Object)31)});
        ((SQLOperation.SQLOperationListener)Mockito.verify((Object)listenerMock, (VerificationMode)Mockito.times((int)1))).onExecute((SQLStatement)sqlArgCaptor.capture());
        Assertions.assertThat((String)((SQLStatement)sqlArgCaptor.getValue()).getSQL()).isEqualTo("insert into Toto(a, b, c) values (?, ?, ?)");
    }

    @Test
    void insert_withVersioningStrategy() throws SQLException {
        DMLGenerator dmlGenerator = new DMLGenerator((ParameterBinderIndex)this.dialect.getColumnBinderRegistry(), (Sorter)new DMLGenerator.CaseSensitiveSorter(), DMLNameProvider::new);
        PreparedStatement preparedStatement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)preparedStatement.executeLargeBatch()).thenReturn((Object)new long[]{1L});
        Connection connection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)connection.prepareStatement(Mockito.anyString())).thenReturn((Object)preparedStatement);
        Mockito.when((Object)connection.prepareStatement(Mockito.anyString(), Mockito.anyInt())).thenReturn((Object)preparedStatement);
        ConnectionProvider connectionProviderMock = (ConnectionProvider)Mockito.mock(ConnectionProvider.class);
        Mockito.when((Object)connectionProviderMock.giveConnection()).thenReturn((Object)connection);
        TransactionAwareConnectionProvider connectionProvider = new TransactionAwareConnectionProvider(connectionProviderMock);
        Table totoTable = new Table("toto");
        Column pk = totoTable.addColumn("id", Integer.class).primaryKey();
        Column versionColumn = totoTable.addColumn("version", Long.class);
        Maps.ChainingHashMap mapping = Maps.forHashMap((Class)null, (Class)null).add((Object)PropertyAccessor.fromMethodReference(VersionnedToto::getVersion, VersionnedToto::setVersion), (Object)versionColumn).add((Object)PropertyAccessor.fromMethodReference(VersionnedToto::getA, VersionnedToto::setA), (Object)pk);
        InsertExecutor testInstance = new InsertExecutor((EntityMapping)new ClassMapping(VersionnedToto.class, totoTable, (Map)mapping, (ReversibleAccessor)PropertyAccessor.fromMethodReference(VersionnedToto::getA, VersionnedToto::setA), (IdentifierInsertionManager)new AlreadyAssignedIdentifierManager(Integer.class, c -> {}, c -> false)), (ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport((ConnectionProvider)connectionProvider, 3), dmlGenerator, new WriteOperationFactory(), 3);
        PropertyAccessor versioningAttributeAccessor = PropertyAccessor.fromMethodReference(VersionnedToto::getVersion, VersionnedToto::setVersion);
        testInstance.setVersioningStrategy((VersioningStrategy)new AbstractVersioningStrategy.VersioningStrategySupport(versioningAttributeAccessor, input -> {
            input = input + 1L;
            return input;
        }));
        VersionnedToto toto = new VersionnedToto(42, 17, 23);
        testInstance.insert((Iterable)Arrays.asList((Object[])new VersionnedToto[]{toto}));
        Assertions.assertThat((long)toto.getVersion()).isEqualTo(1L);
        testInstance.getConnectionProvider().giveConnection().rollback();
        Assertions.assertThat((long)toto.getVersion()).isEqualTo(0L);
        testInstance.getConnectionProvider().giveConnection().rollback();
        Assertions.assertThat((long)toto.getVersion()).isEqualTo(0L);
    }

    protected DMLExecutorTest.PersistenceConfiguration<DMLExecutorTest.Toto, Integer, T> giveAutoGeneratedKeysPersistenceConfiguration() {
        DMLExecutorTest.PersistenceConfiguration toReturn = new DMLExecutorTest.PersistenceConfiguration();
        Table targetTable = new Table("Toto");
        PersistentFieldHarvester persistentFieldHarvester = new PersistentFieldHarvester();
        Map mappedFileds = persistentFieldHarvester.mapFields(DMLExecutorTest.Toto.class, targetTable);
        PropertyAccessor primaryKeyAccessor = Accessors.propertyAccessor((Field)persistentFieldHarvester.getField("a"));
        Column primaryKeyColumn = persistentFieldHarvester.getColumn(primaryKeyAccessor);
        primaryKeyColumn.primaryKey();
        primaryKeyColumn.setAutoGenerated(true);
        JDBCGeneratedKeysIdentifierManager identifierGenerator = new JDBCGeneratedKeysIdentifierManager((IdAccessor)new AccessorWrapperIdAccessor((ReversibleAccessor)primaryKeyAccessor), (GeneratedKeysReader)new GeneratedKeysReaderAsInt(primaryKeyColumn.getName()), Integer.class);
        toReturn.classMappingStrategy = new ClassMapping(DMLExecutorTest.Toto.class, targetTable, mappedFileds, (ReversibleAccessor)primaryKeyAccessor, (IdentifierInsertionManager)identifierGenerator);
        toReturn.targetTable = targetTable;
        return toReturn;
    }

    public static class GeneratedKeysReaderAsInt
    extends GeneratedKeysReader<Integer> {
        public GeneratedKeysReaderAsInt(String keyName) {
            super(keyName, DefaultResultSetReaders.INTEGER_PRIMITIVE_READER);
        }
    }

    protected static class VersionnedToto
    extends DMLExecutorTest.Toto {
        protected long version;

        public VersionnedToto(int a, int b, int c) {
            super(a, b, c);
        }

        public Integer getA() {
            return this.a;
        }

        public void setA(Integer a) {
            this.a = a;
        }

        public long getVersion() {
            return this.version;
        }

        public void setVersion(long version) {
            this.version = version;
        }
    }

    @Nested
    public class InsertExecutorTest_autoGenerateKeys {
        @Test
        void insert_generatedPK() throws Exception {
            DMLExecutorTest.PersistenceConfiguration persistenceConfiguration = InsertExecutorTest.this.giveAutoGeneratedKeysPersistenceConfiguration();
            Mockito.when((Object)InsertExecutorTest.this.jdbcMock.connection.prepareStatement(Mockito.anyString(), Mockito.eq((int)1))).thenReturn((Object)InsertExecutorTest.this.jdbcMock.preparedStatement);
            ResultSet generatedKeyResultSetMock = (ResultSet)Mockito.mock(ResultSet.class);
            Mockito.when((Object)InsertExecutorTest.this.jdbcMock.preparedStatement.getGeneratedKeys()).thenReturn((Object)generatedKeyResultSetMock);
            Mockito.when((Object)generatedKeyResultSetMock.next()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, false, true, false});
            Mockito.when((Object)generatedKeyResultSetMock.getInt((String)Mockito.eq((Object)"a"))).thenReturn((Object)1, (Object[])new Integer[]{2, 3, 4});
            Mockito.when((Object)generatedKeyResultSetMock.getObject((String)Mockito.eq((Object)"a"))).thenReturn((Object)1, new Object[]{2, 3, 4});
            Mockito.when((Object)InsertExecutorTest.this.jdbcMock.connection.prepareStatement((String)InsertExecutorTest.this.jdbcMock.sqlCaptor.capture(), Mockito.eq((int)1))).thenReturn((Object)InsertExecutorTest.this.jdbcMock.preparedStatement);
            DMLGenerator dmlGenerator = new DMLGenerator((ParameterBinderIndex)InsertExecutorTest.this.dialect.getColumnBinderRegistry(), (Sorter)new DMLGenerator.CaseSensitiveSorter(), DMLNameProvider::new);
            InsertExecutor testInstance = new InsertExecutor(persistenceConfiguration.classMappingStrategy, (ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport(InsertExecutorTest.this.jdbcMock.transactionManager, 3), dmlGenerator, InsertExecutorTest.this.noRowCountCheckWriteOperationFactory, 3);
            List totoList = Arrays.asList((Object[])new DMLExecutorTest.Toto[]{new DMLExecutorTest.Toto(17, 23), new DMLExecutorTest.Toto(29, 31), new DMLExecutorTest.Toto(37, 41), new DMLExecutorTest.Toto(43, 53)});
            testInstance.insert((Iterable)totoList);
            ((PreparedStatement)Mockito.verify((Object)InsertExecutorTest.this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)4))).addBatch();
            ((PreparedStatement)Mockito.verify((Object)InsertExecutorTest.this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)2))).executeLargeBatch();
            ((PreparedStatement)Mockito.verify((Object)InsertExecutorTest.this.jdbcMock.preparedStatement, (VerificationMode)Mockito.times((int)8))).setInt((Integer)InsertExecutorTest.this.jdbcMock.indexCaptor.capture(), (Integer)InsertExecutorTest.this.jdbcMock.valueCaptor.capture());
            Assertions.assertThat((String)((String)InsertExecutorTest.this.jdbcMock.sqlCaptor.getValue())).isEqualTo("insert into Toto(a, b, c) values (default, ?, ?)");
            PairSetList<Integer, Integer> expectedPairs = new PairSetList<Integer, Integer>().newRow(1, 17).add(2, 23).newRow(1, 29).add(2, 31).newRow(1, 37).add(2, 41).newRow(1, 43).add(2, 53);
            AbstractDMLExecutorMockTest.assertCapturedPairsEqual(InsertExecutorTest.this.jdbcMock, expectedPairs);
            ((ResultSet)Mockito.verify((Object)generatedKeyResultSetMock, (VerificationMode)Mockito.times((int)6))).next();
            ((ResultSet)Mockito.verify((Object)generatedKeyResultSetMock, (VerificationMode)Mockito.times((int)4))).getInt((String)Mockito.eq((Object)"a"));
            Assertions.assertThat((List)Iterables.collectToList((Iterable)totoList, toto -> toto.a)).isEqualTo((Object)Arrays.asList((Object[])new Integer[]{1, 2, 3, 4}));
        }
    }
}

