/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.ddl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.codefilarete.stalactite.sql.DMLNameProviderFactory;
import org.codefilarete.stalactite.sql.ddl.DDLProvider;
import org.codefilarete.stalactite.sql.ddl.DDLTableGenerator;
import org.codefilarete.stalactite.sql.ddl.SqlTypeRegistry;
import org.codefilarete.stalactite.sql.ddl.structure.ForeignKey;
import org.codefilarete.stalactite.sql.ddl.structure.Index;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.ddl.structure.UniqueConstraint;
import org.codefilarete.tool.collection.Collections;
import org.codefilarete.tool.collection.KeepOrderSet;

public class DDLGenerator
implements DDLProvider {
    private Set<Table> tables = new KeepOrderSet();
    private Set<DDLProvider> ddlProviders = new KeepOrderSet();
    private DDLTableGenerator ddlTableGenerator;

    public DDLGenerator(SqlTypeRegistry sqlTypeRegistry, DMLNameProviderFactory dmlNameProviderFactory) {
        this.ddlTableGenerator = new DDLTableGenerator(sqlTypeRegistry, dmlNameProviderFactory);
    }

    public DDLGenerator(DDLTableGenerator ddlTableGenerator) {
        this.ddlTableGenerator = ddlTableGenerator;
    }

    public DDLTableGenerator getDdlTableGenerator() {
        return this.ddlTableGenerator;
    }

    public void setDdlTableGenerator(DDLTableGenerator ddlTableGenerator) {
        this.ddlTableGenerator = ddlTableGenerator;
    }

    public void setTables(Set<Table> tables) {
        this.tables = tables;
    }

    public void addTables(Collection<Table> tables) {
        this.tables.addAll(tables);
    }

    public void addTables(Table table, Table ... tables) {
        this.tables.add(table);
        this.tables.addAll(Arrays.asList(tables));
    }

    public void setDDLGenerators(Set<DDLProvider> ddlParticipants) {
        this.ddlProviders = ddlParticipants;
    }

    public void addDDLGenerators(DDLProvider ddlGenerator, DDLProvider ... ddlGenerators) {
        this.ddlProviders.add(ddlGenerator);
        this.ddlProviders.addAll(Arrays.asList(ddlGenerators));
    }

    @Override
    public List<String> getCreationScripts() {
        return Collections.cat((Collection[])new Collection[]{this.generateTableCreationScripts(), this.generateDDLParticipantsCreationScripts()});
    }

    protected List<String> generateDDLParticipantsCreationScripts() {
        ArrayList<String> participantsScripts = new ArrayList<String>();
        for (DDLProvider ddlProvider : this.ddlProviders) {
            participantsScripts.addAll(ddlProvider.getCreationScripts());
        }
        return participantsScripts;
    }

    protected List<String> generateTableCreationScripts() {
        ArrayList<String> tableCreationScripts = new ArrayList<String>();
        ArrayList<String> foreignKeysCreationScripts = new ArrayList<String>();
        ArrayList<String> indexesCreationScripts = new ArrayList<String>();
        ArrayList<String> uniqueConstraintsCreationScripts = new ArrayList<String>();
        for (Table table : this.tables) {
            tableCreationScripts.add(this.generateCreationScript(table));
            foreignKeysCreationScripts.addAll(this.getForeignKeyCreationScripts(table));
            indexesCreationScripts.addAll(this.generateIndexCreationScripts(table));
            uniqueConstraintsCreationScripts.addAll(this.generateUniqueConstraintCreationScripts(table));
        }
        return Collections.cat((Collection[])new Collection[]{tableCreationScripts, uniqueConstraintsCreationScripts, indexesCreationScripts, foreignKeysCreationScripts});
    }

    protected String generateCreationScript(Table table) {
        return this.ddlTableGenerator.generateCreateTable(table);
    }

    protected List<String> generateUniqueConstraintCreationScripts(Table<?> table) {
        ArrayList<String> uniqueConstraintCreationScripts = new ArrayList<String>();
        for (UniqueConstraint uniqueConstraint : table.getUniqueConstraints()) {
            uniqueConstraintCreationScripts.add(this.generateCreationScript(uniqueConstraint));
        }
        return uniqueConstraintCreationScripts;
    }

    protected List<String> generateIndexCreationScripts(Table<?> table) {
        ArrayList<String> indexesCreationScripts = new ArrayList<String>();
        for (Index index : table.getIndexes()) {
            indexesCreationScripts.add(this.generateCreationScript(index));
        }
        return indexesCreationScripts;
    }

    protected String generateCreationScript(UniqueConstraint uniqueConstraint) {
        return this.ddlTableGenerator.generateCreateUniqueConstraint(uniqueConstraint);
    }

    protected String generateCreationScript(Index index) {
        return this.ddlTableGenerator.generateCreateIndex(index);
    }

    protected List<String> getForeignKeyCreationScripts(Table<?> table) {
        ArrayList<String> foreignKeysCreationScripts = new ArrayList<String>();
        for (ForeignKey<?, ?, ?> foreignKey : table.getForeignKeys()) {
            foreignKeysCreationScripts.add(this.generateCreationScript(foreignKey));
        }
        return foreignKeysCreationScripts;
    }

    protected String generateCreationScript(ForeignKey foreignKey) {
        return this.ddlTableGenerator.generateCreateForeignKey(foreignKey);
    }

    @Override
    public List<String> getDropScripts() {
        return Collections.cat((Collection[])new Collection[]{this.generateTableDropScripts(), this.generateDDLParticipantsDropScripts()});
    }

    protected List<String> generateTableDropScripts() {
        ArrayList<String> tableCreationScripts = new ArrayList<String>();
        for (Table table : this.tables) {
            tableCreationScripts.add(this.ddlTableGenerator.generateDropTable(table));
        }
        return tableCreationScripts;
    }

    protected List<String> generateDDLParticipantsDropScripts() {
        ArrayList<String> participantsScripts = new ArrayList<String>();
        for (DDLProvider ddlProvider : this.ddlProviders) {
            List<String> dropScripts = ddlProvider.getDropScripts();
            if (Collections.isEmpty(dropScripts)) continue;
            participantsScripts.addAll(dropScripts);
        }
        return participantsScripts;
    }
}

