/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.listener;

import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.codefilarete.stalactite.engine.listener.DeleteByIdListener;
import org.codefilarete.stalactite.engine.listener.DeleteByIdListenerCollection;
import org.codefilarete.stalactite.engine.listener.DeleteListener;
import org.codefilarete.stalactite.engine.listener.DeleteListenerCollection;
import org.codefilarete.stalactite.engine.listener.InsertListener;
import org.codefilarete.stalactite.engine.listener.InsertListenerCollection;
import org.codefilarete.stalactite.engine.listener.PersistListener;
import org.codefilarete.stalactite.engine.listener.PersistListenerCollection;
import org.codefilarete.stalactite.engine.listener.PersisterListener;
import org.codefilarete.stalactite.engine.listener.SelectListener;
import org.codefilarete.stalactite.engine.listener.SelectListenerCollection;
import org.codefilarete.stalactite.engine.listener.UpdateByIdListener;
import org.codefilarete.stalactite.engine.listener.UpdateByIdListenerCollection;
import org.codefilarete.stalactite.engine.listener.UpdateListener;
import org.codefilarete.stalactite.engine.listener.UpdateListenerCollection;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.function.ThrowingExecutable;
import org.codefilarete.tool.function.ThrowingRunnable;

public class PersisterListenerCollection<C, I>
implements PersisterListener<C, I> {
    private final PersistListenerCollection<C> persistListener = new PersistListenerCollection();
    private final InsertListenerCollection<C> insertListener = new InsertListenerCollection();
    private final UpdateByIdListenerCollection<C> updateByIdListener = new UpdateByIdListenerCollection();
    private final UpdateListenerCollection<C> updateListener = new UpdateListenerCollection();
    private final DeleteListenerCollection<C> deleteListener = new DeleteListenerCollection();
    private final DeleteByIdListenerCollection<C> deleteByIdListener = new DeleteByIdListenerCollection();
    private final SelectListenerCollection<C, I> selectListener = new SelectListenerCollection();

    public InsertListenerCollection<C> getInsertListener() {
        return this.insertListener;
    }

    @Override
    public void addPersistListener(PersistListener<? extends C> persistListener) {
        this.persistListener.add(persistListener);
    }

    public <R> R doWithPersistListener(Iterable<? extends C> entities, ThrowingExecutable<R, RuntimeException> delegate) {
        Object result;
        try {
            this.persistListener.beforePersist(entities);
            result = delegate.execute();
            this.persistListener.afterPersist(entities);
        }
        catch (RuntimeException e) {
            this.persistListener.onPersistError(entities, e);
            throw e;
        }
        return (R)result;
    }

    public void doWithPersistListener(Iterable<? extends C> entities, ThrowingRunnable<RuntimeException> delegate) {
        try {
            this.persistListener.beforePersist(entities);
            delegate.run();
            this.persistListener.afterPersist(entities);
        }
        catch (RuntimeException e) {
            this.persistListener.onPersistError(entities, e);
            throw e;
        }
    }

    @Override
    public void addInsertListener(InsertListener<? extends C> insertListener) {
        this.insertListener.add(insertListener);
    }

    public <R> R doWithInsertListener(Iterable<? extends C> entities, ThrowingExecutable<R, RuntimeException> delegate) {
        Object result;
        try {
            this.insertListener.beforeInsert(entities);
            result = delegate.execute();
            this.insertListener.afterInsert(entities);
        }
        catch (RuntimeException e) {
            this.insertListener.onInsertError(entities, e);
            throw e;
        }
        return (R)result;
    }

    public void doWithInsertListener(Iterable<? extends C> entities, ThrowingRunnable<RuntimeException> delegate) {
        try {
            this.insertListener.beforeInsert(entities);
            delegate.run();
            this.insertListener.afterInsert(entities);
        }
        catch (RuntimeException e) {
            this.insertListener.onInsertError(entities, e);
            throw e;
        }
    }

    public UpdateByIdListenerCollection<C> getUpdateByIdListener() {
        return this.updateByIdListener;
    }

    @Override
    public void addUpdateByIdListener(UpdateByIdListener<? extends C> updateByIdListener) {
        this.updateByIdListener.add(updateByIdListener);
    }

    public <R> R doWithUpdateByIdListener(Iterable<? extends C> entities, ThrowingExecutable<R, RuntimeException> delegate) {
        Object result;
        try {
            this.updateByIdListener.beforeUpdateById(entities);
            result = delegate.execute();
            this.updateByIdListener.afterUpdateById(entities);
        }
        catch (RuntimeException e) {
            this.updateByIdListener.onUpdateError(entities, e);
            throw e;
        }
        return (R)result;
    }

    public void doWithUpdateByIdListener(Iterable<? extends C> entities, ThrowingRunnable<RuntimeException> delegate) {
        try {
            this.updateByIdListener.beforeUpdateById(entities);
            delegate.run();
            this.updateByIdListener.afterUpdateById(entities);
        }
        catch (RuntimeException e) {
            this.updateByIdListener.onUpdateError(entities, e);
            throw e;
        }
    }

    public UpdateListenerCollection<C> getUpdateListener() {
        return this.updateListener;
    }

    @Override
    public void addUpdateListener(UpdateListener<? extends C> updateListener) {
        this.updateListener.add(updateListener);
    }

    public <R, T extends Table<T>> R doWithUpdateListener(Iterable<? extends Duo<C, C>> differencesIterable, boolean allColumnsStatement, BiFunction<Iterable<? extends Duo<C, C>>, Boolean, R> delegate) {
        R result;
        try {
            this.updateListener.beforeUpdate((Iterable<Duo<C, C>>)differencesIterable, allColumnsStatement);
            result = delegate.apply(differencesIterable, allColumnsStatement);
            this.updateListener.afterUpdate((Iterable<Duo<C, C>>)differencesIterable, allColumnsStatement);
        }
        catch (RuntimeException e) {
            this.updateListener.onUpdateError((Iterable<C>)Iterables.collectToList(differencesIterable, Duo::getLeft), e);
            throw e;
        }
        return result;
    }

    public <T extends Table<T>> void doWithUpdateListener(Iterable<? extends Duo<C, C>> differencesIterable, boolean allColumnsStatement, BiConsumer<Iterable<? extends Duo<C, C>>, Boolean> delegate) {
        try {
            this.updateListener.beforeUpdate((Iterable<Duo<C, C>>)differencesIterable, allColumnsStatement);
            delegate.accept(differencesIterable, allColumnsStatement);
            this.updateListener.afterUpdate((Iterable<Duo<C, C>>)differencesIterable, allColumnsStatement);
        }
        catch (RuntimeException e) {
            this.updateListener.onUpdateError((Iterable<C>)Iterables.collectToList(differencesIterable, Duo::getLeft), e);
            throw e;
        }
    }

    public DeleteListenerCollection<C> getDeleteListener() {
        return this.deleteListener;
    }

    public DeleteByIdListenerCollection<C> getDeleteByIdListener() {
        return this.deleteByIdListener;
    }

    @Override
    public void addDeleteListener(DeleteListener<? extends C> deleteListener) {
        this.deleteListener.add(deleteListener);
    }

    public <R> R doWithDeleteListener(Iterable<? extends C> entities, ThrowingExecutable<R, RuntimeException> delegate) {
        Object result;
        try {
            this.deleteListener.beforeDelete(entities);
            result = delegate.execute();
            this.deleteListener.afterDelete(entities);
        }
        catch (RuntimeException e) {
            this.deleteListener.onDeleteError(entities, e);
            throw e;
        }
        return (R)result;
    }

    public void doWithDeleteListener(Iterable<? extends C> entities, ThrowingRunnable<RuntimeException> delegate) {
        try {
            this.deleteListener.beforeDelete(entities);
            delegate.run();
            this.deleteListener.afterDelete(entities);
        }
        catch (RuntimeException e) {
            this.deleteListener.onDeleteError(entities, e);
            throw e;
        }
    }

    @Override
    public void addDeleteByIdListener(DeleteByIdListener<? extends C> deleteByIdListener) {
        this.deleteByIdListener.add(deleteByIdListener);
    }

    public <R> R doWithDeleteByIdListener(Iterable<? extends C> entities, ThrowingExecutable<R, RuntimeException> delegate) {
        Object result;
        try {
            this.deleteByIdListener.beforeDeleteById(entities);
            result = delegate.execute();
            this.deleteByIdListener.afterDeleteById(entities);
        }
        catch (RuntimeException e) {
            this.deleteByIdListener.onDeleteError(entities, e);
            throw e;
        }
        return (R)result;
    }

    public void doWithDeleteByIdListener(Iterable<? extends C> entities, ThrowingRunnable<RuntimeException> delegate) {
        try {
            this.deleteByIdListener.beforeDeleteById(entities);
            delegate.run();
            this.deleteByIdListener.afterDeleteById(entities);
        }
        catch (RuntimeException e) {
            this.deleteByIdListener.onDeleteError(entities, e);
            throw e;
        }
    }

    public SelectListenerCollection<C, I> getSelectListener() {
        return this.selectListener;
    }

    @Override
    public void addSelectListener(SelectListener<? extends C, I> selectListener) {
        this.selectListener.add(selectListener);
    }

    public Set<C> doWithSelectListener(Iterable<I> ids, ThrowingExecutable<Set<C>, RuntimeException> delegate) {
        Set result;
        try {
            this.selectListener.beforeSelect(ids);
            result = (Set)delegate.execute();
            this.selectListener.afterSelect(result);
        }
        catch (RuntimeException e) {
            this.selectListener.onSelectError(ids, e);
            throw e;
        }
        return result;
    }

    public void moveTo(PersisterListenerCollection<C, I> persisterListener) {
        this.insertListener.moveTo(persisterListener.insertListener);
        this.updateByIdListener.moveTo(persisterListener.updateByIdListener);
        this.updateListener.moveTo(persisterListener.updateListener);
        this.deleteListener.moveTo(persisterListener.deleteListener);
        this.deleteByIdListener.moveTo(persisterListener.deleteByIdListener);
        this.selectListener.moveTo(persisterListener.selectListener);
    }
}

