/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.order;

import java.util.LinkedHashSet;
import java.util.Set;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.Criteria;
import org.codefilarete.stalactite.query.model.CriteriaChain;
import org.codefilarete.stalactite.query.model.UnvaluedVariable;
import org.codefilarete.stalactite.query.model.ValuedVariable;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;

public class Update<T extends Table<T>> {
    private final T targetTable;
    private final Set<UpdateColumn<T>> columns = new LinkedHashSet<UpdateColumn<T>>();
    private final Criteria<?> criteriaSurrogate = new Criteria();

    public Update(T targetTable) {
        this.targetTable = targetTable;
    }

    public T getTargetTable() {
        return this.targetTable;
    }

    public Criteria getCriteria() {
        return this.criteriaSurrogate;
    }

    public Update<T> set(Column<T, ?> column) {
        this.columns.add(new UpdateColumn<T>(column));
        return this;
    }

    public <C> Update<T> set(Column<T, C> column, C value) {
        this.columns.add(new UpdateColumn<T>(column, new ValuedVariable<C>(value)));
        return this;
    }

    public <C> Update<T> set(Column<T, C> column1, Column<?, C> column2) {
        this.columns.add(new UpdateColumn<T>(column1, column2));
        return this;
    }

    public Set<UpdateColumn<T>> getColumns() {
        return this.columns;
    }

    public CriteriaChain where(Column<T, ?> column, String condition) {
        return this.criteriaSurrogate.and(column, condition);
    }

    public CriteriaChain where(Column<T, ?> column, ConditionalOperator condition) {
        return this.criteriaSurrogate.and(column, condition);
    }

    public static class UpdateColumn<T extends Table<T>> {
        public static final UnvaluedVariable<Object, Object> PLACEHOLDER = new UnvaluedVariable("?", Object.class);
        private final Column<T, Object> column;
        private final Object value;

        public UpdateColumn(Column<T, ?> column) {
            this(column, PLACEHOLDER);
        }

        public <C> UpdateColumn(Column<T, C> column, Object value) {
            this.column = column;
            this.value = value;
        }

        public Column<T, Object> getColumn() {
            return this.column;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

