/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query.model;

import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.UnvaluedVariable;
import org.codefilarete.stalactite.query.model.operator.Between;
import org.codefilarete.stalactite.query.model.operator.Cast;
import org.codefilarete.stalactite.query.model.operator.Coalesce;
import org.codefilarete.stalactite.query.model.operator.Count;
import org.codefilarete.stalactite.query.model.operator.Equals;
import org.codefilarete.stalactite.query.model.operator.Greater;
import org.codefilarete.stalactite.query.model.operator.In;
import org.codefilarete.stalactite.query.model.operator.IsNull;
import org.codefilarete.stalactite.query.model.operator.Lesser;
import org.codefilarete.stalactite.query.model.operator.Like;
import org.codefilarete.stalactite.query.model.operator.LowerCase;
import org.codefilarete.stalactite.query.model.operator.Max;
import org.codefilarete.stalactite.query.model.operator.Min;
import org.codefilarete.stalactite.query.model.operator.SQLFunction;
import org.codefilarete.stalactite.query.model.operator.Substring;
import org.codefilarete.stalactite.query.model.operator.Sum;
import org.codefilarete.stalactite.query.model.operator.Trim;
import org.codefilarete.stalactite.query.model.operator.UpperCase;

public interface Operators {
    public static <O> Equals<O> eq(O value) {
        return new Equals<O>(value);
    }

    public static <I extends ConditionalOperator> I not(I operator) {
        operator.not();
        return operator;
    }

    public static <O> Lesser<O> lt(O value) {
        return new Lesser<O>(value);
    }

    public static <O> Lesser<O> lteq(O value) {
        return new Lesser<O>(value, true);
    }

    public static <O> Greater<O> gt(O value) {
        return new Greater<O>(value);
    }

    public static <O> Greater<O> gteq(O value) {
        return new Greater<O>(value, true);
    }

    public static <O> Between<O> between(O value1, O value2) {
        return new Between<O>(value1, value2);
    }

    public static <O> In<O> in(Iterable<O> value) {
        return new In<O>(value);
    }

    public static <O> In<O> in(O ... value) {
        return new In<O>(value);
    }

    public static IsNull isNull() {
        return new IsNull();
    }

    public static IsNull isNotNull() {
        return Operators.not(Operators.isNull());
    }

    public static <V extends CharSequence> Trim<V> trim(V value) {
        return new Trim<V>(value);
    }

    public static <V extends CharSequence> Trim<Selectable<V>> trim(Selectable<V> value) {
        return new Trim<Selectable<V>>(value);
    }

    public static <V extends CharSequence> Trim<SQLFunction<?, CharSequence>> trim(SQLFunction<?, CharSequence> value) {
        return new Trim(value);
    }

    public static <V extends CharSequence> UpperCase<V> upperCase(V value) {
        return new UpperCase<V>(value);
    }

    public static <V extends CharSequence> UpperCase<Selectable<V>> upperCase(Selectable<V> value) {
        return new UpperCase<Selectable<V>>(value);
    }

    public static <V extends CharSequence> UpperCase<SQLFunction<?, V>> upperCase(SQLFunction<?, V> value) {
        return new UpperCase(value);
    }

    public static <V extends CharSequence> LowerCase<V> lowerCase(V value) {
        return new LowerCase<V>(value);
    }

    public static <V extends CharSequence> LowerCase<Selectable<V>> lowerCase(Selectable<V> value) {
        return new LowerCase<Selectable<V>>(value);
    }

    public static <V extends CharSequence> LowerCase<SQLFunction<?, V>> lowerCase(SQLFunction<?, V> value) {
        return new LowerCase(value);
    }

    public static <V extends CharSequence> Substring<V> substring(V value, int from) {
        return new Substring<V>(value, from);
    }

    public static <V extends CharSequence> Substring<V> substring(V value, int from, int to) {
        return new Substring<V>(value, from, to);
    }

    public static <V extends CharSequence> Substring<V> substring(Selectable<V> value, int from) {
        return new Substring<Selectable<V>>(value, from);
    }

    public static <V extends CharSequence> Substring<V> substring(Selectable<V> value, int from, int to) {
        return new Substring<Selectable<V>>(value, from, to);
    }

    public static <V extends CharSequence> Substring<V> substring(SQLFunction<?, V> value, int from) {
        return new Substring<V>(value, from);
    }

    public static <V extends CharSequence> Substring<V> substring(SQLFunction<?, V> value, int from, int to) {
        return new Substring<V>(value, from, to);
    }

    public static <V extends CharSequence> Like<V> like(V value) {
        return new Like<V>(value);
    }

    public static <V extends CharSequence> Like<SQLFunction<?, V>> like(SQLFunction<?, V> value) {
        return new Like(value);
    }

    public static <V extends CharSequence> Like<V> contains(V value) {
        return new Like<V>(value, true, true);
    }

    public static <V extends CharSequence> Like<SQLFunction<?, V>> contains(SQLFunction<?, V> value) {
        return new Like(value, true, true);
    }

    public static <V extends CharSequence> Like<V> startsWith(V value) {
        return new Like<V>(value, false, true);
    }

    public static <V extends CharSequence> Like<SQLFunction<?, V>> startsWith(SQLFunction<?, V> value) {
        return new Like(value, false, true);
    }

    public static <V extends CharSequence> Like<V> endsWith(V value) {
        return new Like<V>(value, true, false);
    }

    public static <V extends CharSequence> Like<SQLFunction<?, V>> endsWith(SQLFunction<?, V> value) {
        return new Like(value, true, false);
    }

    public static <N extends Number> Sum<N> sum(Selectable<N> column) {
        return new Sum<N>(column);
    }

    public static Count count(Selectable<?> ... columns) {
        return new Count(columns);
    }

    public static Count count(Iterable<? extends Selectable<?>> columns) {
        return new Count(columns);
    }

    public static <N extends Number> Min<N> min(Selectable<N> column) {
        return new Min<N>(column);
    }

    public static <N extends Number> Max<N> max(Selectable<N> column) {
        return new Max<N>(column);
    }

    public static <O> Cast<?, O> cast(String expression, Class<O> javaType) {
        return new Cast(expression, javaType);
    }

    public static <C, O> Cast<C, O> cast(Selectable<C> expression, Class<O> javaType) {
        return new Cast(expression, javaType);
    }

    public static <C> Coalesce<C> coalesce(Selectable<C> column, Selectable<C> ... columns) {
        return new Coalesce<C>(column, (Object[])columns);
    }

    public static <T, V> ConditionalOperator<T, V> arg(String name, ConditionalOperator<T, V> delegate, Class<T> type) {
        delegate.setValue(new UnvaluedVariable(name, type));
        return delegate;
    }

    public static <T> ConditionalOperator<T, T> equalsArgNamed(String name, Class<T> type) {
        return Operators.arg(name, new Equals(), type);
    }

    public static <T> ConditionalOperator<T, Iterable<T>> inArgNamed(String name, Class<T> type) {
        return Operators.arg(name, new In(), type);
    }

    public static <T extends CharSequence> ConditionalOperator<T, T> likeArgNamed(String name, Class<T> type) {
        return Operators.arg(name, new Like(), type);
    }

    public static <T extends CharSequence> ConditionalOperator<T, T> containsArgNamed(String name, Class<T> type) {
        return Operators.arg(name, Like.contains(), type);
    }

    public static <T extends CharSequence> ConditionalOperator<T, T> startsWithArgNamed(String name, Class<T> type) {
        return Operators.arg(name, Like.startsWith(), type);
    }

    public static <T extends CharSequence> ConditionalOperator<T, T> endsWithArgNamed(String name, Class<T> type) {
        return Operators.arg(name, Like.endsWith(), type);
    }

    public static <T> ConditionalOperator<T, T> isLesserThanArgNamed(String name, Class<T> type) {
        return Operators.arg(name, new Lesser(), type);
    }

    public static <T> ConditionalOperator<T, T> isLesserOrEqualsThanArgNamed(String name, Class<T> type) {
        return Operators.arg(name, new Lesser().equals(), type);
    }

    public static <T> ConditionalOperator<T, T> isGreaterThanArgNamed(String name, Class<T> type) {
        return Operators.arg(name, new Greater().equals(), type);
    }

    public static <T> ConditionalOperator<T, T> isGreaterOrEqualsThanArgNamed(String name, Class<T> type) {
        return Operators.arg(name, new Greater().equals(), type);
    }

    public static <T> ConditionalOperator<T, Between.Interval<T>> isBetweenArgNamed(String name, Class<T> type) {
        return Operators.arg(name, new Between(), type);
    }
}

