/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query.builder;

import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.query.builder.ExpandableSQLAppender;
import org.codefilarete.stalactite.query.builder.FunctionSQLBuilderFactory;
import org.codefilarete.stalactite.query.builder.OperatorSQLBuilderFactory;
import org.codefilarete.stalactite.query.builder.PreparableSQLBuilder;
import org.codefilarete.stalactite.query.builder.SQLAppender;
import org.codefilarete.stalactite.query.builder.SQLBuilder;
import org.codefilarete.stalactite.query.builder.StringSQLAppender;
import org.codefilarete.stalactite.query.model.AbstractCriterion;
import org.codefilarete.stalactite.query.model.ColumnCriterion;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.CriteriaChain;
import org.codefilarete.stalactite.query.model.LogicalOperator;
import org.codefilarete.stalactite.query.model.RawCriterion;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.Variable;
import org.codefilarete.stalactite.query.model.operator.BiOperandOperator;
import org.codefilarete.stalactite.query.model.operator.SQLFunction;
import org.codefilarete.stalactite.query.model.operator.TupleIn;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.StringAppender;

public class WhereSQLBuilderFactory {
    public static final String AND = "and";
    public static final String OR = "or";
    private final ColumnBinderRegistry parameterBinderRegistry;
    private final OperatorSQLBuilderFactory operatorSqlBuilderFactory;
    private final FunctionSQLBuilderFactory functionSQLBuilderFactory;

    public WhereSQLBuilderFactory(JavaTypeToSqlTypeMapping javaTypeToSqlTypeMapping, ColumnBinderRegistry parameterBinderRegistry) {
        this(parameterBinderRegistry, new OperatorSQLBuilderFactory(), new FunctionSQLBuilderFactory(javaTypeToSqlTypeMapping));
    }

    public WhereSQLBuilderFactory(ColumnBinderRegistry parameterBinderRegistry, OperatorSQLBuilderFactory operatorSqlBuilderFactory, FunctionSQLBuilderFactory functionSQLBuilderFactory) {
        this.parameterBinderRegistry = parameterBinderRegistry;
        this.operatorSqlBuilderFactory = operatorSqlBuilderFactory;
        this.functionSQLBuilderFactory = functionSQLBuilderFactory;
    }

    public WhereSQLBuilder whereBuilder(CriteriaChain where, DMLNameProvider dmlNameProvider) {
        FunctionSQLBuilderFactory.FunctionSQLBuilder functionSQLBuilder = this.functionSQLBuilderFactory.functionSQLBuilder(dmlNameProvider);
        return new WhereSQLBuilder(where, dmlNameProvider, this.parameterBinderRegistry, this.operatorSqlBuilderFactory.operatorSQLBuilder(functionSQLBuilder), functionSQLBuilder);
    }

    public static class WhereSQLBuilder
    implements SQLBuilder,
    PreparableSQLBuilder {
        private final CriteriaChain where;
        private final DMLNameProvider dmlNameProvider;
        private final ColumnBinderRegistry parameterBinderRegistry;
        private final OperatorSQLBuilderFactory.OperatorSQLBuilder operatorSqlBuilder;
        private final FunctionSQLBuilderFactory.FunctionSQLBuilder functionSQLBuilder;

        public WhereSQLBuilder(CriteriaChain where, DMLNameProvider dmlNameProvider, ColumnBinderRegistry parameterBinderRegistry, OperatorSQLBuilderFactory.OperatorSQLBuilder operatorSqlBuilder, FunctionSQLBuilderFactory.FunctionSQLBuilder functionSQLBuilder) {
            this.where = where;
            this.dmlNameProvider = dmlNameProvider;
            this.parameterBinderRegistry = parameterBinderRegistry;
            this.operatorSqlBuilder = operatorSqlBuilder;
            this.functionSQLBuilder = functionSQLBuilder;
        }

        @Override
        public String toSQL() {
            return this.appendTo(new StringAppender());
        }

        public String appendTo(StringAppender sql) {
            this.appendTo(new StringSQLAppender(sql, this.dmlNameProvider));
            return sql.toString();
        }

        public void appendTo(SQLAppender sql) {
            WhereAppender whereAppender = new WhereAppender(sql, this.dmlNameProvider, this.operatorSqlBuilder, this.functionSQLBuilder);
            whereAppender.cat(this.where);
        }

        @Override
        public ExpandableSQLAppender toPreparableSQL() {
            ExpandableSQLAppender preparedSQLAppender = new ExpandableSQLAppender(this.parameterBinderRegistry, this.dmlNameProvider);
            this.appendTo(preparedSQLAppender);
            return preparedSQLAppender;
        }

        public class WhereAppender {
            private final SQLAppender sql;
            private final OperatorSQLBuilderFactory.OperatorSQLBuilder operatorSqlBuilder;
            private final FunctionSQLBuilderFactory.FunctionSQLBuilder functionSQLBuilder;
            private final DMLNameProvider dmlNameProvider;

            public WhereAppender(SQLAppender sql, DMLNameProvider dmlNameProvider, OperatorSQLBuilderFactory.OperatorSQLBuilder operatorSqlBuilder, FunctionSQLBuilderFactory.FunctionSQLBuilder functionSQLBuilder) {
                this.sql = sql;
                this.operatorSqlBuilder = operatorSqlBuilder;
                this.functionSQLBuilder = functionSQLBuilder;
                this.dmlNameProvider = dmlNameProvider;
            }

            public void cat(CriteriaChain criteria) {
                boolean isNotFirst = false;
                for (Object criterion : criteria) {
                    if (isNotFirst) {
                        this.cat(((AbstractCriterion)criterion).getOperator());
                    } else {
                        isNotFirst = true;
                    }
                    this.cat(criterion);
                }
            }

            private void cat(Object o) {
                if (o instanceof CharSequence) {
                    this.sql.cat(o.toString(), new String[0]);
                } else if (o instanceof CriteriaChain) {
                    this.sql.cat("(", new String[0]);
                    this.cat((CriteriaChain)o);
                    this.sql.cat(")", new String[0]);
                } else if (o instanceof RawCriterion) {
                    for (Object conditionItem : ((RawCriterion)o).getCondition()) {
                        this.catConditionItem(conditionItem);
                    }
                } else if (o instanceof ColumnCriterion) {
                    this.cat((ColumnCriterion)o);
                }
            }

            private void catConditionItem(Object conditionItem) {
                if (conditionItem instanceof ColumnCriterion) {
                    this.cat((ColumnCriterion)conditionItem);
                } else if (conditionItem instanceof CharSequence) {
                    this.sql.cat(conditionItem.toString(), new String[0]);
                } else if (conditionItem instanceof CriteriaChain) {
                    this.sql.cat("(", new String[0]);
                    this.cat((CriteriaChain)conditionItem);
                    this.sql.cat(")", new String[0]);
                } else if (conditionItem instanceof SQLFunction) {
                    this.cat((SQLFunction)conditionItem);
                } else if (conditionItem instanceof Selectable) {
                    this.cat((Selectable)conditionItem);
                } else if (conditionItem instanceof TupleIn) {
                    this.catTupledIn((TupleIn)conditionItem);
                } else if (conditionItem instanceof ConditionalOperator) {
                    this.cat((ConditionalOperator)conditionItem);
                } else {
                    throw new UnsupportedOperationException("Unknown criterion type " + Reflections.toString(conditionItem.getClass()));
                }
            }

            public void cat(ColumnCriterion criterion) {
                Object condition = criterion.getCondition();
                if (condition instanceof BiOperandOperator) {
                    this.cat(criterion.getColumn(), (BiOperandOperator)condition);
                } else {
                    this.cat(criterion.getColumn());
                    this.sql.cat(" ", new String[0]);
                    if (condition instanceof CharSequence) {
                        this.sql.cat(condition.toString(), new String[0]);
                    } else if (condition instanceof ConditionalOperator) {
                        this.cat(criterion.getColumn(), (ConditionalOperator)condition);
                    } else {
                        try {
                            WhereSQLBuilder.this.parameterBinderRegistry.getBinder(condition.getClass());
                        }
                        catch (SQLStatement.BindingException e) {
                            throw new IllegalArgumentException("Unknown criterion type " + Reflections.toString(condition.getClass()));
                        }
                        this.sql.catValue((Variable)condition);
                    }
                }
            }

            public void cat(Selectable column) {
                this.sql.cat(this.dmlNameProvider.getName(column), new String[0]);
            }

            public void cat(LogicalOperator operator) {
                if (operator != null) {
                    this.sql.cat(" ", this.getName(operator), " ");
                }
            }

            public void cat(Selectable c, BiOperandOperator operator) {
                for (Object o : operator.asRawCriterion(c)) {
                    this.catConditionItem(o);
                    this.sql.cat(" ", new String[0]);
                }
                this.sql.removeLastChars(1);
            }

            public void cat(ConditionalOperator operator) {
                this.operatorSqlBuilder.cat(operator, this.sql);
            }

            public void catTupledIn(TupleIn operator) {
                this.operatorSqlBuilder.catTupledIn(operator, this.sql);
            }

            public void cat(SQLFunction sqlFunction) {
                this.functionSQLBuilder.cat(sqlFunction, this.sql);
            }

            public void cat(Selectable column, ConditionalOperator operator) {
                this.operatorSqlBuilder.cat(column, operator, this.sql);
            }

            public String getName(LogicalOperator operator) {
                switch (operator) {
                    case AND: {
                        return WhereSQLBuilderFactory.AND;
                    }
                    case OR: {
                        return WhereSQLBuilderFactory.OR;
                    }
                }
                throw new IllegalArgumentException("Operator " + (Object)((Object)operator) + " is unknown");
            }
        }
    }
}

