/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query.builder;

import java.util.Set;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.query.builder.ExpandableSQLAppender;
import org.codefilarete.stalactite.query.builder.PreparableSQLBuilder;
import org.codefilarete.stalactite.query.builder.QuerySQLBuilderFactory;
import org.codefilarete.stalactite.query.builder.SQLAppender;
import org.codefilarete.stalactite.query.builder.SQLBuilder;
import org.codefilarete.stalactite.query.builder.StringSQLAppender;
import org.codefilarete.stalactite.query.model.Query;
import org.codefilarete.stalactite.query.model.QueryStatement;
import org.codefilarete.tool.StringAppender;

public class PseudoTableSQLBuilderFactory {
    private static final String UNION_ALL_SEPARATOR = " union all ";

    public PseudoTableSQLBuilder pseudoTableBuilder(QueryStatement union, QuerySQLBuilderFactory querySQLBuilderFactory) {
        return new PseudoTableSQLBuilder(union, querySQLBuilderFactory);
    }

    public static class PseudoTableSQLBuilder
    implements SQLBuilder,
    PreparableSQLBuilder {
        private final QueryStatement queryStatement;
        private final QuerySQLBuilderFactory querySQLBuilderFactory;

        public PseudoTableSQLBuilder(QueryStatement queryStatement, QuerySQLBuilderFactory querySQLBuilderFactory) {
            this.queryStatement = queryStatement;
            this.querySQLBuilderFactory = querySQLBuilderFactory;
        }

        @Override
        public CharSequence toSQL() {
            StringAppender result = new StringAppender(500);
            this.appendTo(new StringSQLAppender(result, new DMLNameProvider(this.queryStatement.getAliases()::get)));
            return result.toString();
        }

        @Override
        public ExpandableSQLAppender toPreparableSQL() {
            ExpandableSQLAppender expandableSQLAppender = new ExpandableSQLAppender(this.querySQLBuilderFactory.getParameterBinderRegistry(), new DMLNameProvider(this.queryStatement.getAliases()::get));
            this.appendTo(expandableSQLAppender);
            return expandableSQLAppender;
        }

        public void appendTo(SQLAppender preparedSQLAppender) {
            Set<Query> queries = this.queryStatement.getQueries();
            queries.forEach(query -> {
                this.querySQLBuilderFactory.queryBuilder((Query)query).appendTo(preparedSQLAppender);
                preparedSQLAppender.cat(PseudoTableSQLBuilderFactory.UNION_ALL_SEPARATOR, new String[0]);
            });
            preparedSQLAppender.removeLastChars(PseudoTableSQLBuilderFactory.UNION_ALL_SEPARATOR.length());
        }

        private class UnionGenerator {
            private final SQLAppender sqlAppender;

            private UnionGenerator(SQLAppender sqlAppender) {
                this.sqlAppender = sqlAppender;
            }

            private void cat(Query query) {
                QuerySQLBuilderFactory.QuerySQLBuilder unionBuilder = PseudoTableSQLBuilder.this.querySQLBuilderFactory.queryBuilder(query);
                unionBuilder.appendTo(this.sqlAppender);
            }
        }
    }
}

