/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query.builder;

import javax.annotation.Nullable;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.query.builder.SQLAppender;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.ValuedVariable;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.tool.StringAppender;

public class StringSQLAppender
implements SQLAppender {
    private final StringAppender delegate;
    private final DMLNameProvider dmlNameProvider;

    public StringSQLAppender(StringAppender stringAppender, DMLNameProvider dmlNameProvider) {
        this.delegate = stringAppender;
        this.dmlNameProvider = dmlNameProvider;
    }

    @Override
    public StringSQLAppender cat(String s, String ... ss) {
        this.delegate.cat((Object)s).cat((Object[])ss);
        return this;
    }

    @Override
    public <V> StringSQLAppender catValue(@Nullable Selectable<V> column, Object value) {
        return this.catValue(value);
    }

    @Override
    public StringSQLAppender catValue(Object value) {
        if (value instanceof ValuedVariable) {
            value = ((ValuedVariable)value).getValue();
        }
        if (value instanceof CharSequence) {
            this.delegate.cat((Object)"'", (Object)value.toString().replace("'", "''"), (Object)"'");
        } else if (value instanceof Column) {
            this.delegate.cat((Object)this.dmlNameProvider.getName((Column)value));
        } else {
            this.delegate.cat(value);
        }
        return this;
    }

    @Override
    public StringSQLAppender catColumn(Column column) {
        this.delegate.cat((Object)this.dmlNameProvider.getName(column));
        return this;
    }

    @Override
    public SQLAppender removeLastChars(int length) {
        this.delegate.cutTail(length);
        return this;
    }

    @Override
    public String getSQL() {
        return this.delegate.toString();
    }
}

