/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query.builder;

import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.query.builder.FunctionSQLBuilderFactory;
import org.codefilarete.stalactite.query.builder.SQLAppender;
import org.codefilarete.stalactite.query.builder.StringSQLAppender;
import org.codefilarete.stalactite.query.model.Operators;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.operator.Cast;
import org.codefilarete.stalactite.query.model.operator.Coalesce;
import org.codefilarete.stalactite.query.model.operator.Count;
import org.codefilarete.stalactite.query.model.operator.Max;
import org.codefilarete.stalactite.query.model.operator.Min;
import org.codefilarete.stalactite.query.model.operator.SQLFunction;
import org.codefilarete.stalactite.query.model.operator.Sum;
import org.codefilarete.stalactite.sql.ddl.DefaultTypeMapping;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.StringAppender;
import org.junit.jupiter.api.Test;

class FunctionSQLBuilderTest {
    private final DMLNameProvider dmlNameProvider = new DMLNameProvider(Collections.emptyMap());

    FunctionSQLBuilderTest() {
    }

    @Test
    public void catCount() {
        FunctionSQLBuilderFactory.FunctionSQLBuilder testInstance = new FunctionSQLBuilderFactory.FunctionSQLBuilder(this.dmlNameProvider, (JavaTypeToSqlTypeMapping)new DefaultTypeMapping());
        StringAppender result = new StringAppender();
        Table tableToto = new Table("Toto");
        Column colA = tableToto.addColumn("a", Integer.class);
        testInstance.cat((SQLFunction)new Count(new Selectable[]{colA}), (SQLAppender)new StringSQLAppender(result, this.dmlNameProvider));
        Assertions.assertThat((String)result.toString()).isEqualTo("count(Toto.a)");
        result = new StringAppender();
        testInstance.cat((SQLFunction)new Count(new Selectable[]{colA}).distinct(), (SQLAppender)new StringSQLAppender(result, this.dmlNameProvider));
        Assertions.assertThat((String)result.toString()).isEqualTo("count(distinct Toto.a)");
    }

    @Test
    public void catMin() {
        FunctionSQLBuilderFactory.FunctionSQLBuilder testInstance = new FunctionSQLBuilderFactory.FunctionSQLBuilder(this.dmlNameProvider, (JavaTypeToSqlTypeMapping)new DefaultTypeMapping());
        StringAppender result = new StringAppender();
        Table tableToto = new Table("Toto");
        Column colA = tableToto.addColumn("a", Integer.class);
        testInstance.cat((SQLFunction)new Min((Selectable)colA), (SQLAppender)new StringSQLAppender(result, this.dmlNameProvider));
        Assertions.assertThat((String)result.toString()).isEqualTo("min(Toto.a)");
    }

    @Test
    public void catMax() {
        FunctionSQLBuilderFactory.FunctionSQLBuilder testInstance = new FunctionSQLBuilderFactory.FunctionSQLBuilder(this.dmlNameProvider, (JavaTypeToSqlTypeMapping)new DefaultTypeMapping());
        StringAppender result = new StringAppender();
        Table tableToto = new Table("Toto");
        Column colA = tableToto.addColumn("a", Integer.class);
        testInstance.cat((SQLFunction)new Max((Selectable)colA), (SQLAppender)new StringSQLAppender(result, this.dmlNameProvider));
        Assertions.assertThat((String)result.toString()).isEqualTo("max(Toto.a)");
    }

    @Test
    public void catSum() {
        FunctionSQLBuilderFactory.FunctionSQLBuilder testInstance = new FunctionSQLBuilderFactory.FunctionSQLBuilder(this.dmlNameProvider, (JavaTypeToSqlTypeMapping)new DefaultTypeMapping());
        StringAppender result = new StringAppender();
        Table tableToto = new Table("Toto");
        Column colA = tableToto.addColumn("a", Integer.class);
        testInstance.cat((SQLFunction)new Sum((Selectable)colA), (SQLAppender)new StringSQLAppender(result, this.dmlNameProvider));
        Assertions.assertThat((String)result.toString()).isEqualTo("sum(Toto.a)");
    }

    @Test
    public void catCast() {
        FunctionSQLBuilderFactory.FunctionSQLBuilder testInstance = new FunctionSQLBuilderFactory.FunctionSQLBuilder(this.dmlNameProvider, (JavaTypeToSqlTypeMapping)new DefaultTypeMapping());
        StringAppender result = new StringAppender();
        testInstance.cat((SQLFunction)new Cast("toto", Integer.class), (SQLAppender)new StringSQLAppender(result, this.dmlNameProvider));
        Assertions.assertThat((String)result.toString()).isEqualTo("cast(toto as integer)");
    }

    @Test
    public void catCast_null() {
        FunctionSQLBuilderFactory.FunctionSQLBuilder testInstance = new FunctionSQLBuilderFactory.FunctionSQLBuilder(this.dmlNameProvider, (JavaTypeToSqlTypeMapping)new DefaultTypeMapping());
        StringAppender result = new StringAppender();
        testInstance.cat((SQLFunction)new Cast((String)null, Integer.class), (SQLAppender)new StringSQLAppender(result, this.dmlNameProvider));
        Assertions.assertThat((String)result.toString()).isEqualTo("cast(null as integer)");
    }

    @Test
    public void catCast_function() {
        FunctionSQLBuilderFactory.FunctionSQLBuilder testInstance = new FunctionSQLBuilderFactory.FunctionSQLBuilder(this.dmlNameProvider, (JavaTypeToSqlTypeMapping)new DefaultTypeMapping());
        StringAppender result = new StringAppender();
        Table tableToto = new Table("Toto");
        Column colA = tableToto.addColumn("a", Integer.class, Integer.valueOf(128));
        testInstance.cat((SQLFunction)new Cast((Selectable)new Max((Selectable)colA), Integer.class), (SQLAppender)new StringSQLAppender(result, this.dmlNameProvider));
        Assertions.assertThat((String)result.toString()).isEqualTo("cast(max(Toto.a) as integer)");
    }

    @Test
    public void catCast_typeWithSize() {
        FunctionSQLBuilderFactory.FunctionSQLBuilder testInstance = new FunctionSQLBuilderFactory.FunctionSQLBuilder(this.dmlNameProvider, (JavaTypeToSqlTypeMapping)new DefaultTypeMapping());
        StringAppender result = new StringAppender();
        Table tableToto = new Table("Toto");
        Column colA = tableToto.addColumn("a", String.class, Integer.valueOf(128));
        testInstance.cat((SQLFunction)new Cast((Selectable)colA, String.class, Integer.valueOf(128)), (SQLAppender)new StringSQLAppender(result, this.dmlNameProvider));
        Assertions.assertThat((String)result.toString()).isEqualTo("cast(Toto.a as varchar(128))");
    }

    @Test
    public void coalesce() {
        FunctionSQLBuilderFactory.FunctionSQLBuilder testInstance = new FunctionSQLBuilderFactory.FunctionSQLBuilder(this.dmlNameProvider, (JavaTypeToSqlTypeMapping)new DefaultTypeMapping());
        StringAppender result = new StringAppender();
        Table tableToto = new Table("Toto");
        Column colA = tableToto.addColumn("a", String.class);
        Column colB = tableToto.addColumn("b", String.class);
        StringSQLAppender sql = new StringSQLAppender(result, this.dmlNameProvider);
        testInstance.cat((SQLFunction)new Coalesce((Selectable)colA, new Object[]{colB}), (SQLAppender)sql);
        Assertions.assertThat((String)result.toString()).isEqualTo("coalesce(Toto.a, Toto.b)");
    }

    @Test
    public void combining_functions() {
        FunctionSQLBuilderFactory.FunctionSQLBuilder testInstance = new FunctionSQLBuilderFactory.FunctionSQLBuilder(this.dmlNameProvider, (JavaTypeToSqlTypeMapping)new DefaultTypeMapping());
        Table tableToto = new Table("Toto");
        Column colA = tableToto.addColumn("a", Integer.class);
        Column colB = tableToto.addColumn("b", String.class);
        StringAppender result = new StringAppender();
        StringSQLAppender sql = new StringSQLAppender(result, this.dmlNameProvider);
        testInstance.cat((SQLFunction)new Coalesce((Selectable)colA, new Object[]{new Cast((Selectable)colB, String.class)}), (SQLAppender)sql);
        Assertions.assertThat((String)result.toString()).isEqualTo("coalesce(Toto.a, cast(Toto.b as varchar))");
        result = new StringAppender();
        sql = new StringSQLAppender(result, this.dmlNameProvider);
        testInstance.cat((SQLFunction)new Max((Selectable)new Coalesce((Selectable)colA, new Object[]{new Cast((Selectable)colB, String.class)})), (SQLAppender)sql);
        Assertions.assertThat((String)result.toString()).isEqualTo("max(coalesce(Toto.a, cast(Toto.b as varchar)))");
        result = new StringAppender();
        sql = new StringSQLAppender(result, this.dmlNameProvider);
        testInstance.cat((SQLFunction)Operators.substring((Selectable)colB, (int)2, (int)30), (SQLAppender)sql);
        Assertions.assertThat((String)result.toString()).isEqualTo("substring(Toto.b, 2, 30)");
        result = new StringAppender();
        sql = new StringSQLAppender(result, this.dmlNameProvider);
        testInstance.cat((SQLFunction)Operators.substring((SQLFunction)Operators.cast((Selectable)colA, String.class), (int)2, (int)30), (SQLAppender)sql);
        Assertions.assertThat((String)result.toString()).isEqualTo("substring(cast(Toto.a as varchar), 2, 30)");
    }
}

