/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query.builder;

import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.query.builder.ExpandableSQLAppender;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.UnvaluedVariable;
import org.codefilarete.stalactite.query.model.ValuedVariable;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.PreparedSQL;
import org.codefilarete.stalactite.sql.statement.SQLParameterParser;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;
import org.codefilarete.tool.StringAppender;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Maps;
import org.junit.jupiter.api.Test;

class ExpandableSQLAppenderTest {
    ExpandableSQLAppenderTest() {
    }

    @Test
    void catValue() {
        Table totoTable = new Table("Toto");
        Column nameCol = totoTable.addColumn("name", String.class);
        ExpandableSQLAppender testInstance = new ExpandableSQLAppender(new ColumnBinderRegistry(), new DMLNameProvider(totoTable.getAliases()::get));
        testInstance.cat("select * from Toto where id = ", new String[0]).catValue((Object)new ValuedVariable((Object)42)).cat(" and name = ", new String[0]).catValue((Selectable)nameCol, (Object)new UnvaluedVariable("name", String.class));
        Assertions.assertThat((String)testInstance.getSQL()).isEqualTo("select * from Toto where id = :1 and name = :name");
        Assertions.assertThat((List)testInstance.getParsedSQL().getSqlSnippets()).extracting(sqlSnippet -> sqlSnippet instanceof StringAppender ? sqlSnippet.toString() : sqlSnippet).containsExactly(new Object[]{"select * from Toto where id = ", new SQLParameterParser.Parameter("1"), " and name = ", new SQLParameterParser.Parameter("name"), ""});
        Assertions.assertThat((Map)testInstance.getValues()).containsAllEntriesOf((Map)Maps.forHashMap(String.class, Object.class).add((Object)"1", (Object)42));
    }

    @Test
    void toPreparedSQL() {
        Table totoTable = new Table("Toto");
        Column nameCol = totoTable.addColumn("name", String.class);
        ExpandableSQLAppender testInstance = new ExpandableSQLAppender(new ColumnBinderRegistry(), new DMLNameProvider(totoTable.getAliases()::get));
        testInstance.cat("select * from Toto where id = ", new String[0]).catValue((Object)new ValuedVariable((Object)42)).cat(" and name = ", new String[0]).catValue((Selectable)nameCol, (Object)new UnvaluedVariable("name", String.class));
        PreparedSQL preparedSQL = testInstance.toPreparedSQL((Map)Maps.forHashMap(String.class, Object.class).add((Object)"name", (Object)"John Doe"));
        Assertions.assertThat((String)preparedSQL.getSQL()).isEqualTo("select * from Toto where id = ? and name = ?");
        Assertions.assertThat((Map)preparedSQL.getValues()).isEqualTo((Object)Maps.forHashMap(Integer.class, Object.class).add((Object)1, (Object)42).add((Object)2, (Object)"John Doe"));
        preparedSQL = testInstance.toPreparedSQL((Map)Maps.forHashMap(String.class, Object.class).add((Object)"1", (Object)77).add((Object)"name", (Object)"John Doe"));
        Assertions.assertThat((String)preparedSQL.getSQL()).isEqualTo("select * from Toto where id = ? and name = ?");
        Assertions.assertThat((Map)preparedSQL.getValues()).isEqualTo((Object)Maps.forHashMap(Integer.class, Object.class).add((Object)1, (Object)77).add((Object)2, (Object)"John Doe"));
        preparedSQL = testInstance.toPreparedSQL((Map)Maps.forHashMap(String.class, Object.class).add((Object)"1", (Object)Arrays.asList((Object[])new Integer[]{42, 77})).add((Object)"name", (Object)"John Doe"));
        Assertions.assertThat((String)preparedSQL.getSQL()).isEqualTo("select * from Toto where id = ?, ? and name = ?");
        Assertions.assertThat((Map)preparedSQL.getValues()).isEqualTo((Object)Maps.forHashMap(Integer.class, Object.class).add((Object)1, (Object)42).add((Object)2, (Object)77).add((Object)3, (Object)"John Doe"));
        preparedSQL = testInstance.toPreparedSQL((Map)Maps.forHashMap(String.class, Object.class).add((Object)"1", (Object)new ValuedVariable((Object)Arrays.asList((Object[])new Integer[]{42, 77}))).add((Object)"name", (Object)new ValuedVariable((Object)"John Doe")));
        Assertions.assertThat((String)preparedSQL.getSQL()).isEqualTo("select * from Toto where id = ?, ? and name = ?");
        Assertions.assertThat((Map)preparedSQL.getValues()).isEqualTo((Object)Maps.forHashMap(Integer.class, Object.class).add((Object)1, (Object)42).add((Object)2, (Object)77).add((Object)3, (Object)"John Doe"));
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> testInstance.toPreparedSQL((Map)Maps.forHashMap(String.class, Object.class).add((Object)"1", (Object)new ValuedVariable((Object)Arrays.asList((Object[])new Integer[]{42, 77}))))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Size is not given for parameter name hence expansion is not possible");
    }

    @Test
    void toPreparedSQL_severalTimeSameVariable() {
        Table totoTable = new Table("Toto");
        Column nameCol = totoTable.addColumn("name", String.class);
        ExpandableSQLAppender testInstance = new ExpandableSQLAppender(new ColumnBinderRegistry(), new DMLNameProvider(totoTable.getAliases()::get));
        testInstance.cat("select * from Toto where id = ", new String[0]).catValue((Object)new ValuedVariable((Object)42)).cat(" and name = ", new String[0]).catValue((Selectable)nameCol, (Object)new UnvaluedVariable("name", String.class)).cat(" or id = ", new String[0]).catValue((Object)new ValuedVariable((Object)77)).cat(" and name = ", new String[0]).catValue((Selectable)nameCol, (Object)new UnvaluedVariable("name", String.class));
        PreparedSQL preparedSQL = testInstance.toPreparedSQL((Map)Maps.forHashMap(String.class, Object.class).add((Object)"name", (Object)"John Doe"));
        Assertions.assertThat((String)preparedSQL.getSQL()).isEqualTo("select * from Toto where id = ? and name = ? or id = ? and name = ?");
        Assertions.assertThat((Map)preparedSQL.getValues()).isEqualTo((Object)Maps.forHashMap(Integer.class, Object.class).add((Object)1, (Object)42).add((Object)2, (Object)"John Doe").add((Object)3, (Object)77).add((Object)4, (Object)"John Doe"));
    }
}

