/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query.builder;

import java.util.Iterator;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.query.builder.ExpandableSQLAppender;
import org.codefilarete.stalactite.query.builder.PreparedSQLBuilder;
import org.codefilarete.stalactite.query.builder.PseudoTableSQLBuilderFactory;
import org.codefilarete.stalactite.query.builder.QuerySQLBuilderFactory;
import org.codefilarete.stalactite.query.builder.SQLAppender;
import org.codefilarete.stalactite.query.builder.SQLBuilder;
import org.codefilarete.stalactite.query.builder.StringSQLAppender;
import org.codefilarete.stalactite.query.model.From;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.query.model.Query;
import org.codefilarete.stalactite.query.model.QueryStatement;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.StringAppender;
import org.codefilarete.tool.Strings;
import org.codefilarete.tool.collection.PairIterator;

public class FromSQLBuilderFactory {
    public FromSQLBuilder fromBuilder(From from, DMLNameProvider dmlNameProvider, QuerySQLBuilderFactory querySQLBuilderFactory, PseudoTableSQLBuilderFactory pseudoTableSQLBuilderFactory) {
        return new FromSQLBuilder(from, dmlNameProvider, querySQLBuilderFactory, pseudoTableSQLBuilderFactory);
    }

    public static class FromSQLBuilder
    implements SQLBuilder,
    PreparedSQLBuilder {
        private final From from;
        private final DMLNameProvider dmlNameProvider;
        private final QuerySQLBuilderFactory querySQLBuilderFactory;
        private final PseudoTableSQLBuilderFactory pseudoTableSQLBuilderFactory;

        public FromSQLBuilder(From from, DMLNameProvider dmlNameProvider, QuerySQLBuilderFactory querySQLBuilderFactory, PseudoTableSQLBuilderFactory pseudoTableSQLBuilderFactory) {
            this.from = from;
            this.dmlNameProvider = dmlNameProvider;
            this.querySQLBuilderFactory = querySQLBuilderFactory;
            this.pseudoTableSQLBuilderFactory = pseudoTableSQLBuilderFactory;
        }

        @Override
        public String toSQL() {
            if (this.from.getRoot() == null) {
                throw new IllegalArgumentException("Empty from");
            }
            StringAppender result = new StringAppender();
            FromGenerator fromGenerator = new FromGenerator(new StringSQLAppender(result, this.dmlNameProvider), this.dmlNameProvider);
            fromGenerator.cat(this.from.getRoot());
            Iterator<From.Join> joinIterator = this.from.getJoins().iterator();
            joinIterator.forEachRemaining(fromGenerator::cat);
            return result.toString();
        }

        @Override
        public ExpandableSQLAppender toPreparedSQL() {
            ExpandableSQLAppender preparedSQLAppender = new ExpandableSQLAppender(this.querySQLBuilderFactory.getParameterBinderRegistry(), this.dmlNameProvider);
            this.appendTo(preparedSQLAppender);
            return preparedSQLAppender;
        }

        public void appendTo(final ExpandableSQLAppender preparedSQLAppender) {
            if (this.from.getRoot() == null) {
                throw new IllegalArgumentException("Empty from");
            }
            FromGenerator fromGenerator = new FromGenerator(preparedSQLAppender, this.dmlNameProvider){

                @Override
                void cat(Query query) {
                    QuerySQLBuilderFactory.QuerySQLBuilder unionBuilder = querySQLBuilderFactory.queryBuilder(query);
                    unionBuilder.appendTo(preparedSQLAppender);
                }

                @Override
                void cat(QueryStatement.PseudoTable pseudoTable) {
                    PseudoTableSQLBuilderFactory.PseudoTableSQLBuilder pseudoTableSqlBuilder = pseudoTableSQLBuilderFactory.pseudoTableBuilder(pseudoTable.getQueryStatement(), querySQLBuilderFactory);
                    this.sql.cat("(", new String[0]);
                    pseudoTableSqlBuilder.appendTo(preparedSQLAppender);
                    this.sql.cat(") as ", new String[0]).cat(this.getAliasOrDefault(pseudoTable), new String[0]);
                }
            };
            fromGenerator.cat(this.from.getRoot());
            Iterator<From.Join> joinIterator = this.from.getJoins().iterator();
            joinIterator.forEachRemaining(fromGenerator::cat);
        }

        public class FromGenerator {
            private static final String INNER_JOIN = " inner join ";
            private static final String LEFT_OUTER_JOIN = " left outer join ";
            private static final String RIGHT_OUTER_JOIN = " right outer join ";
            private static final String CROSS_JOIN = " cross join ";
            private static final String ON = " on ";
            final SQLAppender sql;
            private final DMLNameProvider dmlNameProvider;

            public FromGenerator(SQLAppender sql, DMLNameProvider dmlNameProvider) {
                this.sql = sql;
                this.dmlNameProvider = dmlNameProvider;
            }

            public void cat(Object o) {
                if (o instanceof String) {
                    this.sql.cat((String)o, new String[0]);
                } else if (o instanceof Table) {
                    this.cat((Table)o);
                } else if (o instanceof Query) {
                    this.cat((Query)o);
                } else if (o instanceof QueryStatement.PseudoTable) {
                    this.cat((QueryStatement.PseudoTable)o);
                } else if (o instanceof From.CrossJoin) {
                    this.cat((From.CrossJoin)o);
                } else if (o instanceof From.AbstractJoin) {
                    this.cat((From.AbstractJoin)o);
                } else {
                    throw new UnsupportedOperationException("Unknown From element " + Reflections.toString(o.getClass()));
                }
            }

            private void cat(Table table) {
                String tableAlias = this.dmlNameProvider.getAlias(table);
                this.cat(table.getName());
                this.sql.catIf(!Strings.isEmpty((CharSequence)tableAlias), " as " + tableAlias);
            }

            void cat(Query query) {
                QuerySQLBuilderFactory.QuerySQLBuilder unionBuilder = FromSQLBuilder.this.querySQLBuilderFactory.queryBuilder(query);
                unionBuilder.toSQL(this.sql);
            }

            void cat(QueryStatement.PseudoTable pseudoTable) {
                PseudoTableSQLBuilderFactory.PseudoTableSQLBuilder pseudoTableSqlBuilder = FromSQLBuilder.this.pseudoTableSQLBuilderFactory.pseudoTableBuilder(pseudoTable.getQueryStatement(), FromSQLBuilder.this.querySQLBuilderFactory);
                this.sql.cat("(", new String[0]);
                pseudoTableSqlBuilder.toSQL(this.sql);
                String alias = this.getAliasOrDefault(pseudoTable);
                this.sql.cat(")", new String[0]).catIf(alias != null, " as " + alias);
            }

            private void cat(From.CrossJoin join) {
                this.sql.catIf(!this.sql.isEmpty(), CROSS_JOIN);
                this.cat(join.getRightTable());
            }

            private void cat(From.AbstractJoin join) {
                this.cat(join.getJoinDirection(), join.getRightTable());
                if (join instanceof From.RawTableJoin) {
                    this.cat(((From.RawTableJoin)join).getJoinClause());
                } else if (join instanceof From.ColumnJoin) {
                    From.ColumnJoin columnJoin = (From.ColumnJoin)join;
                    String leftPrefix = this.getAliasOrDefault((Fromable)columnJoin.getLeftColumn().getOwner());
                    String rightPrefix = this.getAliasOrDefault((Fromable)columnJoin.getRightColumn().getOwner());
                    this.sql.cat(leftPrefix.toString(), ".", columnJoin.getLeftColumn().getExpression(), " = ", rightPrefix.toString(), ".", columnJoin.getRightColumn().getExpression());
                } else if (join instanceof From.KeyJoin) {
                    From.KeyJoin keyJoin = (From.KeyJoin)join;
                    PairIterator joinColumnsPairs = new PairIterator(keyJoin.getLeftKey().getColumns(), keyJoin.getRightKey().getColumns());
                    joinColumnsPairs.forEachRemaining(duo -> {
                        String leftPrefix = this.getAliasOrDefault((Fromable)((JoinLink)duo.getLeft()).getOwner());
                        String rightPrefix = this.getAliasOrDefault((Fromable)((JoinLink)duo.getRight()).getOwner());
                        this.sql.cat(leftPrefix.toString(), ".", ((JoinLink)duo.getLeft()).getExpression(), " = ", rightPrefix.toString(), ".", ((JoinLink)duo.getRight()).getExpression(), " and ");
                    });
                    this.sql.removeLastChars(" and ".length());
                } else {
                    throw new UnsupportedOperationException("From building is not implemented for " + join.getClass().getName());
                }
            }

            String getAliasOrDefault(Fromable fromable) {
                return (String)Strings.preventEmpty((CharSequence)this.dmlNameProvider.getAlias(fromable), (CharSequence)fromable.getName());
            }

            protected void cat(From.AbstractJoin.JoinDirection joinDirection, Fromable table) {
                String joinType;
                switch (joinDirection) {
                    case INNER_JOIN: {
                        joinType = INNER_JOIN;
                        break;
                    }
                    case LEFT_OUTER_JOIN: {
                        joinType = LEFT_OUTER_JOIN;
                        break;
                    }
                    case RIGHT_OUTER_JOIN: {
                        joinType = RIGHT_OUTER_JOIN;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Join type not implemented");
                    }
                }
                this.sql.cat(joinType, new String[0]);
                this.cat(table);
                this.sql.cat(ON, new String[0]);
            }
        }
    }
}

